/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.collection;

public final class BooleanArray {
    public static boolean get(int n, int n2) {
        BooleanArray.checkIndex(n2);
        return (n & 1 << n2) > 0;
    }

    public static boolean getEnum(int n, Enum<?> enum_) {
        return BooleanArray.get(n, enum_.ordinal());
    }

    public static int set(int n, int n2, boolean bl) {
        BooleanArray.checkIndex(n2);
        if (bl) {
            return n | 1 << n2;
        }
        return n & ~(1 << n2);
    }

    public static int setEnum(int n, Enum<?> enum_, boolean bl) {
        return BooleanArray.set(n, enum_.ordinal(), bl);
    }

    private static void checkIndex(int n) {
        if (n < 0 || n > 30) {
            throw new IndexOutOfBoundsException("Index not between 0 and 30: " + n);
        }
    }

    private BooleanArray() {
    }
}

