/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.Declaration;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.ForStatement;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionDeclarationStatement;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.ast.SwitchMember;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.TypeAlias;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationStatement;
import com.google.dart.engine.ast.visitor.GeneralizingAstVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScopedNameFinder
extends GeneralizingAstVisitor<Void> {
    private Declaration declarationNode;
    private AstNode immediateChild;
    private Map<String, SimpleIdentifier> locals = new HashMap<String, SimpleIdentifier>();
    private int position;
    private boolean referenceIsWithinLocalFunction;

    public ScopedNameFinder(int n) {
        this.position = n;
    }

    public Declaration getDeclaration() {
        return this.declarationNode;
    }

    public Map<String, SimpleIdentifier> getLocals() {
        return this.locals;
    }

    @Override
    public Void visitBlock(Block block) {
        this.checkStatements(block.getStatements());
        return (Void)super.visitBlock(block);
    }

    @Override
    public Void visitCatchClause(CatchClause catchClause) {
        this.addToScope(catchClause.getExceptionParameter());
        this.addToScope(catchClause.getStackTraceParameter());
        return (Void)super.visitCatchClause(catchClause);
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        if (this.immediateChild != constructorDeclaration.getParameters()) {
            this.addParameters(constructorDeclaration.getParameters().getParameters());
        }
        this.declarationNode = constructorDeclaration;
        return null;
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
        this.declarationNode = fieldDeclaration;
        return null;
    }

    @Override
    public Void visitForEachStatement(ForEachStatement forEachStatement) {
        DeclaredIdentifier declaredIdentifier = forEachStatement.getLoopVariable();
        if (declaredIdentifier != null) {
            this.addToScope(declaredIdentifier.getIdentifier());
        }
        return (Void)super.visitForEachStatement(forEachStatement);
    }

    @Override
    public Void visitForStatement(ForStatement forStatement) {
        if (this.immediateChild != forStatement.getVariables() && forStatement.getVariables() != null) {
            this.addVariables(forStatement.getVariables().getVariables());
        }
        return (Void)super.visitForStatement(forStatement);
    }

    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        if (!(functionDeclaration.getParent() instanceof FunctionDeclarationStatement)) {
            this.declarationNode = functionDeclaration;
            return null;
        }
        return (Void)super.visitFunctionDeclaration(functionDeclaration);
    }

    @Override
    public Void visitFunctionDeclarationStatement(FunctionDeclarationStatement functionDeclarationStatement) {
        this.referenceIsWithinLocalFunction = true;
        return (Void)super.visitFunctionDeclarationStatement(functionDeclarationStatement);
    }

    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        if (functionExpression.getParameters() != null && this.immediateChild != functionExpression.getParameters()) {
            this.addParameters(functionExpression.getParameters().getParameters());
        }
        return (Void)super.visitFunctionExpression(functionExpression);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        this.declarationNode = methodDeclaration;
        if (methodDeclaration.getParameters() == null) {
            return null;
        }
        if (this.immediateChild != methodDeclaration.getParameters()) {
            this.addParameters(methodDeclaration.getParameters().getParameters());
        }
        return null;
    }

    @Override
    public Void visitNode(AstNode astNode) {
        this.immediateChild = astNode;
        AstNode astNode2 = astNode.getParent();
        if (astNode2 != null) {
            astNode2.accept(this);
        }
        return null;
    }

    @Override
    public Void visitSwitchMember(SwitchMember switchMember) {
        this.checkStatements(switchMember.getStatements());
        return (Void)super.visitSwitchMember(switchMember);
    }

    @Override
    public Void visitTopLevelVariableDeclaration(TopLevelVariableDeclaration topLevelVariableDeclaration) {
        this.declarationNode = topLevelVariableDeclaration;
        return null;
    }

    @Override
    public Void visitTypeAlias(TypeAlias typeAlias) {
        this.declarationNode = typeAlias;
        return null;
    }

    private void addParameters(NodeList<FormalParameter> nodeList) {
        for (FormalParameter formalParameter : nodeList) {
            this.addToScope(formalParameter.getIdentifier());
        }
    }

    private void addToScope(SimpleIdentifier simpleIdentifier) {
        String string;
        if (simpleIdentifier != null && this.isInRange(simpleIdentifier) && !this.locals.containsKey(string = simpleIdentifier.getName())) {
            this.locals.put(string, simpleIdentifier);
        }
    }

    private void addVariables(NodeList<VariableDeclaration> nodeList) {
        for (VariableDeclaration variableDeclaration : nodeList) {
            this.addToScope(variableDeclaration.getName());
        }
    }

    private void checkStatements(List<Statement> list) {
        for (Statement statement : list) {
            if (statement == this.immediateChild) {
                return;
            }
            if (statement instanceof VariableDeclarationStatement) {
                this.addVariables(((VariableDeclarationStatement)statement).getVariables().getVariables());
                continue;
            }
            if (!(statement instanceof FunctionDeclarationStatement) || this.referenceIsWithinLocalFunction) continue;
            this.addToScope(((FunctionDeclarationStatement)statement).getFunctionDeclaration().getName());
        }
    }

    private boolean isInRange(AstNode astNode) {
        if (this.position < 0) {
            return true;
        }
        return astNode.getEnd() < this.position;
    }
}

