/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.ast;

import com.google.dart.engine.ast.AdjacentStrings;
import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.ArgumentDefinitionTest;
import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AsExpression;
import com.google.dart.engine.ast.AssertStatement;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.BlockFunctionBody;
import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.BreakStatement;
import com.google.dart.engine.ast.CascadeExpression;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.CommentReference;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorFieldInitializer;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.ContinueStatement;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.DefaultFormalParameter;
import com.google.dart.engine.ast.DoStatement;
import com.google.dart.engine.ast.DoubleLiteral;
import com.google.dart.engine.ast.EmptyFunctionBody;
import com.google.dart.engine.ast.EmptyStatement;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.ExpressionFunctionBody;
import com.google.dart.engine.ast.ExpressionStatement;
import com.google.dart.engine.ast.ExtendsClause;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.FieldFormalParameter;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.ForStatement;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionDeclarationStatement;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionExpressionInvocation;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.HideCombinator;
import com.google.dart.engine.ast.IfStatement;
import com.google.dart.engine.ast.ImplementsClause;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.IntegerLiteral;
import com.google.dart.engine.ast.InterpolationExpression;
import com.google.dart.engine.ast.InterpolationString;
import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LabeledStatement;
import com.google.dart.engine.ast.LibraryDirective;
import com.google.dart.engine.ast.LibraryIdentifier;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NativeClause;
import com.google.dart.engine.ast.NativeFunctionBody;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.NullLiteral;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.ast.PartOfDirective;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.RedirectingConstructorInvocation;
import com.google.dart.engine.ast.RethrowExpression;
import com.google.dart.engine.ast.ReturnStatement;
import com.google.dart.engine.ast.ScriptTag;
import com.google.dart.engine.ast.ShowCombinator;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.SuperExpression;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchDefault;
import com.google.dart.engine.ast.SwitchStatement;
import com.google.dart.engine.ast.SymbolLiteral;
import com.google.dart.engine.ast.ThisExpression;
import com.google.dart.engine.ast.ThrowExpression;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.TryStatement;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.TypeParameterList;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.VariableDeclarationStatement;
import com.google.dart.engine.ast.WhileStatement;
import com.google.dart.engine.ast.WithClause;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.utilities.collection.TokenMap;
import java.util.ArrayList;
import java.util.List;

public class IncrementalAstCloner
implements AstVisitor<AstNode> {
    private AstNode oldNode;
    private AstNode newNode;
    private TokenMap tokenMap;

    public IncrementalAstCloner(AstNode astNode, AstNode astNode2, TokenMap tokenMap) {
        this.oldNode = astNode;
        this.newNode = astNode2;
        this.tokenMap = tokenMap;
    }

    @Override
    public AdjacentStrings visitAdjacentStrings(AdjacentStrings adjacentStrings) {
        return new AdjacentStrings(this.cloneNodeList(adjacentStrings.getStrings()));
    }

    @Override
    public Annotation visitAnnotation(Annotation annotation) {
        Annotation annotation2 = new Annotation(this.mapToken(annotation.getAtSign()), this.cloneNode(annotation.getName()), this.mapToken(annotation.getPeriod()), this.cloneNode(annotation.getConstructorName()), this.cloneNode(annotation.getArguments()));
        annotation2.setElement(annotation.getElement());
        return annotation2;
    }

    @Override
    public ArgumentDefinitionTest visitArgumentDefinitionTest(ArgumentDefinitionTest argumentDefinitionTest) {
        ArgumentDefinitionTest argumentDefinitionTest2 = new ArgumentDefinitionTest(this.mapToken(argumentDefinitionTest.getQuestion()), this.cloneNode(argumentDefinitionTest.getIdentifier()));
        argumentDefinitionTest2.setPropagatedType(argumentDefinitionTest.getPropagatedType());
        argumentDefinitionTest2.setStaticType(argumentDefinitionTest.getStaticType());
        return argumentDefinitionTest2;
    }

    @Override
    public ArgumentList visitArgumentList(ArgumentList argumentList) {
        return new ArgumentList(this.mapToken(argumentList.getLeftParenthesis()), this.cloneNodeList(argumentList.getArguments()), this.mapToken(argumentList.getRightParenthesis()));
    }

    @Override
    public AsExpression visitAsExpression(AsExpression asExpression) {
        AsExpression asExpression2 = new AsExpression(this.cloneNode(asExpression.getExpression()), this.mapToken(asExpression.getAsOperator()), this.cloneNode(asExpression.getType()));
        asExpression2.setPropagatedType(asExpression.getPropagatedType());
        asExpression2.setStaticType(asExpression.getStaticType());
        return asExpression2;
    }

    @Override
    public AstNode visitAssertStatement(AssertStatement assertStatement) {
        return new AssertStatement(this.mapToken(assertStatement.getKeyword()), this.mapToken(assertStatement.getLeftParenthesis()), this.cloneNode(assertStatement.getCondition()), this.mapToken(assertStatement.getRightParenthesis()), this.mapToken(assertStatement.getSemicolon()));
    }

    @Override
    public AssignmentExpression visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        AssignmentExpression assignmentExpression2 = new AssignmentExpression(this.cloneNode(assignmentExpression.getLeftHandSide()), this.mapToken(assignmentExpression.getOperator()), this.cloneNode(assignmentExpression.getRightHandSide()));
        assignmentExpression2.setPropagatedElement(assignmentExpression.getPropagatedElement());
        assignmentExpression2.setPropagatedType(assignmentExpression.getPropagatedType());
        assignmentExpression2.setStaticElement(assignmentExpression.getStaticElement());
        assignmentExpression2.setStaticType(assignmentExpression.getStaticType());
        return assignmentExpression2;
    }

    @Override
    public BinaryExpression visitBinaryExpression(BinaryExpression binaryExpression) {
        BinaryExpression binaryExpression2 = new BinaryExpression(this.cloneNode(binaryExpression.getLeftOperand()), this.mapToken(binaryExpression.getOperator()), this.cloneNode(binaryExpression.getRightOperand()));
        binaryExpression2.setPropagatedElement(binaryExpression.getPropagatedElement());
        binaryExpression2.setPropagatedType(binaryExpression.getPropagatedType());
        binaryExpression2.setStaticElement(binaryExpression.getStaticElement());
        binaryExpression2.setStaticType(binaryExpression.getStaticType());
        return binaryExpression2;
    }

    @Override
    public Block visitBlock(Block block) {
        return new Block(this.mapToken(block.getLeftBracket()), this.cloneNodeList(block.getStatements()), this.mapToken(block.getRightBracket()));
    }

    @Override
    public BlockFunctionBody visitBlockFunctionBody(BlockFunctionBody blockFunctionBody) {
        return new BlockFunctionBody(this.cloneNode(blockFunctionBody.getBlock()));
    }

    @Override
    public BooleanLiteral visitBooleanLiteral(BooleanLiteral booleanLiteral) {
        BooleanLiteral booleanLiteral2 = new BooleanLiteral(this.mapToken(booleanLiteral.getLiteral()), booleanLiteral.getValue());
        booleanLiteral2.setPropagatedType(booleanLiteral.getPropagatedType());
        booleanLiteral2.setStaticType(booleanLiteral.getStaticType());
        return booleanLiteral2;
    }

    @Override
    public BreakStatement visitBreakStatement(BreakStatement breakStatement) {
        return new BreakStatement(this.mapToken(breakStatement.getKeyword()), this.cloneNode(breakStatement.getLabel()), this.mapToken(breakStatement.getSemicolon()));
    }

    @Override
    public CascadeExpression visitCascadeExpression(CascadeExpression cascadeExpression) {
        CascadeExpression cascadeExpression2 = new CascadeExpression(this.cloneNode(cascadeExpression.getTarget()), this.cloneNodeList(cascadeExpression.getCascadeSections()));
        cascadeExpression2.setPropagatedType(cascadeExpression.getPropagatedType());
        cascadeExpression2.setStaticType(cascadeExpression.getStaticType());
        return cascadeExpression2;
    }

    @Override
    public CatchClause visitCatchClause(CatchClause catchClause) {
        return new CatchClause(this.mapToken(catchClause.getOnKeyword()), this.cloneNode(catchClause.getExceptionType()), this.mapToken(catchClause.getCatchKeyword()), this.mapToken(catchClause.getLeftParenthesis()), this.cloneNode(catchClause.getExceptionParameter()), this.mapToken(catchClause.getComma()), this.cloneNode(catchClause.getStackTraceParameter()), this.mapToken(catchClause.getRightParenthesis()), this.cloneNode(catchClause.getBody()));
    }

    @Override
    public ClassDeclaration visitClassDeclaration(ClassDeclaration classDeclaration) {
        ClassDeclaration classDeclaration2 = new ClassDeclaration(this.cloneNode(classDeclaration.getDocumentationComment()), this.cloneNodeList(classDeclaration.getMetadata()), this.mapToken(classDeclaration.getAbstractKeyword()), this.mapToken(classDeclaration.getClassKeyword()), this.cloneNode(classDeclaration.getName()), this.cloneNode(classDeclaration.getTypeParameters()), this.cloneNode(classDeclaration.getExtendsClause()), this.cloneNode(classDeclaration.getWithClause()), this.cloneNode(classDeclaration.getImplementsClause()), this.mapToken(classDeclaration.getLeftBracket()), this.cloneNodeList(classDeclaration.getMembers()), this.mapToken(classDeclaration.getRightBracket()));
        classDeclaration2.setNativeClause(this.cloneNode(classDeclaration.getNativeClause()));
        return classDeclaration2;
    }

    @Override
    public ClassTypeAlias visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        return new ClassTypeAlias(this.cloneNode(classTypeAlias.getDocumentationComment()), this.cloneNodeList(classTypeAlias.getMetadata()), this.mapToken(classTypeAlias.getKeyword()), this.cloneNode(classTypeAlias.getName()), this.cloneNode(classTypeAlias.getTypeParameters()), this.mapToken(classTypeAlias.getEquals()), this.mapToken(classTypeAlias.getAbstractKeyword()), this.cloneNode(classTypeAlias.getSuperclass()), this.cloneNode(classTypeAlias.getWithClause()), this.cloneNode(classTypeAlias.getImplementsClause()), this.mapToken(classTypeAlias.getSemicolon()));
    }

    @Override
    public Comment visitComment(Comment comment) {
        if (comment.isDocumentation()) {
            return Comment.createDocumentationCommentWithReferences(this.mapTokens(comment.getTokens()), this.cloneNodeList(comment.getReferences()));
        }
        if (comment.isBlock()) {
            return Comment.createBlockComment(this.mapTokens(comment.getTokens()));
        }
        return Comment.createEndOfLineComment(this.mapTokens(comment.getTokens()));
    }

    @Override
    public CommentReference visitCommentReference(CommentReference commentReference) {
        return new CommentReference(this.mapToken(commentReference.getNewKeyword()), this.cloneNode(commentReference.getIdentifier()));
    }

    @Override
    public CompilationUnit visitCompilationUnit(CompilationUnit compilationUnit) {
        CompilationUnit compilationUnit2 = new CompilationUnit(this.mapToken(compilationUnit.getBeginToken()), this.cloneNode(compilationUnit.getScriptTag()), this.cloneNodeList(compilationUnit.getDirectives()), this.cloneNodeList(compilationUnit.getDeclarations()), this.mapToken(compilationUnit.getEndToken()));
        compilationUnit2.setLineInfo(compilationUnit.getLineInfo());
        compilationUnit2.setElement(compilationUnit.getElement());
        return compilationUnit2;
    }

    @Override
    public ConditionalExpression visitConditionalExpression(ConditionalExpression conditionalExpression) {
        ConditionalExpression conditionalExpression2 = new ConditionalExpression(this.cloneNode(conditionalExpression.getCondition()), this.mapToken(conditionalExpression.getQuestion()), this.cloneNode(conditionalExpression.getThenExpression()), this.mapToken(conditionalExpression.getColon()), this.cloneNode(conditionalExpression.getElseExpression()));
        conditionalExpression2.setPropagatedType(conditionalExpression.getPropagatedType());
        conditionalExpression2.setStaticType(conditionalExpression.getStaticType());
        return conditionalExpression2;
    }

    @Override
    public ConstructorDeclaration visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        ConstructorDeclaration constructorDeclaration2 = new ConstructorDeclaration(this.cloneNode(constructorDeclaration.getDocumentationComment()), this.cloneNodeList(constructorDeclaration.getMetadata()), this.mapToken(constructorDeclaration.getExternalKeyword()), this.mapToken(constructorDeclaration.getConstKeyword()), this.mapToken(constructorDeclaration.getFactoryKeyword()), this.cloneNode(constructorDeclaration.getReturnType()), this.mapToken(constructorDeclaration.getPeriod()), this.cloneNode(constructorDeclaration.getName()), this.cloneNode(constructorDeclaration.getParameters()), this.mapToken(constructorDeclaration.getSeparator()), this.cloneNodeList(constructorDeclaration.getInitializers()), this.cloneNode(constructorDeclaration.getRedirectedConstructor()), this.cloneNode(constructorDeclaration.getBody()));
        constructorDeclaration2.setElement(constructorDeclaration.getElement());
        return constructorDeclaration2;
    }

    @Override
    public ConstructorFieldInitializer visitConstructorFieldInitializer(ConstructorFieldInitializer constructorFieldInitializer) {
        return new ConstructorFieldInitializer(this.mapToken(constructorFieldInitializer.getKeyword()), this.mapToken(constructorFieldInitializer.getPeriod()), this.cloneNode(constructorFieldInitializer.getFieldName()), this.mapToken(constructorFieldInitializer.getEquals()), this.cloneNode(constructorFieldInitializer.getExpression()));
    }

    @Override
    public ConstructorName visitConstructorName(ConstructorName constructorName) {
        ConstructorName constructorName2 = new ConstructorName(this.cloneNode(constructorName.getType()), this.mapToken(constructorName.getPeriod()), this.cloneNode(constructorName.getName()));
        constructorName2.setStaticElement(constructorName.getStaticElement());
        return constructorName2;
    }

    @Override
    public ContinueStatement visitContinueStatement(ContinueStatement continueStatement) {
        return new ContinueStatement(this.mapToken(continueStatement.getKeyword()), this.cloneNode(continueStatement.getLabel()), this.mapToken(continueStatement.getSemicolon()));
    }

    @Override
    public DeclaredIdentifier visitDeclaredIdentifier(DeclaredIdentifier declaredIdentifier) {
        return new DeclaredIdentifier(this.cloneNode(declaredIdentifier.getDocumentationComment()), this.cloneNodeList(declaredIdentifier.getMetadata()), this.mapToken(declaredIdentifier.getKeyword()), this.cloneNode(declaredIdentifier.getType()), this.cloneNode(declaredIdentifier.getIdentifier()));
    }

    @Override
    public DefaultFormalParameter visitDefaultFormalParameter(DefaultFormalParameter defaultFormalParameter) {
        return new DefaultFormalParameter(this.cloneNode(defaultFormalParameter.getParameter()), defaultFormalParameter.getKind(), this.mapToken(defaultFormalParameter.getSeparator()), this.cloneNode(defaultFormalParameter.getDefaultValue()));
    }

    @Override
    public DoStatement visitDoStatement(DoStatement doStatement) {
        return new DoStatement(this.mapToken(doStatement.getDoKeyword()), this.cloneNode(doStatement.getBody()), this.mapToken(doStatement.getWhileKeyword()), this.mapToken(doStatement.getLeftParenthesis()), this.cloneNode(doStatement.getCondition()), this.mapToken(doStatement.getRightParenthesis()), this.mapToken(doStatement.getSemicolon()));
    }

    @Override
    public DoubleLiteral visitDoubleLiteral(DoubleLiteral doubleLiteral) {
        DoubleLiteral doubleLiteral2 = new DoubleLiteral(this.mapToken(doubleLiteral.getLiteral()), doubleLiteral.getValue());
        doubleLiteral2.setPropagatedType(doubleLiteral.getPropagatedType());
        doubleLiteral2.setStaticType(doubleLiteral.getStaticType());
        return doubleLiteral2;
    }

    @Override
    public EmptyFunctionBody visitEmptyFunctionBody(EmptyFunctionBody emptyFunctionBody) {
        return new EmptyFunctionBody(this.mapToken(emptyFunctionBody.getSemicolon()));
    }

    @Override
    public EmptyStatement visitEmptyStatement(EmptyStatement emptyStatement) {
        return new EmptyStatement(this.mapToken(emptyStatement.getSemicolon()));
    }

    @Override
    public ExportDirective visitExportDirective(ExportDirective exportDirective) {
        ExportDirective exportDirective2 = new ExportDirective(this.cloneNode(exportDirective.getDocumentationComment()), this.cloneNodeList(exportDirective.getMetadata()), this.mapToken(exportDirective.getKeyword()), this.cloneNode(exportDirective.getUri()), this.cloneNodeList(exportDirective.getCombinators()), this.mapToken(exportDirective.getSemicolon()));
        exportDirective2.setElement(exportDirective.getElement());
        return exportDirective2;
    }

    @Override
    public ExpressionFunctionBody visitExpressionFunctionBody(ExpressionFunctionBody expressionFunctionBody) {
        return new ExpressionFunctionBody(this.mapToken(expressionFunctionBody.getFunctionDefinition()), this.cloneNode(expressionFunctionBody.getExpression()), this.mapToken(expressionFunctionBody.getSemicolon()));
    }

    @Override
    public ExpressionStatement visitExpressionStatement(ExpressionStatement expressionStatement) {
        return new ExpressionStatement(this.cloneNode(expressionStatement.getExpression()), this.mapToken(expressionStatement.getSemicolon()));
    }

    @Override
    public ExtendsClause visitExtendsClause(ExtendsClause extendsClause) {
        return new ExtendsClause(this.mapToken(extendsClause.getKeyword()), this.cloneNode(extendsClause.getSuperclass()));
    }

    @Override
    public FieldDeclaration visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
        return new FieldDeclaration(this.cloneNode(fieldDeclaration.getDocumentationComment()), this.cloneNodeList(fieldDeclaration.getMetadata()), this.mapToken(fieldDeclaration.getStaticKeyword()), this.cloneNode(fieldDeclaration.getFields()), this.mapToken(fieldDeclaration.getSemicolon()));
    }

    @Override
    public FieldFormalParameter visitFieldFormalParameter(FieldFormalParameter fieldFormalParameter) {
        return new FieldFormalParameter(this.cloneNode(fieldFormalParameter.getDocumentationComment()), this.cloneNodeList(fieldFormalParameter.getMetadata()), this.mapToken(fieldFormalParameter.getKeyword()), this.cloneNode(fieldFormalParameter.getType()), this.mapToken(fieldFormalParameter.getThisToken()), this.mapToken(fieldFormalParameter.getPeriod()), this.cloneNode(fieldFormalParameter.getIdentifier()), this.cloneNode(fieldFormalParameter.getParameters()));
    }

    @Override
    public ForEachStatement visitForEachStatement(ForEachStatement forEachStatement) {
        DeclaredIdentifier declaredIdentifier = forEachStatement.getLoopVariable();
        if (declaredIdentifier == null) {
            return new ForEachStatement(this.mapToken(forEachStatement.getForKeyword()), this.mapToken(forEachStatement.getLeftParenthesis()), this.cloneNode(forEachStatement.getIdentifier()), this.mapToken(forEachStatement.getInKeyword()), this.cloneNode(forEachStatement.getIterator()), this.mapToken(forEachStatement.getRightParenthesis()), this.cloneNode(forEachStatement.getBody()));
        }
        return new ForEachStatement(this.mapToken(forEachStatement.getForKeyword()), this.mapToken(forEachStatement.getLeftParenthesis()), this.cloneNode(declaredIdentifier), this.mapToken(forEachStatement.getInKeyword()), this.cloneNode(forEachStatement.getIterator()), this.mapToken(forEachStatement.getRightParenthesis()), this.cloneNode(forEachStatement.getBody()));
    }

    @Override
    public FormalParameterList visitFormalParameterList(FormalParameterList formalParameterList) {
        return new FormalParameterList(this.mapToken(formalParameterList.getLeftParenthesis()), this.cloneNodeList(formalParameterList.getParameters()), this.mapToken(formalParameterList.getLeftDelimiter()), this.mapToken(formalParameterList.getRightDelimiter()), this.mapToken(formalParameterList.getRightParenthesis()));
    }

    @Override
    public ForStatement visitForStatement(ForStatement forStatement) {
        return new ForStatement(this.mapToken(forStatement.getForKeyword()), this.mapToken(forStatement.getLeftParenthesis()), this.cloneNode(forStatement.getVariables()), this.cloneNode(forStatement.getInitialization()), this.mapToken(forStatement.getLeftSeparator()), this.cloneNode(forStatement.getCondition()), this.mapToken(forStatement.getRightSeparator()), this.cloneNodeList(forStatement.getUpdaters()), this.mapToken(forStatement.getRightParenthesis()), this.cloneNode(forStatement.getBody()));
    }

    @Override
    public FunctionDeclaration visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        return new FunctionDeclaration(this.cloneNode(functionDeclaration.getDocumentationComment()), this.cloneNodeList(functionDeclaration.getMetadata()), this.mapToken(functionDeclaration.getExternalKeyword()), this.cloneNode(functionDeclaration.getReturnType()), this.mapToken(functionDeclaration.getPropertyKeyword()), this.cloneNode(functionDeclaration.getName()), this.cloneNode(functionDeclaration.getFunctionExpression()));
    }

    @Override
    public FunctionDeclarationStatement visitFunctionDeclarationStatement(FunctionDeclarationStatement functionDeclarationStatement) {
        return new FunctionDeclarationStatement(this.cloneNode(functionDeclarationStatement.getFunctionDeclaration()));
    }

    @Override
    public FunctionExpression visitFunctionExpression(FunctionExpression functionExpression) {
        FunctionExpression functionExpression2 = new FunctionExpression(this.cloneNode(functionExpression.getParameters()), this.cloneNode(functionExpression.getBody()));
        functionExpression2.setElement(functionExpression.getElement());
        functionExpression2.setPropagatedType(functionExpression.getPropagatedType());
        functionExpression2.setStaticType(functionExpression.getStaticType());
        return functionExpression2;
    }

    @Override
    public FunctionExpressionInvocation visitFunctionExpressionInvocation(FunctionExpressionInvocation functionExpressionInvocation) {
        FunctionExpressionInvocation functionExpressionInvocation2 = new FunctionExpressionInvocation(this.cloneNode(functionExpressionInvocation.getFunction()), this.cloneNode(functionExpressionInvocation.getArgumentList()));
        functionExpressionInvocation2.setPropagatedElement(functionExpressionInvocation.getPropagatedElement());
        functionExpressionInvocation2.setPropagatedType(functionExpressionInvocation.getPropagatedType());
        functionExpressionInvocation2.setStaticElement(functionExpressionInvocation.getStaticElement());
        functionExpressionInvocation2.setStaticType(functionExpressionInvocation.getStaticType());
        return functionExpressionInvocation2;
    }

    @Override
    public FunctionTypeAlias visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        return new FunctionTypeAlias(this.cloneNode(functionTypeAlias.getDocumentationComment()), this.cloneNodeList(functionTypeAlias.getMetadata()), this.mapToken(functionTypeAlias.getKeyword()), this.cloneNode(functionTypeAlias.getReturnType()), this.cloneNode(functionTypeAlias.getName()), this.cloneNode(functionTypeAlias.getTypeParameters()), this.cloneNode(functionTypeAlias.getParameters()), this.mapToken(functionTypeAlias.getSemicolon()));
    }

    @Override
    public FunctionTypedFormalParameter visitFunctionTypedFormalParameter(FunctionTypedFormalParameter functionTypedFormalParameter) {
        return new FunctionTypedFormalParameter(this.cloneNode(functionTypedFormalParameter.getDocumentationComment()), this.cloneNodeList(functionTypedFormalParameter.getMetadata()), this.cloneNode(functionTypedFormalParameter.getReturnType()), this.cloneNode(functionTypedFormalParameter.getIdentifier()), this.cloneNode(functionTypedFormalParameter.getParameters()));
    }

    @Override
    public HideCombinator visitHideCombinator(HideCombinator hideCombinator) {
        return new HideCombinator(this.mapToken(hideCombinator.getKeyword()), this.cloneNodeList(hideCombinator.getHiddenNames()));
    }

    @Override
    public IfStatement visitIfStatement(IfStatement ifStatement) {
        return new IfStatement(this.mapToken(ifStatement.getIfKeyword()), this.mapToken(ifStatement.getLeftParenthesis()), this.cloneNode(ifStatement.getCondition()), this.mapToken(ifStatement.getRightParenthesis()), this.cloneNode(ifStatement.getThenStatement()), this.mapToken(ifStatement.getElseKeyword()), this.cloneNode(ifStatement.getElseStatement()));
    }

    @Override
    public ImplementsClause visitImplementsClause(ImplementsClause implementsClause) {
        return new ImplementsClause(this.mapToken(implementsClause.getKeyword()), this.cloneNodeList(implementsClause.getInterfaces()));
    }

    @Override
    public ImportDirective visitImportDirective(ImportDirective importDirective) {
        return new ImportDirective(this.cloneNode(importDirective.getDocumentationComment()), this.cloneNodeList(importDirective.getMetadata()), this.mapToken(importDirective.getKeyword()), this.cloneNode(importDirective.getUri()), this.mapToken(importDirective.getAsToken()), this.cloneNode(importDirective.getPrefix()), this.cloneNodeList(importDirective.getCombinators()), this.mapToken(importDirective.getSemicolon()));
    }

    @Override
    public IndexExpression visitIndexExpression(IndexExpression indexExpression) {
        Token token = this.mapToken(indexExpression.getPeriod());
        IndexExpression indexExpression2 = token == null ? new IndexExpression(this.cloneNode(indexExpression.getTarget()), this.mapToken(indexExpression.getLeftBracket()), this.cloneNode(indexExpression.getIndex()), this.mapToken(indexExpression.getRightBracket())) : new IndexExpression(token, this.mapToken(indexExpression.getLeftBracket()), this.cloneNode(indexExpression.getIndex()), this.mapToken(indexExpression.getRightBracket()));
        indexExpression2.setAuxiliaryElements(indexExpression.getAuxiliaryElements());
        indexExpression2.setPropagatedElement(indexExpression.getPropagatedElement());
        indexExpression2.setPropagatedType(indexExpression.getPropagatedType());
        indexExpression2.setStaticElement(indexExpression.getStaticElement());
        indexExpression2.setStaticType(indexExpression.getStaticType());
        return indexExpression2;
    }

    @Override
    public InstanceCreationExpression visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        InstanceCreationExpression instanceCreationExpression2 = new InstanceCreationExpression(this.mapToken(instanceCreationExpression.getKeyword()), this.cloneNode(instanceCreationExpression.getConstructorName()), this.cloneNode(instanceCreationExpression.getArgumentList()));
        instanceCreationExpression2.setPropagatedType(instanceCreationExpression.getPropagatedType());
        instanceCreationExpression2.setStaticElement(instanceCreationExpression.getStaticElement());
        instanceCreationExpression2.setStaticType(instanceCreationExpression.getStaticType());
        return instanceCreationExpression2;
    }

    @Override
    public IntegerLiteral visitIntegerLiteral(IntegerLiteral integerLiteral) {
        IntegerLiteral integerLiteral2 = new IntegerLiteral(this.mapToken(integerLiteral.getLiteral()), integerLiteral.getValue());
        integerLiteral2.setPropagatedType(integerLiteral.getPropagatedType());
        integerLiteral2.setStaticType(integerLiteral.getStaticType());
        return integerLiteral2;
    }

    @Override
    public InterpolationExpression visitInterpolationExpression(InterpolationExpression interpolationExpression) {
        return new InterpolationExpression(this.mapToken(interpolationExpression.getLeftBracket()), this.cloneNode(interpolationExpression.getExpression()), this.mapToken(interpolationExpression.getRightBracket()));
    }

    @Override
    public InterpolationString visitInterpolationString(InterpolationString interpolationString) {
        return new InterpolationString(this.mapToken(interpolationString.getContents()), interpolationString.getValue());
    }

    @Override
    public IsExpression visitIsExpression(IsExpression isExpression) {
        IsExpression isExpression2 = new IsExpression(this.cloneNode(isExpression.getExpression()), this.mapToken(isExpression.getIsOperator()), this.mapToken(isExpression.getNotOperator()), this.cloneNode(isExpression.getType()));
        isExpression2.setPropagatedType(isExpression.getPropagatedType());
        isExpression2.setStaticType(isExpression.getStaticType());
        return isExpression2;
    }

    @Override
    public Label visitLabel(Label label) {
        return new Label(this.cloneNode(label.getLabel()), this.mapToken(label.getColon()));
    }

    @Override
    public LabeledStatement visitLabeledStatement(LabeledStatement labeledStatement) {
        return new LabeledStatement(this.cloneNodeList(labeledStatement.getLabels()), this.cloneNode(labeledStatement.getStatement()));
    }

    @Override
    public LibraryDirective visitLibraryDirective(LibraryDirective libraryDirective) {
        return new LibraryDirective(this.cloneNode(libraryDirective.getDocumentationComment()), this.cloneNodeList(libraryDirective.getMetadata()), this.mapToken(libraryDirective.getLibraryToken()), this.cloneNode(libraryDirective.getName()), this.mapToken(libraryDirective.getSemicolon()));
    }

    @Override
    public LibraryIdentifier visitLibraryIdentifier(LibraryIdentifier libraryIdentifier) {
        LibraryIdentifier libraryIdentifier2 = new LibraryIdentifier(this.cloneNodeList(libraryIdentifier.getComponents()));
        libraryIdentifier2.setPropagatedType(libraryIdentifier.getPropagatedType());
        libraryIdentifier2.setStaticType(libraryIdentifier.getStaticType());
        return libraryIdentifier2;
    }

    @Override
    public ListLiteral visitListLiteral(ListLiteral listLiteral) {
        ListLiteral listLiteral2 = new ListLiteral(this.mapToken(listLiteral.getConstKeyword()), this.cloneNode(listLiteral.getTypeArguments()), this.mapToken(listLiteral.getLeftBracket()), this.cloneNodeList(listLiteral.getElements()), this.mapToken(listLiteral.getRightBracket()));
        listLiteral2.setPropagatedType(listLiteral.getPropagatedType());
        listLiteral2.setStaticType(listLiteral.getStaticType());
        return listLiteral2;
    }

    @Override
    public MapLiteral visitMapLiteral(MapLiteral mapLiteral) {
        MapLiteral mapLiteral2 = new MapLiteral(this.mapToken(mapLiteral.getConstKeyword()), this.cloneNode(mapLiteral.getTypeArguments()), this.mapToken(mapLiteral.getLeftBracket()), this.cloneNodeList(mapLiteral.getEntries()), this.mapToken(mapLiteral.getRightBracket()));
        mapLiteral2.setPropagatedType(mapLiteral.getPropagatedType());
        mapLiteral2.setStaticType(mapLiteral.getStaticType());
        return mapLiteral2;
    }

    @Override
    public MapLiteralEntry visitMapLiteralEntry(MapLiteralEntry mapLiteralEntry) {
        return new MapLiteralEntry(this.cloneNode(mapLiteralEntry.getKey()), this.mapToken(mapLiteralEntry.getSeparator()), this.cloneNode(mapLiteralEntry.getValue()));
    }

    @Override
    public MethodDeclaration visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        return new MethodDeclaration(this.cloneNode(methodDeclaration.getDocumentationComment()), this.cloneNodeList(methodDeclaration.getMetadata()), this.mapToken(methodDeclaration.getExternalKeyword()), this.mapToken(methodDeclaration.getModifierKeyword()), this.cloneNode(methodDeclaration.getReturnType()), this.mapToken(methodDeclaration.getPropertyKeyword()), this.mapToken(methodDeclaration.getOperatorKeyword()), this.cloneNode(methodDeclaration.getName()), this.cloneNode(methodDeclaration.getParameters()), this.cloneNode(methodDeclaration.getBody()));
    }

    @Override
    public MethodInvocation visitMethodInvocation(MethodInvocation methodInvocation) {
        MethodInvocation methodInvocation2 = new MethodInvocation(this.cloneNode(methodInvocation.getTarget()), this.mapToken(methodInvocation.getPeriod()), this.cloneNode(methodInvocation.getMethodName()), this.cloneNode(methodInvocation.getArgumentList()));
        methodInvocation2.setPropagatedType(methodInvocation.getPropagatedType());
        methodInvocation2.setStaticType(methodInvocation.getStaticType());
        return methodInvocation2;
    }

    @Override
    public NamedExpression visitNamedExpression(NamedExpression namedExpression) {
        NamedExpression namedExpression2 = new NamedExpression(this.cloneNode(namedExpression.getName()), this.cloneNode(namedExpression.getExpression()));
        namedExpression2.setPropagatedType(namedExpression.getPropagatedType());
        namedExpression2.setStaticType(namedExpression.getStaticType());
        return namedExpression2;
    }

    @Override
    public AstNode visitNativeClause(NativeClause nativeClause) {
        return new NativeClause(this.mapToken(nativeClause.getKeyword()), this.cloneNode(nativeClause.getName()));
    }

    @Override
    public NativeFunctionBody visitNativeFunctionBody(NativeFunctionBody nativeFunctionBody) {
        return new NativeFunctionBody(this.mapToken(nativeFunctionBody.getNativeToken()), this.cloneNode(nativeFunctionBody.getStringLiteral()), this.mapToken(nativeFunctionBody.getSemicolon()));
    }

    @Override
    public NullLiteral visitNullLiteral(NullLiteral nullLiteral) {
        NullLiteral nullLiteral2 = new NullLiteral(this.mapToken(nullLiteral.getLiteral()));
        nullLiteral2.setPropagatedType(nullLiteral.getPropagatedType());
        nullLiteral2.setStaticType(nullLiteral.getStaticType());
        return nullLiteral2;
    }

    @Override
    public ParenthesizedExpression visitParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
        ParenthesizedExpression parenthesizedExpression2 = new ParenthesizedExpression(this.mapToken(parenthesizedExpression.getLeftParenthesis()), this.cloneNode(parenthesizedExpression.getExpression()), this.mapToken(parenthesizedExpression.getRightParenthesis()));
        parenthesizedExpression2.setPropagatedType(parenthesizedExpression.getPropagatedType());
        parenthesizedExpression2.setStaticType(parenthesizedExpression.getStaticType());
        return parenthesizedExpression2;
    }

    @Override
    public PartDirective visitPartDirective(PartDirective partDirective) {
        PartDirective partDirective2 = new PartDirective(this.cloneNode(partDirective.getDocumentationComment()), this.cloneNodeList(partDirective.getMetadata()), this.mapToken(partDirective.getPartToken()), this.cloneNode(partDirective.getUri()), this.mapToken(partDirective.getSemicolon()));
        partDirective2.setElement(partDirective.getElement());
        return partDirective2;
    }

    @Override
    public PartOfDirective visitPartOfDirective(PartOfDirective partOfDirective) {
        PartOfDirective partOfDirective2 = new PartOfDirective(this.cloneNode(partOfDirective.getDocumentationComment()), this.cloneNodeList(partOfDirective.getMetadata()), this.mapToken(partOfDirective.getPartToken()), this.mapToken(partOfDirective.getOfToken()), this.cloneNode(partOfDirective.getLibraryName()), this.mapToken(partOfDirective.getSemicolon()));
        partOfDirective2.setElement(partOfDirective.getElement());
        return partOfDirective2;
    }

    @Override
    public PostfixExpression visitPostfixExpression(PostfixExpression postfixExpression) {
        PostfixExpression postfixExpression2 = new PostfixExpression(this.cloneNode(postfixExpression.getOperand()), this.mapToken(postfixExpression.getOperator()));
        postfixExpression2.setPropagatedElement(postfixExpression.getPropagatedElement());
        postfixExpression2.setPropagatedType(postfixExpression.getPropagatedType());
        postfixExpression2.setStaticElement(postfixExpression.getStaticElement());
        postfixExpression2.setStaticType(postfixExpression.getStaticType());
        return postfixExpression2;
    }

    @Override
    public PrefixedIdentifier visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        PrefixedIdentifier prefixedIdentifier2 = new PrefixedIdentifier(this.cloneNode(prefixedIdentifier.getPrefix()), this.mapToken(prefixedIdentifier.getPeriod()), this.cloneNode(prefixedIdentifier.getIdentifier()));
        prefixedIdentifier2.setPropagatedType(prefixedIdentifier.getPropagatedType());
        prefixedIdentifier2.setStaticType(prefixedIdentifier.getStaticType());
        return prefixedIdentifier2;
    }

    @Override
    public PrefixExpression visitPrefixExpression(PrefixExpression prefixExpression) {
        PrefixExpression prefixExpression2 = new PrefixExpression(this.mapToken(prefixExpression.getOperator()), this.cloneNode(prefixExpression.getOperand()));
        prefixExpression2.setPropagatedElement(prefixExpression.getPropagatedElement());
        prefixExpression2.setPropagatedType(prefixExpression.getPropagatedType());
        prefixExpression2.setStaticElement(prefixExpression.getStaticElement());
        prefixExpression2.setStaticType(prefixExpression.getStaticType());
        return prefixExpression2;
    }

    @Override
    public PropertyAccess visitPropertyAccess(PropertyAccess propertyAccess) {
        PropertyAccess propertyAccess2 = new PropertyAccess(this.cloneNode(propertyAccess.getTarget()), this.mapToken(propertyAccess.getOperator()), this.cloneNode(propertyAccess.getPropertyName()));
        propertyAccess2.setPropagatedType(propertyAccess.getPropagatedType());
        propertyAccess2.setStaticType(propertyAccess.getStaticType());
        return propertyAccess2;
    }

    @Override
    public RedirectingConstructorInvocation visitRedirectingConstructorInvocation(RedirectingConstructorInvocation redirectingConstructorInvocation) {
        RedirectingConstructorInvocation redirectingConstructorInvocation2 = new RedirectingConstructorInvocation(this.mapToken(redirectingConstructorInvocation.getKeyword()), this.mapToken(redirectingConstructorInvocation.getPeriod()), this.cloneNode(redirectingConstructorInvocation.getConstructorName()), this.cloneNode(redirectingConstructorInvocation.getArgumentList()));
        redirectingConstructorInvocation2.setStaticElement(redirectingConstructorInvocation.getStaticElement());
        return redirectingConstructorInvocation2;
    }

    @Override
    public RethrowExpression visitRethrowExpression(RethrowExpression rethrowExpression) {
        RethrowExpression rethrowExpression2 = new RethrowExpression(this.mapToken(rethrowExpression.getKeyword()));
        rethrowExpression2.setPropagatedType(rethrowExpression.getPropagatedType());
        rethrowExpression2.setStaticType(rethrowExpression.getStaticType());
        return rethrowExpression2;
    }

    @Override
    public ReturnStatement visitReturnStatement(ReturnStatement returnStatement) {
        return new ReturnStatement(this.mapToken(returnStatement.getKeyword()), this.cloneNode(returnStatement.getExpression()), this.mapToken(returnStatement.getSemicolon()));
    }

    @Override
    public ScriptTag visitScriptTag(ScriptTag scriptTag) {
        return new ScriptTag(this.mapToken(scriptTag.getScriptTag()));
    }

    @Override
    public ShowCombinator visitShowCombinator(ShowCombinator showCombinator) {
        return new ShowCombinator(this.mapToken(showCombinator.getKeyword()), this.cloneNodeList(showCombinator.getShownNames()));
    }

    @Override
    public SimpleFormalParameter visitSimpleFormalParameter(SimpleFormalParameter simpleFormalParameter) {
        return new SimpleFormalParameter(this.cloneNode(simpleFormalParameter.getDocumentationComment()), this.cloneNodeList(simpleFormalParameter.getMetadata()), this.mapToken(simpleFormalParameter.getKeyword()), this.cloneNode(simpleFormalParameter.getType()), this.cloneNode(simpleFormalParameter.getIdentifier()));
    }

    @Override
    public SimpleIdentifier visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        Token token = this.mapToken(simpleIdentifier.getToken());
        if (token == null) {
            token = simpleIdentifier.getToken();
        }
        SimpleIdentifier simpleIdentifier2 = new SimpleIdentifier(token);
        simpleIdentifier2.setAuxiliaryElements(simpleIdentifier.getAuxiliaryElements());
        simpleIdentifier2.setPropagatedElement(simpleIdentifier.getPropagatedElement());
        simpleIdentifier2.setPropagatedType(simpleIdentifier.getPropagatedType());
        simpleIdentifier2.setStaticElement(simpleIdentifier.getStaticElement());
        simpleIdentifier2.setStaticType(simpleIdentifier.getStaticType());
        return simpleIdentifier2;
    }

    @Override
    public SimpleStringLiteral visitSimpleStringLiteral(SimpleStringLiteral simpleStringLiteral) {
        SimpleStringLiteral simpleStringLiteral2 = new SimpleStringLiteral(this.mapToken(simpleStringLiteral.getLiteral()), simpleStringLiteral.getValue());
        simpleStringLiteral2.setPropagatedType(simpleStringLiteral.getPropagatedType());
        simpleStringLiteral2.setStaticType(simpleStringLiteral.getStaticType());
        return simpleStringLiteral2;
    }

    @Override
    public StringInterpolation visitStringInterpolation(StringInterpolation stringInterpolation) {
        StringInterpolation stringInterpolation2 = new StringInterpolation(this.cloneNodeList(stringInterpolation.getElements()));
        stringInterpolation2.setPropagatedType(stringInterpolation.getPropagatedType());
        stringInterpolation2.setStaticType(stringInterpolation.getStaticType());
        return stringInterpolation2;
    }

    @Override
    public SuperConstructorInvocation visitSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
        SuperConstructorInvocation superConstructorInvocation2 = new SuperConstructorInvocation(this.mapToken(superConstructorInvocation.getKeyword()), this.mapToken(superConstructorInvocation.getPeriod()), this.cloneNode(superConstructorInvocation.getConstructorName()), this.cloneNode(superConstructorInvocation.getArgumentList()));
        superConstructorInvocation2.setStaticElement(superConstructorInvocation.getStaticElement());
        return superConstructorInvocation2;
    }

    @Override
    public SuperExpression visitSuperExpression(SuperExpression superExpression) {
        SuperExpression superExpression2 = new SuperExpression(this.mapToken(superExpression.getKeyword()));
        superExpression2.setPropagatedType(superExpression.getPropagatedType());
        superExpression2.setStaticType(superExpression.getStaticType());
        return superExpression2;
    }

    @Override
    public SwitchCase visitSwitchCase(SwitchCase switchCase) {
        return new SwitchCase(this.cloneNodeList(switchCase.getLabels()), this.mapToken(switchCase.getKeyword()), this.cloneNode(switchCase.getExpression()), this.mapToken(switchCase.getColon()), this.cloneNodeList(switchCase.getStatements()));
    }

    @Override
    public SwitchDefault visitSwitchDefault(SwitchDefault switchDefault) {
        return new SwitchDefault(this.cloneNodeList(switchDefault.getLabels()), this.mapToken(switchDefault.getKeyword()), this.mapToken(switchDefault.getColon()), this.cloneNodeList(switchDefault.getStatements()));
    }

    @Override
    public SwitchStatement visitSwitchStatement(SwitchStatement switchStatement) {
        return new SwitchStatement(this.mapToken(switchStatement.getKeyword()), this.mapToken(switchStatement.getLeftParenthesis()), this.cloneNode(switchStatement.getExpression()), this.mapToken(switchStatement.getRightParenthesis()), this.mapToken(switchStatement.getLeftBracket()), this.cloneNodeList(switchStatement.getMembers()), this.mapToken(switchStatement.getRightBracket()));
    }

    @Override
    public AstNode visitSymbolLiteral(SymbolLiteral symbolLiteral) {
        SymbolLiteral symbolLiteral2 = new SymbolLiteral(this.mapToken(symbolLiteral.getPoundSign()), this.mapTokens(symbolLiteral.getComponents()));
        symbolLiteral2.setPropagatedType(symbolLiteral.getPropagatedType());
        symbolLiteral2.setStaticType(symbolLiteral.getStaticType());
        return symbolLiteral2;
    }

    @Override
    public ThisExpression visitThisExpression(ThisExpression thisExpression) {
        ThisExpression thisExpression2 = new ThisExpression(this.mapToken(thisExpression.getKeyword()));
        thisExpression2.setPropagatedType(thisExpression.getPropagatedType());
        thisExpression2.setStaticType(thisExpression.getStaticType());
        return thisExpression2;
    }

    @Override
    public ThrowExpression visitThrowExpression(ThrowExpression throwExpression) {
        ThrowExpression throwExpression2 = new ThrowExpression(this.mapToken(throwExpression.getKeyword()), this.cloneNode(throwExpression.getExpression()));
        throwExpression2.setPropagatedType(throwExpression.getPropagatedType());
        throwExpression2.setStaticType(throwExpression.getStaticType());
        return throwExpression2;
    }

    @Override
    public TopLevelVariableDeclaration visitTopLevelVariableDeclaration(TopLevelVariableDeclaration topLevelVariableDeclaration) {
        return new TopLevelVariableDeclaration(this.cloneNode(topLevelVariableDeclaration.getDocumentationComment()), this.cloneNodeList(topLevelVariableDeclaration.getMetadata()), this.cloneNode(topLevelVariableDeclaration.getVariables()), this.mapToken(topLevelVariableDeclaration.getSemicolon()));
    }

    @Override
    public TryStatement visitTryStatement(TryStatement tryStatement) {
        return new TryStatement(this.mapToken(tryStatement.getTryKeyword()), this.cloneNode(tryStatement.getBody()), this.cloneNodeList(tryStatement.getCatchClauses()), this.mapToken(tryStatement.getFinallyKeyword()), this.cloneNode(tryStatement.getFinallyBlock()));
    }

    @Override
    public TypeArgumentList visitTypeArgumentList(TypeArgumentList typeArgumentList) {
        return new TypeArgumentList(this.mapToken(typeArgumentList.getLeftBracket()), this.cloneNodeList(typeArgumentList.getArguments()), this.mapToken(typeArgumentList.getRightBracket()));
    }

    @Override
    public TypeName visitTypeName(TypeName typeName) {
        TypeName typeName2 = new TypeName(this.cloneNode(typeName.getName()), this.cloneNode(typeName.getTypeArguments()));
        typeName2.setType(typeName.getType());
        return typeName2;
    }

    @Override
    public TypeParameter visitTypeParameter(TypeParameter typeParameter) {
        return new TypeParameter(this.cloneNode(typeParameter.getDocumentationComment()), this.cloneNodeList(typeParameter.getMetadata()), this.cloneNode(typeParameter.getName()), this.mapToken(typeParameter.getKeyword()), this.cloneNode(typeParameter.getBound()));
    }

    @Override
    public TypeParameterList visitTypeParameterList(TypeParameterList typeParameterList) {
        return new TypeParameterList(this.mapToken(typeParameterList.getLeftBracket()), this.cloneNodeList(typeParameterList.getTypeParameters()), this.mapToken(typeParameterList.getRightBracket()));
    }

    @Override
    public VariableDeclaration visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        return new VariableDeclaration(null, this.cloneNodeList(variableDeclaration.getMetadata()), this.cloneNode(variableDeclaration.getName()), this.mapToken(variableDeclaration.getEquals()), this.cloneNode(variableDeclaration.getInitializer()));
    }

    @Override
    public VariableDeclarationList visitVariableDeclarationList(VariableDeclarationList variableDeclarationList) {
        return new VariableDeclarationList(null, this.cloneNodeList(variableDeclarationList.getMetadata()), this.mapToken(variableDeclarationList.getKeyword()), this.cloneNode(variableDeclarationList.getType()), this.cloneNodeList(variableDeclarationList.getVariables()));
    }

    @Override
    public VariableDeclarationStatement visitVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement) {
        return new VariableDeclarationStatement(this.cloneNode(variableDeclarationStatement.getVariables()), this.mapToken(variableDeclarationStatement.getSemicolon()));
    }

    @Override
    public WhileStatement visitWhileStatement(WhileStatement whileStatement) {
        return new WhileStatement(this.mapToken(whileStatement.getKeyword()), this.mapToken(whileStatement.getLeftParenthesis()), this.cloneNode(whileStatement.getCondition()), this.mapToken(whileStatement.getRightParenthesis()), this.cloneNode(whileStatement.getBody()));
    }

    @Override
    public WithClause visitWithClause(WithClause withClause) {
        return new WithClause(this.mapToken(withClause.getWithKeyword()), this.cloneNodeList(withClause.getMixinTypes()));
    }

    private <E extends AstNode> E cloneNode(E e) {
        if (e == null) {
            return null;
        }
        if (e == this.oldNode) {
            return (E)this.newNode;
        }
        return (E)e.accept(this);
    }

    private <E extends AstNode> List<E> cloneNodeList(NodeList<E> nodeList) {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        for (AstNode astNode : nodeList) {
            arrayList.add(this.cloneNode(astNode));
        }
        return arrayList;
    }

    private Token mapToken(Token token) {
        if (token == null) {
            return null;
        }
        return this.tokenMap.get(token);
    }

    private Token[] mapTokens(Token[] tokenArray) {
        Token[] tokenArray2 = new Token[tokenArray.length];
        for (int i = 0; i < tokenArray2.length; ++i) {
            tokenArray2[i] = this.mapToken(tokenArray[i]);
        }
        return tokenArray2;
    }
}

