/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.source;

import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.sdk.DartSdk;
import com.google.dart.engine.source.DartUriResolver;
import com.google.dart.engine.source.LocalSourcePredicate;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.UriKind;
import com.google.dart.engine.source.UriResolver;
import java.net.URI;
import java.net.URISyntaxException;

public class SourceFactory {
    private AnalysisContext context;
    private UriResolver[] resolvers;
    private LocalSourcePredicate localSourcePredicate = LocalSourcePredicate.NOT_SDK;

    public SourceFactory(UriResolver ... uriResolverArray) {
        this.resolvers = uriResolverArray;
    }

    public Source forUri(String string) {
        try {
            URI uRI = new URI(string);
            if (uRI.isAbsolute()) {
                return this.internalResolveUri(null, uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public Source fromEncoding(String string) {
        if (string.length() < 2) {
            throw new IllegalArgumentException("Invalid encoding length");
        }
        UriKind uriKind = UriKind.fromEncoding(string.charAt(0));
        if (uriKind == null) {
            throw new IllegalArgumentException("Invalid source kind in encoding: " + (Object)((Object)uriKind));
        }
        try {
            URI uRI = new URI(string.substring(1));
            for (UriResolver uriResolver : this.resolvers) {
                Source source = uriResolver.fromEncoding(uriKind, uRI);
                if (source == null) continue;
                return source;
            }
            throw new IllegalArgumentException("No resolver for kind: " + (Object)((Object)uriKind));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid URI in encoding");
        }
    }

    public AnalysisContext getContext() {
        return this.context;
    }

    public DartSdk getDartSdk() {
        for (UriResolver uriResolver : this.resolvers) {
            if (!(uriResolver instanceof DartUriResolver)) continue;
            DartUriResolver dartUriResolver = (DartUriResolver)uriResolver;
            return dartUriResolver.getDartSdk();
        }
        return null;
    }

    public boolean isLocalSource(Source source) {
        return this.localSourcePredicate.isLocal(source);
    }

    public Source resolveUri(Source source, String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return this.internalResolveUri(source, new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URI restoreUri(Source source) {
        for (UriResolver uriResolver : this.resolvers) {
            URI uRI = uriResolver.restoreAbsolute(source);
            if (uRI == null) continue;
            return uRI;
        }
        return null;
    }

    public void setContext(AnalysisContext analysisContext) {
        this.context = analysisContext;
    }

    public void setLocalSourcePredicate(LocalSourcePredicate localSourcePredicate) {
        this.localSourcePredicate = localSourcePredicate;
    }

    private Source internalResolveUri(Source source, URI uRI) {
        if (uRI.isAbsolute()) {
            for (UriResolver uriResolver : this.resolvers) {
                Source source2 = uriResolver.resolveAbsolute(uRI);
                if (source2 == null) continue;
                return source2;
            }
            return null;
        }
        return source.resolveRelative(uRI);
    }
}

