/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.source;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.source.FileBasedSource;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.UriKind;
import com.google.dart.engine.source.UriResolver;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class PackageUriResolver
extends UriResolver {
    private File[] packagesDirectories;
    public static final String PACKAGE_SCHEME = "package";
    private static boolean CanLogRequiredKeyIoException = true;

    public static boolean isPackageUri(URI uRI) {
        return PACKAGE_SCHEME.equals(uRI.getScheme());
    }

    public PackageUriResolver(File ... fileArray) {
        if (fileArray.length < 1) {
            throw new IllegalArgumentException("At least one package directory must be provided");
        }
        this.packagesDirectories = fileArray;
    }

    @Override
    public Source fromEncoding(UriKind uriKind, URI uRI) {
        if (uriKind == UriKind.PACKAGE_SELF_URI || uriKind == UriKind.PACKAGE_URI) {
            return new FileBasedSource(new File(uRI), uriKind);
        }
        return null;
    }

    @Override
    public Source resolveAbsolute(URI uRI) {
        String string;
        String string2;
        if (!PackageUriResolver.isPackageUri(uRI)) {
            return null;
        }
        String string3 = uRI.getPath();
        if (string3 == null && (string3 = uRI.getSchemeSpecificPart()) == null) {
            return null;
        }
        int n = string3.indexOf(47);
        if (n == -1) {
            string2 = string3;
            string = "";
        } else {
            if (n == 0) {
                return null;
            }
            string2 = string3.substring(0, n);
            string = string3.substring(n + 1);
        }
        for (File file : this.packagesDirectories) {
            File file2 = new File(file, string3);
            if (!file2.exists()) continue;
            File file3 = this.getCanonicalFile(file, string2, string);
            UriKind uriKind = this.isSelfReference(file, file3) ? UriKind.PACKAGE_SELF_URI : UriKind.PACKAGE_URI;
            return new FileBasedSource(file3, uriKind);
        }
        return new FileBasedSource(this.getCanonicalFile(this.packagesDirectories[0], string2, string), UriKind.PACKAGE_URI);
    }

    @Override
    public URI restoreAbsolute(Source source) {
        if (source instanceof FileBasedSource) {
            String string = ((FileBasedSource)source).getFile().getPath();
            for (File file : this.packagesDirectories) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (File file2 : fileArray) {
                    try {
                        String string2 = file2.getCanonicalPath();
                        if (!string.startsWith(string2)) continue;
                        String string3 = string.substring(string2.length());
                        return URI.create("package:" + file2.getName() + string3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    protected File getCanonicalFile(File file, String string, String string2) {
        File file2;
        block3: {
            file2 = new File(file, string);
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                if (!iOException.getMessage().contains("Required key not available")) {
                    AnalysisEngine.getInstance().getLogger().logError("Canonical failed: " + file2, iOException);
                }
                if (!CanLogRequiredKeyIoException) break block3;
                CanLogRequiredKeyIoException = false;
                AnalysisEngine.getInstance().getLogger().logError("Canonical failed: " + file2, iOException);
            }
        }
        return new File(file2, string2.replace('/', File.separatorChar));
    }

    private boolean isSelfReference(File file, File file2) {
        File file3 = file.getParentFile();
        if (file3 == null) {
            return false;
        }
        String string = file3.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        return string2.startsWith(string + "/lib");
    }
}

