/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.source;

import com.google.dart.engine.source.FileBasedSource;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.UriKind;
import com.google.dart.engine.source.UriResolver;
import java.io.File;
import java.net.URI;

public class FileUriResolver
extends UriResolver {
    public static final String FILE_SCHEME = "file";

    public static boolean isFileUri(URI uRI) {
        return uRI.getScheme().equals(FILE_SCHEME);
    }

    @Override
    public Source fromEncoding(UriKind uriKind, URI uRI) {
        if (uriKind == UriKind.FILE_URI) {
            return new FileBasedSource(new File(uRI), uriKind);
        }
        return null;
    }

    @Override
    public Source resolveAbsolute(URI uRI) {
        if (!FileUriResolver.isFileUri(uRI)) {
            return null;
        }
        return new FileBasedSource(new File(uRI));
    }
}

