/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.source;

import com.google.dart.engine.internal.context.PerformanceStatistics;
import com.google.dart.engine.internal.context.TimestampedData;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.UriKind;
import com.google.dart.engine.utilities.general.TimeCounter;
import com.google.dart.engine.utilities.io.FileUtilities;
import com.google.dart.engine.utilities.translation.DartBlockBody;
import com.google.dart.engine.utilities.translation.DartOmit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class FileBasedSource
implements Source {
    private final File file;
    private String encoding;
    private final UriKind uriKind;
    @DartOmit
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");

    public FileBasedSource(File file) {
        this(file, UriKind.FILE_URI);
    }

    public FileBasedSource(File file, UriKind uriKind) {
        this.file = file;
        this.uriKind = uriKind;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.file.equals(((FileBasedSource)object).file);
    }

    @Override
    public boolean exists() {
        return this.file.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimestampedData<CharSequence> getContents() throws Exception {
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.io.start();
        try {
            TimestampedData<CharSequence> timestampedData = this.getContentsFromFile();
            return timestampedData;
        }
        finally {
            timeCounterHandle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DartOmit
    public void getContentsToReceiver(Source.ContentReceiver contentReceiver) throws Exception {
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.io.start();
        try {
            this.getContentsFromFileToReceiver(contentReceiver);
        }
        finally {
            timeCounterHandle.stop();
        }
    }

    @Override
    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.uriKind.getEncoding() + this.file.toURI().toString();
        }
        return this.encoding;
    }

    @Override
    public String getFullName() {
        return this.file.getAbsolutePath();
    }

    @Override
    public long getModificationStamp() {
        return this.file.lastModified();
    }

    @Override
    public String getShortName() {
        return this.file.getName();
    }

    @Override
    public UriKind getUriKind() {
        return this.uriKind;
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public boolean isInSystemLibrary() {
        return this.uriKind == UriKind.DART_URI;
    }

    @Override
    public Source resolveRelative(URI uRI) {
        try {
            URI uRI2 = this.getFile().toURI().resolve(uRI).normalize();
            return new FileBasedSource(new File(uRI2), this.uriKind);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        if (this.file == null) {
            return "<unknown source>";
        }
        return this.file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DartBlockBody(value={"return new TimestampedData<String>(_file.lastModified(), _file.readAsStringSync());"})
    protected TimestampedData<CharSequence> getContentsFromFile() throws Exception {
        String string;
        long l = this.file.lastModified();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
        FileChannel fileChannel = null;
        ByteBuffer byteBuffer = null;
        try {
            fileChannel = randomAccessFile.getChannel();
            long l2 = fileChannel.size();
            if (l2 > Integer.MAX_VALUE) {
                throw new IllegalStateException("File is too long to be read");
            }
            int n = (int)l2;
            byte[] byArray = new byte[n];
            byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.position(0);
            byteBuffer.limit(n);
            fileChannel.read(byteBuffer);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            byteBuffer = null;
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
        if (byteBuffer != null) {
            byteBuffer.rewind();
            return new TimestampedData<CharSequence>(l, UTF_8_CHARSET.decode(byteBuffer));
        }
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8");
            string = FileUtilities.getContents(inputStreamReader);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new TimestampedData<CharSequence>(l, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DartOmit
    protected void getContentsFromFileToReceiver(Source.ContentReceiver contentReceiver) throws Exception {
        String string;
        long l = this.file.lastModified();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
        FileChannel fileChannel = null;
        ByteBuffer byteBuffer = null;
        try {
            fileChannel = randomAccessFile.getChannel();
            long l2 = fileChannel.size();
            if (l2 > Integer.MAX_VALUE) {
                throw new IllegalStateException("File is too long to be read");
            }
            int n = (int)l2;
            byte[] byArray = new byte[n];
            byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.position(0);
            byteBuffer.limit(n);
            fileChannel.read(byteBuffer);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            byteBuffer = null;
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
        if (byteBuffer != null) {
            byteBuffer.rewind();
            contentReceiver.accept(UTF_8_CHARSET.decode(byteBuffer), l);
            return;
        }
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8");
            string = FileUtilities.getContents(inputStreamReader);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        contentReceiver.accept(string, l);
    }

    File getFile() {
        return this.file;
    }
}

