/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.source;

import com.google.common.annotations.VisibleForTesting;
import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.sdk.DirectoryBasedDartSdk;
import com.google.dart.engine.source.FileBasedSource;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.UriKind;
import com.google.dart.engine.source.UriResolver;
import com.google.dart.engine.utilities.io.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExplicitPackageUriResolver
extends UriResolver {
    public static final String PACKAGE_SCHEME = "package";
    private static final String PUB_LIST_COMMAND = "list-package-dirs";
    private File rootDir;
    private DirectoryBasedDartSdk sdk;
    @VisibleForTesting
    protected Map<String, List<File>> packageMap;

    public static boolean isPackageUri(URI uRI) {
        return PACKAGE_SCHEME.equals(uRI.getScheme());
    }

    public ExplicitPackageUriResolver(DirectoryBasedDartSdk directoryBasedDartSdk, File file) {
        if (file == null) {
            throw new IllegalArgumentException("the root dir must not be null");
        }
        this.sdk = directoryBasedDartSdk;
        this.rootDir = file;
    }

    @Override
    public Source fromEncoding(UriKind uriKind, URI uRI) {
        if (uriKind == UriKind.PACKAGE_URI) {
            return new FileBasedSource(new File(uRI), uriKind);
        }
        return null;
    }

    @Override
    public Source resolveAbsolute(URI uRI) {
        List<File> list;
        String string;
        String string2;
        if (!ExplicitPackageUriResolver.isPackageUri(uRI)) {
            return null;
        }
        String string3 = uRI.getPath();
        if (string3 == null && (string3 = uRI.getSchemeSpecificPart()) == null) {
            return null;
        }
        int n = string3.indexOf(47);
        if (n == -1) {
            string2 = string3;
            string = "";
        } else {
            if (n == 0) {
                return null;
            }
            string2 = string3.substring(0, n);
            string = string3.substring(n + 1);
        }
        if (this.packageMap == null) {
            this.packageMap = this.calculatePackageMap();
        }
        if ((list = this.packageMap.get(string2)) != null) {
            for (File file : list) {
                File file2;
                if (!file.exists() || !(file2 = new File(file, string.replace('/', File.separatorChar))).exists()) continue;
                return new FileBasedSource(file2, UriKind.PACKAGE_URI);
            }
        }
        String string4 = string2 + "/" + string;
        return new FileBasedSource(new File(this.rootDir, string4.replace('/', File.separatorChar)), UriKind.PACKAGE_URI);
    }

    public String resolvePathToPackage(String string) {
        if (this.packageMap == null) {
            return null;
        }
        for (String string2 : this.packageMap.keySet()) {
            List<File> list = this.packageMap.get(string2);
            for (File file : list) {
                try {
                    if (!file.getCanonicalPath().endsWith(string)) continue;
                    return string2;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    @Override
    public URI restoreAbsolute(Source source) {
        if (this.packageMap == null) {
            return null;
        }
        if (source instanceof FileBasedSource) {
            String string = ((FileBasedSource)source).getFile().getPath();
            for (String string2 : this.packageMap.keySet()) {
                for (File file : this.packageMap.get(string2)) {
                    if (!file.exists()) continue;
                    try {
                        String string3 = file.getCanonicalPath();
                        if (!string.startsWith(string3)) continue;
                        String string4 = string.substring(string3.length());
                        return URI.create("package:" + string2 + "/" + string4);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        return null;
    }

    protected Map<String, List<File>> calculatePackageMap() {
        ProcessBuilder processBuilder = new ProcessBuilder(this.sdk.getPubExecutable().getAbsolutePath(), PUB_LIST_COMMAND);
        processBuilder.directory(this.rootDir);
        ProcessRunner processRunner = new ProcessRunner(processBuilder);
        try {
            if (processRunner.runSync(0L) == 0) {
                return this.parsePackageMap(processRunner.getStdOut());
            }
            AnalysisEngine.getInstance().getLogger().logInformation("pub list-package-dirs failed: exit code " + processRunner.getExitCode());
        }
        catch (IOException iOException) {
            AnalysisEngine.getInstance().getLogger().logInformation("error running pub list-package-dirs", iOException);
        }
        catch (JSONException jSONException) {
            AnalysisEngine.getInstance().getLogger().logError("malformed json from pub list-package-dirs", jSONException);
        }
        return new HashMap<String, List<File>>();
    }

    protected Map<String, List<File>> parsePackageMap(String string) throws JSONException {
        HashMap<String, List<File>> hashMap = new HashMap<String, List<File>>();
        JSONObject jSONObject = new JSONObject(string);
        JSONObject jSONObject2 = jSONObject.optJSONObject("packages");
        if (jSONObject2 != null) {
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                Object object;
                Object e = iterator.next();
                if (!(e instanceof String)) continue;
                String string2 = (String)e;
                ArrayList<File> arrayList = new ArrayList<File>();
                hashMap.put(string2, arrayList);
                Object object2 = jSONObject2.get(string2);
                if (object2 instanceof String) {
                    object = (String)object2;
                    arrayList.add(new File((String)object));
                    continue;
                }
                if (!(object2 instanceof JSONArray)) continue;
                object = (JSONArray)object2;
                for (int i = 0; i < ((JSONArray)object).length(); ++i) {
                    arrayList.add(new File(((JSONArray)object).getString(i)));
                }
            }
        }
        return hashMap;
    }
}

