/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.source;

import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceContainer;
import java.io.File;

public class DirectoryBasedSourceContainer
implements SourceContainer {
    private final String path;

    private static String appendFileSeparator(String string) {
        if (string == null || string.length() <= 0 || string.charAt(string.length() - 1) == File.separatorChar) {
            return string;
        }
        return string + File.separator;
    }

    public DirectoryBasedSourceContainer(File file) {
        this(file.getPath());
    }

    public DirectoryBasedSourceContainer(String string) {
        this.path = DirectoryBasedSourceContainer.appendFileSeparator(string);
    }

    @Override
    public boolean contains(Source source) {
        return source.getFullName().startsWith(this.path);
    }

    public boolean equals(Object object) {
        return object instanceof DirectoryBasedSourceContainer && ((DirectoryBasedSourceContainer)object).getPath().equals(this.getPath());
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "SourceContainer[" + this.path + "]";
    }
}

