/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.source;

import com.google.dart.engine.sdk.DartSdk;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.UriKind;
import com.google.dart.engine.source.UriResolver;
import java.net.URI;

public class DartUriResolver
extends UriResolver {
    private final DartSdk sdk;
    private static final String DART_SCHEME = "dart";
    private static final String DART_EXT_SCHEME = "dart-ext:";

    public static boolean isDartExtUri(String string) {
        return string != null && string.startsWith(DART_EXT_SCHEME);
    }

    public static boolean isDartUri(URI uRI) {
        return DART_SCHEME.equals(uRI.getScheme());
    }

    public DartUriResolver(DartSdk dartSdk) {
        this.sdk = dartSdk;
    }

    @Override
    public Source fromEncoding(UriKind uriKind, URI uRI) {
        if (uriKind == UriKind.DART_URI) {
            return this.sdk.fromEncoding(uriKind, uRI);
        }
        return null;
    }

    public DartSdk getDartSdk() {
        return this.sdk;
    }

    @Override
    public Source resolveAbsolute(URI uRI) {
        if (!DartUriResolver.isDartUri(uRI)) {
            return null;
        }
        return this.sdk.mapDartUri(uRI.toString());
    }
}

