/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.search;

import com.google.dart.engine.internal.search.pattern.AndSearchPattern;
import com.google.dart.engine.internal.search.pattern.CamelCaseSearchPattern;
import com.google.dart.engine.internal.search.pattern.ExactSearchPattern;
import com.google.dart.engine.internal.search.pattern.OrSearchPattern;
import com.google.dart.engine.internal.search.pattern.PrefixSearchPattern;
import com.google.dart.engine.internal.search.pattern.RegularExpressionSearchPattern;
import com.google.dart.engine.internal.search.pattern.WildcardSearchPattern;
import com.google.dart.engine.search.SearchPattern;

public final class SearchPatternFactory {
    public static SearchPattern createAndPattern(SearchPattern ... searchPatternArray) {
        if (searchPatternArray.length == 1) {
            return searchPatternArray[0];
        }
        return new AndSearchPattern(searchPatternArray);
    }

    public static SearchPattern createCamelCasePattern(String string, boolean bl) {
        return new CamelCaseSearchPattern(string, bl);
    }

    public static SearchPattern createExactPattern(String string, boolean bl) {
        return new ExactSearchPattern(string, bl);
    }

    public static SearchPattern createOrPattern(SearchPattern ... searchPatternArray) {
        if (searchPatternArray.length == 1) {
            return searchPatternArray[0];
        }
        return new OrSearchPattern(searchPatternArray);
    }

    public static SearchPattern createPrefixPattern(String string, boolean bl) {
        return new PrefixSearchPattern(string, bl);
    }

    public static SearchPattern createRegularExpressionPattern(String string, boolean bl) {
        return new RegularExpressionSearchPattern(string, bl);
    }

    public static SearchPattern createWildcardPattern(String string, boolean bl) {
        return new WildcardSearchPattern(string, bl);
    }

    private SearchPatternFactory() {
    }
}

