/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.search;

import com.google.common.base.Objects;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.search.MatchKind;
import com.google.dart.engine.search.MatchQuality;
import com.google.dart.engine.utilities.source.SourceRange;
import java.text.Collator;
import java.util.Comparator;

public class SearchMatch {
    private final MatchQuality quality;
    private final MatchKind kind;
    private final Element element;
    private final SourceRange sourceRange;
    private boolean qualified;
    public static final Comparator<SearchMatch> SORT_BY_ELEMENT_NAME = new Comparator<SearchMatch>(){

        @Override
        public int compare(SearchMatch searchMatch, SearchMatch searchMatch2) {
            String string = searchMatch.getElement().getDisplayName();
            String string2 = searchMatch2.getElement().getDisplayName();
            return Collator.getInstance().compare(string, string2);
        }
    };

    public SearchMatch(MatchQuality matchQuality, MatchKind matchKind, Element element, SourceRange sourceRange) {
        this.quality = matchQuality;
        this.kind = matchKind;
        this.element = element;
        this.sourceRange = sourceRange;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SearchMatch)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        SearchMatch searchMatch = (SearchMatch)object;
        return this.kind == searchMatch.kind && this.quality == searchMatch.quality && this.qualified == searchMatch.qualified && Objects.equal(this.sourceRange, searchMatch.sourceRange) && Objects.equal(this.element, searchMatch.element);
    }

    public Element getElement() {
        return this.element;
    }

    public MatchKind getKind() {
        return this.kind;
    }

    public MatchQuality getQuality() {
        return this.quality;
    }

    public SourceRange getSourceRange() {
        return this.sourceRange;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.element, this.sourceRange, this.kind});
    }

    public boolean isQualified() {
        return this.qualified;
    }

    public void setQualified(boolean bl) {
        this.qualified = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SearchMatch(kind=");
        stringBuilder.append((Object)this.kind);
        stringBuilder.append(", quality=");
        stringBuilder.append((Object)this.quality);
        stringBuilder.append(", element=");
        stringBuilder.append(this.element.getDisplayName());
        stringBuilder.append(", range=");
        stringBuilder.append(this.sourceRange);
        stringBuilder.append(", qualified=");
        stringBuilder.append(this.qualified);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

