/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.sdk;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.ChangeSet;
import com.google.dart.engine.internal.context.AnalysisContextImpl;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.sdk.LibraryMap;
import com.google.dart.engine.internal.sdk.SdkLibrariesReader;
import com.google.dart.engine.sdk.DartSdk;
import com.google.dart.engine.sdk.SdkLibrary;
import com.google.dart.engine.source.DartUriResolver;
import com.google.dart.engine.source.FileBasedSource;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceFactory;
import com.google.dart.engine.source.UriKind;
import com.google.dart.engine.utilities.io.FileUtilities;
import com.google.dart.engine.utilities.os.OSUtilities;
import com.google.dart.engine.utilities.translation.DartBlockBody;
import com.google.dart.engine.utilities.translation.DartOmit;
import com.google.dart.engine.utilities.translation.DartOptional;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class DirectoryBasedDartSdk
implements DartSdk {
    private InternalAnalysisContext analysisContext;
    private final File sdkDirectory;
    private String sdkVersion;
    private File dartiumExecutable;
    private File vmExecutable;
    private LibraryMap libraryMap;
    private static final String BIN_DIRECTORY_NAME = "bin";
    private static final String CHROMIUM_DIRECTORY_NAME = "chromium";
    private static final String DARTIUM_EXECUTABLE_NAME_LINUX = "chrome";
    private static final String DARTIUM_EXECUTABLE_NAME_MAC = "Chromium.app/Contents/MacOS/Chromium";
    private static final String DARTIUM_EXECUTABLE_NAME_WIN = "Chrome.exe";
    private static final String DEFAULT_DIRECTORY_PROPERTY_NAME = "com.google.dart.sdk";
    private static final String DOCS_DIRECTORY_NAME = "docs";
    private static final String DOC_FILE_SUFFIX = "_api.json";
    private static final String INTERNAL_DIR = "_internal";
    private static final String LIB_DIRECTORY_NAME = "lib";
    private static final String LIBRARIES_FILE = "libraries.dart";
    private static final String PUB_EXECUTABLE_NAME_WIN = "pub.bat";
    private static final String PUB_EXECUTABLE_NAME = "pub";
    private static final String REVISION_FILE_NAME = "revision";
    private static final String VM_EXECUTABLE_NAME_WIN = "dart.exe";
    private static final String VM_EXECUTABLE_NAME = "dart";

    public static DirectoryBasedDartSdk getDefaultSdk() {
        File file = DirectoryBasedDartSdk.getDefaultSdkDirectory();
        if (file == null) {
            return null;
        }
        return new DirectoryBasedDartSdk(file);
    }

    public static File getDefaultSdkDirectory() {
        String string = System.getProperty(DEFAULT_DIRECTORY_PROPERTY_NAME);
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    @DartOmit
    public DirectoryBasedDartSdk(File file) {
        this(file, false);
    }

    public DirectoryBasedDartSdk(File file, @DartOptional(defaultValue="false") boolean bl) {
        this.sdkDirectory = file.getAbsoluteFile();
        this.initializeSdk();
        this.initializeLibraryMap(bl);
        this.analysisContext = new AnalysisContextImpl();
        this.analysisContext.setSourceFactory(new SourceFactory(new DartUriResolver(this)));
        String[] stringArray = this.getUris();
        ChangeSet changeSet = new ChangeSet();
        for (String string : stringArray) {
            changeSet.addedSource(this.analysisContext.getSourceFactory().forUri(string));
        }
        this.analysisContext.applyChanges(changeSet);
    }

    @Override
    public Source fromEncoding(UriKind uriKind, URI uRI) {
        return new FileBasedSource(new File(uRI), uriKind);
    }

    @Override
    public AnalysisContext getContext() {
        return this.analysisContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDartiumExecutable() {
        DirectoryBasedDartSdk directoryBasedDartSdk = this;
        synchronized (directoryBasedDartSdk) {
            File file;
            if (this.dartiumExecutable == null && (file = new File(this.getDartiumWorkingDirectory(), this.getDartiumBinaryName())).exists()) {
                this.dartiumExecutable = file;
            }
        }
        return this.dartiumExecutable;
    }

    public File getDartiumWorkingDirectory() {
        return new File(this.sdkDirectory.getParentFile(), CHROMIUM_DIRECTORY_NAME);
    }

    public File getDirectory() {
        return this.sdkDirectory;
    }

    public File getDocDirectory() {
        return new File(this.sdkDirectory, DOCS_DIRECTORY_NAME);
    }

    public File getDocFileFor(String string) {
        File file = this.getDocDirectory();
        if (!file.exists()) {
            return null;
        }
        File file2 = new File(file, string);
        File file3 = new File(file2, string + DOC_FILE_SUFFIX);
        if (file3.exists()) {
            return file3;
        }
        return null;
    }

    public File getLibraryDirectory() {
        return new File(this.sdkDirectory, LIB_DIRECTORY_NAME);
    }

    public File getPubExecutable() {
        String string = OSUtilities.isWindows() ? PUB_EXECUTABLE_NAME_WIN : PUB_EXECUTABLE_NAME;
        File file = new File(new File(this.sdkDirectory, BIN_DIRECTORY_NAME), string);
        return file.exists() ? file : null;
    }

    @Override
    public SdkLibrary[] getSdkLibraries() {
        return this.libraryMap.getSdkLibraries();
    }

    @Override
    public SdkLibrary getSdkLibrary(String string) {
        return this.libraryMap.getLibrary(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSdkVersion() {
        DirectoryBasedDartSdk directoryBasedDartSdk = this;
        synchronized (directoryBasedDartSdk) {
            if (this.sdkVersion == null) {
                this.sdkVersion = "0";
                File file = new File(this.sdkDirectory, REVISION_FILE_NAME);
                try {
                    String string = FileUtilities.getContents(file);
                    if (string != null) {
                        this.sdkVersion = string;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.sdkVersion;
    }

    @Override
    public String[] getUris() {
        return this.libraryMap.getUris();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getVmExecutable() {
        DirectoryBasedDartSdk directoryBasedDartSdk = this;
        synchronized (directoryBasedDartSdk) {
            File file;
            if (this.vmExecutable == null && (file = new File(new File(this.sdkDirectory, BIN_DIRECTORY_NAME), this.getVmBinaryName())).exists()) {
                this.vmExecutable = file;
            }
        }
        return this.vmExecutable;
    }

    public boolean hasDocumentation() {
        return this.getDocDirectory().exists();
    }

    public boolean isDartiumInstalled() {
        return this.getDartiumExecutable() != null;
    }

    @Override
    public Source mapDartUri(String string) {
        SdkLibrary sdkLibrary = this.getSdkLibrary(string);
        if (sdkLibrary == null) {
            return null;
        }
        return new FileBasedSource(new File(this.getLibraryDirectory(), sdkLibrary.getPath()), UriKind.DART_URI);
    }

    @DartBlockBody(value={})
    private void ensureVmIsExecutable() {
        File file = this.getVmExecutable();
        if (file != null && !file.canExecute()) {
            FileUtilities.makeExecutable(file);
            AnalysisEngine.getInstance().getLogger().logError(file.getPath() + " was not executable");
        }
    }

    private String getDartiumBinaryName() {
        if (OSUtilities.isWindows()) {
            return DARTIUM_EXECUTABLE_NAME_WIN;
        }
        if (OSUtilities.isMac()) {
            return DARTIUM_EXECUTABLE_NAME_MAC;
        }
        return DARTIUM_EXECUTABLE_NAME_LINUX;
    }

    private String getVmBinaryName() {
        if (OSUtilities.isWindows()) {
            return VM_EXECUTABLE_NAME_WIN;
        }
        return VM_EXECUTABLE_NAME;
    }

    private void initializeLibraryMap(boolean bl) {
        File file = new File(new File(this.getLibraryDirectory(), INTERNAL_DIR), LIBRARIES_FILE);
        try {
            String string = FileUtilities.getContents(file);
            this.libraryMap = new SdkLibrariesReader(bl).readFromFile(file, string);
        }
        catch (Exception exception) {
            AnalysisEngine.getInstance().getLogger().logError("Could not initialize the library map from " + file.getAbsolutePath(), exception);
            this.libraryMap = new LibraryMap();
        }
    }

    private void initializeSdk() {
        if (!OSUtilities.isWindows()) {
            this.ensureVmIsExecutable();
        }
    }
}

