/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.scanner;

import com.google.dart.engine.scanner.TokenClass;

public enum TokenType {
    EOF(null, ""){

        public String toString() {
            return "-eof-";
        }
    }
    ,
    DOUBLE,
    HEXADECIMAL,
    IDENTIFIER,
    INT,
    KEYWORD,
    MULTI_LINE_COMMENT,
    SCRIPT_TAG,
    SINGLE_LINE_COMMENT,
    STRING,
    AMPERSAND(TokenClass.BITWISE_AND_OPERATOR, "&"),
    AMPERSAND_AMPERSAND(TokenClass.LOGICAL_AND_OPERATOR, "&&"),
    AMPERSAND_EQ(TokenClass.ASSIGNMENT_OPERATOR, "&="),
    AT(null, "@"),
    BANG(TokenClass.UNARY_PREFIX_OPERATOR, "!"),
    BANG_EQ(TokenClass.EQUALITY_OPERATOR, "!="),
    BAR(TokenClass.BITWISE_OR_OPERATOR, "|"),
    BAR_BAR(TokenClass.LOGICAL_OR_OPERATOR, "||"),
    BAR_EQ(TokenClass.ASSIGNMENT_OPERATOR, "|="),
    COLON(null, ":"),
    COMMA(null, ","),
    CARET(TokenClass.BITWISE_XOR_OPERATOR, "^"),
    CARET_EQ(TokenClass.ASSIGNMENT_OPERATOR, "^="),
    CLOSE_CURLY_BRACKET(null, "}"),
    CLOSE_PAREN(null, ")"),
    CLOSE_SQUARE_BRACKET(null, "]"),
    EQ(TokenClass.ASSIGNMENT_OPERATOR, "="),
    EQ_EQ(TokenClass.EQUALITY_OPERATOR, "=="),
    FUNCTION(null, "=>"),
    GT(TokenClass.RELATIONAL_OPERATOR, ">"),
    GT_EQ(TokenClass.RELATIONAL_OPERATOR, ">="),
    GT_GT(TokenClass.SHIFT_OPERATOR, ">>"),
    GT_GT_EQ(TokenClass.ASSIGNMENT_OPERATOR, ">>="),
    HASH(null, "#"),
    INDEX(TokenClass.UNARY_POSTFIX_OPERATOR, "[]"),
    INDEX_EQ(TokenClass.UNARY_POSTFIX_OPERATOR, "[]="),
    IS(TokenClass.RELATIONAL_OPERATOR, "is"),
    LT(TokenClass.RELATIONAL_OPERATOR, "<"),
    LT_EQ(TokenClass.RELATIONAL_OPERATOR, "<="),
    LT_LT(TokenClass.SHIFT_OPERATOR, "<<"),
    LT_LT_EQ(TokenClass.ASSIGNMENT_OPERATOR, "<<="),
    MINUS(TokenClass.ADDITIVE_OPERATOR, "-"),
    MINUS_EQ(TokenClass.ASSIGNMENT_OPERATOR, "-="),
    MINUS_MINUS(TokenClass.UNARY_PREFIX_OPERATOR, "--"),
    OPEN_CURLY_BRACKET(null, "{"),
    OPEN_PAREN(TokenClass.UNARY_POSTFIX_OPERATOR, "("),
    OPEN_SQUARE_BRACKET(TokenClass.UNARY_POSTFIX_OPERATOR, "["),
    PERCENT(TokenClass.MULTIPLICATIVE_OPERATOR, "%"),
    PERCENT_EQ(TokenClass.ASSIGNMENT_OPERATOR, "%="),
    PERIOD(TokenClass.UNARY_POSTFIX_OPERATOR, "."),
    PERIOD_PERIOD(TokenClass.CASCADE_OPERATOR, ".."),
    PLUS(TokenClass.ADDITIVE_OPERATOR, "+"),
    PLUS_EQ(TokenClass.ASSIGNMENT_OPERATOR, "+="),
    PLUS_PLUS(TokenClass.UNARY_PREFIX_OPERATOR, "++"),
    QUESTION(TokenClass.CONDITIONAL_OPERATOR, "?"),
    SEMICOLON(null, ";"),
    SLASH(TokenClass.MULTIPLICATIVE_OPERATOR, "/"),
    SLASH_EQ(TokenClass.ASSIGNMENT_OPERATOR, "/="),
    STAR(TokenClass.MULTIPLICATIVE_OPERATOR, "*"),
    STAR_EQ(TokenClass.ASSIGNMENT_OPERATOR, "*="),
    STRING_INTERPOLATION_EXPRESSION(null, "${"),
    STRING_INTERPOLATION_IDENTIFIER(null, "$"),
    TILDE(TokenClass.UNARY_PREFIX_OPERATOR, "~"),
    TILDE_SLASH(TokenClass.MULTIPLICATIVE_OPERATOR, "~/"),
    TILDE_SLASH_EQ(TokenClass.ASSIGNMENT_OPERATOR, "~/="),
    BACKPING(null, "`"),
    BACKSLASH(null, "\\"),
    PERIOD_PERIOD_PERIOD(null, "...");

    private TokenClass tokenClass;
    private String lexeme;

    private TokenType() {
        this(TokenClass.NO_CLASS, null);
    }

    private TokenType(TokenClass tokenClass, String string2) {
        this.tokenClass = tokenClass == null ? TokenClass.NO_CLASS : tokenClass;
        this.lexeme = string2;
    }

    public String getLexeme() {
        return this.lexeme;
    }

    public int getPrecedence() {
        return this.tokenClass.getPrecedence();
    }

    public boolean isAdditiveOperator() {
        return this.tokenClass == TokenClass.ADDITIVE_OPERATOR;
    }

    public boolean isAssignmentOperator() {
        return this.tokenClass == TokenClass.ASSIGNMENT_OPERATOR;
    }

    public boolean isAssociativeOperator() {
        return this == AMPERSAND || this == AMPERSAND_AMPERSAND || this == BAR || this == BAR_BAR || this == CARET || this == PLUS || this == STAR;
    }

    public boolean isEqualityOperator() {
        return this.tokenClass == TokenClass.EQUALITY_OPERATOR;
    }

    public boolean isIncrementOperator() {
        return this.lexeme == "++" || this.lexeme == "--";
    }

    public boolean isMultiplicativeOperator() {
        return this.tokenClass == TokenClass.MULTIPLICATIVE_OPERATOR;
    }

    public boolean isOperator() {
        return this.tokenClass != TokenClass.NO_CLASS && this != OPEN_PAREN && this != OPEN_SQUARE_BRACKET && this != PERIOD;
    }

    public boolean isRelationalOperator() {
        return this.tokenClass == TokenClass.RELATIONAL_OPERATOR;
    }

    public boolean isShiftOperator() {
        return this.tokenClass == TokenClass.SHIFT_OPERATOR;
    }

    public boolean isUnaryPostfixOperator() {
        return this.tokenClass == TokenClass.UNARY_POSTFIX_OPERATOR;
    }

    public boolean isUnaryPrefixOperator() {
        return this.tokenClass == TokenClass.UNARY_PREFIX_OPERATOR;
    }

    public boolean isUserDefinableOperator() {
        return this.lexeme == "==" || this.lexeme == "~" || this.lexeme == "[]" || this.lexeme == "[]=" || this.lexeme == "*" || this.lexeme == "/" || this.lexeme == "%" || this.lexeme == "~/" || this.lexeme == "+" || this.lexeme == "-" || this.lexeme == "<<" || this.lexeme == ">>" || this.lexeme == ">=" || this.lexeme == ">" || this.lexeme == "<=" || this.lexeme == "<" || this.lexeme == "&" || this.lexeme == "^" || this.lexeme == "|";
    }
}

