/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.scanner;

import com.google.dart.engine.scanner.TokenType;

public class Token {
    private final TokenType type;
    private int offset;
    private Token previous;
    private Token next;

    public Token(TokenType tokenType, int n) {
        this.type = tokenType;
        this.offset = n;
    }

    public Token copy() {
        return new Token(this.type, this.offset);
    }

    public int getEnd() {
        return this.offset + this.getLength();
    }

    public int getLength() {
        return this.getLexeme().length();
    }

    public String getLexeme() {
        return this.type.getLexeme();
    }

    public Token getNext() {
        return this.next;
    }

    public int getOffset() {
        return this.offset;
    }

    public Token getPrecedingComments() {
        return null;
    }

    public Token getPrevious() {
        return this.previous;
    }

    public TokenType getType() {
        return this.type;
    }

    public boolean isOperator() {
        return this.type.isOperator();
    }

    public boolean isSynthetic() {
        return this.getLength() == 0;
    }

    public boolean isUserDefinableOperator() {
        return this.type.isUserDefinableOperator();
    }

    public boolean matchesAny(TokenType ... tokenTypeArray) {
        for (TokenType tokenType : tokenTypeArray) {
            if (this.type != tokenType) continue;
            return true;
        }
        return false;
    }

    public Token setNext(Token token) {
        this.next = token;
        token.setPrevious(this);
        return token;
    }

    public Token setNextWithoutSettingPrevious(Token token) {
        this.next = token;
        return token;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public String toString() {
        return this.getLexeme();
    }

    public Object value() {
        return this.type.getLexeme();
    }

    protected void applyDelta(int n) {
        this.offset += n;
    }

    protected Token copyComments(Token token) {
        Token token2;
        if (token == null) {
            return null;
        }
        Token token3 = token2 = token.copy();
        for (token = token.getNext(); token != null; token = token.getNext()) {
            token3 = token3.setNext(token.copy());
        }
        return token2;
    }

    private void setPrevious(Token token) {
        this.previous = token;
    }
}

