/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.scanner;

import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.scanner.BeginToken;
import com.google.dart.engine.scanner.BeginTokenWithComment;
import com.google.dart.engine.scanner.CharacterReader;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordState;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.KeywordTokenWithComment;
import com.google.dart.engine.scanner.ScannerErrorCode;
import com.google.dart.engine.scanner.StringToken;
import com.google.dart.engine.scanner.StringTokenWithComment;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.scanner.TokenWithComment;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.collection.IntList;
import com.google.dart.engine.utilities.instrumentation.Instrumentation;
import com.google.dart.engine.utilities.instrumentation.InstrumentationBuilder;
import java.util.ArrayList;
import java.util.List;

public class Scanner {
    private final Source source;
    private CharacterReader reader;
    private AnalysisErrorListener errorListener;
    private boolean preserveComments = true;
    private final Token tokens;
    private Token tail;
    private Token firstComment;
    private Token lastComment;
    private int tokenStart;
    private IntList lineStarts = new IntList(1024);
    private List<BeginToken> groupingStack = new ArrayList<BeginToken>(128);
    private int stackEnd = -1;
    private boolean hasUnmatchedGroups = false;

    public Scanner(Source source, CharacterReader characterReader, AnalysisErrorListener analysisErrorListener) {
        this.source = source;
        this.reader = characterReader;
        this.errorListener = analysisErrorListener;
        this.tokens = new Token(TokenType.EOF, -1);
        this.tokens.setNext(this.tokens);
        this.tail = this.tokens;
        this.tokenStart = -1;
        this.lineStarts.add(0);
    }

    public int[] getLineStarts() {
        return this.lineStarts.toArray();
    }

    public boolean hasUnmatchedGroups() {
        return this.hasUnmatchedGroups;
    }

    public void setPreserveComments(boolean bl) {
        this.preserveComments = bl;
    }

    public void setSourceStart(int n, int n2) {
        int n3 = this.reader.getOffset();
        if (n < 1 || n2 < 1 || n3 < 0 || n + n2 - 2 >= n3) {
            return;
        }
        for (int i = 2; i < n; ++i) {
            this.lineStarts.add(1);
        }
        this.lineStarts.add(n3 - n2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token tokenize() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("dart.engine.AbstractScanner.tokenize");
        int n = 0;
        try {
            int n2 = this.reader.advance();
            while (n2 != -1) {
                ++n;
                n2 = this.bigSwitch(n2);
            }
            this.appendEofToken();
            instrumentationBuilder.metric("tokensCount", n);
            Token token = this.getFirstToken();
            return token;
        }
        finally {
            instrumentationBuilder.log(2);
        }
    }

    protected void appendToken(Token token) {
        this.tail = this.tail.setNext(token);
    }

    protected int bigSwitch(int n) {
        int n2;
        this.beginToken();
        if (n == 13) {
            n = this.reader.advance();
            if (n == 10) {
                n = this.reader.advance();
            }
            this.recordStartOfLine();
            return n;
        }
        if (n == 10) {
            n = this.reader.advance();
            this.recordStartOfLine();
            return n;
        }
        if (n == 9 || n == 32) {
            return this.reader.advance();
        }
        if (n == 114 && ((n2 = this.reader.peek()) == 34 || n2 == 39)) {
            int n3 = this.reader.getOffset();
            return this.tokenizeString(this.reader.advance(), n3, true);
        }
        if (97 <= n && n <= 122) {
            return this.tokenizeKeywordOrIdentifier(n, true);
        }
        if (65 <= n && n <= 90 || n == 95 || n == 36) {
            return this.tokenizeIdentifier(n, this.reader.getOffset(), true);
        }
        if (n == 60) {
            return this.tokenizeLessThan(n);
        }
        if (n == 62) {
            return this.tokenizeGreaterThan(n);
        }
        if (n == 61) {
            return this.tokenizeEquals(n);
        }
        if (n == 33) {
            return this.tokenizeExclamation(n);
        }
        if (n == 43) {
            return this.tokenizePlus(n);
        }
        if (n == 45) {
            return this.tokenizeMinus(n);
        }
        if (n == 42) {
            return this.tokenizeMultiply(n);
        }
        if (n == 37) {
            return this.tokenizePercent(n);
        }
        if (n == 38) {
            return this.tokenizeAmpersand(n);
        }
        if (n == 124) {
            return this.tokenizeBar(n);
        }
        if (n == 94) {
            return this.tokenizeCaret(n);
        }
        if (n == 91) {
            return this.tokenizeOpenSquareBracket(n);
        }
        if (n == 126) {
            return this.tokenizeTilde(n);
        }
        if (n == 92) {
            this.appendTokenOfType(TokenType.BACKSLASH);
            return this.reader.advance();
        }
        if (n == 35) {
            return this.tokenizeTag(n);
        }
        if (n == 40) {
            this.appendBeginToken(TokenType.OPEN_PAREN);
            return this.reader.advance();
        }
        if (n == 41) {
            this.appendEndToken(TokenType.CLOSE_PAREN, TokenType.OPEN_PAREN);
            return this.reader.advance();
        }
        if (n == 44) {
            this.appendTokenOfType(TokenType.COMMA);
            return this.reader.advance();
        }
        if (n == 58) {
            this.appendTokenOfType(TokenType.COLON);
            return this.reader.advance();
        }
        if (n == 59) {
            this.appendTokenOfType(TokenType.SEMICOLON);
            return this.reader.advance();
        }
        if (n == 63) {
            this.appendTokenOfType(TokenType.QUESTION);
            return this.reader.advance();
        }
        if (n == 93) {
            this.appendEndToken(TokenType.CLOSE_SQUARE_BRACKET, TokenType.OPEN_SQUARE_BRACKET);
            return this.reader.advance();
        }
        if (n == 96) {
            this.appendTokenOfType(TokenType.BACKPING);
            return this.reader.advance();
        }
        if (n == 123) {
            this.appendBeginToken(TokenType.OPEN_CURLY_BRACKET);
            return this.reader.advance();
        }
        if (n == 125) {
            this.appendEndToken(TokenType.CLOSE_CURLY_BRACKET, TokenType.OPEN_CURLY_BRACKET);
            return this.reader.advance();
        }
        if (n == 47) {
            return this.tokenizeSlashOrComment(n);
        }
        if (n == 64) {
            this.appendTokenOfType(TokenType.AT);
            return this.reader.advance();
        }
        if (n == 34 || n == 39) {
            return this.tokenizeString(n, this.reader.getOffset(), false);
        }
        if (n == 46) {
            return this.tokenizeDotOrNumber(n);
        }
        if (n == 48) {
            return this.tokenizeHexOrNumber(n);
        }
        if (49 <= n && n <= 57) {
            return this.tokenizeNumber(n);
        }
        if (n == -1) {
            return -1;
        }
        this.reportError(ScannerErrorCode.ILLEGAL_CHARACTER, n);
        return this.reader.advance();
    }

    protected Token getFirstToken() {
        return this.tokens.getNext();
    }

    protected Token getTail() {
        return this.tail;
    }

    protected void recordStartOfLine() {
        this.lineStarts.add(this.reader.getOffset());
    }

    private void appendBeginToken(TokenType tokenType) {
        BeginToken beginToken;
        if (this.firstComment == null) {
            beginToken = new BeginToken(tokenType, this.tokenStart);
        } else {
            beginToken = new BeginTokenWithComment(tokenType, this.tokenStart, this.firstComment);
            this.firstComment = null;
            this.lastComment = null;
        }
        this.tail = this.tail.setNext(beginToken);
        this.groupingStack.add(beginToken);
        ++this.stackEnd;
    }

    private void appendCommentToken(TokenType tokenType, String string) {
        if (!this.preserveComments) {
            return;
        }
        this.lastComment = this.firstComment == null ? (this.firstComment = new StringToken(tokenType, string, this.tokenStart)) : this.lastComment.setNext(new StringToken(tokenType, string, this.tokenStart));
    }

    private void appendEndToken(TokenType tokenType, TokenType tokenType2) {
        BeginToken beginToken;
        Token token;
        if (this.firstComment == null) {
            token = new Token(tokenType, this.tokenStart);
        } else {
            token = new TokenWithComment(tokenType, this.tokenStart, this.firstComment);
            this.firstComment = null;
            this.lastComment = null;
        }
        this.tail = this.tail.setNext(token);
        if (this.stackEnd >= 0 && (beginToken = this.groupingStack.get(this.stackEnd)).getType() == tokenType2) {
            beginToken.setEndToken(token);
            this.groupingStack.remove(this.stackEnd--);
        }
    }

    private void appendEofToken() {
        Token token;
        if (this.firstComment == null) {
            token = new Token(TokenType.EOF, this.reader.getOffset() + 1);
        } else {
            token = new TokenWithComment(TokenType.EOF, this.reader.getOffset() + 1, this.firstComment);
            this.firstComment = null;
            this.lastComment = null;
        }
        token.setNext(token);
        this.tail = this.tail.setNext(token);
        if (this.stackEnd >= 0) {
            this.hasUnmatchedGroups = true;
        }
    }

    private void appendKeywordToken(Keyword keyword) {
        if (this.firstComment == null) {
            this.tail = this.tail.setNext(new KeywordToken(keyword, this.tokenStart));
        } else {
            this.tail = this.tail.setNext(new KeywordTokenWithComment(keyword, this.tokenStart, this.firstComment));
            this.firstComment = null;
            this.lastComment = null;
        }
    }

    private void appendStringToken(TokenType tokenType, String string) {
        if (this.firstComment == null) {
            this.tail = this.tail.setNext(new StringToken(tokenType, string, this.tokenStart));
        } else {
            this.tail = this.tail.setNext(new StringTokenWithComment(tokenType, string, this.tokenStart, this.firstComment));
            this.firstComment = null;
            this.lastComment = null;
        }
    }

    private void appendStringTokenWithOffset(TokenType tokenType, String string, int n) {
        if (this.firstComment == null) {
            this.tail = this.tail.setNext(new StringToken(tokenType, string, this.tokenStart + n));
        } else {
            this.tail = this.tail.setNext(new StringTokenWithComment(tokenType, string, this.tokenStart + n, this.firstComment));
            this.firstComment = null;
            this.lastComment = null;
        }
    }

    private void appendTokenOfType(TokenType tokenType) {
        if (this.firstComment == null) {
            this.tail = this.tail.setNext(new Token(tokenType, this.tokenStart));
        } else {
            this.tail = this.tail.setNext(new TokenWithComment(tokenType, this.tokenStart, this.firstComment));
            this.firstComment = null;
            this.lastComment = null;
        }
    }

    private void appendTokenOfTypeWithOffset(TokenType tokenType, int n) {
        if (this.firstComment == null) {
            this.tail = this.tail.setNext(new Token(tokenType, n));
        } else {
            this.tail = this.tail.setNext(new TokenWithComment(tokenType, n, this.firstComment));
            this.firstComment = null;
            this.lastComment = null;
        }
    }

    private void beginToken() {
        this.tokenStart = this.reader.getOffset();
    }

    private BeginToken findTokenMatchingClosingBraceInInterpolationExpression() {
        while (this.stackEnd >= 0) {
            BeginToken beginToken = this.groupingStack.get(this.stackEnd);
            if (beginToken.getType() == TokenType.OPEN_CURLY_BRACKET || beginToken.getType() == TokenType.STRING_INTERPOLATION_EXPRESSION) {
                return beginToken;
            }
            this.hasUnmatchedGroups = true;
            this.groupingStack.remove(this.stackEnd--);
        }
        return null;
    }

    private Source getSource() {
        return this.source;
    }

    private void reportError(ScannerErrorCode scannerErrorCode, Object ... objectArray) {
        this.errorListener.onError(new AnalysisError(this.getSource(), this.reader.getOffset(), 1, scannerErrorCode, objectArray));
    }

    private int select(char c, TokenType tokenType, TokenType tokenType2) {
        int n = this.reader.advance();
        if (n == c) {
            this.appendTokenOfType(tokenType);
            return this.reader.advance();
        }
        this.appendTokenOfType(tokenType2);
        return n;
    }

    private int selectWithOffset(char c, TokenType tokenType, TokenType tokenType2, int n) {
        int n2 = this.reader.advance();
        if (n2 == c) {
            this.appendTokenOfTypeWithOffset(tokenType, n);
            return this.reader.advance();
        }
        this.appendTokenOfTypeWithOffset(tokenType2, n);
        return n2;
    }

    private int tokenizeAmpersand(int n) {
        n = this.reader.advance();
        if (n == 38) {
            this.appendTokenOfType(TokenType.AMPERSAND_AMPERSAND);
            return this.reader.advance();
        }
        if (n == 61) {
            this.appendTokenOfType(TokenType.AMPERSAND_EQ);
            return this.reader.advance();
        }
        this.appendTokenOfType(TokenType.AMPERSAND);
        return n;
    }

    private int tokenizeBar(int n) {
        n = this.reader.advance();
        if (n == 124) {
            this.appendTokenOfType(TokenType.BAR_BAR);
            return this.reader.advance();
        }
        if (n == 61) {
            this.appendTokenOfType(TokenType.BAR_EQ);
            return this.reader.advance();
        }
        this.appendTokenOfType(TokenType.BAR);
        return n;
    }

    private int tokenizeCaret(int n) {
        return this.select('=', TokenType.CARET_EQ, TokenType.CARET);
    }

    private int tokenizeDotOrNumber(int n) {
        int n2 = this.reader.getOffset();
        n = this.reader.advance();
        if (48 <= n && n <= 57) {
            return this.tokenizeFractionPart(n, n2);
        }
        if (46 == n) {
            return this.select('.', TokenType.PERIOD_PERIOD_PERIOD, TokenType.PERIOD_PERIOD);
        }
        this.appendTokenOfType(TokenType.PERIOD);
        return n;
    }

    private int tokenizeEquals(int n) {
        n = this.reader.advance();
        if (n == 61) {
            this.appendTokenOfType(TokenType.EQ_EQ);
            return this.reader.advance();
        }
        if (n == 62) {
            this.appendTokenOfType(TokenType.FUNCTION);
            return this.reader.advance();
        }
        this.appendTokenOfType(TokenType.EQ);
        return n;
    }

    private int tokenizeExclamation(int n) {
        n = this.reader.advance();
        if (n == 61) {
            this.appendTokenOfType(TokenType.BANG_EQ);
            return this.reader.advance();
        }
        this.appendTokenOfType(TokenType.BANG);
        return n;
    }

    private int tokenizeExponent(int n) {
        if (n == 43 || n == 45) {
            n = this.reader.advance();
        }
        boolean bl = false;
        while (true) {
            if (48 > n || n > 57) {
                if (!bl) {
                    this.reportError(ScannerErrorCode.MISSING_DIGIT, new Object[0]);
                }
                return n;
            }
            bl = true;
            n = this.reader.advance();
        }
    }

    private int tokenizeFractionPart(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            if (48 > n || n > 57) {
                if (101 == n || 69 == n) {
                    bl2 = true;
                    n = this.tokenizeExponent(this.reader.advance());
                    bl = true;
                    continue;
                }
                bl = true;
                continue;
            }
            bl2 = true;
            n = this.reader.advance();
        }
        if (!bl2) {
            this.appendStringToken(TokenType.INT, this.reader.getString(n2, -2));
            if (46 == n) {
                return this.selectWithOffset('.', TokenType.PERIOD_PERIOD_PERIOD, TokenType.PERIOD_PERIOD, this.reader.getOffset() - 1);
            }
            this.appendTokenOfTypeWithOffset(TokenType.PERIOD, this.reader.getOffset() - 1);
            return this.bigSwitch(n);
        }
        this.appendStringToken(TokenType.DOUBLE, this.reader.getString(n2, n < 0 ? 0 : -1));
        return n;
    }

    private int tokenizeGreaterThan(int n) {
        n = this.reader.advance();
        if (61 == n) {
            this.appendTokenOfType(TokenType.GT_EQ);
            return this.reader.advance();
        }
        if (62 == n) {
            n = this.reader.advance();
            if (61 == n) {
                this.appendTokenOfType(TokenType.GT_GT_EQ);
                return this.reader.advance();
            }
            this.appendTokenOfType(TokenType.GT_GT);
            return n;
        }
        this.appendTokenOfType(TokenType.GT);
        return n;
    }

    private int tokenizeHex(int n) {
        int n2 = this.reader.getOffset() - 1;
        boolean bl = false;
        while (48 <= (n = this.reader.advance()) && n <= 57 || 65 <= n && n <= 70 || 97 <= n && n <= 102) {
            bl = true;
        }
        if (!bl) {
            this.reportError(ScannerErrorCode.MISSING_HEX_DIGIT, new Object[0]);
        }
        this.appendStringToken(TokenType.HEXADECIMAL, this.reader.getString(n2, n < 0 ? 0 : -1));
        return n;
    }

    private int tokenizeHexOrNumber(int n) {
        int n2 = this.reader.peek();
        if (n2 == 120 || n2 == 88) {
            this.reader.advance();
            return this.tokenizeHex(n2);
        }
        return this.tokenizeNumber(n);
    }

    private int tokenizeIdentifier(int n, int n2, boolean bl) {
        while (97 <= n && n <= 122 || 65 <= n && n <= 90 || 48 <= n && n <= 57 || n == 95 || n == 36 && bl) {
            n = this.reader.advance();
        }
        this.appendStringToken(TokenType.IDENTIFIER, this.reader.getString(n2, n < 0 ? 0 : -1));
        return n;
    }

    private int tokenizeInterpolatedExpression(int n, int n2) {
        this.appendBeginToken(TokenType.STRING_INTERPOLATION_EXPRESSION);
        n = this.reader.advance();
        while (n != -1) {
            if (n == 125) {
                BeginToken beginToken = this.findTokenMatchingClosingBraceInInterpolationExpression();
                if (beginToken == null) {
                    this.beginToken();
                    this.appendTokenOfType(TokenType.CLOSE_CURLY_BRACKET);
                    n = this.reader.advance();
                    this.beginToken();
                    return n;
                }
                if (beginToken.getType() == TokenType.OPEN_CURLY_BRACKET) {
                    this.beginToken();
                    this.appendEndToken(TokenType.CLOSE_CURLY_BRACKET, TokenType.OPEN_CURLY_BRACKET);
                    n = this.reader.advance();
                    this.beginToken();
                    continue;
                }
                if (beginToken.getType() != TokenType.STRING_INTERPOLATION_EXPRESSION) continue;
                this.beginToken();
                this.appendEndToken(TokenType.CLOSE_CURLY_BRACKET, TokenType.STRING_INTERPOLATION_EXPRESSION);
                n = this.reader.advance();
                this.beginToken();
                return n;
            }
            n = this.bigSwitch(n);
        }
        if (n == -1) {
            return n;
        }
        n = this.reader.advance();
        this.beginToken();
        return n;
    }

    private int tokenizeInterpolatedIdentifier(int n, int n2) {
        this.appendStringTokenWithOffset(TokenType.STRING_INTERPOLATION_IDENTIFIER, "$", 0);
        if (65 <= n && n <= 90 || 97 <= n && n <= 122 || n == 95) {
            this.beginToken();
            n = this.tokenizeKeywordOrIdentifier(n, false);
        }
        this.beginToken();
        return n;
    }

    private int tokenizeKeywordOrIdentifier(int n, boolean bl) {
        KeywordState keywordState;
        int n2 = this.reader.getOffset();
        for (keywordState = KeywordState.KEYWORD_STATE; keywordState != null && 97 <= n && n <= 122; keywordState = keywordState.next((char)n)) {
            n = this.reader.advance();
        }
        if (keywordState == null || keywordState.keyword() == null) {
            return this.tokenizeIdentifier(n, n2, bl);
        }
        if (65 <= n && n <= 90 || 48 <= n && n <= 57 || n == 95 || n == 36) {
            return this.tokenizeIdentifier(n, n2, bl);
        }
        if (n < 128) {
            this.appendKeywordToken(keywordState.keyword());
            return n;
        }
        return this.tokenizeIdentifier(n, n2, bl);
    }

    private int tokenizeLessThan(int n) {
        n = this.reader.advance();
        if (61 == n) {
            this.appendTokenOfType(TokenType.LT_EQ);
            return this.reader.advance();
        }
        if (60 == n) {
            return this.select('=', TokenType.LT_LT_EQ, TokenType.LT_LT);
        }
        this.appendTokenOfType(TokenType.LT);
        return n;
    }

    private int tokenizeMinus(int n) {
        n = this.reader.advance();
        if (n == 45) {
            this.appendTokenOfType(TokenType.MINUS_MINUS);
            return this.reader.advance();
        }
        if (n == 61) {
            this.appendTokenOfType(TokenType.MINUS_EQ);
            return this.reader.advance();
        }
        this.appendTokenOfType(TokenType.MINUS);
        return n;
    }

    private int tokenizeMultiLineComment(int n) {
        int n2 = 1;
        n = this.reader.advance();
        while (true) {
            if (-1 == n) {
                this.reportError(ScannerErrorCode.UNTERMINATED_MULTI_LINE_COMMENT, new Object[0]);
                this.appendCommentToken(TokenType.MULTI_LINE_COMMENT, this.reader.getString(this.tokenStart, 0));
                return n;
            }
            if (42 == n) {
                n = this.reader.advance();
                if (47 != n) continue;
                if (0 == --n2) {
                    this.appendCommentToken(TokenType.MULTI_LINE_COMMENT, this.reader.getString(this.tokenStart, 0));
                    return this.reader.advance();
                }
                n = this.reader.advance();
                continue;
            }
            if (47 == n) {
                n = this.reader.advance();
                if (42 != n) continue;
                n = this.reader.advance();
                ++n2;
                continue;
            }
            if (n == 13) {
                n = this.reader.advance();
                if (n == 10) {
                    n = this.reader.advance();
                }
                this.recordStartOfLine();
                continue;
            }
            if (n == 10) {
                this.recordStartOfLine();
                n = this.reader.advance();
                continue;
            }
            n = this.reader.advance();
        }
    }

    private int tokenizeMultiLineRawString(int n, int n2) {
        int n3 = this.reader.advance();
        block0: while (n3 != -1) {
            while (n3 != n) {
                n3 = this.reader.advance();
                if (n3 == -1) break block0;
                if (n3 == 13) {
                    n3 = this.reader.advance();
                    if (n3 == 10) {
                        n3 = this.reader.advance();
                    }
                    this.recordStartOfLine();
                    continue;
                }
                if (n3 != 10) continue;
                this.recordStartOfLine();
                n3 = this.reader.advance();
            }
            n3 = this.reader.advance();
            if (n3 != n || (n3 = this.reader.advance()) != n) continue;
            this.appendStringToken(TokenType.STRING, this.reader.getString(n2, 0));
            return this.reader.advance();
        }
        this.reportError(ScannerErrorCode.UNTERMINATED_STRING_LITERAL, new Object[0]);
        this.appendStringToken(TokenType.STRING, this.reader.getString(n2, 0));
        return this.reader.advance();
    }

    private int tokenizeMultiLineString(int n, int n2, boolean bl) {
        if (bl) {
            return this.tokenizeMultiLineRawString(n, n2);
        }
        int n3 = this.reader.advance();
        while (n3 != -1) {
            if (n3 == 36) {
                this.appendStringToken(TokenType.STRING, this.reader.getString(n2, -1));
                this.beginToken();
                n3 = this.tokenizeStringInterpolation(n2);
                n2 = this.reader.getOffset();
                continue;
            }
            if (n3 == n) {
                n3 = this.reader.advance();
                if (n3 != n || (n3 = this.reader.advance()) != n) continue;
                this.appendStringToken(TokenType.STRING, this.reader.getString(n2, 0));
                return this.reader.advance();
            }
            if (n3 == 92) {
                n3 = this.reader.advance();
                if (n3 == -1) break;
                if (n3 == 13) {
                    n3 = this.reader.advance();
                    if (n3 == 10) {
                        n3 = this.reader.advance();
                    }
                    this.recordStartOfLine();
                    continue;
                }
                if (n3 == 10) {
                    this.recordStartOfLine();
                    n3 = this.reader.advance();
                    continue;
                }
                n3 = this.reader.advance();
                continue;
            }
            if (n3 == 13) {
                n3 = this.reader.advance();
                if (n3 == 10) {
                    n3 = this.reader.advance();
                }
                this.recordStartOfLine();
                continue;
            }
            if (n3 == 10) {
                this.recordStartOfLine();
                n3 = this.reader.advance();
                continue;
            }
            n3 = this.reader.advance();
        }
        this.reportError(ScannerErrorCode.UNTERMINATED_STRING_LITERAL, new Object[0]);
        this.appendStringToken(TokenType.STRING, this.reader.getString(n2, 0));
        return this.reader.advance();
    }

    private int tokenizeMultiply(int n) {
        return this.select('=', TokenType.STAR_EQ, TokenType.STAR);
    }

    private int tokenizeNumber(int n) {
        int n2 = this.reader.getOffset();
        while (48 <= (n = this.reader.advance()) && n <= 57) {
        }
        if (n == 46) {
            return this.tokenizeFractionPart(this.reader.advance(), n2);
        }
        if (n == 101 || n == 69) {
            return this.tokenizeFractionPart(n, n2);
        }
        this.appendStringToken(TokenType.INT, this.reader.getString(n2, n < 0 ? 0 : -1));
        return n;
    }

    private int tokenizeOpenSquareBracket(int n) {
        n = this.reader.advance();
        if (n == 93) {
            return this.select('=', TokenType.INDEX_EQ, TokenType.INDEX);
        }
        this.appendBeginToken(TokenType.OPEN_SQUARE_BRACKET);
        return n;
    }

    private int tokenizePercent(int n) {
        return this.select('=', TokenType.PERCENT_EQ, TokenType.PERCENT);
    }

    private int tokenizePlus(int n) {
        n = this.reader.advance();
        if (43 == n) {
            this.appendTokenOfType(TokenType.PLUS_PLUS);
            return this.reader.advance();
        }
        if (61 == n) {
            this.appendTokenOfType(TokenType.PLUS_EQ);
            return this.reader.advance();
        }
        this.appendTokenOfType(TokenType.PLUS);
        return n;
    }

    private int tokenizeSingleLineComment(int n) {
        do {
            if (-1 != (n = this.reader.advance())) continue;
            this.appendCommentToken(TokenType.SINGLE_LINE_COMMENT, this.reader.getString(this.tokenStart, 0));
            return n;
        } while (10 != n && 13 != n);
        this.appendCommentToken(TokenType.SINGLE_LINE_COMMENT, this.reader.getString(this.tokenStart, -1));
        return n;
    }

    private int tokenizeSingleLineRawString(int n, int n2, int n3) {
        n = this.reader.advance();
        while (n != -1) {
            if (n == n2) {
                this.appendStringToken(TokenType.STRING, this.reader.getString(n3, 0));
                return this.reader.advance();
            }
            if (n == 13 || n == 10) {
                this.reportError(ScannerErrorCode.UNTERMINATED_STRING_LITERAL, new Object[0]);
                this.appendStringToken(TokenType.STRING, this.reader.getString(n3, 0));
                return this.reader.advance();
            }
            n = this.reader.advance();
        }
        this.reportError(ScannerErrorCode.UNTERMINATED_STRING_LITERAL, new Object[0]);
        this.appendStringToken(TokenType.STRING, this.reader.getString(n3, 0));
        return this.reader.advance();
    }

    private int tokenizeSingleLineString(int n, int n2, int n3) {
        while (n != n2) {
            if (n == 92) {
                n = this.reader.advance();
            } else if (n == 36) {
                this.appendStringToken(TokenType.STRING, this.reader.getString(n3, -1));
                this.beginToken();
                n = this.tokenizeStringInterpolation(n3);
                n3 = this.reader.getOffset();
                continue;
            }
            if (n <= 13 && (n == 10 || n == 13 || n == -1)) {
                this.reportError(ScannerErrorCode.UNTERMINATED_STRING_LITERAL, new Object[0]);
                this.appendStringToken(TokenType.STRING, this.reader.getString(n3, 0));
                return this.reader.advance();
            }
            n = this.reader.advance();
        }
        this.appendStringToken(TokenType.STRING, this.reader.getString(n3, 0));
        return this.reader.advance();
    }

    private int tokenizeSlashOrComment(int n) {
        n = this.reader.advance();
        if (42 == n) {
            return this.tokenizeMultiLineComment(n);
        }
        if (47 == n) {
            return this.tokenizeSingleLineComment(n);
        }
        if (61 == n) {
            this.appendTokenOfType(TokenType.SLASH_EQ);
            return this.reader.advance();
        }
        this.appendTokenOfType(TokenType.SLASH);
        return n;
    }

    private int tokenizeString(int n, int n2, boolean bl) {
        int n3 = n;
        if (n3 == (n = this.reader.advance())) {
            n = this.reader.advance();
            if (n3 == n) {
                return this.tokenizeMultiLineString(n3, n2, bl);
            }
            this.appendStringToken(TokenType.STRING, this.reader.getString(n2, -1));
            return n;
        }
        if (bl) {
            return this.tokenizeSingleLineRawString(n, n3, n2);
        }
        return this.tokenizeSingleLineString(n, n3, n2);
    }

    private int tokenizeStringInterpolation(int n) {
        this.beginToken();
        int n2 = this.reader.advance();
        if (n2 == 123) {
            return this.tokenizeInterpolatedExpression(n2, n);
        }
        return this.tokenizeInterpolatedIdentifier(n2, n);
    }

    private int tokenizeTag(int n) {
        if (this.reader.getOffset() == 0 && this.reader.peek() == 33) {
            while ((n = this.reader.advance()) != 10 && n != 13 && n > 0) {
            }
            this.appendStringToken(TokenType.SCRIPT_TAG, this.reader.getString(this.tokenStart, 0));
            return n;
        }
        this.appendTokenOfType(TokenType.HASH);
        return this.reader.advance();
    }

    private int tokenizeTilde(int n) {
        n = this.reader.advance();
        if (n == 47) {
            return this.select('=', TokenType.TILDE_SLASH_EQ, TokenType.TILDE_SLASH);
        }
        this.appendTokenOfType(TokenType.TILDE);
        return n;
    }
}

