/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.scanner;

import com.google.dart.engine.scanner.Keyword;
import java.util.Arrays;

public final class KeywordState {
    private static final KeywordState[] EMPTY_TABLE = new KeywordState[26];
    public static final KeywordState KEYWORD_STATE = KeywordState.createKeywordStateTable();
    private final KeywordState[] table;
    private final Keyword keyword;

    private static KeywordState computeKeywordStateTable(int n, String[] stringArray, int n2, int n3) {
        KeywordState[] keywordStateArray = new KeywordState[26];
        assert (n3 != 0);
        char c = '\u0000';
        int n4 = -1;
        boolean bl = false;
        for (int i = n2; i < n2 + n3; ++i) {
            char c2;
            if (stringArray[i].length() == n) {
                bl = true;
            }
            if (stringArray[i].length() <= n || c == (c2 = stringArray[i].charAt(n))) continue;
            if (n4 != -1) {
                keywordStateArray[c - 97] = KeywordState.computeKeywordStateTable(n + 1, stringArray, n4, i - n4);
            }
            n4 = i;
            c = c2;
        }
        if (n4 != -1) {
            assert (keywordStateArray[c - 97] == null);
        } else {
            assert (n3 == 1);
            return new KeywordState(EMPTY_TABLE, stringArray[n2]);
        }
        keywordStateArray[c - 97] = KeywordState.computeKeywordStateTable(n + 1, stringArray, n4, n2 + n3 - n4);
        if (bl) {
            return new KeywordState(keywordStateArray, stringArray[n2]);
        }
        return new KeywordState(keywordStateArray, null);
    }

    private static KeywordState createKeywordStateTable() {
        Keyword[] keywordArray = Keyword.values();
        Object[] objectArray = new String[keywordArray.length];
        for (int i = 0; i < keywordArray.length; ++i) {
            objectArray[i] = keywordArray[i].getSyntax();
        }
        Arrays.sort(objectArray);
        return KeywordState.computeKeywordStateTable(0, (String[])objectArray, 0, objectArray.length);
    }

    private KeywordState(KeywordState[] keywordStateArray, String string) {
        this.table = keywordStateArray;
        this.keyword = string == null ? null : Keyword.keywords.get(string);
    }

    public Keyword keyword() {
        return this.keyword;
    }

    public KeywordState next(char c) {
        return this.table[c - 97];
    }
}

