/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.scanner;

import java.util.LinkedHashMap;
import java.util.Map;

public enum Keyword {
    ASSERT("assert"),
    BREAK("break"),
    CASE("case"),
    CATCH("catch"),
    CLASS("class"),
    CONST("const"),
    CONTINUE("continue"),
    DEFAULT("default"),
    DO("do"),
    ELSE("else"),
    ENUM("enum"),
    EXTENDS("extends"),
    FALSE("false"),
    FINAL("final"),
    FINALLY("finally"),
    FOR("for"),
    IF("if"),
    IN("in"),
    IS("is"),
    NEW("new"),
    NULL("null"),
    RETHROW("rethrow"),
    RETURN("return"),
    SUPER("super"),
    SWITCH("switch"),
    THIS("this"),
    THROW("throw"),
    TRUE("true"),
    TRY("try"),
    VAR("var"),
    VOID("void"),
    WHILE("while"),
    WITH("with"),
    ABSTRACT("abstract", true),
    AS("as", true),
    DYNAMIC("dynamic", true),
    EXPORT("export", true),
    EXTERNAL("external", true),
    FACTORY("factory", true),
    GET("get", true),
    IMPLEMENTS("implements", true),
    IMPORT("import", true),
    LIBRARY("library", true),
    OPERATOR("operator", true),
    PART("part", true),
    SET("set", true),
    STATIC("static", true),
    TYPEDEF("typedef", true);

    private final String syntax;
    private final boolean isPseudoKeyword;
    public static Map<String, Keyword> keywords;

    private static Map<String, Keyword> createKeywordMap() {
        LinkedHashMap<String, Keyword> linkedHashMap = new LinkedHashMap<String, Keyword>();
        for (Keyword keyword : Keyword.values()) {
            linkedHashMap.put(keyword.syntax, keyword);
        }
        return linkedHashMap;
    }

    private Keyword(String string2) {
        this(string2, false);
    }

    private Keyword(String string2, boolean bl) {
        this.syntax = string2;
        this.isPseudoKeyword = bl;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public boolean isPseudoKeyword() {
        return this.isPseudoKeyword;
    }

    static {
        keywords = Keyword.createKeywordMap();
    }
}

