/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.scanner;

import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.scanner.CharacterReader;
import com.google.dart.engine.scanner.Scanner;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.collection.TokenMap;

public class IncrementalScanner
extends Scanner {
    private CharacterReader reader;
    private TokenMap tokenMap = new TokenMap();
    private Token leftToken;
    private Token rightToken;
    private boolean hasNonWhitespaceChange = false;

    public IncrementalScanner(Source source, CharacterReader characterReader, AnalysisErrorListener analysisErrorListener) {
        super(source, characterReader, analysisErrorListener);
        this.reader = characterReader;
    }

    public Token getLeftToken() {
        return this.leftToken;
    }

    public Token getRightToken() {
        return this.rightToken;
    }

    public TokenMap getTokenMap() {
        return this.tokenMap;
    }

    public boolean hasNonWhitespaceChange() {
        return this.hasNonWhitespaceChange;
    }

    public Token rescan(Token token, int n, int n2, int n3) {
        Token token2;
        Token token3;
        Token token4;
        while (token.getType() != TokenType.EOF && token.getEnd() < n) {
            token = this.copyAndAdvance(token, 0);
        }
        Token token5 = token;
        Token token6 = token.getPrevious();
        this.leftToken = this.getTail();
        int n4 = n + (n2 == 0 ? 0 : n2 - 1);
        while (token.getType() != TokenType.EOF && token.getOffset() <= n4) {
            token = token.getNext();
        }
        if (token.getType() != TokenType.EOF && n4 + 1 == token.getOffset()) {
            token4 = token;
            token3 = token = token.getNext();
        } else {
            token4 = token.getPrevious();
            token3 = token;
        }
        int n5 = n3 - n2;
        int n6 = Math.min(token5.getOffset(), n);
        int n7 = token4.getEnd() + n5 - 1;
        int n8 = n + n3 - 1;
        int n9 = Math.max(n8, n7);
        this.reader.setOffset(n6 - 1);
        int n10 = this.reader.advance();
        while (n10 != -1 && this.reader.getOffset() <= n9) {
            n10 = this.bigSwitch(n10);
        }
        if (token.getType() == TokenType.EOF) {
            this.copyAndAdvance(token, n5);
            this.rightToken = this.getTail();
            this.rightToken.setNextWithoutSettingPrevious(this.rightToken);
        } else {
            token = this.copyAndAdvance(token, n5);
            this.rightToken = this.getTail();
            while (token.getType() != TokenType.EOF) {
                token = this.copyAndAdvance(token, n5);
            }
            token2 = this.copyAndAdvance(token, n5);
            token2.setNextWithoutSettingPrevious(token2);
        }
        for (token2 = this.leftToken.getNext(); token2 != this.rightToken && token5 != token3 && token2.getType() != TokenType.EOF && this.equalTokens(token5, token2); token5 = token5.getNext(), token2 = token2.getNext()) {
            this.tokenMap.put(token5, token2);
            token6 = token5;
            this.leftToken = token2;
        }
        for (Token token7 = this.rightToken.getPrevious(); token7 != this.leftToken && token4 != token6 && token7.getType() != TokenType.EOF && this.equalTokens(token4, token7); token4 = token4.getPrevious(), token7 = token7.getPrevious()) {
            this.tokenMap.put(token4, token7);
            token3 = token4;
            this.rightToken = token7;
        }
        this.hasNonWhitespaceChange = this.leftToken.getNext() != this.rightToken || token6.getNext() != token3;
        return this.getFirstToken();
    }

    private Token copyAndAdvance(Token token, int n) {
        Token token2 = token.copy();
        this.tokenMap.put(token, token2);
        token2.applyDelta(n);
        this.appendToken(token2);
        Token token3 = token.getPrecedingComments();
        Token token4 = token.getPrecedingComments();
        while (token3 != null) {
            this.tokenMap.put(token3, token4);
            token3 = token3.getNext();
            token4 = token4.getNext();
        }
        return token.getNext();
    }

    private boolean equalTokens(Token token, Token token2) {
        return token.getType() == token2.getType() && token.getLength() == token2.getLength() && token.getLexeme().equals(token2.getLexeme());
    }
}

