/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.scanner;

import com.google.dart.engine.scanner.CharacterReader;

public class CharSequenceReader
implements CharacterReader {
    private final CharSequence sequence;
    private final int stringLength;
    private int charOffset;

    public CharSequenceReader(CharSequence charSequence) {
        this.sequence = charSequence;
        this.stringLength = charSequence.length();
        this.charOffset = -1;
    }

    @Override
    public int advance() {
        if (this.charOffset + 1 >= this.stringLength) {
            return -1;
        }
        return this.sequence.charAt(++this.charOffset);
    }

    @Override
    public int getOffset() {
        return this.charOffset;
    }

    @Override
    public String getString(int n, int n2) {
        return ((Object)this.sequence.subSequence(n, this.charOffset + 1 + n2)).toString();
    }

    @Override
    public int peek() {
        if (this.charOffset + 1 >= this.sequence.length()) {
            return -1;
        }
        return this.sequence.charAt(this.charOffset + 1);
    }

    @Override
    public void setOffset(int n) {
        this.charOffset = n;
    }
}

