/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.AdjacentStrings;
import com.google.dart.engine.ast.AnnotatedNode;
import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.ArgumentDefinitionTest;
import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AsExpression;
import com.google.dart.engine.ast.AssertStatement;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.BlockFunctionBody;
import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.BreakStatement;
import com.google.dart.engine.ast.CascadeExpression;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.Combinator;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.CommentReference;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.CompilationUnitMember;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorFieldInitializer;
import com.google.dart.engine.ast.ConstructorInitializer;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.ContinueStatement;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.DefaultFormalParameter;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.DoStatement;
import com.google.dart.engine.ast.DoubleLiteral;
import com.google.dart.engine.ast.EmptyFunctionBody;
import com.google.dart.engine.ast.EmptyStatement;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.ExpressionFunctionBody;
import com.google.dart.engine.ast.ExpressionStatement;
import com.google.dart.engine.ast.ExtendsClause;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.FieldFormalParameter;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.ForStatement;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionDeclarationStatement;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionExpressionInvocation;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.HideCombinator;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.IfStatement;
import com.google.dart.engine.ast.ImplementsClause;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.IntegerLiteral;
import com.google.dart.engine.ast.InterpolationElement;
import com.google.dart.engine.ast.InterpolationExpression;
import com.google.dart.engine.ast.InterpolationString;
import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LabeledStatement;
import com.google.dart.engine.ast.LibraryDirective;
import com.google.dart.engine.ast.LibraryIdentifier;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NamespaceDirective;
import com.google.dart.engine.ast.NativeClause;
import com.google.dart.engine.ast.NativeFunctionBody;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.NormalFormalParameter;
import com.google.dart.engine.ast.NullLiteral;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.ast.PartOfDirective;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.RedirectingConstructorInvocation;
import com.google.dart.engine.ast.RethrowExpression;
import com.google.dart.engine.ast.ReturnStatement;
import com.google.dart.engine.ast.ScriptTag;
import com.google.dart.engine.ast.ShowCombinator;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.SuperExpression;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchDefault;
import com.google.dart.engine.ast.SwitchMember;
import com.google.dart.engine.ast.SwitchStatement;
import com.google.dart.engine.ast.SymbolLiteral;
import com.google.dart.engine.ast.ThisExpression;
import com.google.dart.engine.ast.ThrowExpression;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.TryStatement;
import com.google.dart.engine.ast.TypeAlias;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.TypeParameterList;
import com.google.dart.engine.ast.TypedLiteral;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.VariableDeclarationStatement;
import com.google.dart.engine.ast.WhileStatement;
import com.google.dart.engine.ast.WithClause;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.BooleanErrorListener;
import com.google.dart.engine.internal.parser.CommentAndMetadata;
import com.google.dart.engine.internal.parser.FinalConstVarOrType;
import com.google.dart.engine.internal.parser.Modifiers;
import com.google.dart.engine.parser.ParserErrorCode;
import com.google.dart.engine.scanner.BeginToken;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Scanner;
import com.google.dart.engine.scanner.StringToken;
import com.google.dart.engine.scanner.SubSequenceReader;
import com.google.dart.engine.scanner.SyntheticStringToken;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.dart.ParameterKind;
import com.google.dart.engine.utilities.general.StringUtilities;
import com.google.dart.engine.utilities.instrumentation.Instrumentation;
import com.google.dart.engine.utilities.instrumentation.InstrumentationBuilder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Parser {
    private final Source source;
    private AnalysisErrorListener errorListener;
    private int errorListenerLock = 0;
    private boolean parseFunctionBodies = true;
    private Token currentToken;
    private boolean inLoop = false;
    private boolean inSwitch = false;
    private static final String HIDE = "hide";
    private static final String OF = "of";
    private static final String ON = "on";
    private static final String NATIVE = "native";
    private static final String SHOW = "show";

    public Parser(Source source, AnalysisErrorListener analysisErrorListener) {
        this.source = source;
        this.errorListener = analysisErrorListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilationUnit parseCompilationUnit(Token token) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("dart.engine.Parser.parseCompilationUnit");
        try {
            this.currentToken = token;
            CompilationUnit compilationUnit = this.parseCompilationUnit();
            return compilationUnit;
        }
        finally {
            instrumentationBuilder.log(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression parseExpression(Token token) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("dart.engine.Parser.parseExpression");
        try {
            this.currentToken = token;
            Expression expression = this.parseExpression();
            return expression;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement parseStatement(Token token) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("dart.engine.Parser.parseStatement");
        try {
            this.currentToken = token;
            Statement statement = this.parseStatement();
            return statement;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Statement> parseStatements(Token token) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("dart.engine.Parser.parseStatements");
        try {
            this.currentToken = token;
            List<Statement> list = this.parseStatementList();
            return list;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    public void setParseFunctionBodies(boolean bl) {
        this.parseFunctionBodies = bl;
    }

    protected Annotation parseAnnotation() {
        Token token = this.expect(TokenType.AT);
        Identifier identifier = this.parsePrefixedIdentifier();
        Token token2 = null;
        SimpleIdentifier simpleIdentifier = null;
        if (this.matches(TokenType.PERIOD)) {
            token2 = this.getAndAdvance();
            simpleIdentifier = this.parseSimpleIdentifier();
        }
        ArgumentList argumentList = null;
        if (this.matches(TokenType.OPEN_PAREN)) {
            argumentList = this.parseArgumentList();
        }
        return new Annotation(token, identifier, token2, simpleIdentifier, argumentList);
    }

    protected Expression parseArgument() {
        if (this.matchesIdentifier() && this.tokenMatches(this.peek(), TokenType.COLON)) {
            return new NamedExpression(this.parseLabel(), this.parseExpression());
        }
        return this.parseExpression();
    }

    protected ArgumentList parseArgumentList() {
        Token token = this.expect(TokenType.OPEN_PAREN);
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.matches(TokenType.CLOSE_PAREN)) {
            return new ArgumentList(token, arrayList, this.getAndAdvance());
        }
        Expression expression = this.parseArgument();
        arrayList.add(expression);
        boolean bl = expression instanceof NamedExpression;
        boolean bl2 = false;
        while (this.optional(TokenType.COMMA)) {
            expression = this.parseArgument();
            arrayList.add(expression);
            if (bl) {
                if (bl2 || expression instanceof NamedExpression) continue;
                this.reportErrorForCurrentToken(ParserErrorCode.POSITIONAL_AFTER_NAMED_ARGUMENT, new Object[0]);
                bl2 = true;
                continue;
            }
            if (!(expression instanceof NamedExpression)) continue;
            bl = true;
        }
        Token token2 = this.expect(TokenType.CLOSE_PAREN);
        return new ArgumentList(token, arrayList, token2);
    }

    protected Expression parseBitwiseOrExpression() {
        Expression expression = this.matchesKeyword(Keyword.SUPER) && this.tokenMatches(this.peek(), TokenType.BAR) ? new SuperExpression(this.getAndAdvance()) : this.parseBitwiseXorExpression();
        while (this.matches(TokenType.BAR)) {
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseBitwiseXorExpression());
        }
        return expression;
    }

    protected Block parseBlock() {
        Object object;
        Token token = this.expect(TokenType.OPEN_CURLY_BRACKET);
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        Token token2 = this.currentToken;
        while (!this.matches(TokenType.EOF) && !this.matches(TokenType.CLOSE_CURLY_BRACKET)) {
            object = this.parseStatement();
            if (object != null) {
                arrayList.add((Statement)object);
            }
            if (this.currentToken == token2) {
                this.reportErrorForToken(ParserErrorCode.UNEXPECTED_TOKEN, this.currentToken, this.currentToken.getLexeme());
                this.advance();
            }
            token2 = this.currentToken;
        }
        object = this.expect(TokenType.CLOSE_CURLY_BRACKET);
        return new Block(token, arrayList, (Token)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassMember parseClassMember(String string) {
        CommentAndMetadata commentAndMetadata = this.parseCommentAndMetadata();
        Modifiers modifiers = this.parseModifiers();
        if (this.matchesKeyword(Keyword.VOID)) {
            TypeName typeName = this.parseReturnType();
            if (this.matchesKeyword(Keyword.GET) && this.tokenMatchesIdentifier(this.peek())) {
                this.validateModifiersForGetterOrSetterOrMethod(modifiers);
                return this.parseGetter(commentAndMetadata, modifiers.getExternalKeyword(), modifiers.getStaticKeyword(), typeName);
            }
            if (this.matchesKeyword(Keyword.SET) && this.tokenMatchesIdentifier(this.peek())) {
                this.validateModifiersForGetterOrSetterOrMethod(modifiers);
                return this.parseSetter(commentAndMetadata, modifiers.getExternalKeyword(), modifiers.getStaticKeyword(), typeName);
            }
            if (this.matchesKeyword(Keyword.OPERATOR) && this.isOperator(this.peek())) {
                this.validateModifiersForOperator(modifiers);
                return this.parseOperator(commentAndMetadata, modifiers.getExternalKeyword(), typeName);
            }
            if (this.matchesIdentifier() && this.peek().matchesAny(TokenType.OPEN_PAREN, TokenType.OPEN_CURLY_BRACKET, TokenType.FUNCTION)) {
                this.validateModifiersForGetterOrSetterOrMethod(modifiers);
                return this.parseMethodDeclarationAfterReturnType(commentAndMetadata, modifiers.getExternalKeyword(), modifiers.getStaticKeyword(), typeName);
            }
            if (this.matchesIdentifier() && this.peek().matchesAny(TokenType.EQ, TokenType.COMMA, TokenType.SEMICOLON)) {
                this.reportErrorForNode(ParserErrorCode.VOID_VARIABLE, typeName, new Object[0]);
                return this.parseInitializedIdentifierList(commentAndMetadata, modifiers.getStaticKeyword(), this.validateModifiersForField(modifiers), typeName);
            }
            if (this.isOperator(this.currentToken)) {
                this.validateModifiersForOperator(modifiers);
                return this.parseOperator(commentAndMetadata, modifiers.getExternalKeyword(), typeName);
            }
            this.reportErrorForToken(ParserErrorCode.EXPECTED_EXECUTABLE, this.currentToken, new Object[0]);
            return null;
        }
        if (this.matchesKeyword(Keyword.GET) && this.tokenMatchesIdentifier(this.peek())) {
            this.validateModifiersForGetterOrSetterOrMethod(modifiers);
            return this.parseGetter(commentAndMetadata, modifiers.getExternalKeyword(), modifiers.getStaticKeyword(), null);
        }
        if (this.matchesKeyword(Keyword.SET) && this.tokenMatchesIdentifier(this.peek())) {
            this.validateModifiersForGetterOrSetterOrMethod(modifiers);
            return this.parseSetter(commentAndMetadata, modifiers.getExternalKeyword(), modifiers.getStaticKeyword(), null);
        }
        if (this.matchesKeyword(Keyword.OPERATOR) && this.isOperator(this.peek())) {
            this.validateModifiersForOperator(modifiers);
            return this.parseOperator(commentAndMetadata, modifiers.getExternalKeyword(), null);
        }
        if (!this.matchesIdentifier()) {
            if (this.isOperator(this.currentToken)) {
                this.validateModifiersForOperator(modifiers);
                return this.parseOperator(commentAndMetadata, modifiers.getExternalKeyword(), null);
            }
            this.reportErrorForToken(ParserErrorCode.EXPECTED_CLASS_MEMBER, this.currentToken, new Object[0]);
            if (commentAndMetadata.getComment() != null || !commentAndMetadata.getMetadata().isEmpty()) {
                return new MethodDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), null, null, null, null, null, this.createSyntheticIdentifier(), new FormalParameterList(null, new ArrayList<FormalParameter>(), null, null, null), new EmptyFunctionBody(this.createSyntheticToken(TokenType.SEMICOLON)));
            }
            return null;
        }
        if (this.tokenMatches(this.peek(), TokenType.PERIOD) && this.tokenMatchesIdentifier(this.peekAt(2)) && this.tokenMatches(this.peekAt(3), TokenType.OPEN_PAREN)) {
            return this.parseConstructor(commentAndMetadata, modifiers.getExternalKeyword(), this.validateModifiersForConstructor(modifiers), modifiers.getFactoryKeyword(), this.parseSimpleIdentifier(), this.getAndAdvance(), this.parseSimpleIdentifier(), this.parseFormalParameterList());
        }
        if (this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
            SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
            FormalParameterList formalParameterList = this.parseFormalParameterList();
            if (this.matches(TokenType.COLON) || modifiers.getFactoryKeyword() != null || simpleIdentifier.getName().equals(string)) {
                return this.parseConstructor(commentAndMetadata, modifiers.getExternalKeyword(), this.validateModifiersForConstructor(modifiers), modifiers.getFactoryKeyword(), simpleIdentifier, null, null, formalParameterList);
            }
            this.validateModifiersForGetterOrSetterOrMethod(modifiers);
            this.validateFormalParameterList(formalParameterList);
            return this.parseMethodDeclarationAfterParameters(commentAndMetadata, modifiers.getExternalKeyword(), modifiers.getStaticKeyword(), null, simpleIdentifier, formalParameterList);
        }
        if (this.peek().matchesAny(TokenType.EQ, TokenType.COMMA, TokenType.SEMICOLON)) {
            if (modifiers.getConstKeyword() == null && modifiers.getFinalKeyword() == null && modifiers.getVarKeyword() == null) {
                this.reportErrorForCurrentToken(ParserErrorCode.MISSING_CONST_FINAL_VAR_OR_TYPE, new Object[0]);
            }
            return this.parseInitializedIdentifierList(commentAndMetadata, modifiers.getStaticKeyword(), this.validateModifiersForField(modifiers), null);
        }
        TypeName typeName = this.parseTypeName();
        if (this.matchesKeyword(Keyword.GET) && this.tokenMatchesIdentifier(this.peek())) {
            this.validateModifiersForGetterOrSetterOrMethod(modifiers);
            return this.parseGetter(commentAndMetadata, modifiers.getExternalKeyword(), modifiers.getStaticKeyword(), typeName);
        }
        if (this.matchesKeyword(Keyword.SET) && this.tokenMatchesIdentifier(this.peek())) {
            this.validateModifiersForGetterOrSetterOrMethod(modifiers);
            return this.parseSetter(commentAndMetadata, modifiers.getExternalKeyword(), modifiers.getStaticKeyword(), typeName);
        }
        if (this.matchesKeyword(Keyword.OPERATOR) && this.isOperator(this.peek())) {
            this.validateModifiersForOperator(modifiers);
            return this.parseOperator(commentAndMetadata, modifiers.getExternalKeyword(), typeName);
        }
        if (!this.matchesIdentifier()) {
            if (this.matches(TokenType.CLOSE_CURLY_BRACKET)) {
                return this.parseInitializedIdentifierList(commentAndMetadata, modifiers.getStaticKeyword(), this.validateModifiersForField(modifiers), typeName);
            }
            if (this.isOperator(this.currentToken)) {
                this.validateModifiersForOperator(modifiers);
                return this.parseOperator(commentAndMetadata, modifiers.getExternalKeyword(), typeName);
            }
            this.reportErrorForToken(ParserErrorCode.EXPECTED_CLASS_MEMBER, this.currentToken, new Object[0]);
            try {
                this.lockErrorListener();
                FieldDeclaration fieldDeclaration = this.parseInitializedIdentifierList(commentAndMetadata, modifiers.getStaticKeyword(), this.validateModifiersForField(modifiers), typeName);
                return fieldDeclaration;
            }
            finally {
                this.unlockErrorListener();
            }
        }
        if (this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
            SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
            FormalParameterList formalParameterList = this.parseFormalParameterList();
            if (simpleIdentifier.getName().equals(string)) {
                this.reportErrorForNode(ParserErrorCode.CONSTRUCTOR_WITH_RETURN_TYPE, typeName, new Object[0]);
                return this.parseConstructor(commentAndMetadata, modifiers.getExternalKeyword(), this.validateModifiersForConstructor(modifiers), modifiers.getFactoryKeyword(), simpleIdentifier, null, null, formalParameterList);
            }
            this.validateModifiersForGetterOrSetterOrMethod(modifiers);
            this.validateFormalParameterList(formalParameterList);
            return this.parseMethodDeclarationAfterParameters(commentAndMetadata, modifiers.getExternalKeyword(), modifiers.getStaticKeyword(), typeName, simpleIdentifier, formalParameterList);
        }
        return this.parseInitializedIdentifierList(commentAndMetadata, modifiers.getStaticKeyword(), this.validateModifiersForField(modifiers), typeName);
    }

    protected CompilationUnit parseCompilationUnit() {
        Token token = this.currentToken;
        ScriptTag scriptTag = null;
        if (this.matches(TokenType.SCRIPT_TAG)) {
            scriptTag = new ScriptTag(this.getAndAdvance());
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ArrayList<Directive> arrayList = new ArrayList<Directive>();
        ArrayList<CompilationUnitMember> arrayList2 = new ArrayList<CompilationUnitMember>();
        Token token2 = this.currentToken;
        while (!this.matches(TokenType.EOF)) {
            AnnotatedNode annotatedNode;
            CommentAndMetadata commentAndMetadata = this.parseCommentAndMetadata();
            if ((this.matchesKeyword(Keyword.IMPORT) || this.matchesKeyword(Keyword.EXPORT) || this.matchesKeyword(Keyword.LIBRARY) || this.matchesKeyword(Keyword.PART)) && !this.tokenMatches(this.peek(), TokenType.PERIOD) && !this.tokenMatches(this.peek(), TokenType.LT) && !this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
                annotatedNode = this.parseDirective(commentAndMetadata);
                if (arrayList2.size() > 0 && !bl4) {
                    this.reportErrorForCurrentToken(ParserErrorCode.DIRECTIVE_AFTER_DECLARATION, new Object[0]);
                    bl4 = true;
                }
                if (annotatedNode instanceof LibraryDirective) {
                    if (bl) {
                        this.reportErrorForCurrentToken(ParserErrorCode.MULTIPLE_LIBRARY_DIRECTIVES, new Object[0]);
                    } else {
                        if (arrayList.size() > 0) {
                            this.reportErrorForToken(ParserErrorCode.LIBRARY_DIRECTIVE_NOT_FIRST, ((LibraryDirective)annotatedNode).getLibraryToken(), new Object[0]);
                        }
                        bl = true;
                    }
                } else if (annotatedNode instanceof PartDirective) {
                    bl3 = true;
                } else if (bl3) {
                    if (annotatedNode instanceof ExportDirective) {
                        this.reportErrorForToken(ParserErrorCode.EXPORT_DIRECTIVE_AFTER_PART_DIRECTIVE, ((NamespaceDirective)annotatedNode).getKeyword(), new Object[0]);
                    } else if (annotatedNode instanceof ImportDirective) {
                        this.reportErrorForToken(ParserErrorCode.IMPORT_DIRECTIVE_AFTER_PART_DIRECTIVE, ((NamespaceDirective)annotatedNode).getKeyword(), new Object[0]);
                    }
                }
                if (annotatedNode instanceof PartOfDirective) {
                    if (bl2) {
                        this.reportErrorForCurrentToken(ParserErrorCode.MULTIPLE_PART_OF_DIRECTIVES, new Object[0]);
                    } else {
                        int n = arrayList.size();
                        for (int i = 0; i < n; ++i) {
                            this.reportErrorForToken(ParserErrorCode.NON_PART_OF_DIRECTIVE_IN_PART, ((Directive)arrayList.get(i)).getKeyword(), new Object[0]);
                        }
                        bl2 = true;
                    }
                } else if (bl2) {
                    this.reportErrorForToken(ParserErrorCode.NON_PART_OF_DIRECTIVE_IN_PART, ((Directive)annotatedNode).getKeyword(), new Object[0]);
                }
                arrayList.add((Directive)annotatedNode);
            } else if (this.matches(TokenType.SEMICOLON)) {
                this.reportErrorForToken(ParserErrorCode.UNEXPECTED_TOKEN, this.currentToken, this.currentToken.getLexeme());
                this.advance();
            } else {
                annotatedNode = this.parseCompilationUnitMember(commentAndMetadata);
                if (annotatedNode != null) {
                    arrayList2.add((CompilationUnitMember)annotatedNode);
                }
            }
            if (this.currentToken == token2) {
                this.reportErrorForToken(ParserErrorCode.UNEXPECTED_TOKEN, this.currentToken, this.currentToken.getLexeme());
                this.advance();
                while (!this.matches(TokenType.EOF) && !this.couldBeStartOfCompilationUnitMember()) {
                    this.advance();
                }
            }
            token2 = this.currentToken;
        }
        return new CompilationUnit(token, scriptTag, arrayList, arrayList2, this.currentToken);
    }

    protected Expression parseConditionalExpression() {
        Expression expression = this.parseLogicalOrExpression();
        if (!this.matches(TokenType.QUESTION)) {
            return expression;
        }
        Token token = this.getAndAdvance();
        Expression expression2 = this.parseExpressionWithoutCascade();
        Token token2 = this.expect(TokenType.COLON);
        Expression expression3 = this.parseExpressionWithoutCascade();
        return new ConditionalExpression(expression, token, expression2, token2, expression3);
    }

    protected ConstructorName parseConstructorName() {
        TypeName typeName = this.parseTypeName();
        Token token = null;
        SimpleIdentifier simpleIdentifier = null;
        if (this.matches(TokenType.PERIOD)) {
            token = this.getAndAdvance();
            simpleIdentifier = this.parseSimpleIdentifier();
        }
        return new ConstructorName(typeName, token, simpleIdentifier);
    }

    protected Expression parseExpression() {
        if (this.matchesKeyword(Keyword.THROW)) {
            return this.parseThrowExpression();
        }
        if (this.matchesKeyword(Keyword.RETHROW)) {
            return this.parseRethrowExpression();
        }
        Expression expression = this.parseConditionalExpression();
        TokenType tokenType = this.currentToken.getType();
        if (tokenType == TokenType.PERIOD_PERIOD) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            while (tokenType == TokenType.PERIOD_PERIOD) {
                Expression expression2 = this.parseCascadeSection();
                if (expression2 != null) {
                    arrayList.add(expression2);
                }
                tokenType = this.currentToken.getType();
            }
            return new CascadeExpression(expression, arrayList);
        }
        if (tokenType.isAssignmentOperator()) {
            Token token = this.getAndAdvance();
            this.ensureAssignable(expression);
            return new AssignmentExpression(expression, token, this.parseExpression());
        }
        return expression;
    }

    protected Expression parseExpressionWithoutCascade() {
        if (this.matchesKeyword(Keyword.THROW)) {
            return this.parseThrowExpressionWithoutCascade();
        }
        if (this.matchesKeyword(Keyword.RETHROW)) {
            return this.parseRethrowExpression();
        }
        Expression expression = this.parseConditionalExpression();
        if (this.currentToken.getType().isAssignmentOperator()) {
            Token token = this.getAndAdvance();
            this.ensureAssignable(expression);
            expression = new AssignmentExpression(expression, token, this.parseExpressionWithoutCascade());
        }
        return expression;
    }

    protected ExtendsClause parseExtendsClause() {
        Token token = this.expectKeyword(Keyword.EXTENDS);
        TypeName typeName = this.parseTypeName();
        return new ExtendsClause(token, typeName);
    }

    protected FormalParameterList parseFormalParameterList() {
        Object object;
        Token token = this.expect(TokenType.OPEN_PAREN);
        if (this.matches(TokenType.CLOSE_PAREN)) {
            return new FormalParameterList(token, null, null, null, this.getAndAdvance());
        }
        ArrayList<FormalParameter> arrayList = new ArrayList<FormalParameter>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList<Object> arrayList5 = arrayList2;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        ParameterKind parameterKind = ParameterKind.REQUIRED;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Token token6 = null;
        do {
            if (bl) {
                bl = false;
            } else if (!this.optional(TokenType.COMMA)) {
                if (this.getEndToken(token) != null) {
                    this.reportErrorForCurrentToken(ParserErrorCode.EXPECTED_TOKEN, TokenType.COMMA.getLexeme());
                } else {
                    this.reportErrorForToken(ParserErrorCode.MISSING_CLOSING_PARENTHESIS, this.currentToken.getPrevious(), new Object[0]);
                    break;
                }
            }
            token6 = this.currentToken;
            if (this.matches(TokenType.OPEN_SQUARE_BRACKET)) {
                bl5 = true;
                if (token2 != null && !bl2) {
                    this.reportErrorForCurrentToken(ParserErrorCode.MULTIPLE_POSITIONAL_PARAMETER_GROUPS, new Object[0]);
                    bl2 = true;
                }
                if (token4 != null && !bl4) {
                    this.reportErrorForCurrentToken(ParserErrorCode.MIXED_PARAMETER_GROUPS, new Object[0]);
                    bl4 = true;
                }
                token2 = this.getAndAdvance();
                arrayList5 = arrayList3;
                parameterKind = ParameterKind.POSITIONAL;
            } else if (this.matches(TokenType.OPEN_CURLY_BRACKET)) {
                bl5 = true;
                if (token4 != null && !bl3) {
                    this.reportErrorForCurrentToken(ParserErrorCode.MULTIPLE_NAMED_PARAMETER_GROUPS, new Object[0]);
                    bl3 = true;
                }
                if (token2 != null && !bl4) {
                    this.reportErrorForCurrentToken(ParserErrorCode.MIXED_PARAMETER_GROUPS, new Object[0]);
                    bl4 = true;
                }
                token4 = this.getAndAdvance();
                arrayList5 = arrayList4;
                parameterKind = ParameterKind.NAMED;
            }
            object = this.parseFormalParameter(parameterKind);
            arrayList.add((FormalParameter)object);
            arrayList5.add(object);
            if (parameterKind == ParameterKind.REQUIRED && bl5) {
                this.reportErrorForNode(ParserErrorCode.NORMAL_BEFORE_OPTIONAL_PARAMETERS, (AstNode)object, new Object[0]);
            }
            if (this.matches(TokenType.CLOSE_SQUARE_BRACKET)) {
                token3 = this.getAndAdvance();
                arrayList5 = arrayList2;
                if (token2 == null) {
                    if (token4 != null) {
                        this.reportErrorForCurrentToken(ParserErrorCode.WRONG_TERMINATOR_FOR_PARAMETER_GROUP, "}");
                        token5 = token3;
                        token3 = null;
                    } else {
                        this.reportErrorForCurrentToken(ParserErrorCode.UNEXPECTED_TERMINATOR_FOR_PARAMETER_GROUP, "[");
                    }
                }
                parameterKind = ParameterKind.REQUIRED;
                continue;
            }
            if (!this.matches(TokenType.CLOSE_CURLY_BRACKET)) continue;
            token5 = this.getAndAdvance();
            arrayList5 = arrayList2;
            if (token4 == null) {
                if (token2 != null) {
                    this.reportErrorForCurrentToken(ParserErrorCode.WRONG_TERMINATOR_FOR_PARAMETER_GROUP, "]");
                    token3 = token5;
                    token5 = null;
                } else {
                    this.reportErrorForCurrentToken(ParserErrorCode.UNEXPECTED_TERMINATOR_FOR_PARAMETER_GROUP, "{");
                }
            }
            parameterKind = ParameterKind.REQUIRED;
        } while (!this.matches(TokenType.CLOSE_PAREN) && token6 != this.currentToken);
        object = this.expect(TokenType.CLOSE_PAREN);
        if (token2 != null && token3 == null) {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_TERMINATOR_FOR_PARAMETER_GROUP, "]");
        }
        if (token4 != null && token5 == null) {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_TERMINATOR_FOR_PARAMETER_GROUP, "}");
        }
        if (token2 == null) {
            token2 = token4;
        }
        if (token3 == null) {
            token3 = token5;
        }
        return new FormalParameterList(token, arrayList, token2, token3, (Token)object);
    }

    protected FunctionExpression parseFunctionExpression() {
        FormalParameterList formalParameterList = this.parseFormalParameterList();
        this.validateFormalParameterList(formalParameterList);
        FunctionBody functionBody = this.parseFunctionBody(false, ParserErrorCode.MISSING_FUNCTION_BODY, true);
        return new FunctionExpression(formalParameterList, functionBody);
    }

    protected ImplementsClause parseImplementsClause() {
        Token token = this.expectKeyword(Keyword.IMPLEMENTS);
        ArrayList<TypeName> arrayList = new ArrayList<TypeName>();
        arrayList.add(this.parseTypeName());
        while (this.optional(TokenType.COMMA)) {
            arrayList.add(this.parseTypeName());
        }
        return new ImplementsClause(token, arrayList);
    }

    protected Label parseLabel() {
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        Token token = this.expect(TokenType.COLON);
        return new Label(simpleIdentifier, token);
    }

    protected LibraryIdentifier parseLibraryIdentifier() {
        ArrayList<SimpleIdentifier> arrayList = new ArrayList<SimpleIdentifier>();
        arrayList.add(this.parseSimpleIdentifier());
        while (this.matches(TokenType.PERIOD)) {
            this.advance();
            arrayList.add(this.parseSimpleIdentifier());
        }
        return new LibraryIdentifier(arrayList);
    }

    protected Expression parseLogicalOrExpression() {
        Expression expression = this.parseLogicalAndExpression();
        while (this.matches(TokenType.BAR_BAR)) {
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseLogicalAndExpression());
        }
        return expression;
    }

    protected MapLiteralEntry parseMapLiteralEntry() {
        Expression expression = this.parseExpression();
        Token token = this.expect(TokenType.COLON);
        Expression expression2 = this.parseExpression();
        return new MapLiteralEntry(expression, token, expression2);
    }

    protected NormalFormalParameter parseNormalFormalParameter() {
        CommentAndMetadata commentAndMetadata = this.parseCommentAndMetadata();
        FinalConstVarOrType finalConstVarOrType = this.parseFinalConstVarOrType(true);
        Token token = null;
        Token token2 = null;
        if (this.matchesKeyword(Keyword.THIS)) {
            token = this.getAndAdvance();
            token2 = this.expect(TokenType.PERIOD);
        }
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        if (this.matches(TokenType.OPEN_PAREN)) {
            FormalParameterList formalParameterList = this.parseFormalParameterList();
            if (token == null) {
                if (finalConstVarOrType.getKeyword() != null) {
                    this.reportErrorForToken(ParserErrorCode.FUNCTION_TYPED_PARAMETER_VAR, finalConstVarOrType.getKeyword(), new Object[0]);
                }
                return new FunctionTypedFormalParameter(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), finalConstVarOrType.getType(), simpleIdentifier, formalParameterList);
            }
            return new FieldFormalParameter(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), finalConstVarOrType.getKeyword(), finalConstVarOrType.getType(), token, token2, simpleIdentifier, formalParameterList);
        }
        TypeName typeName = finalConstVarOrType.getType();
        if (typeName != null) {
            if (this.tokenMatchesKeyword(typeName.getName().getBeginToken(), Keyword.VOID)) {
                this.reportErrorForToken(ParserErrorCode.VOID_PARAMETER, typeName.getName().getBeginToken(), new Object[0]);
            } else if (finalConstVarOrType.getKeyword() != null && this.tokenMatchesKeyword(finalConstVarOrType.getKeyword(), Keyword.VAR)) {
                this.reportErrorForToken(ParserErrorCode.VAR_AND_TYPE, finalConstVarOrType.getKeyword(), new Object[0]);
            }
        }
        if (token != null) {
            return new FieldFormalParameter(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), finalConstVarOrType.getKeyword(), finalConstVarOrType.getType(), token, token2, simpleIdentifier, null);
        }
        return new SimpleFormalParameter(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), finalConstVarOrType.getKeyword(), finalConstVarOrType.getType(), simpleIdentifier);
    }

    protected Identifier parsePrefixedIdentifier() {
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        if (!this.matches(TokenType.PERIOD)) {
            return simpleIdentifier;
        }
        Token token = this.getAndAdvance();
        SimpleIdentifier simpleIdentifier2 = this.parseSimpleIdentifier();
        return new PrefixedIdentifier(simpleIdentifier, token, simpleIdentifier2);
    }

    protected TypeName parseReturnType() {
        if (this.matchesKeyword(Keyword.VOID)) {
            return new TypeName(new SimpleIdentifier(this.getAndAdvance()), null);
        }
        return this.parseTypeName();
    }

    protected SimpleIdentifier parseSimpleIdentifier() {
        if (this.matchesIdentifier()) {
            return new SimpleIdentifier(this.getAndAdvance());
        }
        this.reportErrorForCurrentToken(ParserErrorCode.MISSING_IDENTIFIER, new Object[0]);
        return this.createSyntheticIdentifier();
    }

    protected Statement parseStatement() {
        ArrayList<Label> arrayList = new ArrayList<Label>();
        while (this.matchesIdentifier() && this.tokenMatches(this.peek(), TokenType.COLON)) {
            arrayList.add(this.parseLabel());
        }
        Statement statement = this.parseNonLabeledStatement();
        if (arrayList.isEmpty()) {
            return statement;
        }
        return new LabeledStatement(arrayList, statement);
    }

    protected StringLiteral parseStringLiteral() {
        ArrayList<StringLiteral> arrayList = new ArrayList<StringLiteral>();
        while (this.matches(TokenType.STRING)) {
            Token token = this.getAndAdvance();
            if (this.matches(TokenType.STRING_INTERPOLATION_EXPRESSION) || this.matches(TokenType.STRING_INTERPOLATION_IDENTIFIER)) {
                arrayList.add(this.parseStringInterpolation(token));
                continue;
            }
            arrayList.add(new SimpleStringLiteral(token, this.computeStringValue(token.getLexeme(), true, true)));
        }
        if (arrayList.size() < 1) {
            this.reportErrorForCurrentToken(ParserErrorCode.EXPECTED_STRING_LITERAL, new Object[0]);
            return this.createSyntheticStringLiteral();
        }
        if (arrayList.size() == 1) {
            return (StringLiteral)arrayList.get(0);
        }
        return new AdjacentStrings(arrayList);
    }

    protected TypeArgumentList parseTypeArgumentList() {
        Token token = this.expect(TokenType.LT);
        ArrayList<TypeName> arrayList = new ArrayList<TypeName>();
        arrayList.add(this.parseTypeName());
        while (this.optional(TokenType.COMMA)) {
            arrayList.add(this.parseTypeName());
        }
        Token token2 = this.expectGt();
        return new TypeArgumentList(token, arrayList, token2);
    }

    protected TypeName parseTypeName() {
        Identifier identifier;
        if (this.matchesKeyword(Keyword.VAR)) {
            this.reportErrorForCurrentToken(ParserErrorCode.VAR_AS_TYPE_NAME, new Object[0]);
            identifier = new SimpleIdentifier(this.getAndAdvance());
        } else if (this.matchesIdentifier()) {
            identifier = this.parsePrefixedIdentifier();
        } else {
            identifier = this.createSyntheticIdentifier();
            this.reportErrorForCurrentToken(ParserErrorCode.EXPECTED_TYPE_NAME, new Object[0]);
        }
        TypeArgumentList typeArgumentList = null;
        if (this.matches(TokenType.LT)) {
            typeArgumentList = this.parseTypeArgumentList();
        }
        return new TypeName(identifier, typeArgumentList);
    }

    protected TypeParameter parseTypeParameter() {
        CommentAndMetadata commentAndMetadata = this.parseCommentAndMetadata();
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        if (this.matchesKeyword(Keyword.EXTENDS)) {
            Token token = this.getAndAdvance();
            TypeName typeName = this.parseTypeName();
            return new TypeParameter(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), simpleIdentifier, token, typeName);
        }
        return new TypeParameter(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), simpleIdentifier, null, null);
    }

    protected TypeParameterList parseTypeParameterList() {
        Token token = this.expect(TokenType.LT);
        ArrayList<TypeParameter> arrayList = new ArrayList<TypeParameter>();
        arrayList.add(this.parseTypeParameter());
        while (this.optional(TokenType.COMMA)) {
            arrayList.add(this.parseTypeParameter());
        }
        Token token2 = this.expectGt();
        return new TypeParameterList(token, arrayList, token2);
    }

    protected WithClause parseWithClause() {
        Token token = this.expectKeyword(Keyword.WITH);
        ArrayList<TypeName> arrayList = new ArrayList<TypeName>();
        arrayList.add(this.parseTypeName());
        while (this.optional(TokenType.COMMA)) {
            arrayList.add(this.parseTypeName());
        }
        return new WithClause(token, arrayList);
    }

    @VisibleForTesting
    void setCurrentToken(Token token) {
        this.currentToken = token;
    }

    private void advance() {
        this.currentToken = this.currentToken.getNext();
    }

    private void appendScalarValue(StringBuilder stringBuilder, String string, int n, int n2, int n3) {
        if (n < 0 || n > 0x10FFFF || n >= 55296 && n <= 57343) {
            this.reportErrorForCurrentToken(ParserErrorCode.INVALID_CODE_POINT, string);
            return;
        }
        if (n < 65535) {
            stringBuilder.append((char)n);
        } else {
            stringBuilder.append(Character.toChars(n));
        }
    }

    private String computeStringValue(String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n = 0;
        if (bl) {
            if (StringUtilities.startsWith4(string, 0, 114, 34, 34, 34) || StringUtilities.startsWith4(string, 0, 114, 39, 39, 39)) {
                bl3 = true;
                n += 4;
            } else if (StringUtilities.startsWith2(string, 0, 114, 34) || StringUtilities.startsWith2(string, 0, 114, 39)) {
                bl3 = true;
                n += 2;
            } else if (StringUtilities.startsWith3(string, 0, 34, 34, 34) || StringUtilities.startsWith3(string, 0, 39, 39, 39)) {
                n += 3;
            } else if (StringUtilities.startsWithChar(string, 34) || StringUtilities.startsWithChar(string, 39)) {
                ++n;
            }
        }
        int n2 = string.length();
        if (bl2) {
            if (StringUtilities.endsWith3(string, 34, 34, 34) || StringUtilities.endsWith3(string, 39, 39, 39)) {
                n2 -= 3;
            } else if (StringUtilities.endsWithChar(string, 34) || StringUtilities.endsWithChar(string, 39)) {
                --n2;
            }
        }
        if (n2 - n + 1 < 0) {
            AnalysisEngine.getInstance().getLogger().logError("Internal error: computeStringValue(" + string + ", " + bl + ", " + bl2 + ")");
            return "";
        }
        if (bl3) {
            return string.substring(n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 - n + 1);
        int n3 = n;
        while (n3 < n2) {
            n3 = this.translateCharacter(stringBuilder, string, n3);
        }
        return stringBuilder.toString();
    }

    private FunctionDeclaration convertToFunctionDeclaration(MethodDeclaration methodDeclaration) {
        return new FunctionDeclaration(methodDeclaration.getDocumentationComment(), methodDeclaration.getMetadata(), methodDeclaration.getExternalKeyword(), methodDeclaration.getReturnType(), methodDeclaration.getPropertyKeyword(), methodDeclaration.getName(), new FunctionExpression(methodDeclaration.getParameters(), methodDeclaration.getBody()));
    }

    private boolean couldBeStartOfCompilationUnitMember() {
        if ((this.matchesKeyword(Keyword.IMPORT) || this.matchesKeyword(Keyword.EXPORT) || this.matchesKeyword(Keyword.LIBRARY) || this.matchesKeyword(Keyword.PART)) && !this.tokenMatches(this.peek(), TokenType.PERIOD) && !this.tokenMatches(this.peek(), TokenType.LT)) {
            return true;
        }
        if (this.matchesKeyword(Keyword.CLASS)) {
            return true;
        }
        if (this.matchesKeyword(Keyword.TYPEDEF) && !this.tokenMatches(this.peek(), TokenType.PERIOD) && !this.tokenMatches(this.peek(), TokenType.LT)) {
            return true;
        }
        if (this.matchesKeyword(Keyword.VOID) || (this.matchesKeyword(Keyword.GET) || this.matchesKeyword(Keyword.SET)) && this.tokenMatchesIdentifier(this.peek()) || this.matchesKeyword(Keyword.OPERATOR) && this.isOperator(this.peek())) {
            return true;
        }
        if (this.matchesIdentifier()) {
            if (this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
                return true;
            }
            Token token = this.skipReturnType(this.currentToken);
            if (token == null) {
                return false;
            }
            if (this.matchesKeyword(Keyword.GET) || this.matchesKeyword(Keyword.SET) || this.matchesKeyword(Keyword.OPERATOR) && this.isOperator(this.peek()) || this.matchesIdentifier()) {
                return true;
            }
        }
        return false;
    }

    private SimpleIdentifier createSyntheticIdentifier() {
        Token token = this.currentToken.getType() == TokenType.KEYWORD ? this.injectToken(new SyntheticStringToken(TokenType.IDENTIFIER, this.currentToken.getLexeme(), this.currentToken.getOffset())) : this.createSyntheticToken(TokenType.IDENTIFIER);
        return new SimpleIdentifier(token);
    }

    private Token createSyntheticKeyword(Keyword keyword) {
        return this.injectToken(new SyntheticKeywordToken(keyword, this.currentToken.getOffset()));
    }

    private SimpleStringLiteral createSyntheticStringLiteral() {
        return new SimpleStringLiteral(this.createSyntheticToken(TokenType.STRING), "");
    }

    private Token createSyntheticToken(TokenType tokenType) {
        return this.injectToken(new StringToken(tokenType, "", this.currentToken.getOffset()));
    }

    private void ensureAssignable(Expression expression) {
        if (expression != null && !expression.isAssignable()) {
            this.reportErrorForCurrentToken(ParserErrorCode.ILLEGAL_ASSIGNMENT_TO_NON_ASSIGNABLE, new Object[0]);
        }
    }

    private Token expect(TokenType tokenType) {
        if (this.matches(tokenType)) {
            return this.getAndAdvance();
        }
        if (tokenType == TokenType.SEMICOLON) {
            this.reportErrorForToken(ParserErrorCode.EXPECTED_TOKEN, this.currentToken.getPrevious(), tokenType.getLexeme());
        } else {
            this.reportErrorForCurrentToken(ParserErrorCode.EXPECTED_TOKEN, tokenType.getLexeme());
        }
        return this.currentToken;
    }

    private Token expectGt() {
        if (this.matchesGt()) {
            return this.getAndAdvance();
        }
        this.reportErrorForCurrentToken(ParserErrorCode.EXPECTED_TOKEN, TokenType.GT.getLexeme());
        return this.currentToken;
    }

    private Token expectKeyword(Keyword keyword) {
        if (this.matchesKeyword(keyword)) {
            return this.getAndAdvance();
        }
        this.reportErrorForCurrentToken(ParserErrorCode.EXPECTED_TOKEN, keyword.getSyntax());
        return this.currentToken;
    }

    private Token expectSemicolon() {
        if (this.matches(TokenType.SEMICOLON)) {
            return this.getAndAdvance();
        }
        this.reportErrorForToken(ParserErrorCode.EXPECTED_TOKEN, this.currentToken.getPrevious(), ";");
        return this.createSyntheticToken(TokenType.SEMICOLON);
    }

    private int[] findRange(List<int[]> list, int n) {
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            int[] nArray = list.get(i);
            if (nArray[0] <= n && n <= nArray[1]) {
                return nArray;
            }
            if (n >= nArray[0]) continue;
            return null;
        }
        return null;
    }

    private Token getAndAdvance() {
        Token token = this.currentToken;
        this.advance();
        return token;
    }

    private List<int[]> getCodeBlockRanges(String string) {
        int n;
        char c;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n2 = string.length();
        if (n2 < 3) {
            return arrayList;
        }
        int n3 = 0;
        char c2 = string.charAt(0);
        if (c2 == '/') {
            c = string.charAt(1);
            n = string.charAt(2);
            if (c == '*' && n == 42 || c == '/' && n == 47) {
                n3 = 3;
            }
        }
        while (n3 < n2) {
            c = string.charAt(n3);
            if (c == '\r' || c == '\n') {
                ++n3;
                while (n3 < n2 && Character.isWhitespace(string.charAt(n3))) {
                    ++n3;
                }
                if (!StringUtilities.startsWith6(string, n3, 42, 32, 32, 32, 32, 32)) continue;
                for (n = n3 + 6; n < n2 && string.charAt(n) != '\r' && string.charAt(n) != '\n'; ++n) {
                }
                arrayList.add(new int[]{n3, n});
                n3 = n;
                continue;
            }
            if (n3 + 1 < n2 && c == '[' && string.charAt(n3 + 1) == ':') {
                n = StringUtilities.indexOf2(string, n3 + 2, 58, 93);
                if (n < 0) {
                    n = n2;
                }
                arrayList.add(new int[]{n3, n});
                n3 = n + 1;
                continue;
            }
            ++n3;
        }
        return arrayList;
    }

    private Token getEndToken(Token token) {
        if (token instanceof BeginToken) {
            return ((BeginToken)token).getEndToken();
        }
        return null;
    }

    private boolean hasReturnTypeInTypeAlias() {
        Token token = this.skipReturnType(this.currentToken);
        if (token == null) {
            return false;
        }
        return this.tokenMatchesIdentifier(token);
    }

    private Token injectToken(Token token) {
        Token token2 = this.currentToken.getPrevious();
        token.setNext(this.currentToken);
        token2.setNext(token);
        return token;
    }

    private boolean isFunctionDeclaration() {
        Token token;
        if (this.matchesKeyword(Keyword.VOID)) {
            return true;
        }
        Token token2 = this.skipTypeName(this.currentToken);
        if (token2 == null) {
            token2 = this.currentToken;
        }
        if ((token = this.skipSimpleIdentifier(token2)) == null) {
            token = this.skipSimpleIdentifier(this.currentToken);
        }
        if (token == null) {
            return false;
        }
        if (this.isFunctionExpression(token)) {
            return true;
        }
        if (this.matchesKeyword(Keyword.GET)) {
            Token token3 = this.skipSimpleIdentifier(this.currentToken.getNext());
            if (token3 == null) {
                return false;
            }
            return this.tokenMatches(token3, TokenType.FUNCTION) || this.tokenMatches(token3, TokenType.OPEN_CURLY_BRACKET);
        }
        return false;
    }

    private boolean isFunctionExpression(Token token) {
        Token token2 = this.skipFormalParameterList(token);
        if (token2 == null) {
            return false;
        }
        return token2.matchesAny(TokenType.OPEN_CURLY_BRACKET, TokenType.FUNCTION);
    }

    private boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    private boolean isInitializedVariableDeclaration() {
        if (this.matchesKeyword(Keyword.FINAL) || this.matchesKeyword(Keyword.VAR)) {
            return true;
        }
        if (this.matchesKeyword(Keyword.CONST)) {
            return !this.peek().matchesAny(TokenType.LT, TokenType.OPEN_CURLY_BRACKET, TokenType.OPEN_SQUARE_BRACKET, TokenType.INDEX);
        }
        Token token = this.skipTypeName(this.currentToken);
        if (token == null) {
            return false;
        }
        if ((token = this.skipSimpleIdentifier(token)) == null) {
            return false;
        }
        TokenType tokenType = token.getType();
        return tokenType == TokenType.EQ || tokenType == TokenType.COMMA || tokenType == TokenType.SEMICOLON || this.tokenMatchesKeyword(token, Keyword.IN);
    }

    private boolean isLinkText(String string, int n) {
        int n2 = n + 1;
        int n3 = string.length();
        if (n2 >= n3) {
            return false;
        }
        char c = string.charAt(n2);
        if (c == '(' || c == ':') {
            return true;
        }
        while (Character.isWhitespace(c)) {
            if (++n2 >= n3) {
                return false;
            }
            c = string.charAt(n2);
        }
        return c == '[';
    }

    private boolean isOperator(Token token) {
        if (!token.isOperator()) {
            return false;
        }
        if (token.getType() == TokenType.EQ) {
            return false;
        }
        Token token2 = token.getNext();
        while (token2.isOperator()) {
            token2 = token2.getNext();
        }
        return this.tokenMatches(token2, TokenType.OPEN_PAREN);
    }

    private boolean isSwitchMember() {
        Token token = this.currentToken;
        while (this.tokenMatches(token, TokenType.IDENTIFIER) && this.tokenMatches(token.getNext(), TokenType.COLON)) {
            token = token.getNext().getNext();
        }
        if (token.getType() == TokenType.KEYWORD) {
            Keyword keyword = ((KeywordToken)token).getKeyword();
            return keyword == Keyword.CASE || keyword == Keyword.DEFAULT;
        }
        return false;
    }

    private boolean isTypedIdentifier(Token token) {
        Token token2 = this.skipReturnType(token);
        if (token2 == null) {
            return false;
        }
        if (this.tokenMatchesIdentifier(token2)) {
            return true;
        }
        return this.tokenMatchesKeyword(token2, Keyword.THIS) && this.tokenMatches(token2.getNext(), TokenType.PERIOD) && this.tokenMatchesIdentifier(token2.getNext().getNext());
    }

    private Token lexicallyFirst(Token ... tokenArray) {
        Token token = null;
        int n = Integer.MAX_VALUE;
        for (Token token2 : tokenArray) {
            int n2;
            if (token2 == null || (n2 = token2.getOffset()) >= n) continue;
            token = token2;
            n = n2;
        }
        return token;
    }

    private void lockErrorListener() {
        ++this.errorListenerLock;
    }

    private boolean matches(TokenType tokenType) {
        return this.currentToken.getType() == tokenType;
    }

    private boolean matchesGt() {
        TokenType tokenType = this.currentToken.getType();
        if (tokenType == TokenType.GT) {
            return true;
        }
        if (tokenType == TokenType.GT_GT) {
            int n = this.currentToken.getOffset();
            Token token = new Token(TokenType.GT, n);
            Token token2 = new Token(TokenType.GT, n + 1);
            token2.setNext(this.currentToken.getNext());
            token.setNext(token2);
            this.currentToken.getPrevious().setNext(token);
            this.currentToken = token;
            return true;
        }
        if (tokenType == TokenType.GT_EQ) {
            int n = this.currentToken.getOffset();
            Token token = new Token(TokenType.GT, n);
            Token token3 = new Token(TokenType.EQ, n + 1);
            token3.setNext(this.currentToken.getNext());
            token.setNext(token3);
            this.currentToken.getPrevious().setNext(token);
            this.currentToken = token;
            return true;
        }
        if (tokenType == TokenType.GT_GT_EQ) {
            int n = this.currentToken.getOffset();
            Token token = new Token(TokenType.GT, n);
            Token token4 = new Token(TokenType.GT, n + 1);
            Token token5 = new Token(TokenType.EQ, n + 2);
            token5.setNext(this.currentToken.getNext());
            token4.setNext(token5);
            token.setNext(token4);
            this.currentToken.getPrevious().setNext(token);
            this.currentToken = token;
            return true;
        }
        return false;
    }

    private boolean matchesIdentifier() {
        return this.tokenMatchesIdentifier(this.currentToken);
    }

    private boolean matchesKeyword(Keyword keyword) {
        return this.tokenMatchesKeyword(this.currentToken, keyword);
    }

    private boolean matchesString(String string) {
        return this.currentToken.getType() == TokenType.IDENTIFIER && this.currentToken.getLexeme().equals(string);
    }

    private boolean optional(TokenType tokenType) {
        if (this.matches(tokenType)) {
            this.advance();
            return true;
        }
        return false;
    }

    private Expression parseAdditiveExpression() {
        Expression expression = this.matchesKeyword(Keyword.SUPER) && this.currentToken.getNext().getType().isAdditiveOperator() ? new SuperExpression(this.getAndAdvance()) : this.parseMultiplicativeExpression();
        while (this.currentToken.getType().isAdditiveOperator()) {
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseMultiplicativeExpression());
        }
        return expression;
    }

    private ArgumentDefinitionTest parseArgumentDefinitionTest() {
        Token token = this.expect(TokenType.QUESTION);
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        this.reportErrorForToken(ParserErrorCode.DEPRECATED_ARGUMENT_DEFINITION_TEST, token, new Object[0]);
        return new ArgumentDefinitionTest(token, simpleIdentifier);
    }

    private AssertStatement parseAssertStatement() {
        Token token = this.expectKeyword(Keyword.ASSERT);
        Token token2 = this.expect(TokenType.OPEN_PAREN);
        Expression expression = this.parseExpression();
        if (expression instanceof AssignmentExpression) {
            this.reportErrorForNode(ParserErrorCode.ASSERT_DOES_NOT_TAKE_ASSIGNMENT, expression, new Object[0]);
        } else if (expression instanceof CascadeExpression) {
            this.reportErrorForNode(ParserErrorCode.ASSERT_DOES_NOT_TAKE_CASCADE, expression, new Object[0]);
        } else if (expression instanceof ThrowExpression) {
            this.reportErrorForNode(ParserErrorCode.ASSERT_DOES_NOT_TAKE_THROW, expression, new Object[0]);
        } else if (expression instanceof RethrowExpression) {
            this.reportErrorForNode(ParserErrorCode.ASSERT_DOES_NOT_TAKE_RETHROW, expression, new Object[0]);
        }
        Token token3 = this.expect(TokenType.CLOSE_PAREN);
        Token token4 = this.expect(TokenType.SEMICOLON);
        return new AssertStatement(token, token2, expression, token3, token4);
    }

    private Expression parseAssignableExpression(boolean bl) {
        boolean bl2;
        if (this.matchesKeyword(Keyword.SUPER)) {
            return this.parseAssignableSelector(new SuperExpression(this.getAndAdvance()), false);
        }
        AstNode astNode = this.parsePrimaryExpression();
        boolean bl3 = bl2 = bl || astNode instanceof SimpleIdentifier;
        while (true) {
            Expression expression;
            AstNode astNode2;
            if (this.matches(TokenType.OPEN_PAREN)) {
                astNode2 = this.parseArgumentList();
                if (astNode instanceof SimpleIdentifier) {
                    astNode = new MethodInvocation(null, null, (SimpleIdentifier)astNode, (ArgumentList)astNode2);
                } else if (astNode instanceof PrefixedIdentifier) {
                    expression = (PrefixedIdentifier)astNode;
                    astNode = new MethodInvocation(((PrefixedIdentifier)expression).getPrefix(), ((PrefixedIdentifier)expression).getPeriod(), ((PrefixedIdentifier)expression).getIdentifier(), (ArgumentList)astNode2);
                } else if (astNode instanceof PropertyAccess) {
                    expression = (PropertyAccess)astNode;
                    astNode = new MethodInvocation(((PropertyAccess)expression).getTarget(), ((PropertyAccess)expression).getOperator(), ((PropertyAccess)expression).getPropertyName(), (ArgumentList)astNode2);
                } else {
                    astNode = new FunctionExpressionInvocation((Expression)astNode, (ArgumentList)astNode2);
                }
                if (bl) continue;
                bl2 = false;
                continue;
            }
            astNode2 = this.parseAssignableSelector((Expression)astNode, bl2 || astNode instanceof PrefixedIdentifier);
            if (astNode2 == astNode) {
                if (!bl2 && astNode instanceof PrefixedIdentifier) {
                    expression = (PrefixedIdentifier)astNode;
                    astNode = new PropertyAccess(((PrefixedIdentifier)expression).getPrefix(), ((PrefixedIdentifier)expression).getPeriod(), ((PrefixedIdentifier)expression).getIdentifier());
                }
                return astNode;
            }
            astNode = astNode2;
            bl2 = true;
        }
    }

    private Expression parseAssignableSelector(Expression expression, boolean bl) {
        if (this.matches(TokenType.OPEN_SQUARE_BRACKET)) {
            Token token = this.getAndAdvance();
            Expression expression2 = this.parseExpression();
            Token token2 = this.expect(TokenType.CLOSE_SQUARE_BRACKET);
            return new IndexExpression(expression, token, expression2, token2);
        }
        if (this.matches(TokenType.PERIOD)) {
            Token token = this.getAndAdvance();
            return new PropertyAccess(expression, token, this.parseSimpleIdentifier());
        }
        if (!bl) {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_ASSIGNABLE_SELECTOR, new Object[0]);
        }
        return expression;
    }

    private Expression parseBitwiseAndExpression() {
        Expression expression = this.matchesKeyword(Keyword.SUPER) && this.tokenMatches(this.peek(), TokenType.AMPERSAND) ? new SuperExpression(this.getAndAdvance()) : this.parseShiftExpression();
        while (this.matches(TokenType.AMPERSAND)) {
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseShiftExpression());
        }
        return expression;
    }

    private Expression parseBitwiseXorExpression() {
        Expression expression = this.matchesKeyword(Keyword.SUPER) && this.tokenMatches(this.peek(), TokenType.CARET) ? new SuperExpression(this.getAndAdvance()) : this.parseBitwiseAndExpression();
        while (this.matches(TokenType.CARET)) {
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseBitwiseAndExpression());
        }
        return expression;
    }

    private Statement parseBreakStatement() {
        Token token = this.expectKeyword(Keyword.BREAK);
        SimpleIdentifier simpleIdentifier = null;
        if (this.matchesIdentifier()) {
            simpleIdentifier = this.parseSimpleIdentifier();
        }
        if (!this.inLoop && !this.inSwitch && simpleIdentifier == null) {
            this.reportErrorForToken(ParserErrorCode.BREAK_OUTSIDE_OF_LOOP, token, new Object[0]);
        }
        Token token2 = this.expect(TokenType.SEMICOLON);
        return new BreakStatement(token, simpleIdentifier, token2);
    }

    private Expression parseCascadeSection() {
        Object object;
        Object object2;
        Token token = this.expect(TokenType.PERIOD_PERIOD);
        Object object3 = null;
        SimpleIdentifier simpleIdentifier = null;
        if (this.matchesIdentifier()) {
            simpleIdentifier = this.parseSimpleIdentifier();
        } else if (this.currentToken.getType() == TokenType.OPEN_SQUARE_BRACKET) {
            Token token2 = this.getAndAdvance();
            object2 = this.parseExpression();
            object = this.expect(TokenType.CLOSE_SQUARE_BRACKET);
            object3 = new IndexExpression(token, token2, (Expression)object2, (Token)object);
            token = null;
        } else {
            this.reportErrorForToken(ParserErrorCode.MISSING_IDENTIFIER, this.currentToken, this.currentToken.getLexeme());
            simpleIdentifier = this.createSyntheticIdentifier();
        }
        if (this.currentToken.getType() == TokenType.OPEN_PAREN) {
            while (this.currentToken.getType() == TokenType.OPEN_PAREN) {
                if (simpleIdentifier != null) {
                    object3 = new MethodInvocation((Expression)object3, token, simpleIdentifier, this.parseArgumentList());
                    token = null;
                    simpleIdentifier = null;
                    continue;
                }
                if (object3 == null) {
                    object3 = new MethodInvocation((Expression)object3, token, this.createSyntheticIdentifier(), this.parseArgumentList());
                    continue;
                }
                object3 = new FunctionExpressionInvocation((Expression)object3, this.parseArgumentList());
            }
        } else if (simpleIdentifier != null) {
            object3 = new PropertyAccess((Expression)object3, token, simpleIdentifier);
            token = null;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            object2 = this.parseAssignableSelector((Expression)object3, true);
            if (object2 == object3) continue;
            object3 = object2;
            bl = true;
            while (this.currentToken.getType() == TokenType.OPEN_PAREN) {
                if (object3 instanceof PropertyAccess) {
                    object = (PropertyAccess)object3;
                    object3 = new MethodInvocation(((PropertyAccess)object).getTarget(), ((PropertyAccess)object).getOperator(), ((PropertyAccess)object).getPropertyName(), this.parseArgumentList());
                    continue;
                }
                object3 = new FunctionExpressionInvocation((Expression)object3, this.parseArgumentList());
            }
        }
        if (this.currentToken.getType().isAssignmentOperator()) {
            object2 = this.getAndAdvance();
            this.ensureAssignable((Expression)object3);
            object3 = new AssignmentExpression((Expression)object3, (Token)object2, this.parseExpressionWithoutCascade());
        }
        return object3;
    }

    private CompilationUnitMember parseClassDeclaration(CommentAndMetadata commentAndMetadata, Token token) {
        Object object;
        Token token2 = this.expectKeyword(Keyword.CLASS);
        if (this.matchesIdentifier() && (this.tokenMatches((Token)(object = this.peek()), TokenType.LT) ? (object = this.skipTypeParameterList((Token)object)) != null && this.tokenMatches((Token)object, TokenType.EQ) : this.tokenMatches((Token)object, TokenType.EQ))) {
            return this.parseClassTypeAlias(commentAndMetadata, token, token2);
        }
        object = this.parseSimpleIdentifier();
        String string = ((SimpleIdentifier)object).getName();
        TypeParameterList typeParameterList = null;
        if (this.matches(TokenType.LT)) {
            typeParameterList = this.parseTypeParameterList();
        }
        ExtendsClause extendsClause = null;
        WithClause withClause = null;
        ImplementsClause implementsClause = null;
        boolean bl = true;
        while (bl) {
            if (this.matchesKeyword(Keyword.EXTENDS)) {
                if (extendsClause == null) {
                    extendsClause = this.parseExtendsClause();
                    if (withClause != null) {
                        this.reportErrorForToken(ParserErrorCode.WITH_BEFORE_EXTENDS, withClause.getWithKeyword(), new Object[0]);
                        continue;
                    }
                    if (implementsClause == null) continue;
                    this.reportErrorForToken(ParserErrorCode.IMPLEMENTS_BEFORE_EXTENDS, implementsClause.getKeyword(), new Object[0]);
                    continue;
                }
                this.reportErrorForToken(ParserErrorCode.MULTIPLE_EXTENDS_CLAUSES, extendsClause.getKeyword(), new Object[0]);
                this.parseExtendsClause();
                continue;
            }
            if (this.matchesKeyword(Keyword.WITH)) {
                if (withClause == null) {
                    withClause = this.parseWithClause();
                    if (implementsClause == null) continue;
                    this.reportErrorForToken(ParserErrorCode.IMPLEMENTS_BEFORE_WITH, implementsClause.getKeyword(), new Object[0]);
                    continue;
                }
                this.reportErrorForToken(ParserErrorCode.MULTIPLE_WITH_CLAUSES, withClause.getWithKeyword(), new Object[0]);
                this.parseWithClause();
                continue;
            }
            if (this.matchesKeyword(Keyword.IMPLEMENTS)) {
                if (implementsClause == null) {
                    implementsClause = this.parseImplementsClause();
                    continue;
                }
                this.reportErrorForToken(ParserErrorCode.MULTIPLE_IMPLEMENTS_CLAUSES, implementsClause.getKeyword(), new Object[0]);
                this.parseImplementsClause();
                continue;
            }
            bl = false;
        }
        if (withClause != null && extendsClause == null) {
            this.reportErrorForToken(ParserErrorCode.WITH_WITHOUT_EXTENDS, withClause.getWithKeyword(), new Object[0]);
        }
        NativeClause nativeClause = null;
        if (this.matchesString(NATIVE) && this.tokenMatches(this.peek(), TokenType.STRING)) {
            nativeClause = this.parseNativeClause();
        }
        Token token3 = null;
        List<ClassMember> list = null;
        Token token4 = null;
        if (this.matches(TokenType.OPEN_CURLY_BRACKET)) {
            token3 = this.expect(TokenType.OPEN_CURLY_BRACKET);
            list = this.parseClassMembers(string, this.getEndToken(token3));
            token4 = this.expect(TokenType.CLOSE_CURLY_BRACKET);
        } else {
            token3 = this.createSyntheticToken(TokenType.OPEN_CURLY_BRACKET);
            token4 = this.createSyntheticToken(TokenType.CLOSE_CURLY_BRACKET);
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_CLASS_BODY, new Object[0]);
        }
        ClassDeclaration classDeclaration = new ClassDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, token2, (SimpleIdentifier)object, typeParameterList, extendsClause, withClause, implementsClause, token3, list, token4);
        classDeclaration.setNativeClause(nativeClause);
        return classDeclaration;
    }

    private List<ClassMember> parseClassMembers(String string, Token token) {
        ArrayList<ClassMember> arrayList = new ArrayList<ClassMember>();
        Token token2 = this.currentToken;
        while (!(this.matches(TokenType.EOF) || this.matches(TokenType.CLOSE_CURLY_BRACKET) || token == null && (this.matchesKeyword(Keyword.CLASS) || this.matchesKeyword(Keyword.TYPEDEF)))) {
            if (this.matches(TokenType.SEMICOLON)) {
                this.reportErrorForToken(ParserErrorCode.UNEXPECTED_TOKEN, this.currentToken, this.currentToken.getLexeme());
                this.advance();
            } else {
                ClassMember classMember = this.parseClassMember(string);
                if (classMember != null) {
                    arrayList.add(classMember);
                }
            }
            if (this.currentToken == token2) {
                this.reportErrorForToken(ParserErrorCode.UNEXPECTED_TOKEN, this.currentToken, this.currentToken.getLexeme());
                this.advance();
            }
            token2 = this.currentToken;
        }
        return arrayList;
    }

    private ClassTypeAlias parseClassTypeAlias(CommentAndMetadata commentAndMetadata, Token token, Token token2) {
        Token token3;
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        TypeParameterList typeParameterList = null;
        if (this.matches(TokenType.LT)) {
            typeParameterList = this.parseTypeParameterList();
        }
        Token token4 = this.expect(TokenType.EQ);
        if (this.matchesKeyword(Keyword.ABSTRACT)) {
            token = this.getAndAdvance();
        }
        TypeName typeName = this.parseTypeName();
        WithClause withClause = null;
        if (this.matchesKeyword(Keyword.WITH)) {
            withClause = this.parseWithClause();
        }
        ImplementsClause implementsClause = null;
        if (this.matchesKeyword(Keyword.IMPLEMENTS)) {
            implementsClause = this.parseImplementsClause();
        }
        if (this.matches(TokenType.SEMICOLON)) {
            token3 = this.getAndAdvance();
        } else {
            if (this.matches(TokenType.OPEN_CURLY_BRACKET)) {
                this.reportErrorForCurrentToken(ParserErrorCode.EXPECTED_TOKEN, TokenType.SEMICOLON.getLexeme());
                Token token5 = this.getAndAdvance();
                this.parseClassMembers(simpleIdentifier.getName(), this.getEndToken(token5));
                this.expect(TokenType.CLOSE_CURLY_BRACKET);
            } else {
                this.reportErrorForToken(ParserErrorCode.EXPECTED_TOKEN, this.currentToken.getPrevious(), TokenType.SEMICOLON.getLexeme());
            }
            token3 = this.createSyntheticToken(TokenType.SEMICOLON);
        }
        return new ClassTypeAlias(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token2, simpleIdentifier, typeParameterList, token4, token, typeName, withClause, implementsClause, token3);
    }

    private List<Combinator> parseCombinators() {
        ArrayList<Combinator> arrayList = new ArrayList<Combinator>();
        while (this.matchesString(SHOW) || this.matchesString(HIDE)) {
            List<SimpleIdentifier> list;
            Token token = this.expect(TokenType.IDENTIFIER);
            if (token.getLexeme().equals(SHOW)) {
                list = this.parseIdentifierList();
                arrayList.add(new ShowCombinator(token, list));
                continue;
            }
            list = this.parseIdentifierList();
            arrayList.add(new HideCombinator(token, list));
        }
        return arrayList;
    }

    private CommentAndMetadata parseCommentAndMetadata() {
        Comment comment = this.parseDocumentationComment();
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        while (this.matches(TokenType.AT)) {
            arrayList.add(this.parseAnnotation());
            Comment comment2 = this.parseDocumentationComment();
            if (comment2 == null) continue;
            comment = comment2;
        }
        return new CommentAndMetadata(comment, arrayList);
    }

    private CommentReference parseCommentReference(String string, int n) {
        if (string.length() == 0) {
            SyntheticStringToken syntheticStringToken = new SyntheticStringToken(TokenType.IDENTIFIER, "", n);
            return new CommentReference(null, new SimpleIdentifier(syntheticStringToken));
        }
        try {
            BooleanErrorListener booleanErrorListener = new BooleanErrorListener();
            Scanner scanner = new Scanner(null, new SubSequenceReader(string, n), booleanErrorListener);
            scanner.setSourceStart(1, 1);
            Token token = scanner.tokenize();
            if (booleanErrorListener.getErrorReported()) {
                return null;
            }
            Token token2 = null;
            if (this.tokenMatchesKeyword(token, Keyword.NEW)) {
                token2 = token;
                token = token.getNext();
            }
            if (this.tokenMatchesIdentifier(token)) {
                Token token3;
                Identifier identifier;
                Token token4 = token.getNext();
                Token token5 = token4.getNext();
                if (this.tokenMatches(token4, TokenType.PERIOD) && this.tokenMatchesIdentifier(token5)) {
                    identifier = new PrefixedIdentifier(new SimpleIdentifier(token), token4, new SimpleIdentifier(token5));
                    token3 = token5.getNext();
                } else {
                    identifier = new SimpleIdentifier(token);
                    token3 = token.getNext();
                }
                if (token3.getType() != TokenType.EOF) {
                    return null;
                }
                return new CommentReference(token2, identifier);
            }
            if (this.tokenMatchesKeyword(token, Keyword.THIS) || this.tokenMatchesKeyword(token, Keyword.NULL) || this.tokenMatchesKeyword(token, Keyword.TRUE) || this.tokenMatchesKeyword(token, Keyword.FALSE)) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private List<CommentReference> parseCommentReferences(Token[] tokenArray) {
        ArrayList<CommentReference> arrayList = new ArrayList<CommentReference>();
        for (Token token : tokenArray) {
            String string = token.getLexeme();
            int n = string.length();
            List<int[]> list = this.getCodeBlockRanges(string);
            int n2 = string.indexOf(91);
            while (n2 >= 0 && n2 + 1 < n) {
                int[] nArray = this.findRange(list, n2);
                if (nArray == null) {
                    Object object;
                    char c;
                    int n3 = token.getOffset() + n2 + 1;
                    int n4 = string.indexOf(93, n2);
                    if (n4 >= 0) {
                        c = string.charAt(n2 + 1);
                        if (c != '\'' && c != '\"' && !this.isLinkText(string, n4) && (object = this.parseCommentReference(string.substring(n2 + 1, n4), n3)) != null) {
                            arrayList.add((CommentReference)object);
                        }
                    } else {
                        c = string.charAt(n2 + 1);
                        if (Character.isLetterOrDigit(c)) {
                            int n5 = StringUtilities.indexOfFirstNotLetterDigit(string, n2 + 1);
                            String string2 = string.substring(n2 + 1, n5);
                            StringToken stringToken = new StringToken(TokenType.IDENTIFIER, string2, n3);
                            arrayList.add(new CommentReference(null, new SimpleIdentifier(stringToken)));
                        } else {
                            object = new SyntheticStringToken(TokenType.IDENTIFIER, "", n3);
                            arrayList.add(new CommentReference(null, new SimpleIdentifier((Token)object)));
                        }
                        n4 = n2 + 1;
                    }
                    n2 = string.indexOf(91, n4);
                    continue;
                }
                n2 = string.indexOf(91, nArray[1] + 1);
            }
        }
        return arrayList;
    }

    private CompilationUnitMember parseCompilationUnitMember(CommentAndMetadata commentAndMetadata) {
        Modifiers modifiers = this.parseModifiers();
        if (this.matchesKeyword(Keyword.CLASS)) {
            return this.parseClassDeclaration(commentAndMetadata, this.validateModifiersForClass(modifiers));
        }
        if (this.matchesKeyword(Keyword.TYPEDEF) && !this.tokenMatches(this.peek(), TokenType.PERIOD) && !this.tokenMatches(this.peek(), TokenType.LT) && !this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
            this.validateModifiersForTypedef(modifiers);
            return this.parseTypeAlias(commentAndMetadata);
        }
        if (this.matchesKeyword(Keyword.VOID)) {
            TypeName typeName = this.parseReturnType();
            if ((this.matchesKeyword(Keyword.GET) || this.matchesKeyword(Keyword.SET)) && this.tokenMatchesIdentifier(this.peek())) {
                this.validateModifiersForTopLevelFunction(modifiers);
                return this.parseFunctionDeclaration(commentAndMetadata, modifiers.getExternalKeyword(), typeName);
            }
            if (this.matchesKeyword(Keyword.OPERATOR) && this.isOperator(this.peek())) {
                this.reportErrorForToken(ParserErrorCode.TOP_LEVEL_OPERATOR, this.currentToken, new Object[0]);
                return this.convertToFunctionDeclaration(this.parseOperator(commentAndMetadata, modifiers.getExternalKeyword(), typeName));
            }
            if (this.matchesIdentifier() && this.peek().matchesAny(TokenType.OPEN_PAREN, TokenType.OPEN_CURLY_BRACKET, TokenType.FUNCTION)) {
                this.validateModifiersForTopLevelFunction(modifiers);
                return this.parseFunctionDeclaration(commentAndMetadata, modifiers.getExternalKeyword(), typeName);
            }
            if (this.matchesIdentifier() && this.peek().matchesAny(TokenType.EQ, TokenType.COMMA, TokenType.SEMICOLON)) {
                this.reportErrorForNode(ParserErrorCode.VOID_VARIABLE, typeName, new Object[0]);
                return new TopLevelVariableDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), this.parseVariableDeclarationListAfterType(null, this.validateModifiersForTopLevelVariable(modifiers), null), this.expect(TokenType.SEMICOLON));
            }
            this.reportErrorForToken(ParserErrorCode.EXPECTED_EXECUTABLE, this.currentToken, new Object[0]);
            return null;
        }
        if ((this.matchesKeyword(Keyword.GET) || this.matchesKeyword(Keyword.SET)) && this.tokenMatchesIdentifier(this.peek())) {
            this.validateModifiersForTopLevelFunction(modifiers);
            return this.parseFunctionDeclaration(commentAndMetadata, modifiers.getExternalKeyword(), null);
        }
        if (this.matchesKeyword(Keyword.OPERATOR) && this.isOperator(this.peek())) {
            this.reportErrorForToken(ParserErrorCode.TOP_LEVEL_OPERATOR, this.currentToken, new Object[0]);
            return this.convertToFunctionDeclaration(this.parseOperator(commentAndMetadata, modifiers.getExternalKeyword(), null));
        }
        if (!this.matchesIdentifier()) {
            this.reportErrorForToken(ParserErrorCode.EXPECTED_EXECUTABLE, this.currentToken, new Object[0]);
            return null;
        }
        if (this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
            this.validateModifiersForTopLevelFunction(modifiers);
            return this.parseFunctionDeclaration(commentAndMetadata, modifiers.getExternalKeyword(), null);
        }
        if (this.peek().matchesAny(TokenType.EQ, TokenType.COMMA, TokenType.SEMICOLON)) {
            if (modifiers.getConstKeyword() == null && modifiers.getFinalKeyword() == null && modifiers.getVarKeyword() == null) {
                this.reportErrorForCurrentToken(ParserErrorCode.MISSING_CONST_FINAL_VAR_OR_TYPE, new Object[0]);
            }
            return new TopLevelVariableDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), this.parseVariableDeclarationListAfterType(null, this.validateModifiersForTopLevelVariable(modifiers), null), this.expect(TokenType.SEMICOLON));
        }
        TypeName typeName = this.parseReturnType();
        if ((this.matchesKeyword(Keyword.GET) || this.matchesKeyword(Keyword.SET)) && this.tokenMatchesIdentifier(this.peek())) {
            this.validateModifiersForTopLevelFunction(modifiers);
            return this.parseFunctionDeclaration(commentAndMetadata, modifiers.getExternalKeyword(), typeName);
        }
        if (this.matchesKeyword(Keyword.OPERATOR) && this.isOperator(this.peek())) {
            this.reportErrorForToken(ParserErrorCode.TOP_LEVEL_OPERATOR, this.currentToken, new Object[0]);
            return this.convertToFunctionDeclaration(this.parseOperator(commentAndMetadata, modifiers.getExternalKeyword(), typeName));
        }
        if (this.matches(TokenType.AT)) {
            return new TopLevelVariableDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), this.parseVariableDeclarationListAfterType(null, this.validateModifiersForTopLevelVariable(modifiers), typeName), this.expect(TokenType.SEMICOLON));
        }
        if (!this.matchesIdentifier()) {
            this.reportErrorForToken(ParserErrorCode.EXPECTED_EXECUTABLE, this.currentToken, new Object[0]);
            Token token = this.matches(TokenType.SEMICOLON) ? this.getAndAdvance() : this.createSyntheticToken(TokenType.SEMICOLON);
            ArrayList<VariableDeclaration> arrayList = new ArrayList<VariableDeclaration>();
            arrayList.add(new VariableDeclaration(null, null, this.createSyntheticIdentifier(), null, null));
            return new TopLevelVariableDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), new VariableDeclarationList(null, null, null, typeName, arrayList), token);
        }
        if (this.peek().matchesAny(TokenType.OPEN_PAREN, TokenType.FUNCTION, TokenType.OPEN_CURLY_BRACKET)) {
            this.validateModifiersForTopLevelFunction(modifiers);
            return this.parseFunctionDeclaration(commentAndMetadata, modifiers.getExternalKeyword(), typeName);
        }
        return new TopLevelVariableDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), this.parseVariableDeclarationListAfterType(null, this.validateModifiersForTopLevelVariable(modifiers), typeName), this.expect(TokenType.SEMICOLON));
    }

    private Expression parseConstExpression() {
        Token token = this.expectKeyword(Keyword.CONST);
        if (this.matches(TokenType.OPEN_SQUARE_BRACKET) || this.matches(TokenType.INDEX)) {
            return this.parseListLiteral(token, null);
        }
        if (this.matches(TokenType.OPEN_CURLY_BRACKET)) {
            return this.parseMapLiteral(token, null);
        }
        if (this.matches(TokenType.LT)) {
            return this.parseListOrMapLiteral(token);
        }
        return this.parseInstanceCreationExpression(token);
    }

    private ConstructorDeclaration parseConstructor(CommentAndMetadata commentAndMetadata, Token token, Token token2, Token token3, SimpleIdentifier simpleIdentifier, Token token4, SimpleIdentifier simpleIdentifier2, FormalParameterList formalParameterList) {
        FunctionBody functionBody;
        boolean bl = token == null;
        Token token5 = null;
        ArrayList<ConstructorInitializer> arrayList = null;
        if (this.matches(TokenType.COLON)) {
            token5 = this.getAndAdvance();
            arrayList = new ArrayList<ConstructorInitializer>();
            do {
                if (this.matchesKeyword(Keyword.THIS)) {
                    if (this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
                        bl = false;
                        arrayList.add(this.parseRedirectingConstructorInvocation());
                        continue;
                    }
                    if (this.tokenMatches(this.peek(), TokenType.PERIOD) && this.tokenMatches(this.peekAt(3), TokenType.OPEN_PAREN)) {
                        bl = false;
                        arrayList.add(this.parseRedirectingConstructorInvocation());
                        continue;
                    }
                    arrayList.add(this.parseConstructorFieldInitializer());
                    continue;
                }
                if (this.matchesKeyword(Keyword.SUPER)) {
                    arrayList.add(this.parseSuperConstructorInvocation());
                    continue;
                }
                arrayList.add(this.parseConstructorFieldInitializer());
            } while (this.optional(TokenType.COMMA));
        }
        ConstructorName constructorName = null;
        if (this.matches(TokenType.EQ)) {
            token5 = this.getAndAdvance();
            constructorName = this.parseConstructorName();
            functionBody = new EmptyFunctionBody(this.expect(TokenType.SEMICOLON));
            if (token3 == null) {
                this.reportErrorForNode(ParserErrorCode.REDIRECTION_IN_NON_FACTORY_CONSTRUCTOR, constructorName, new Object[0]);
            }
        } else {
            functionBody = this.parseFunctionBody(true, ParserErrorCode.MISSING_FUNCTION_BODY, false);
            if (token2 != null && token3 != null && token == null) {
                this.reportErrorForToken(ParserErrorCode.CONST_FACTORY, token3, new Object[0]);
            } else if (functionBody instanceof EmptyFunctionBody) {
                if (token3 != null && token == null) {
                    this.reportErrorForToken(ParserErrorCode.FACTORY_WITHOUT_BODY, token3, new Object[0]);
                }
            } else if (token2 != null) {
                this.reportErrorForNode(ParserErrorCode.CONST_CONSTRUCTOR_WITH_BODY, functionBody, new Object[0]);
            } else if (!bl) {
                this.reportErrorForNode(ParserErrorCode.EXTERNAL_CONSTRUCTOR_WITH_BODY, functionBody, new Object[0]);
            }
        }
        return new ConstructorDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, token2, token3, simpleIdentifier, token4, simpleIdentifier2, formalParameterList, token5, arrayList, constructorName, functionBody);
    }

    private ConstructorFieldInitializer parseConstructorFieldInitializer() {
        Token token = null;
        Token token2 = null;
        if (this.matchesKeyword(Keyword.THIS)) {
            token = this.getAndAdvance();
            token2 = this.expect(TokenType.PERIOD);
        }
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        Token token3 = this.expect(TokenType.EQ);
        Expression expression = this.parseConditionalExpression();
        TokenType tokenType = this.currentToken.getType();
        if (tokenType == TokenType.PERIOD_PERIOD) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            while (tokenType == TokenType.PERIOD_PERIOD) {
                Expression expression2 = this.parseCascadeSection();
                if (expression2 != null) {
                    arrayList.add(expression2);
                }
                tokenType = this.currentToken.getType();
            }
            expression = new CascadeExpression(expression, arrayList);
        }
        return new ConstructorFieldInitializer(token, token2, simpleIdentifier, token3, expression);
    }

    private Statement parseContinueStatement() {
        Token token = this.expectKeyword(Keyword.CONTINUE);
        if (!this.inLoop && !this.inSwitch) {
            this.reportErrorForToken(ParserErrorCode.CONTINUE_OUTSIDE_OF_LOOP, token, new Object[0]);
        }
        SimpleIdentifier simpleIdentifier = null;
        if (this.matchesIdentifier()) {
            simpleIdentifier = this.parseSimpleIdentifier();
        }
        if (this.inSwitch && !this.inLoop && simpleIdentifier == null) {
            this.reportErrorForToken(ParserErrorCode.CONTINUE_WITHOUT_LABEL_IN_CASE, token, new Object[0]);
        }
        Token token2 = this.expect(TokenType.SEMICOLON);
        return new ContinueStatement(token, simpleIdentifier, token2);
    }

    private Directive parseDirective(CommentAndMetadata commentAndMetadata) {
        if (this.matchesKeyword(Keyword.IMPORT)) {
            return this.parseImportDirective(commentAndMetadata);
        }
        if (this.matchesKeyword(Keyword.EXPORT)) {
            return this.parseExportDirective(commentAndMetadata);
        }
        if (this.matchesKeyword(Keyword.LIBRARY)) {
            return this.parseLibraryDirective(commentAndMetadata);
        }
        if (this.matchesKeyword(Keyword.PART)) {
            return this.parsePartDirective(commentAndMetadata);
        }
        throw new IllegalStateException("parseDirective invoked in an invalid state; currentToken = " + this.currentToken);
    }

    private Comment parseDocumentationComment() {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (Token token = this.currentToken.getPrecedingComments(); token != null; token = token.getNext()) {
            if (token.getType() == TokenType.SINGLE_LINE_COMMENT) {
                if (!StringUtilities.startsWith3(token.getLexeme(), 0, 47, 47, 47)) continue;
                if (arrayList.size() == 1 && StringUtilities.startsWith3(((Token)arrayList.get(0)).getLexeme(), 0, 47, 42, 42)) {
                    arrayList.clear();
                }
                arrayList.add(token);
                continue;
            }
            if (!StringUtilities.startsWith3(token.getLexeme(), 0, 47, 42, 42)) continue;
            arrayList.clear();
            arrayList.add(token);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        Token[] tokenArray = arrayList.toArray(new Token[arrayList.size()]);
        List<CommentReference> list = this.parseCommentReferences(tokenArray);
        return Comment.createDocumentationCommentWithReferences(tokenArray, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseDoStatement() {
        boolean bl = this.inLoop;
        this.inLoop = true;
        try {
            Token token = this.expectKeyword(Keyword.DO);
            Statement statement = this.parseStatement();
            Token token2 = this.expectKeyword(Keyword.WHILE);
            Token token3 = this.expect(TokenType.OPEN_PAREN);
            Expression expression = this.parseExpression();
            Token token4 = this.expect(TokenType.CLOSE_PAREN);
            Token token5 = this.expect(TokenType.SEMICOLON);
            DoStatement doStatement = new DoStatement(token, statement, token2, token3, expression, token4, token5);
            return doStatement;
        }
        finally {
            this.inLoop = bl;
        }
    }

    private Statement parseEmptyStatement() {
        return new EmptyStatement(this.getAndAdvance());
    }

    private Expression parseEqualityExpression() {
        Expression expression = this.matchesKeyword(Keyword.SUPER) && this.currentToken.getNext().getType().isEqualityOperator() ? new SuperExpression(this.getAndAdvance()) : this.parseRelationalExpression();
        boolean bl = false;
        while (this.currentToken.getType().isEqualityOperator()) {
            Token token = this.getAndAdvance();
            if (bl) {
                this.reportErrorForNode(ParserErrorCode.EQUALITY_CANNOT_BE_EQUALITY_OPERAND, expression, new Object[0]);
            }
            expression = new BinaryExpression(expression, token, this.parseRelationalExpression());
            bl = true;
        }
        return expression;
    }

    private ExportDirective parseExportDirective(CommentAndMetadata commentAndMetadata) {
        Token token = this.expectKeyword(Keyword.EXPORT);
        StringLiteral stringLiteral = this.parseStringLiteral();
        List<Combinator> list = this.parseCombinators();
        Token token2 = this.expectSemicolon();
        return new ExportDirective(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, stringLiteral, list, token2);
    }

    private List<Expression> parseExpressionList() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(this.parseExpression());
        while (this.optional(TokenType.COMMA)) {
            arrayList.add(this.parseExpression());
        }
        return arrayList;
    }

    private FinalConstVarOrType parseFinalConstVarOrType(boolean bl) {
        Token token = null;
        TypeName typeName = null;
        if (this.matchesKeyword(Keyword.FINAL) || this.matchesKeyword(Keyword.CONST)) {
            token = this.getAndAdvance();
            if (this.isTypedIdentifier(this.currentToken)) {
                typeName = this.parseTypeName();
            }
        } else if (this.matchesKeyword(Keyword.VAR)) {
            token = this.getAndAdvance();
        } else if (this.isTypedIdentifier(this.currentToken)) {
            typeName = this.parseReturnType();
        } else if (!bl) {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_CONST_FINAL_VAR_OR_TYPE, new Object[0]);
        }
        return new FinalConstVarOrType(token, typeName);
    }

    private FormalParameter parseFormalParameter(ParameterKind parameterKind) {
        NormalFormalParameter normalFormalParameter = this.parseNormalFormalParameter();
        if (this.matches(TokenType.EQ)) {
            Token token = this.getAndAdvance();
            Expression expression = this.parseExpression();
            if (parameterKind == ParameterKind.NAMED) {
                this.reportErrorForToken(ParserErrorCode.WRONG_SEPARATOR_FOR_NAMED_PARAMETER, token, new Object[0]);
            } else if (parameterKind == ParameterKind.REQUIRED) {
                this.reportErrorForNode(ParserErrorCode.POSITIONAL_PARAMETER_OUTSIDE_GROUP, normalFormalParameter, new Object[0]);
            }
            return new DefaultFormalParameter(normalFormalParameter, parameterKind, token, expression);
        }
        if (this.matches(TokenType.COLON)) {
            Token token = this.getAndAdvance();
            Expression expression = this.parseExpression();
            if (parameterKind == ParameterKind.POSITIONAL) {
                this.reportErrorForToken(ParserErrorCode.WRONG_SEPARATOR_FOR_POSITIONAL_PARAMETER, token, new Object[0]);
            } else if (parameterKind == ParameterKind.REQUIRED) {
                this.reportErrorForNode(ParserErrorCode.NAMED_PARAMETER_OUTSIDE_GROUP, normalFormalParameter, new Object[0]);
            }
            return new DefaultFormalParameter(normalFormalParameter, parameterKind, token, expression);
        }
        if (parameterKind != ParameterKind.REQUIRED) {
            return new DefaultFormalParameter(normalFormalParameter, parameterKind, null, null);
        }
        return normalFormalParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseForStatement() {
        boolean bl = this.inLoop;
        this.inLoop = true;
        try {
            Object object;
            Object object2;
            Object object3;
            Token token = this.expectKeyword(Keyword.FOR);
            Token token2 = this.expect(TokenType.OPEN_PAREN);
            VariableDeclarationList variableDeclarationList = null;
            Expression expression = null;
            if (!this.matches(TokenType.SEMICOLON)) {
                object3 = this.parseCommentAndMetadata();
                if (this.matchesIdentifier() && this.tokenMatchesKeyword(this.peek(), Keyword.IN)) {
                    object2 = new ArrayList();
                    object = this.parseSimpleIdentifier();
                    object2.add(new VariableDeclaration(null, null, (SimpleIdentifier)object, null, null));
                    variableDeclarationList = new VariableDeclarationList(((CommentAndMetadata)object3).getComment(), ((CommentAndMetadata)object3).getMetadata(), null, null, (List<VariableDeclaration>)object2);
                } else if (this.isInitializedVariableDeclaration()) {
                    variableDeclarationList = this.parseVariableDeclarationListAfterMetadata((CommentAndMetadata)object3);
                } else {
                    expression = this.parseExpression();
                }
                if (this.matchesKeyword(Keyword.IN)) {
                    AstNode astNode;
                    Token token3;
                    AstNode astNode2;
                    NodeList<VariableDeclaration> nodeList;
                    object2 = null;
                    object = null;
                    if (variableDeclarationList == null) {
                        this.reportErrorForCurrentToken(ParserErrorCode.MISSING_VARIABLE_IN_FOR_EACH, new Object[0]);
                    } else {
                        nodeList = variableDeclarationList.getVariables();
                        if (nodeList.size() > 1) {
                            this.reportErrorForCurrentToken(ParserErrorCode.MULTIPLE_VARIABLES_IN_FOR_EACH, Integer.toString(nodeList.size()));
                        }
                        if (((VariableDeclaration)(astNode2 = (VariableDeclaration)nodeList.get(0))).getInitializer() != null) {
                            this.reportErrorForCurrentToken(ParserErrorCode.INITIALIZED_VARIABLE_IN_FOR_EACH, new Object[0]);
                        }
                        token3 = variableDeclarationList.getKeyword();
                        astNode = variableDeclarationList.getType();
                        if (token3 != null || astNode != null) {
                            object2 = new DeclaredIdentifier(((CommentAndMetadata)object3).getComment(), ((CommentAndMetadata)object3).getMetadata(), token3, (TypeName)astNode, ((VariableDeclaration)astNode2).getName());
                        } else {
                            if (!((CommentAndMetadata)object3).getMetadata().isEmpty()) {
                                // empty if block
                            }
                            object = ((VariableDeclaration)astNode2).getName();
                        }
                    }
                    nodeList = this.expectKeyword(Keyword.IN);
                    astNode2 = this.parseExpression();
                    token3 = this.expect(TokenType.CLOSE_PAREN);
                    astNode = this.parseStatement();
                    if (object2 == null) {
                        ForEachStatement forEachStatement = new ForEachStatement(token, token2, (SimpleIdentifier)object, (Token)((Object)nodeList), (Expression)astNode2, token3, (Statement)astNode);
                        return forEachStatement;
                    }
                    ForEachStatement forEachStatement = new ForEachStatement(token, token2, (DeclaredIdentifier)object2, (Token)((Object)nodeList), (Expression)astNode2, token3, (Statement)astNode);
                    return forEachStatement;
                }
            }
            object3 = this.expect(TokenType.SEMICOLON);
            object2 = null;
            if (!this.matches(TokenType.SEMICOLON)) {
                object2 = this.parseExpression();
            }
            object = this.expect(TokenType.SEMICOLON);
            List<Expression> list = null;
            if (!this.matches(TokenType.CLOSE_PAREN)) {
                list = this.parseExpressionList();
            }
            Token token4 = this.expect(TokenType.CLOSE_PAREN);
            Statement statement = this.parseStatement();
            ForStatement forStatement = new ForStatement(token, token2, variableDeclarationList, expression, (Token)object3, (Expression)object2, (Token)object, list, token4, statement);
            return forStatement;
        }
        finally {
            this.inLoop = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionBody parseFunctionBody(boolean bl, ParserErrorCode parserErrorCode, boolean bl2) {
        boolean bl3 = this.inLoop;
        boolean bl4 = this.inSwitch;
        this.inLoop = false;
        this.inSwitch = false;
        try {
            if (this.matches(TokenType.SEMICOLON)) {
                if (!bl) {
                    this.reportErrorForCurrentToken(parserErrorCode, new Object[0]);
                }
                EmptyFunctionBody emptyFunctionBody = new EmptyFunctionBody(this.getAndAdvance());
                return emptyFunctionBody;
            }
            if (this.matches(TokenType.FUNCTION)) {
                Token token = this.getAndAdvance();
                Expression expression = this.parseExpression();
                Token token2 = null;
                if (!bl2) {
                    token2 = this.expect(TokenType.SEMICOLON);
                }
                if (!this.parseFunctionBodies) {
                    EmptyFunctionBody emptyFunctionBody = new EmptyFunctionBody(this.createSyntheticToken(TokenType.SEMICOLON));
                    return emptyFunctionBody;
                }
                ExpressionFunctionBody expressionFunctionBody = new ExpressionFunctionBody(token, expression, token2);
                return expressionFunctionBody;
            }
            if (this.matches(TokenType.OPEN_CURLY_BRACKET)) {
                if (!this.parseFunctionBodies) {
                    this.skipBlock();
                    EmptyFunctionBody emptyFunctionBody = new EmptyFunctionBody(this.createSyntheticToken(TokenType.SEMICOLON));
                    return emptyFunctionBody;
                }
                BlockFunctionBody blockFunctionBody = new BlockFunctionBody(this.parseBlock());
                return blockFunctionBody;
            }
            if (this.matchesString(NATIVE)) {
                Token token = this.getAndAdvance();
                StringLiteral stringLiteral = null;
                if (this.matches(TokenType.STRING)) {
                    stringLiteral = this.parseStringLiteral();
                }
                NativeFunctionBody nativeFunctionBody = new NativeFunctionBody(token, stringLiteral, this.expect(TokenType.SEMICOLON));
                return nativeFunctionBody;
            }
            this.reportErrorForCurrentToken(parserErrorCode, new Object[0]);
            EmptyFunctionBody emptyFunctionBody = new EmptyFunctionBody(this.createSyntheticToken(TokenType.SEMICOLON));
            return emptyFunctionBody;
        }
        finally {
            this.inLoop = bl3;
            this.inSwitch = bl4;
        }
    }

    private FunctionDeclaration parseFunctionDeclaration(CommentAndMetadata commentAndMetadata, Token token, TypeName typeName) {
        Token token2 = null;
        boolean bl = false;
        if (this.matchesKeyword(Keyword.GET) && !this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
            token2 = this.getAndAdvance();
            bl = true;
        } else if (this.matchesKeyword(Keyword.SET) && !this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
            token2 = this.getAndAdvance();
        }
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        FormalParameterList formalParameterList = null;
        if (!bl) {
            if (this.matches(TokenType.OPEN_PAREN)) {
                formalParameterList = this.parseFormalParameterList();
                this.validateFormalParameterList(formalParameterList);
            } else {
                this.reportErrorForCurrentToken(ParserErrorCode.MISSING_FUNCTION_PARAMETERS, new Object[0]);
            }
        } else if (this.matches(TokenType.OPEN_PAREN)) {
            this.reportErrorForCurrentToken(ParserErrorCode.GETTER_WITH_PARAMETERS, new Object[0]);
            this.parseFormalParameterList();
        }
        FunctionBody functionBody = token == null ? this.parseFunctionBody(false, ParserErrorCode.MISSING_FUNCTION_BODY, false) : new EmptyFunctionBody(this.expect(TokenType.SEMICOLON));
        return new FunctionDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, typeName, token2, simpleIdentifier, new FunctionExpression(formalParameterList, functionBody));
    }

    private Statement parseFunctionDeclarationStatement() {
        Modifiers modifiers = this.parseModifiers();
        this.validateModifiersForFunctionDeclarationStatement(modifiers);
        return this.parseFunctionDeclarationStatementAfterReturnType(this.parseCommentAndMetadata(), this.parseOptionalReturnType());
    }

    private Statement parseFunctionDeclarationStatementAfterReturnType(CommentAndMetadata commentAndMetadata, TypeName typeName) {
        FunctionDeclaration functionDeclaration = this.parseFunctionDeclaration(commentAndMetadata, null, typeName);
        Token token = functionDeclaration.getPropertyKeyword();
        if (token != null) {
            if (((KeywordToken)token).getKeyword() == Keyword.GET) {
                this.reportErrorForToken(ParserErrorCode.GETTER_IN_FUNCTION, token, new Object[0]);
            } else {
                this.reportErrorForToken(ParserErrorCode.SETTER_IN_FUNCTION, token, new Object[0]);
            }
        }
        return new FunctionDeclarationStatement(functionDeclaration);
    }

    private FunctionTypeAlias parseFunctionTypeAlias(CommentAndMetadata commentAndMetadata, Token token) {
        TypeName typeName = null;
        if (this.hasReturnTypeInTypeAlias()) {
            typeName = this.parseReturnType();
        }
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        TypeParameterList typeParameterList = null;
        if (this.matches(TokenType.LT)) {
            typeParameterList = this.parseTypeParameterList();
        }
        if (this.matches(TokenType.SEMICOLON) || this.matches(TokenType.EOF)) {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_TYPEDEF_PARAMETERS, new Object[0]);
            FormalParameterList formalParameterList = new FormalParameterList(this.createSyntheticToken(TokenType.OPEN_PAREN), null, null, null, this.createSyntheticToken(TokenType.CLOSE_PAREN));
            Token token2 = this.expect(TokenType.SEMICOLON);
            return new FunctionTypeAlias(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, typeName, simpleIdentifier, typeParameterList, formalParameterList, token2);
        }
        if (!this.matches(TokenType.OPEN_PAREN)) {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_TYPEDEF_PARAMETERS, new Object[0]);
            return new FunctionTypeAlias(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, typeName, simpleIdentifier, typeParameterList, new FormalParameterList(this.createSyntheticToken(TokenType.OPEN_PAREN), null, null, null, this.createSyntheticToken(TokenType.CLOSE_PAREN)), this.createSyntheticToken(TokenType.SEMICOLON));
        }
        FormalParameterList formalParameterList = this.parseFormalParameterList();
        this.validateFormalParameterList(formalParameterList);
        Token token3 = this.expect(TokenType.SEMICOLON);
        return new FunctionTypeAlias(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, typeName, simpleIdentifier, typeParameterList, formalParameterList, token3);
    }

    private MethodDeclaration parseGetter(CommentAndMetadata commentAndMetadata, Token token, Token token2, TypeName typeName) {
        Token token3 = this.expectKeyword(Keyword.GET);
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        if (this.matches(TokenType.OPEN_PAREN) && this.tokenMatches(this.peek(), TokenType.CLOSE_PAREN)) {
            this.reportErrorForCurrentToken(ParserErrorCode.GETTER_WITH_PARAMETERS, new Object[0]);
            this.advance();
            this.advance();
        }
        FunctionBody functionBody = this.parseFunctionBody(token != null || token2 == null, ParserErrorCode.STATIC_GETTER_WITHOUT_BODY, false);
        if (token != null && !(functionBody instanceof EmptyFunctionBody)) {
            this.reportErrorForCurrentToken(ParserErrorCode.EXTERNAL_GETTER_WITH_BODY, new Object[0]);
        }
        return new MethodDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, token2, typeName, token3, null, simpleIdentifier, null, functionBody);
    }

    private List<SimpleIdentifier> parseIdentifierList() {
        ArrayList<SimpleIdentifier> arrayList = new ArrayList<SimpleIdentifier>();
        arrayList.add(this.parseSimpleIdentifier());
        while (this.matches(TokenType.COMMA)) {
            this.advance();
            arrayList.add(this.parseSimpleIdentifier());
        }
        return arrayList;
    }

    private Statement parseIfStatement() {
        Token token = this.expectKeyword(Keyword.IF);
        Token token2 = this.expect(TokenType.OPEN_PAREN);
        Expression expression = this.parseExpression();
        Token token3 = this.expect(TokenType.CLOSE_PAREN);
        Statement statement = this.parseStatement();
        Token token4 = null;
        Statement statement2 = null;
        if (this.matchesKeyword(Keyword.ELSE)) {
            token4 = this.getAndAdvance();
            statement2 = this.parseStatement();
        }
        return new IfStatement(token, token2, expression, token3, statement, token4, statement2);
    }

    private ImportDirective parseImportDirective(CommentAndMetadata commentAndMetadata) {
        Token token = this.expectKeyword(Keyword.IMPORT);
        StringLiteral stringLiteral = this.parseStringLiteral();
        Token token2 = null;
        SimpleIdentifier simpleIdentifier = null;
        if (this.matchesKeyword(Keyword.AS)) {
            token2 = this.getAndAdvance();
            simpleIdentifier = this.parseSimpleIdentifier();
        }
        List<Combinator> list = this.parseCombinators();
        Token token3 = this.expectSemicolon();
        return new ImportDirective(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, stringLiteral, token2, simpleIdentifier, list, token3);
    }

    private FieldDeclaration parseInitializedIdentifierList(CommentAndMetadata commentAndMetadata, Token token, Token token2, TypeName typeName) {
        VariableDeclarationList variableDeclarationList = this.parseVariableDeclarationListAfterType(null, token2, typeName);
        return new FieldDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, variableDeclarationList, this.expect(TokenType.SEMICOLON));
    }

    private InstanceCreationExpression parseInstanceCreationExpression(Token token) {
        ConstructorName constructorName = this.parseConstructorName();
        ArgumentList argumentList = this.parseArgumentList();
        return new InstanceCreationExpression(token, constructorName, argumentList);
    }

    private LibraryDirective parseLibraryDirective(CommentAndMetadata commentAndMetadata) {
        Token token = this.expectKeyword(Keyword.LIBRARY);
        LibraryIdentifier libraryIdentifier = this.parseLibraryName(ParserErrorCode.MISSING_NAME_IN_LIBRARY_DIRECTIVE, token);
        Token token2 = this.expect(TokenType.SEMICOLON);
        return new LibraryDirective(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, libraryIdentifier, token2);
    }

    private LibraryIdentifier parseLibraryName(ParserErrorCode parserErrorCode, Token token) {
        Object object;
        if (this.matchesIdentifier()) {
            return this.parseLibraryIdentifier();
        }
        if (this.matches(TokenType.STRING)) {
            object = this.parseStringLiteral();
            this.reportErrorForNode(ParserErrorCode.NON_IDENTIFIER_LIBRARY_NAME, (AstNode)object, new Object[0]);
        } else {
            this.reportErrorForToken(parserErrorCode, token, new Object[0]);
        }
        object = new ArrayList();
        ((ArrayList)object).add(this.createSyntheticIdentifier());
        return new LibraryIdentifier((List<SimpleIdentifier>)object);
    }

    private ListLiteral parseListLiteral(Token token, TypeArgumentList typeArgumentList) {
        if (this.matches(TokenType.INDEX)) {
            BeginToken beginToken = new BeginToken(TokenType.OPEN_SQUARE_BRACKET, this.currentToken.getOffset());
            Token token2 = new Token(TokenType.CLOSE_SQUARE_BRACKET, this.currentToken.getOffset() + 1);
            beginToken.setEndToken(token2);
            token2.setNext(this.currentToken.getNext());
            beginToken.setNext(token2);
            this.currentToken.getPrevious().setNext(beginToken);
            this.currentToken = this.currentToken.getNext();
            return new ListLiteral(token, typeArgumentList, beginToken, null, token2);
        }
        Token token3 = this.expect(TokenType.OPEN_SQUARE_BRACKET);
        if (this.matches(TokenType.CLOSE_SQUARE_BRACKET)) {
            return new ListLiteral(token, typeArgumentList, token3, null, this.getAndAdvance());
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(this.parseExpression());
        while (this.optional(TokenType.COMMA)) {
            if (this.matches(TokenType.CLOSE_SQUARE_BRACKET)) {
                return new ListLiteral(token, typeArgumentList, token3, arrayList, this.getAndAdvance());
            }
            arrayList.add(this.parseExpression());
        }
        Token token4 = this.expect(TokenType.CLOSE_SQUARE_BRACKET);
        return new ListLiteral(token, typeArgumentList, token3, arrayList, token4);
    }

    private TypedLiteral parseListOrMapLiteral(Token token) {
        TypeArgumentList typeArgumentList = null;
        if (this.matches(TokenType.LT)) {
            typeArgumentList = this.parseTypeArgumentList();
        }
        if (this.matches(TokenType.OPEN_CURLY_BRACKET)) {
            return this.parseMapLiteral(token, typeArgumentList);
        }
        if (this.matches(TokenType.OPEN_SQUARE_BRACKET) || this.matches(TokenType.INDEX)) {
            return this.parseListLiteral(token, typeArgumentList);
        }
        this.reportErrorForCurrentToken(ParserErrorCode.EXPECTED_LIST_OR_MAP_LITERAL, new Object[0]);
        return new ListLiteral(token, typeArgumentList, this.createSyntheticToken(TokenType.OPEN_SQUARE_BRACKET), null, this.createSyntheticToken(TokenType.CLOSE_SQUARE_BRACKET));
    }

    private Expression parseLogicalAndExpression() {
        Expression expression = this.parseEqualityExpression();
        while (this.matches(TokenType.AMPERSAND_AMPERSAND)) {
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseEqualityExpression());
        }
        return expression;
    }

    private MapLiteral parseMapLiteral(Token token, TypeArgumentList typeArgumentList) {
        Token token2 = this.expect(TokenType.OPEN_CURLY_BRACKET);
        ArrayList<MapLiteralEntry> arrayList = new ArrayList<MapLiteralEntry>();
        if (this.matches(TokenType.CLOSE_CURLY_BRACKET)) {
            return new MapLiteral(token, typeArgumentList, token2, arrayList, this.getAndAdvance());
        }
        arrayList.add(this.parseMapLiteralEntry());
        while (this.optional(TokenType.COMMA)) {
            if (this.matches(TokenType.CLOSE_CURLY_BRACKET)) {
                return new MapLiteral(token, typeArgumentList, token2, arrayList, this.getAndAdvance());
            }
            arrayList.add(this.parseMapLiteralEntry());
        }
        Token token3 = this.expect(TokenType.CLOSE_CURLY_BRACKET);
        return new MapLiteral(token, typeArgumentList, token2, arrayList, token3);
    }

    private MethodDeclaration parseMethodDeclarationAfterParameters(CommentAndMetadata commentAndMetadata, Token token, Token token2, TypeName typeName, SimpleIdentifier simpleIdentifier, FormalParameterList formalParameterList) {
        FunctionBody functionBody = this.parseFunctionBody(token != null || token2 == null, ParserErrorCode.MISSING_FUNCTION_BODY, false);
        if (token != null) {
            if (!(functionBody instanceof EmptyFunctionBody)) {
                this.reportErrorForNode(ParserErrorCode.EXTERNAL_METHOD_WITH_BODY, functionBody, new Object[0]);
            }
        } else if (token2 != null && functionBody instanceof EmptyFunctionBody) {
            this.reportErrorForNode(ParserErrorCode.ABSTRACT_STATIC_METHOD, functionBody, new Object[0]);
        }
        return new MethodDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, token2, typeName, null, null, simpleIdentifier, formalParameterList, functionBody);
    }

    private MethodDeclaration parseMethodDeclarationAfterReturnType(CommentAndMetadata commentAndMetadata, Token token, Token token2, TypeName typeName) {
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        FormalParameterList formalParameterList = this.parseFormalParameterList();
        this.validateFormalParameterList(formalParameterList);
        return this.parseMethodDeclarationAfterParameters(commentAndMetadata, token, token2, typeName, simpleIdentifier, formalParameterList);
    }

    private Modifiers parseModifiers() {
        Modifiers modifiers = new Modifiers();
        boolean bl = true;
        while (bl) {
            if (this.tokenMatches(this.peek(), TokenType.PERIOD) || this.tokenMatches(this.peek(), TokenType.LT) || this.tokenMatches(this.peek(), TokenType.OPEN_PAREN)) {
                return modifiers;
            }
            if (this.matchesKeyword(Keyword.ABSTRACT)) {
                if (modifiers.getAbstractKeyword() != null) {
                    this.reportErrorForCurrentToken(ParserErrorCode.DUPLICATED_MODIFIER, this.currentToken.getLexeme());
                    this.advance();
                    continue;
                }
                modifiers.setAbstractKeyword(this.getAndAdvance());
                continue;
            }
            if (this.matchesKeyword(Keyword.CONST)) {
                if (modifiers.getConstKeyword() != null) {
                    this.reportErrorForCurrentToken(ParserErrorCode.DUPLICATED_MODIFIER, this.currentToken.getLexeme());
                    this.advance();
                    continue;
                }
                modifiers.setConstKeyword(this.getAndAdvance());
                continue;
            }
            if (this.matchesKeyword(Keyword.EXTERNAL) && !this.tokenMatches(this.peek(), TokenType.PERIOD) && !this.tokenMatches(this.peek(), TokenType.LT)) {
                if (modifiers.getExternalKeyword() != null) {
                    this.reportErrorForCurrentToken(ParserErrorCode.DUPLICATED_MODIFIER, this.currentToken.getLexeme());
                    this.advance();
                    continue;
                }
                modifiers.setExternalKeyword(this.getAndAdvance());
                continue;
            }
            if (this.matchesKeyword(Keyword.FACTORY) && !this.tokenMatches(this.peek(), TokenType.PERIOD) && !this.tokenMatches(this.peek(), TokenType.LT)) {
                if (modifiers.getFactoryKeyword() != null) {
                    this.reportErrorForCurrentToken(ParserErrorCode.DUPLICATED_MODIFIER, this.currentToken.getLexeme());
                    this.advance();
                    continue;
                }
                modifiers.setFactoryKeyword(this.getAndAdvance());
                continue;
            }
            if (this.matchesKeyword(Keyword.FINAL)) {
                if (modifiers.getFinalKeyword() != null) {
                    this.reportErrorForCurrentToken(ParserErrorCode.DUPLICATED_MODIFIER, this.currentToken.getLexeme());
                    this.advance();
                    continue;
                }
                modifiers.setFinalKeyword(this.getAndAdvance());
                continue;
            }
            if (this.matchesKeyword(Keyword.STATIC) && !this.tokenMatches(this.peek(), TokenType.PERIOD) && !this.tokenMatches(this.peek(), TokenType.LT)) {
                if (modifiers.getStaticKeyword() != null) {
                    this.reportErrorForCurrentToken(ParserErrorCode.DUPLICATED_MODIFIER, this.currentToken.getLexeme());
                    this.advance();
                    continue;
                }
                modifiers.setStaticKeyword(this.getAndAdvance());
                continue;
            }
            if (this.matchesKeyword(Keyword.VAR)) {
                if (modifiers.getVarKeyword() != null) {
                    this.reportErrorForCurrentToken(ParserErrorCode.DUPLICATED_MODIFIER, this.currentToken.getLexeme());
                    this.advance();
                    continue;
                }
                modifiers.setVarKeyword(this.getAndAdvance());
                continue;
            }
            bl = false;
        }
        return modifiers;
    }

    private Expression parseMultiplicativeExpression() {
        Expression expression = this.matchesKeyword(Keyword.SUPER) && this.currentToken.getNext().getType().isMultiplicativeOperator() ? new SuperExpression(this.getAndAdvance()) : this.parseUnaryExpression();
        while (this.currentToken.getType().isMultiplicativeOperator()) {
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseUnaryExpression());
        }
        return expression;
    }

    private NativeClause parseNativeClause() {
        Token token = this.getAndAdvance();
        StringLiteral stringLiteral = this.parseStringLiteral();
        return new NativeClause(token, stringLiteral);
    }

    private InstanceCreationExpression parseNewExpression() {
        return this.parseInstanceCreationExpression(this.expectKeyword(Keyword.NEW));
    }

    private Statement parseNonLabeledStatement() {
        CommentAndMetadata commentAndMetadata = this.parseCommentAndMetadata();
        if (this.matches(TokenType.OPEN_CURLY_BRACKET)) {
            Token token;
            if (this.tokenMatches(this.peek(), TokenType.STRING) && (token = this.skipStringLiteral(this.currentToken.getNext())) != null && token.getType() == TokenType.COLON) {
                return new ExpressionStatement(this.parseExpression(), this.expect(TokenType.SEMICOLON));
            }
            return this.parseBlock();
        }
        if (this.matches(TokenType.KEYWORD) && !((KeywordToken)this.currentToken).getKeyword().isPseudoKeyword()) {
            Keyword keyword = ((KeywordToken)this.currentToken).getKeyword();
            if (keyword == Keyword.ASSERT) {
                return this.parseAssertStatement();
            }
            if (keyword == Keyword.BREAK) {
                return this.parseBreakStatement();
            }
            if (keyword == Keyword.CONTINUE) {
                return this.parseContinueStatement();
            }
            if (keyword == Keyword.DO) {
                return this.parseDoStatement();
            }
            if (keyword == Keyword.FOR) {
                return this.parseForStatement();
            }
            if (keyword == Keyword.IF) {
                return this.parseIfStatement();
            }
            if (keyword == Keyword.RETHROW) {
                return new ExpressionStatement(this.parseRethrowExpression(), this.expect(TokenType.SEMICOLON));
            }
            if (keyword == Keyword.RETURN) {
                return this.parseReturnStatement();
            }
            if (keyword == Keyword.SWITCH) {
                return this.parseSwitchStatement();
            }
            if (keyword == Keyword.THROW) {
                return new ExpressionStatement(this.parseThrowExpression(), this.expect(TokenType.SEMICOLON));
            }
            if (keyword == Keyword.TRY) {
                return this.parseTryStatement();
            }
            if (keyword == Keyword.WHILE) {
                return this.parseWhileStatement();
            }
            if (keyword == Keyword.VAR || keyword == Keyword.FINAL) {
                return this.parseVariableDeclarationStatementAfterMetadata(commentAndMetadata);
            }
            if (keyword == Keyword.VOID) {
                TypeName typeName = this.parseReturnType();
                if (this.matchesIdentifier() && this.peek().matchesAny(TokenType.OPEN_PAREN, TokenType.OPEN_CURLY_BRACKET, TokenType.FUNCTION)) {
                    return this.parseFunctionDeclarationStatementAfterReturnType(commentAndMetadata, typeName);
                }
                if (this.matchesIdentifier()) {
                    if (this.peek().matchesAny(TokenType.EQ, TokenType.COMMA, TokenType.SEMICOLON)) {
                        this.reportErrorForNode(ParserErrorCode.VOID_VARIABLE, typeName, new Object[0]);
                        return this.parseVariableDeclarationStatementAfterMetadata(commentAndMetadata);
                    }
                } else if (this.matches(TokenType.CLOSE_CURLY_BRACKET)) {
                    return this.parseVariableDeclarationStatementAfterType(commentAndMetadata, null, typeName);
                }
                this.reportErrorForCurrentToken(ParserErrorCode.MISSING_STATEMENT, new Object[0]);
                return new EmptyStatement(this.createSyntheticToken(TokenType.SEMICOLON));
            }
            if (keyword == Keyword.CONST) {
                Token token;
                if (this.peek().matchesAny(TokenType.LT, TokenType.OPEN_CURLY_BRACKET, TokenType.OPEN_SQUARE_BRACKET, TokenType.INDEX)) {
                    return new ExpressionStatement(this.parseExpression(), this.expect(TokenType.SEMICOLON));
                }
                if (this.tokenMatches(this.peek(), TokenType.IDENTIFIER) && (token = this.skipTypeName(this.peek())) != null && (this.tokenMatches(token, TokenType.OPEN_PAREN) || this.tokenMatches(token, TokenType.PERIOD) && this.tokenMatches(token.getNext(), TokenType.IDENTIFIER) && this.tokenMatches(token.getNext().getNext(), TokenType.OPEN_PAREN))) {
                    return new ExpressionStatement(this.parseExpression(), this.expect(TokenType.SEMICOLON));
                }
                return this.parseVariableDeclarationStatementAfterMetadata(commentAndMetadata);
            }
            if (keyword == Keyword.NEW || keyword == Keyword.TRUE || keyword == Keyword.FALSE || keyword == Keyword.NULL || keyword == Keyword.SUPER || keyword == Keyword.THIS) {
                return new ExpressionStatement(this.parseExpression(), this.expect(TokenType.SEMICOLON));
            }
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_STATEMENT, new Object[0]);
            return new EmptyStatement(this.createSyntheticToken(TokenType.SEMICOLON));
        }
        if (this.matches(TokenType.SEMICOLON)) {
            return this.parseEmptyStatement();
        }
        if (this.isInitializedVariableDeclaration()) {
            return this.parseVariableDeclarationStatementAfterMetadata(commentAndMetadata);
        }
        if (this.isFunctionDeclaration()) {
            return this.parseFunctionDeclarationStatement();
        }
        if (this.matches(TokenType.CLOSE_CURLY_BRACKET)) {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_STATEMENT, new Object[0]);
            return new EmptyStatement(this.createSyntheticToken(TokenType.SEMICOLON));
        }
        return new ExpressionStatement(this.parseExpression(), this.expect(TokenType.SEMICOLON));
    }

    private MethodDeclaration parseOperator(CommentAndMetadata commentAndMetadata, Token token, TypeName typeName) {
        Object object;
        Token token2;
        if (this.matchesKeyword(Keyword.OPERATOR)) {
            token2 = this.getAndAdvance();
        } else {
            this.reportErrorForToken(ParserErrorCode.MISSING_KEYWORD_OPERATOR, this.currentToken, new Object[0]);
            token2 = this.createSyntheticKeyword(Keyword.OPERATOR);
        }
        if (!this.currentToken.isUserDefinableOperator()) {
            this.reportErrorForCurrentToken(ParserErrorCode.NON_USER_DEFINABLE_OPERATOR, this.currentToken.getLexeme());
        }
        SimpleIdentifier simpleIdentifier = new SimpleIdentifier(this.getAndAdvance());
        if (this.matches(TokenType.EQ) && (this.tokenMatches((Token)(object = this.currentToken.getPrevious()), TokenType.EQ_EQ) || this.tokenMatches((Token)object, TokenType.BANG_EQ)) && this.currentToken.getOffset() == ((Token)object).getOffset() + 2) {
            this.reportErrorForCurrentToken(ParserErrorCode.INVALID_OPERATOR, ((Token)object).getLexeme() + this.currentToken.getLexeme());
            this.advance();
        }
        object = this.parseFormalParameterList();
        this.validateFormalParameterList((FormalParameterList)object);
        FunctionBody functionBody = this.parseFunctionBody(true, ParserErrorCode.MISSING_FUNCTION_BODY, false);
        if (token != null && !(functionBody instanceof EmptyFunctionBody)) {
            this.reportErrorForCurrentToken(ParserErrorCode.EXTERNAL_OPERATOR_WITH_BODY, new Object[0]);
        }
        return new MethodDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, null, typeName, null, token2, simpleIdentifier, (FormalParameterList)object, functionBody);
    }

    private TypeName parseOptionalReturnType() {
        if (this.matchesKeyword(Keyword.VOID)) {
            return this.parseReturnType();
        }
        if (this.matchesIdentifier() && !this.matchesKeyword(Keyword.GET) && !this.matchesKeyword(Keyword.SET) && !this.matchesKeyword(Keyword.OPERATOR) && (this.tokenMatchesIdentifier(this.peek()) || this.tokenMatches(this.peek(), TokenType.LT))) {
            return this.parseReturnType();
        }
        if (this.matchesIdentifier() && this.tokenMatches(this.peek(), TokenType.PERIOD) && this.tokenMatchesIdentifier(this.peekAt(2)) && (this.tokenMatchesIdentifier(this.peekAt(3)) || this.tokenMatches(this.peekAt(3), TokenType.LT))) {
            return this.parseReturnType();
        }
        return null;
    }

    private Directive parsePartDirective(CommentAndMetadata commentAndMetadata) {
        Token token = this.expectKeyword(Keyword.PART);
        if (this.matchesString(OF)) {
            Token token2 = this.getAndAdvance();
            LibraryIdentifier libraryIdentifier = this.parseLibraryName(ParserErrorCode.MISSING_NAME_IN_PART_OF_DIRECTIVE, token2);
            Token token3 = this.expect(TokenType.SEMICOLON);
            return new PartOfDirective(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, token2, libraryIdentifier, token3);
        }
        StringLiteral stringLiteral = this.parseStringLiteral();
        Token token4 = this.expect(TokenType.SEMICOLON);
        return new PartDirective(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, stringLiteral, token4);
    }

    private Expression parsePostfixExpression() {
        Expression expression = this.parseAssignableExpression(true);
        if (this.matches(TokenType.OPEN_SQUARE_BRACKET) || this.matches(TokenType.PERIOD) || this.matches(TokenType.OPEN_PAREN)) {
            do {
                if (this.matches(TokenType.OPEN_PAREN)) {
                    ArgumentList argumentList = this.parseArgumentList();
                    if (expression instanceof PropertyAccess) {
                        PropertyAccess propertyAccess = (PropertyAccess)expression;
                        expression = new MethodInvocation(propertyAccess.getTarget(), propertyAccess.getOperator(), propertyAccess.getPropertyName(), argumentList);
                        continue;
                    }
                    expression = new FunctionExpressionInvocation(expression, argumentList);
                    continue;
                }
                expression = this.parseAssignableSelector(expression, true);
            } while (this.matches(TokenType.OPEN_SQUARE_BRACKET) || this.matches(TokenType.PERIOD) || this.matches(TokenType.OPEN_PAREN));
            return expression;
        }
        if (!this.currentToken.getType().isIncrementOperator()) {
            return expression;
        }
        this.ensureAssignable(expression);
        Token token = this.getAndAdvance();
        return new PostfixExpression(expression, token);
    }

    private Expression parsePrimaryExpression() {
        if (this.matchesKeyword(Keyword.THIS)) {
            return new ThisExpression(this.getAndAdvance());
        }
        if (this.matchesKeyword(Keyword.SUPER)) {
            return this.parseAssignableSelector(new SuperExpression(this.getAndAdvance()), false);
        }
        if (this.matchesKeyword(Keyword.NULL)) {
            return new NullLiteral(this.getAndAdvance());
        }
        if (this.matchesKeyword(Keyword.FALSE)) {
            return new BooleanLiteral(this.getAndAdvance(), false);
        }
        if (this.matchesKeyword(Keyword.TRUE)) {
            return new BooleanLiteral(this.getAndAdvance(), true);
        }
        if (this.matches(TokenType.DOUBLE)) {
            Token token = this.getAndAdvance();
            double d = 0.0;
            try {
                d = Double.parseDouble(token.getLexeme());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new DoubleLiteral(token, d);
        }
        if (this.matches(TokenType.HEXADECIMAL)) {
            Token token = this.getAndAdvance();
            BigInteger bigInteger = null;
            try {
                bigInteger = new BigInteger(token.getLexeme().substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new IntegerLiteral(token, bigInteger);
        }
        if (this.matches(TokenType.INT)) {
            Token token = this.getAndAdvance();
            BigInteger bigInteger = null;
            try {
                bigInteger = new BigInteger(token.getLexeme());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new IntegerLiteral(token, bigInteger);
        }
        if (this.matches(TokenType.STRING)) {
            return this.parseStringLiteral();
        }
        if (this.matches(TokenType.OPEN_CURLY_BRACKET)) {
            return this.parseMapLiteral(null, null);
        }
        if (this.matches(TokenType.OPEN_SQUARE_BRACKET) || this.matches(TokenType.INDEX)) {
            return this.parseListLiteral(null, null);
        }
        if (this.matchesIdentifier()) {
            return this.parsePrefixedIdentifier();
        }
        if (this.matchesKeyword(Keyword.NEW)) {
            return this.parseNewExpression();
        }
        if (this.matchesKeyword(Keyword.CONST)) {
            return this.parseConstExpression();
        }
        if (this.matches(TokenType.OPEN_PAREN)) {
            if (this.isFunctionExpression(this.currentToken)) {
                return this.parseFunctionExpression();
            }
            Token token = this.getAndAdvance();
            Expression expression = this.parseExpression();
            Token token2 = this.expect(TokenType.CLOSE_PAREN);
            return new ParenthesizedExpression(token, expression, token2);
        }
        if (this.matches(TokenType.LT)) {
            return this.parseListOrMapLiteral(null);
        }
        if (this.matches(TokenType.QUESTION)) {
            return this.parseArgumentDefinitionTest();
        }
        if (this.matchesKeyword(Keyword.VOID)) {
            this.reportErrorForCurrentToken(ParserErrorCode.UNEXPECTED_TOKEN, this.currentToken.getLexeme());
            this.advance();
            return this.parsePrimaryExpression();
        }
        if (this.matches(TokenType.HASH)) {
            return this.parseSymbolLiteral();
        }
        this.reportErrorForCurrentToken(ParserErrorCode.MISSING_IDENTIFIER, new Object[0]);
        return this.createSyntheticIdentifier();
    }

    private RedirectingConstructorInvocation parseRedirectingConstructorInvocation() {
        Token token = this.expectKeyword(Keyword.THIS);
        Token token2 = null;
        SimpleIdentifier simpleIdentifier = null;
        if (this.matches(TokenType.PERIOD)) {
            token2 = this.getAndAdvance();
            simpleIdentifier = this.parseSimpleIdentifier();
        }
        ArgumentList argumentList = this.parseArgumentList();
        return new RedirectingConstructorInvocation(token, token2, simpleIdentifier, argumentList);
    }

    private Expression parseRelationalExpression() {
        if (this.matchesKeyword(Keyword.SUPER) && this.currentToken.getNext().getType().isRelationalOperator()) {
            Expression expression = new SuperExpression(this.getAndAdvance());
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseBitwiseOrExpression());
            return expression;
        }
        Expression expression = this.parseBitwiseOrExpression();
        if (this.matchesKeyword(Keyword.AS)) {
            Token token = this.getAndAdvance();
            expression = new AsExpression(expression, token, this.parseTypeName());
        } else if (this.matchesKeyword(Keyword.IS)) {
            Token token = this.getAndAdvance();
            Token token2 = null;
            if (this.matches(TokenType.BANG)) {
                token2 = this.getAndAdvance();
            }
            expression = new IsExpression(expression, token, token2, this.parseTypeName());
        } else if (this.currentToken.getType().isRelationalOperator()) {
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseBitwiseOrExpression());
        }
        return expression;
    }

    private Expression parseRethrowExpression() {
        return new RethrowExpression(this.expectKeyword(Keyword.RETHROW));
    }

    private Statement parseReturnStatement() {
        Token token = this.expectKeyword(Keyword.RETURN);
        if (this.matches(TokenType.SEMICOLON)) {
            return new ReturnStatement(token, null, this.getAndAdvance());
        }
        Expression expression = this.parseExpression();
        Token token2 = this.expect(TokenType.SEMICOLON);
        return new ReturnStatement(token, expression, token2);
    }

    private MethodDeclaration parseSetter(CommentAndMetadata commentAndMetadata, Token token, Token token2, TypeName typeName) {
        Token token3 = this.expectKeyword(Keyword.SET);
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        FormalParameterList formalParameterList = this.parseFormalParameterList();
        this.validateFormalParameterList(formalParameterList);
        FunctionBody functionBody = this.parseFunctionBody(token != null || token2 == null, ParserErrorCode.STATIC_SETTER_WITHOUT_BODY, false);
        if (token != null && !(functionBody instanceof EmptyFunctionBody)) {
            this.reportErrorForCurrentToken(ParserErrorCode.EXTERNAL_SETTER_WITH_BODY, new Object[0]);
        }
        return new MethodDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), token, token2, typeName, token3, null, simpleIdentifier, formalParameterList, functionBody);
    }

    private Expression parseShiftExpression() {
        Expression expression = this.matchesKeyword(Keyword.SUPER) && this.currentToken.getNext().getType().isShiftOperator() ? new SuperExpression(this.getAndAdvance()) : this.parseAdditiveExpression();
        while (this.currentToken.getType().isShiftOperator()) {
            Token token = this.getAndAdvance();
            expression = new BinaryExpression(expression, token, this.parseAdditiveExpression());
        }
        return expression;
    }

    private List<Statement> parseStatementList() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        Token token = this.currentToken;
        while (!(this.matches(TokenType.EOF) || this.matches(TokenType.CLOSE_CURLY_BRACKET) || this.isSwitchMember())) {
            arrayList.add(this.parseStatement());
            if (this.currentToken == token) {
                this.reportErrorForToken(ParserErrorCode.UNEXPECTED_TOKEN, this.currentToken, this.currentToken.getLexeme());
                this.advance();
            }
            token = this.currentToken;
        }
        return arrayList;
    }

    private StringInterpolation parseStringInterpolation(Token token) {
        ArrayList<InterpolationElement> arrayList = new ArrayList<InterpolationElement>();
        boolean bl = this.matches(TokenType.STRING_INTERPOLATION_EXPRESSION) || this.matches(TokenType.STRING_INTERPOLATION_IDENTIFIER);
        arrayList.add(new InterpolationString(token, this.computeStringValue(token.getLexeme(), true, !bl)));
        while (bl) {
            Expression expression;
            Token token2;
            if (this.matches(TokenType.STRING_INTERPOLATION_EXPRESSION)) {
                token2 = this.getAndAdvance();
                expression = this.parseExpression();
                Token token3 = this.expect(TokenType.CLOSE_CURLY_BRACKET);
                arrayList.add(new InterpolationExpression(token2, expression, token3));
            } else {
                token2 = this.getAndAdvance();
                expression = null;
                expression = this.matchesKeyword(Keyword.THIS) ? new ThisExpression(this.getAndAdvance()) : this.parseSimpleIdentifier();
                arrayList.add(new InterpolationExpression(token2, expression, null));
            }
            if (!this.matches(TokenType.STRING)) continue;
            token = this.getAndAdvance();
            bl = this.matches(TokenType.STRING_INTERPOLATION_EXPRESSION) || this.matches(TokenType.STRING_INTERPOLATION_IDENTIFIER);
            arrayList.add(new InterpolationString(token, this.computeStringValue(token.getLexeme(), false, !bl)));
        }
        return new StringInterpolation(arrayList);
    }

    private SuperConstructorInvocation parseSuperConstructorInvocation() {
        Token token = this.expectKeyword(Keyword.SUPER);
        Token token2 = null;
        SimpleIdentifier simpleIdentifier = null;
        if (this.matches(TokenType.PERIOD)) {
            token2 = this.getAndAdvance();
            simpleIdentifier = this.parseSimpleIdentifier();
        }
        ArgumentList argumentList = this.parseArgumentList();
        return new SuperConstructorInvocation(token, token2, simpleIdentifier, argumentList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwitchStatement parseSwitchStatement() {
        boolean bl = this.inSwitch;
        this.inSwitch = true;
        try {
            Object object;
            Object object2;
            HashSet<Object> hashSet = new HashSet<Object>();
            Token token = this.expectKeyword(Keyword.SWITCH);
            Token token2 = this.expect(TokenType.OPEN_PAREN);
            Expression expression = this.parseExpression();
            Token token3 = this.expect(TokenType.CLOSE_PAREN);
            Token token4 = this.expect(TokenType.OPEN_CURLY_BRACKET);
            Token token5 = null;
            ArrayList<SwitchMember> arrayList = new ArrayList<SwitchMember>();
            while (!this.matches(TokenType.EOF) && !this.matches(TokenType.CLOSE_CURLY_BRACKET)) {
                Token token6;
                Object object3;
                object2 = new ArrayList();
                while (this.matchesIdentifier() && this.tokenMatches(this.peek(), TokenType.COLON)) {
                    object = this.parseSimpleIdentifier();
                    object3 = ((SimpleIdentifier)object).getToken().getLexeme();
                    if (hashSet.contains(object3)) {
                        this.reportErrorForToken(ParserErrorCode.DUPLICATE_LABEL_IN_SWITCH_STATEMENT, ((SimpleIdentifier)object).getToken(), object3);
                    } else {
                        hashSet.add(object3);
                    }
                    token6 = this.expect(TokenType.COLON);
                    object2.add(new Label((SimpleIdentifier)object, token6));
                }
                if (this.matchesKeyword(Keyword.CASE)) {
                    object = this.getAndAdvance();
                    object3 = this.parseExpression();
                    token6 = this.expect(TokenType.COLON);
                    arrayList.add(new SwitchCase((List<Label>)object2, (Token)object, (Expression)object3, token6, this.parseStatementList()));
                    if (token5 == null) continue;
                    this.reportErrorForToken(ParserErrorCode.SWITCH_HAS_CASE_AFTER_DEFAULT_CASE, (Token)object, new Object[0]);
                    continue;
                }
                if (this.matchesKeyword(Keyword.DEFAULT)) {
                    if (token5 != null) {
                        this.reportErrorForToken(ParserErrorCode.SWITCH_HAS_MULTIPLE_DEFAULT_CASES, this.peek(), new Object[0]);
                    }
                    token5 = this.getAndAdvance();
                    object = this.expect(TokenType.COLON);
                    arrayList.add(new SwitchDefault((List<Label>)object2, token5, (Token)object, this.parseStatementList()));
                    continue;
                }
                this.reportErrorForCurrentToken(ParserErrorCode.EXPECTED_CASE_OR_DEFAULT, new Object[0]);
                while (!(this.matches(TokenType.EOF) || this.matches(TokenType.CLOSE_CURLY_BRACKET) || this.matchesKeyword(Keyword.CASE) || this.matchesKeyword(Keyword.DEFAULT))) {
                    this.advance();
                }
            }
            object2 = this.expect(TokenType.CLOSE_CURLY_BRACKET);
            object = new SwitchStatement(token, token2, expression, token3, token4, arrayList, (Token)object2);
            return object;
        }
        finally {
            this.inSwitch = bl;
        }
    }

    private SymbolLiteral parseSymbolLiteral() {
        Token token = this.getAndAdvance();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        if (this.matchesIdentifier()) {
            arrayList.add(this.getAndAdvance());
            while (this.matches(TokenType.PERIOD)) {
                this.advance();
                if (this.matchesIdentifier()) {
                    arrayList.add(this.getAndAdvance());
                    continue;
                }
                this.reportErrorForCurrentToken(ParserErrorCode.MISSING_IDENTIFIER, new Object[0]);
                arrayList.add(this.createSyntheticToken(TokenType.IDENTIFIER));
                break;
            }
        } else if (this.currentToken.isOperator()) {
            arrayList.add(this.getAndAdvance());
        } else {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_IDENTIFIER, new Object[0]);
            arrayList.add(this.createSyntheticToken(TokenType.IDENTIFIER));
        }
        return new SymbolLiteral(token, arrayList.toArray(new Token[arrayList.size()]));
    }

    private Expression parseThrowExpression() {
        Token token = this.expectKeyword(Keyword.THROW);
        if (this.matches(TokenType.SEMICOLON) || this.matches(TokenType.CLOSE_PAREN)) {
            this.reportErrorForToken(ParserErrorCode.MISSING_EXPRESSION_IN_THROW, this.currentToken, new Object[0]);
            return new ThrowExpression(token, this.createSyntheticIdentifier());
        }
        Expression expression = this.parseExpression();
        return new ThrowExpression(token, expression);
    }

    private Expression parseThrowExpressionWithoutCascade() {
        Token token = this.expectKeyword(Keyword.THROW);
        if (this.matches(TokenType.SEMICOLON) || this.matches(TokenType.CLOSE_PAREN)) {
            this.reportErrorForToken(ParserErrorCode.MISSING_EXPRESSION_IN_THROW, this.currentToken, new Object[0]);
            return new ThrowExpression(token, this.createSyntheticIdentifier());
        }
        Expression expression = this.parseExpressionWithoutCascade();
        return new ThrowExpression(token, expression);
    }

    private Statement parseTryStatement() {
        Token token;
        Token token2 = this.expectKeyword(Keyword.TRY);
        Block block = this.parseBlock();
        ArrayList<CatchClause> arrayList = new ArrayList<CatchClause>();
        Block block2 = null;
        while (this.matchesString(ON) || this.matchesKeyword(Keyword.CATCH)) {
            token = null;
            TypeName typeName = null;
            if (this.matchesString(ON)) {
                token = this.getAndAdvance();
                typeName = this.parseTypeName();
            }
            Token token3 = null;
            Token token4 = null;
            SimpleIdentifier simpleIdentifier = null;
            Token token5 = null;
            SimpleIdentifier simpleIdentifier2 = null;
            Token token6 = null;
            if (this.matchesKeyword(Keyword.CATCH)) {
                token3 = this.getAndAdvance();
                token4 = this.expect(TokenType.OPEN_PAREN);
                simpleIdentifier = this.parseSimpleIdentifier();
                if (this.matches(TokenType.COMMA)) {
                    token5 = this.getAndAdvance();
                    simpleIdentifier2 = this.parseSimpleIdentifier();
                }
                token6 = this.expect(TokenType.CLOSE_PAREN);
            }
            Block block3 = this.parseBlock();
            arrayList.add(new CatchClause(token, typeName, token3, token4, simpleIdentifier, token5, simpleIdentifier2, token6, block3));
        }
        token = null;
        if (this.matchesKeyword(Keyword.FINALLY)) {
            token = this.getAndAdvance();
            block2 = this.parseBlock();
        } else if (arrayList.isEmpty()) {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_CATCH_OR_FINALLY, new Object[0]);
        }
        return new TryStatement(token2, block, arrayList, token, block2);
    }

    private TypeAlias parseTypeAlias(CommentAndMetadata commentAndMetadata) {
        Token token = this.expectKeyword(Keyword.TYPEDEF);
        if (this.matchesIdentifier()) {
            Token token2 = this.peek();
            if (this.tokenMatches(token2, TokenType.LT)) {
                if ((token2 = this.skipTypeParameterList(token2)) != null && this.tokenMatches(token2, TokenType.EQ)) {
                    ClassTypeAlias classTypeAlias = this.parseClassTypeAlias(commentAndMetadata, null, token);
                    this.reportErrorForToken(ParserErrorCode.DEPRECATED_CLASS_TYPE_ALIAS, token, new Object[0]);
                    return classTypeAlias;
                }
            } else if (this.tokenMatches(token2, TokenType.EQ)) {
                ClassTypeAlias classTypeAlias = this.parseClassTypeAlias(commentAndMetadata, null, token);
                this.reportErrorForToken(ParserErrorCode.DEPRECATED_CLASS_TYPE_ALIAS, token, new Object[0]);
                return classTypeAlias;
            }
        }
        return this.parseFunctionTypeAlias(commentAndMetadata, token);
    }

    private Expression parseUnaryExpression() {
        if (this.matches(TokenType.MINUS) || this.matches(TokenType.BANG) || this.matches(TokenType.TILDE)) {
            Token token = this.getAndAdvance();
            if (this.matchesKeyword(Keyword.SUPER)) {
                if (this.tokenMatches(this.peek(), TokenType.OPEN_SQUARE_BRACKET) || this.tokenMatches(this.peek(), TokenType.PERIOD)) {
                    return new PrefixExpression(token, this.parseUnaryExpression());
                }
                return new PrefixExpression(token, new SuperExpression(this.getAndAdvance()));
            }
            return new PrefixExpression(token, this.parseUnaryExpression());
        }
        if (this.currentToken.getType().isIncrementOperator()) {
            Token token = this.getAndAdvance();
            if (this.matchesKeyword(Keyword.SUPER)) {
                if (this.tokenMatches(this.peek(), TokenType.OPEN_SQUARE_BRACKET) || this.tokenMatches(this.peek(), TokenType.PERIOD)) {
                    return new PrefixExpression(token, this.parseUnaryExpression());
                }
                if (token.getType() == TokenType.MINUS_MINUS) {
                    int n = token.getOffset();
                    Token token2 = new Token(TokenType.MINUS, n);
                    Token token3 = new Token(TokenType.MINUS, n + 1);
                    token3.setNext(this.currentToken);
                    token2.setNext(token3);
                    token.getPrevious().setNext(token2);
                    return new PrefixExpression(token2, new PrefixExpression(token3, new SuperExpression(this.getAndAdvance())));
                }
                this.reportErrorForCurrentToken(ParserErrorCode.INVALID_OPERATOR_FOR_SUPER, token.getLexeme());
                return new PrefixExpression(token, new SuperExpression(this.getAndAdvance()));
            }
            return new PrefixExpression(token, this.parseAssignableExpression(false));
        }
        if (this.matches(TokenType.PLUS)) {
            this.reportErrorForCurrentToken(ParserErrorCode.MISSING_IDENTIFIER, new Object[0]);
            return this.createSyntheticIdentifier();
        }
        return this.parsePostfixExpression();
    }

    private VariableDeclaration parseVariableDeclaration() {
        CommentAndMetadata commentAndMetadata = this.parseCommentAndMetadata();
        SimpleIdentifier simpleIdentifier = this.parseSimpleIdentifier();
        Token token = null;
        Expression expression = null;
        if (this.matches(TokenType.EQ)) {
            token = this.getAndAdvance();
            expression = this.parseExpression();
        }
        return new VariableDeclaration(commentAndMetadata.getComment(), commentAndMetadata.getMetadata(), simpleIdentifier, token, expression);
    }

    private VariableDeclarationList parseVariableDeclarationListAfterMetadata(CommentAndMetadata commentAndMetadata) {
        FinalConstVarOrType finalConstVarOrType = this.parseFinalConstVarOrType(false);
        return this.parseVariableDeclarationListAfterType(commentAndMetadata, finalConstVarOrType.getKeyword(), finalConstVarOrType.getType());
    }

    private VariableDeclarationList parseVariableDeclarationListAfterType(CommentAndMetadata commentAndMetadata, Token token, TypeName typeName) {
        if (typeName != null && token != null && this.tokenMatchesKeyword(token, Keyword.VAR)) {
            this.reportErrorForToken(ParserErrorCode.VAR_AND_TYPE, token, new Object[0]);
        }
        ArrayList<VariableDeclaration> arrayList = new ArrayList<VariableDeclaration>();
        arrayList.add(this.parseVariableDeclaration());
        while (this.matches(TokenType.COMMA)) {
            this.advance();
            arrayList.add(this.parseVariableDeclaration());
        }
        return new VariableDeclarationList(commentAndMetadata != null ? commentAndMetadata.getComment() : null, commentAndMetadata != null ? commentAndMetadata.getMetadata() : null, token, typeName, arrayList);
    }

    private VariableDeclarationStatement parseVariableDeclarationStatementAfterMetadata(CommentAndMetadata commentAndMetadata) {
        VariableDeclarationList variableDeclarationList = this.parseVariableDeclarationListAfterMetadata(commentAndMetadata);
        Token token = this.expect(TokenType.SEMICOLON);
        return new VariableDeclarationStatement(variableDeclarationList, token);
    }

    private VariableDeclarationStatement parseVariableDeclarationStatementAfterType(CommentAndMetadata commentAndMetadata, Token token, TypeName typeName) {
        VariableDeclarationList variableDeclarationList = this.parseVariableDeclarationListAfterType(commentAndMetadata, token, typeName);
        Token token2 = this.expect(TokenType.SEMICOLON);
        return new VariableDeclarationStatement(variableDeclarationList, token2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseWhileStatement() {
        boolean bl = this.inLoop;
        this.inLoop = true;
        try {
            Token token = this.expectKeyword(Keyword.WHILE);
            Token token2 = this.expect(TokenType.OPEN_PAREN);
            Expression expression = this.parseExpression();
            Token token3 = this.expect(TokenType.CLOSE_PAREN);
            Statement statement = this.parseStatement();
            WhileStatement whileStatement = new WhileStatement(token, token2, expression, token3, statement);
            return whileStatement;
        }
        finally {
            this.inLoop = bl;
        }
    }

    private Token peek() {
        return this.currentToken.getNext();
    }

    private Token peekAt(int n) {
        Token token = this.currentToken;
        for (int i = 0; i < n; ++i) {
            token = token.getNext();
        }
        return token;
    }

    private void reportError(AnalysisError analysisError) {
        if (this.errorListenerLock != 0) {
            return;
        }
        this.errorListener.onError(analysisError);
    }

    private void reportErrorForCurrentToken(ParserErrorCode parserErrorCode, Object ... objectArray) {
        this.reportErrorForToken(parserErrorCode, this.currentToken, objectArray);
    }

    private void reportErrorForNode(ParserErrorCode parserErrorCode, AstNode astNode, Object ... objectArray) {
        this.reportError(new AnalysisError(this.source, astNode.getOffset(), astNode.getLength(), parserErrorCode, objectArray));
    }

    private void reportErrorForToken(ParserErrorCode parserErrorCode, Token token, Object ... objectArray) {
        this.reportError(new AnalysisError(this.source, token.getOffset(), token.getLength(), parserErrorCode, objectArray));
    }

    private void skipBlock() {
        this.currentToken = ((BeginToken)this.currentToken).getEndToken().getNext();
    }

    private Token skipFinalConstVarOrType(Token token) {
        if (this.tokenMatchesKeyword(token, Keyword.FINAL) || this.tokenMatchesKeyword(token, Keyword.CONST)) {
            Token token2 = token.getNext();
            if (this.tokenMatchesIdentifier(token2)) {
                Token token3 = token2.getNext();
                if (this.tokenMatchesIdentifier(token3) || this.tokenMatches(token3, TokenType.LT) || this.tokenMatches(token3, TokenType.PERIOD)) {
                    return this.skipTypeName(token2);
                }
                return token2;
            }
        } else {
            Token token4;
            if (this.tokenMatchesKeyword(token, Keyword.VAR)) {
                return token.getNext();
            }
            if (this.tokenMatchesIdentifier(token) && (this.tokenMatchesIdentifier(token4 = token.getNext()) || this.tokenMatches(token4, TokenType.LT) || this.tokenMatchesKeyword(token4, Keyword.THIS) || this.tokenMatches(token4, TokenType.PERIOD) && this.tokenMatchesIdentifier(token4.getNext()) && (this.tokenMatchesIdentifier(token4.getNext().getNext()) || this.tokenMatches(token4.getNext().getNext(), TokenType.LT) || this.tokenMatchesKeyword(token4.getNext().getNext(), Keyword.THIS)))) {
                return this.skipReturnType(token);
            }
        }
        return null;
    }

    private Token skipFormalParameterList(Token token) {
        Token token2;
        if (!this.tokenMatches(token, TokenType.OPEN_PAREN)) {
            return null;
        }
        Token token3 = token.getNext();
        if (this.tokenMatches(token3, TokenType.CLOSE_PAREN)) {
            return token3.getNext();
        }
        if (token3.matchesAny(TokenType.AT, TokenType.OPEN_SQUARE_BRACKET, TokenType.OPEN_CURLY_BRACKET) || this.tokenMatchesKeyword(token3, Keyword.VOID) || this.tokenMatchesIdentifier(token3) && token3.getNext().matchesAny(TokenType.COMMA, TokenType.CLOSE_PAREN)) {
            return this.skipPastMatchingToken(token);
        }
        if (this.tokenMatchesIdentifier(token3) && this.tokenMatches(token3.getNext(), TokenType.OPEN_PAREN) && (token2 = this.skipFormalParameterList(token3.getNext())) != null && token2.matchesAny(TokenType.COMMA, TokenType.CLOSE_PAREN)) {
            return this.skipPastMatchingToken(token);
        }
        token2 = this.skipFinalConstVarOrType(token3);
        if (token2 == null) {
            return null;
        }
        if (this.skipSimpleIdentifier(token2) == null) {
            return null;
        }
        return this.skipPastMatchingToken(token);
    }

    private Token skipPastMatchingToken(Token token) {
        if (!(token instanceof BeginToken)) {
            return null;
        }
        Token token2 = ((BeginToken)token).getEndToken();
        if (token2 == null) {
            return null;
        }
        return token2.getNext();
    }

    private Token skipPrefixedIdentifier(Token token) {
        Token token2 = this.skipSimpleIdentifier(token);
        if (token2 == null) {
            return null;
        }
        if (!this.tokenMatches(token2, TokenType.PERIOD)) {
            return token2;
        }
        return this.skipSimpleIdentifier(token2.getNext());
    }

    private Token skipReturnType(Token token) {
        if (this.tokenMatchesKeyword(token, Keyword.VOID)) {
            return token.getNext();
        }
        return this.skipTypeName(token);
    }

    private Token skipSimpleIdentifier(Token token) {
        if (this.tokenMatches(token, TokenType.IDENTIFIER) || this.tokenMatches(token, TokenType.KEYWORD) && ((KeywordToken)token).getKeyword().isPseudoKeyword()) {
            return token.getNext();
        }
        return null;
    }

    private Token skipStringInterpolation(Token token) {
        Token token2 = token;
        TokenType tokenType = token2.getType();
        while (tokenType == TokenType.STRING_INTERPOLATION_EXPRESSION || tokenType == TokenType.STRING_INTERPOLATION_IDENTIFIER) {
            if (tokenType == TokenType.STRING_INTERPOLATION_EXPRESSION) {
                token2 = token2.getNext();
                tokenType = token2.getType();
                int n = 1;
                while (n > 0) {
                    if (tokenType == TokenType.EOF) {
                        return null;
                    }
                    if (tokenType == TokenType.OPEN_CURLY_BRACKET) {
                        ++n;
                    } else if (tokenType == TokenType.CLOSE_CURLY_BRACKET) {
                        --n;
                    } else if (tokenType == TokenType.STRING) {
                        if ((token2 = this.skipStringLiteral(token2)) == null) {
                            return null;
                        }
                    } else {
                        token2 = token2.getNext();
                    }
                    tokenType = token2.getType();
                }
                token2 = token2.getNext();
                tokenType = token2.getType();
            } else {
                if ((token2 = token2.getNext()).getType() != TokenType.IDENTIFIER) {
                    return null;
                }
                token2 = token2.getNext();
            }
            if ((tokenType = token2.getType()) != TokenType.STRING) continue;
            token2 = token2.getNext();
            tokenType = token2.getType();
        }
        return token2;
    }

    private Token skipStringLiteral(Token token) {
        Token token2 = token;
        while (token2 != null && this.tokenMatches(token2, TokenType.STRING)) {
            TokenType tokenType = (token2 = token2.getNext()).getType();
            if (tokenType != TokenType.STRING_INTERPOLATION_EXPRESSION && tokenType != TokenType.STRING_INTERPOLATION_IDENTIFIER) continue;
            token2 = this.skipStringInterpolation(token2);
        }
        if (token2 == token) {
            return null;
        }
        return token2;
    }

    private Token skipTypeArgumentList(Token token) {
        Token token2 = token;
        if (!this.tokenMatches(token2, TokenType.LT)) {
            return null;
        }
        if ((token2 = this.skipTypeName(token2.getNext())) == null) {
            return null;
        }
        while (this.tokenMatches(token2, TokenType.COMMA)) {
            if ((token2 = this.skipTypeName(token2.getNext())) != null) continue;
            return null;
        }
        if (token2.getType() == TokenType.GT) {
            return token2.getNext();
        }
        if (token2.getType() == TokenType.GT_GT) {
            Token token3 = new Token(TokenType.GT, token2.getOffset() + 1);
            token3.setNextWithoutSettingPrevious(token2.getNext());
            return token3;
        }
        return null;
    }

    private Token skipTypeName(Token token) {
        Token token2 = this.skipPrefixedIdentifier(token);
        if (token2 == null) {
            return null;
        }
        if (this.tokenMatches(token2, TokenType.LT)) {
            token2 = this.skipTypeArgumentList(token2);
        }
        return token2;
    }

    private Token skipTypeParameterList(Token token) {
        if (!this.tokenMatches(token, TokenType.LT)) {
            return null;
        }
        int n = 1;
        Token token2 = token.getNext();
        while (n > 0) {
            if (this.tokenMatches(token2, TokenType.EOF)) {
                return null;
            }
            if (this.tokenMatches(token2, TokenType.LT)) {
                ++n;
            } else if (this.tokenMatches(token2, TokenType.GT)) {
                --n;
            } else if (this.tokenMatches(token2, TokenType.GT_EQ)) {
                if (n == 1) {
                    Token token3 = new Token(TokenType.EQ, token2.getOffset() + 2);
                    token3.setNextWithoutSettingPrevious(token2.getNext());
                    return token3;
                }
                --n;
            } else if (this.tokenMatches(token2, TokenType.GT_GT)) {
                n -= 2;
            } else if (this.tokenMatches(token2, TokenType.GT_GT_EQ)) {
                if (n < 2) {
                    return null;
                }
                if (n == 2) {
                    Token token4 = new Token(TokenType.EQ, token2.getOffset() + 2);
                    token4.setNextWithoutSettingPrevious(token2.getNext());
                    return token4;
                }
                n -= 2;
            }
            token2 = token2.getNext();
        }
        return token2;
    }

    private boolean tokenMatches(Token token, TokenType tokenType) {
        return token.getType() == tokenType;
    }

    private boolean tokenMatchesIdentifier(Token token) {
        return this.tokenMatches(token, TokenType.IDENTIFIER) || this.tokenMatches(token, TokenType.KEYWORD) && ((KeywordToken)token).getKeyword().isPseudoKeyword();
    }

    private boolean tokenMatchesKeyword(Token token, Keyword keyword) {
        return token.getType() == TokenType.KEYWORD && ((KeywordToken)token).getKeyword() == keyword;
    }

    private int translateCharacter(StringBuilder stringBuilder, String string, int n) {
        char c = string.charAt(n);
        if (c != '\\') {
            stringBuilder.append(c);
            return n + 1;
        }
        int n2 = n + 1;
        int n3 = string.length();
        if (n2 >= n3) {
            return n3;
        }
        c = string.charAt(n2);
        if (c == 'n') {
            stringBuilder.append('\n');
        } else if (c == 'r') {
            stringBuilder.append('\r');
        } else if (c == 'f') {
            stringBuilder.append('\f');
        } else if (c == 'b') {
            stringBuilder.append('\b');
        } else if (c == 't') {
            stringBuilder.append('\t');
        } else if (c == 'v') {
            stringBuilder.append('\u000b');
        } else {
            if (c == 'x') {
                if (n2 + 2 >= n3) {
                    this.reportErrorForCurrentToken(ParserErrorCode.INVALID_HEX_ESCAPE, new Object[0]);
                    return n3;
                }
                char c2 = string.charAt(n2 + 1);
                char c3 = string.charAt(n2 + 2);
                if (!this.isHexDigit(c2) || !this.isHexDigit(c3)) {
                    this.reportErrorForCurrentToken(ParserErrorCode.INVALID_HEX_ESCAPE, new Object[0]);
                } else {
                    stringBuilder.append((char)((Character.digit(c2, 16) << 4) + Character.digit(c3, 16)));
                }
                return n2 + 3;
            }
            if (c == 'u') {
                if (++n2 >= n3) {
                    this.reportErrorForCurrentToken(ParserErrorCode.INVALID_UNICODE_ESCAPE, new Object[0]);
                    return n3;
                }
                c = string.charAt(n2);
                if (c == '{') {
                    if (++n2 >= n3) {
                        this.reportErrorForCurrentToken(ParserErrorCode.INVALID_UNICODE_ESCAPE, new Object[0]);
                        return n3;
                    }
                    c = string.charAt(n2);
                    int n4 = 0;
                    int n5 = 0;
                    while (c != '}') {
                        if (!this.isHexDigit(c)) {
                            this.reportErrorForCurrentToken(ParserErrorCode.INVALID_UNICODE_ESCAPE, new Object[0]);
                            ++n2;
                            while (n2 < n3 && string.charAt(n2) != '}') {
                                ++n2;
                            }
                            return n2 + 1;
                        }
                        ++n4;
                        n5 = (n5 << 4) + Character.digit(c, 16);
                        if (++n2 >= n3) {
                            this.reportErrorForCurrentToken(ParserErrorCode.INVALID_UNICODE_ESCAPE, new Object[0]);
                            return n3;
                        }
                        c = string.charAt(n2);
                    }
                    if (n4 < 1 || n4 > 6) {
                        this.reportErrorForCurrentToken(ParserErrorCode.INVALID_UNICODE_ESCAPE, new Object[0]);
                    }
                    this.appendScalarValue(stringBuilder, string.substring(n, n2 + 1), n5, n, n2);
                    return n2 + 1;
                }
                if (n2 + 3 >= n3) {
                    this.reportErrorForCurrentToken(ParserErrorCode.INVALID_UNICODE_ESCAPE, new Object[0]);
                    return n3;
                }
                char c4 = c;
                char c5 = string.charAt(n2 + 1);
                char c6 = string.charAt(n2 + 2);
                char c7 = string.charAt(n2 + 3);
                if (!(this.isHexDigit(c4) && this.isHexDigit(c5) && this.isHexDigit(c6) && this.isHexDigit(c7))) {
                    this.reportErrorForCurrentToken(ParserErrorCode.INVALID_UNICODE_ESCAPE, new Object[0]);
                } else {
                    this.appendScalarValue(stringBuilder, string.substring(n, n2 + 1), (((Character.digit(c4, 16) << 4) + Character.digit(c5, 16) << 4) + Character.digit(c6, 16) << 4) + Character.digit(c7, 16), n, n2 + 3);
                }
                return n2 + 4;
            }
            stringBuilder.append(c);
        }
        return n2 + 1;
    }

    private void unlockErrorListener() {
        if (this.errorListenerLock == 0) {
            throw new IllegalStateException("Attempt to unlock not locked error listener.");
        }
        --this.errorListenerLock;
    }

    private void validateFormalParameterList(FormalParameterList formalParameterList) {
        for (FormalParameter formalParameter : formalParameterList.getParameters()) {
            if (!(formalParameter instanceof FieldFormalParameter)) continue;
            this.reportErrorForNode(ParserErrorCode.FIELD_INITIALIZER_OUTSIDE_CONSTRUCTOR, ((FieldFormalParameter)formalParameter).getIdentifier(), new Object[0]);
        }
    }

    private Token validateModifiersForClass(Modifiers modifiers) {
        this.validateModifiersForTopLevelDeclaration(modifiers);
        if (modifiers.getConstKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.CONST_CLASS, modifiers.getConstKeyword(), new Object[0]);
        }
        if (modifiers.getExternalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.EXTERNAL_CLASS, modifiers.getExternalKeyword(), new Object[0]);
        }
        if (modifiers.getFinalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.FINAL_CLASS, modifiers.getFinalKeyword(), new Object[0]);
        }
        if (modifiers.getVarKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.VAR_CLASS, modifiers.getVarKeyword(), new Object[0]);
        }
        return modifiers.getAbstractKeyword();
    }

    private Token validateModifiersForConstructor(Modifiers modifiers) {
        if (modifiers.getAbstractKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.ABSTRACT_CLASS_MEMBER, modifiers.getAbstractKeyword(), new Object[0]);
        }
        if (modifiers.getFinalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.FINAL_CONSTRUCTOR, modifiers.getFinalKeyword(), new Object[0]);
        }
        if (modifiers.getStaticKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.STATIC_CONSTRUCTOR, modifiers.getStaticKeyword(), new Object[0]);
        }
        if (modifiers.getVarKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.CONSTRUCTOR_WITH_RETURN_TYPE, modifiers.getVarKeyword(), new Object[0]);
        }
        Token token = modifiers.getExternalKeyword();
        Token token2 = modifiers.getConstKeyword();
        Token token3 = modifiers.getFactoryKeyword();
        if (token != null && token2 != null && token2.getOffset() < token.getOffset()) {
            this.reportErrorForToken(ParserErrorCode.EXTERNAL_AFTER_CONST, token, new Object[0]);
        }
        if (token != null && token3 != null && token3.getOffset() < token.getOffset()) {
            this.reportErrorForToken(ParserErrorCode.EXTERNAL_AFTER_FACTORY, token, new Object[0]);
        }
        return token2;
    }

    private Token validateModifiersForField(Modifiers modifiers) {
        if (modifiers.getAbstractKeyword() != null) {
            this.reportErrorForCurrentToken(ParserErrorCode.ABSTRACT_CLASS_MEMBER, new Object[0]);
        }
        if (modifiers.getExternalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.EXTERNAL_FIELD, modifiers.getExternalKeyword(), new Object[0]);
        }
        if (modifiers.getFactoryKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.NON_CONSTRUCTOR_FACTORY, modifiers.getFactoryKeyword(), new Object[0]);
        }
        Token token = modifiers.getStaticKeyword();
        Token token2 = modifiers.getConstKeyword();
        Token token3 = modifiers.getFinalKeyword();
        Token token4 = modifiers.getVarKeyword();
        if (token2 != null) {
            if (token3 != null) {
                this.reportErrorForToken(ParserErrorCode.CONST_AND_FINAL, token3, new Object[0]);
            }
            if (token4 != null) {
                this.reportErrorForToken(ParserErrorCode.CONST_AND_VAR, token4, new Object[0]);
            }
            if (token != null && token2.getOffset() < token.getOffset()) {
                this.reportErrorForToken(ParserErrorCode.STATIC_AFTER_CONST, token, new Object[0]);
            }
        } else if (token3 != null) {
            if (token4 != null) {
                this.reportErrorForToken(ParserErrorCode.FINAL_AND_VAR, token4, new Object[0]);
            }
            if (token != null && token3.getOffset() < token.getOffset()) {
                this.reportErrorForToken(ParserErrorCode.STATIC_AFTER_FINAL, token, new Object[0]);
            }
        } else if (token4 != null && token != null && token4.getOffset() < token.getOffset()) {
            this.reportErrorForToken(ParserErrorCode.STATIC_AFTER_VAR, token, new Object[0]);
        }
        return this.lexicallyFirst(token2, token3, token4);
    }

    private void validateModifiersForFunctionDeclarationStatement(Modifiers modifiers) {
        if (modifiers.getAbstractKeyword() != null || modifiers.getConstKeyword() != null || modifiers.getExternalKeyword() != null || modifiers.getFactoryKeyword() != null || modifiers.getFinalKeyword() != null || modifiers.getStaticKeyword() != null || modifiers.getVarKeyword() != null) {
            this.reportErrorForCurrentToken(ParserErrorCode.LOCAL_FUNCTION_DECLARATION_MODIFIER, new Object[0]);
        }
    }

    private void validateModifiersForGetterOrSetterOrMethod(Modifiers modifiers) {
        if (modifiers.getAbstractKeyword() != null) {
            this.reportErrorForCurrentToken(ParserErrorCode.ABSTRACT_CLASS_MEMBER, new Object[0]);
        }
        if (modifiers.getConstKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.CONST_METHOD, modifiers.getConstKeyword(), new Object[0]);
        }
        if (modifiers.getFactoryKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.NON_CONSTRUCTOR_FACTORY, modifiers.getFactoryKeyword(), new Object[0]);
        }
        if (modifiers.getFinalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.FINAL_METHOD, modifiers.getFinalKeyword(), new Object[0]);
        }
        if (modifiers.getVarKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.VAR_RETURN_TYPE, modifiers.getVarKeyword(), new Object[0]);
        }
        Token token = modifiers.getExternalKeyword();
        Token token2 = modifiers.getStaticKeyword();
        if (token != null && token2 != null && token2.getOffset() < token.getOffset()) {
            this.reportErrorForToken(ParserErrorCode.EXTERNAL_AFTER_STATIC, token, new Object[0]);
        }
    }

    private void validateModifiersForOperator(Modifiers modifiers) {
        if (modifiers.getAbstractKeyword() != null) {
            this.reportErrorForCurrentToken(ParserErrorCode.ABSTRACT_CLASS_MEMBER, new Object[0]);
        }
        if (modifiers.getConstKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.CONST_METHOD, modifiers.getConstKeyword(), new Object[0]);
        }
        if (modifiers.getFactoryKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.NON_CONSTRUCTOR_FACTORY, modifiers.getFactoryKeyword(), new Object[0]);
        }
        if (modifiers.getFinalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.FINAL_METHOD, modifiers.getFinalKeyword(), new Object[0]);
        }
        if (modifiers.getStaticKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.STATIC_OPERATOR, modifiers.getStaticKeyword(), new Object[0]);
        }
        if (modifiers.getVarKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.VAR_RETURN_TYPE, modifiers.getVarKeyword(), new Object[0]);
        }
    }

    private void validateModifiersForTopLevelDeclaration(Modifiers modifiers) {
        if (modifiers.getFactoryKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.FACTORY_TOP_LEVEL_DECLARATION, modifiers.getFactoryKeyword(), new Object[0]);
        }
        if (modifiers.getStaticKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.STATIC_TOP_LEVEL_DECLARATION, modifiers.getStaticKeyword(), new Object[0]);
        }
    }

    private void validateModifiersForTopLevelFunction(Modifiers modifiers) {
        this.validateModifiersForTopLevelDeclaration(modifiers);
        if (modifiers.getAbstractKeyword() != null) {
            this.reportErrorForCurrentToken(ParserErrorCode.ABSTRACT_TOP_LEVEL_FUNCTION, new Object[0]);
        }
        if (modifiers.getConstKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.CONST_CLASS, modifiers.getConstKeyword(), new Object[0]);
        }
        if (modifiers.getFinalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.FINAL_CLASS, modifiers.getFinalKeyword(), new Object[0]);
        }
        if (modifiers.getVarKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.VAR_RETURN_TYPE, modifiers.getVarKeyword(), new Object[0]);
        }
    }

    private Token validateModifiersForTopLevelVariable(Modifiers modifiers) {
        this.validateModifiersForTopLevelDeclaration(modifiers);
        if (modifiers.getAbstractKeyword() != null) {
            this.reportErrorForCurrentToken(ParserErrorCode.ABSTRACT_TOP_LEVEL_VARIABLE, new Object[0]);
        }
        if (modifiers.getExternalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.EXTERNAL_FIELD, modifiers.getExternalKeyword(), new Object[0]);
        }
        Token token = modifiers.getConstKeyword();
        Token token2 = modifiers.getFinalKeyword();
        Token token3 = modifiers.getVarKeyword();
        if (token != null) {
            if (token2 != null) {
                this.reportErrorForToken(ParserErrorCode.CONST_AND_FINAL, token2, new Object[0]);
            }
            if (token3 != null) {
                this.reportErrorForToken(ParserErrorCode.CONST_AND_VAR, token3, new Object[0]);
            }
        } else if (token2 != null && token3 != null) {
            this.reportErrorForToken(ParserErrorCode.FINAL_AND_VAR, token3, new Object[0]);
        }
        return this.lexicallyFirst(token, token2, token3);
    }

    private void validateModifiersForTypedef(Modifiers modifiers) {
        this.validateModifiersForTopLevelDeclaration(modifiers);
        if (modifiers.getAbstractKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.ABSTRACT_TYPEDEF, modifiers.getAbstractKeyword(), new Object[0]);
        }
        if (modifiers.getConstKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.CONST_TYPEDEF, modifiers.getConstKeyword(), new Object[0]);
        }
        if (modifiers.getExternalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.EXTERNAL_TYPEDEF, modifiers.getExternalKeyword(), new Object[0]);
        }
        if (modifiers.getFinalKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.FINAL_TYPEDEF, modifiers.getFinalKeyword(), new Object[0]);
        }
        if (modifiers.getVarKeyword() != null) {
            this.reportErrorForToken(ParserErrorCode.VAR_TYPEDEF, modifiers.getVarKeyword(), new Object[0]);
        }
    }

    private static class SyntheticKeywordToken
    extends KeywordToken {
        public SyntheticKeywordToken(Keyword keyword, int n) {
            super(keyword, n);
        }

        @Override
        public Token copy() {
            return new SyntheticKeywordToken(this.getKeyword(), this.getOffset());
        }

        @Override
        public int getLength() {
            return 0;
        }
    }
}

