/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.parser;

import com.google.dart.engine.ast.AdjacentStrings;
import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.ArgumentDefinitionTest;
import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AsExpression;
import com.google.dart.engine.ast.AssertStatement;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.BlockFunctionBody;
import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.BreakStatement;
import com.google.dart.engine.ast.CascadeExpression;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.CommentReference;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorFieldInitializer;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.ContinueStatement;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.DefaultFormalParameter;
import com.google.dart.engine.ast.DoStatement;
import com.google.dart.engine.ast.DoubleLiteral;
import com.google.dart.engine.ast.EmptyFunctionBody;
import com.google.dart.engine.ast.EmptyStatement;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.ExpressionFunctionBody;
import com.google.dart.engine.ast.ExpressionStatement;
import com.google.dart.engine.ast.ExtendsClause;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.FieldFormalParameter;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.ForStatement;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionDeclarationStatement;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionExpressionInvocation;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.HideCombinator;
import com.google.dart.engine.ast.IfStatement;
import com.google.dart.engine.ast.ImplementsClause;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.IntegerLiteral;
import com.google.dart.engine.ast.InterpolationExpression;
import com.google.dart.engine.ast.InterpolationString;
import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LabeledStatement;
import com.google.dart.engine.ast.LibraryDirective;
import com.google.dart.engine.ast.LibraryIdentifier;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NativeClause;
import com.google.dart.engine.ast.NativeFunctionBody;
import com.google.dart.engine.ast.NullLiteral;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.ast.PartOfDirective;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.RedirectingConstructorInvocation;
import com.google.dart.engine.ast.RethrowExpression;
import com.google.dart.engine.ast.ReturnStatement;
import com.google.dart.engine.ast.ScriptTag;
import com.google.dart.engine.ast.ShowCombinator;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.SuperExpression;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchDefault;
import com.google.dart.engine.ast.SwitchStatement;
import com.google.dart.engine.ast.SymbolLiteral;
import com.google.dart.engine.ast.ThisExpression;
import com.google.dart.engine.ast.ThrowExpression;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.TryStatement;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.TypeParameterList;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.VariableDeclarationStatement;
import com.google.dart.engine.ast.WhileStatement;
import com.google.dart.engine.ast.WithClause;
import com.google.dart.engine.parser.IncrementalParseException;
import com.google.dart.engine.parser.InsufficientContextException;
import com.google.dart.engine.parser.Parser;

public class IncrementalParseDispatcher
implements AstVisitor<AstNode> {
    private Parser parser;
    private AstNode oldNode;

    public IncrementalParseDispatcher(Parser parser, AstNode astNode) {
        this.parser = parser;
        this.oldNode = astNode;
    }

    @Override
    public AstNode visitAdjacentStrings(AdjacentStrings adjacentStrings) {
        if (adjacentStrings.getStrings().contains(this.oldNode)) {
            return this.parser.parseStringLiteral();
        }
        return this.notAChild(adjacentStrings);
    }

    @Override
    public AstNode visitAnnotation(Annotation annotation) {
        if (this.oldNode == annotation.getName()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == annotation.getConstructorName()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == annotation.getArguments()) {
            return this.parser.parseArgumentList();
        }
        return this.notAChild(annotation);
    }

    @Override
    public AstNode visitArgumentDefinitionTest(ArgumentDefinitionTest argumentDefinitionTest) {
        if (this.oldNode == argumentDefinitionTest.getIdentifier()) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(argumentDefinitionTest);
    }

    @Override
    public AstNode visitArgumentList(ArgumentList argumentList) {
        if (argumentList.getArguments().contains(this.oldNode)) {
            return this.parser.parseArgument();
        }
        return this.notAChild(argumentList);
    }

    @Override
    public AstNode visitAsExpression(AsExpression asExpression) {
        if (this.oldNode == asExpression.getExpression()) {
            return this.parser.parseBitwiseOrExpression();
        }
        if (this.oldNode == asExpression.getType()) {
            return this.parser.parseTypeName();
        }
        return this.notAChild(asExpression);
    }

    @Override
    public AstNode visitAssertStatement(AssertStatement assertStatement) {
        if (this.oldNode == assertStatement.getCondition()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(assertStatement);
    }

    @Override
    public AstNode visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        if (this.oldNode == assignmentExpression.getLeftHandSide()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == assignmentExpression.getRightHandSide()) {
            if (this.isCascadeAllowedInAssignment(assignmentExpression)) {
                return this.parser.parseExpression();
            }
            return this.parser.parseExpressionWithoutCascade();
        }
        return this.notAChild(assignmentExpression);
    }

    @Override
    public AstNode visitBinaryExpression(BinaryExpression binaryExpression) {
        if (this.oldNode == binaryExpression.getLeftOperand()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == binaryExpression.getRightOperand()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(binaryExpression);
    }

    @Override
    public AstNode visitBlock(Block block) {
        if (block.getStatements().contains(this.oldNode)) {
            return this.parser.parseStatement();
        }
        return this.notAChild(block);
    }

    @Override
    public AstNode visitBlockFunctionBody(BlockFunctionBody blockFunctionBody) {
        if (this.oldNode == blockFunctionBody.getBlock()) {
            return this.parser.parseBlock();
        }
        return this.notAChild(blockFunctionBody);
    }

    @Override
    public AstNode visitBooleanLiteral(BooleanLiteral booleanLiteral) {
        return this.notAChild(booleanLiteral);
    }

    @Override
    public AstNode visitBreakStatement(BreakStatement breakStatement) {
        if (this.oldNode == breakStatement.getLabel()) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(breakStatement);
    }

    @Override
    public AstNode visitCascadeExpression(CascadeExpression cascadeExpression) {
        if (this.oldNode == cascadeExpression.getTarget()) {
            return this.parser.parseConditionalExpression();
        }
        if (cascadeExpression.getCascadeSections().contains(this.oldNode)) {
            throw new InsufficientContextException();
        }
        return this.notAChild(cascadeExpression);
    }

    @Override
    public AstNode visitCatchClause(CatchClause catchClause) {
        if (this.oldNode == catchClause.getExceptionType()) {
            return this.parser.parseTypeName();
        }
        if (this.oldNode == catchClause.getExceptionParameter()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == catchClause.getStackTraceParameter()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == catchClause.getBody()) {
            return this.parser.parseBlock();
        }
        return this.notAChild(catchClause);
    }

    @Override
    public AstNode visitClassDeclaration(ClassDeclaration classDeclaration) {
        if (this.oldNode == classDeclaration.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (classDeclaration.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == classDeclaration.getName()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == classDeclaration.getTypeParameters()) {
            return this.parser.parseTypeParameterList();
        }
        if (this.oldNode == classDeclaration.getExtendsClause()) {
            return this.parser.parseExtendsClause();
        }
        if (this.oldNode == classDeclaration.getWithClause()) {
            return this.parser.parseWithClause();
        }
        if (this.oldNode == classDeclaration.getImplementsClause()) {
            return this.parser.parseImplementsClause();
        }
        if (classDeclaration.getMembers().contains(this.oldNode)) {
            ClassMember classMember = this.parser.parseClassMember(classDeclaration.getName().getName());
            if (classMember == null) {
                throw new InsufficientContextException();
            }
            return classMember;
        }
        return this.notAChild(classDeclaration);
    }

    @Override
    public AstNode visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        if (this.oldNode == classTypeAlias.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (classTypeAlias.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == classTypeAlias.getName()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == classTypeAlias.getTypeParameters()) {
            return this.parser.parseTypeParameterList();
        }
        if (this.oldNode == classTypeAlias.getSuperclass()) {
            return this.parser.parseTypeName();
        }
        if (this.oldNode == classTypeAlias.getWithClause()) {
            return this.parser.parseWithClause();
        }
        if (this.oldNode == classTypeAlias.getImplementsClause()) {
            return this.parser.parseImplementsClause();
        }
        return this.notAChild(classTypeAlias);
    }

    @Override
    public AstNode visitComment(Comment comment) {
        throw new InsufficientContextException();
    }

    @Override
    public AstNode visitCommentReference(CommentReference commentReference) {
        if (this.oldNode == commentReference.getIdentifier()) {
            return this.parser.parsePrefixedIdentifier();
        }
        return this.notAChild(commentReference);
    }

    @Override
    public AstNode visitCompilationUnit(CompilationUnit compilationUnit) {
        throw new InsufficientContextException();
    }

    @Override
    public AstNode visitConditionalExpression(ConditionalExpression conditionalExpression) {
        if (this.oldNode == conditionalExpression.getCondition()) {
            return this.parser.parseLogicalOrExpression();
        }
        if (this.oldNode == conditionalExpression.getThenExpression()) {
            return this.parser.parseExpressionWithoutCascade();
        }
        if (this.oldNode == conditionalExpression.getElseExpression()) {
            return this.parser.parseExpressionWithoutCascade();
        }
        return this.notAChild(conditionalExpression);
    }

    @Override
    public AstNode visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        if (this.oldNode == constructorDeclaration.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (constructorDeclaration.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == constructorDeclaration.getReturnType()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == constructorDeclaration.getName()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == constructorDeclaration.getParameters()) {
            return this.parser.parseFormalParameterList();
        }
        if (this.oldNode == constructorDeclaration.getRedirectedConstructor()) {
            throw new InsufficientContextException();
        }
        if (constructorDeclaration.getInitializers().contains(this.oldNode)) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == constructorDeclaration.getBody()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(constructorDeclaration);
    }

    @Override
    public AstNode visitConstructorFieldInitializer(ConstructorFieldInitializer constructorFieldInitializer) {
        if (this.oldNode == constructorFieldInitializer.getFieldName()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == constructorFieldInitializer.getExpression()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(constructorFieldInitializer);
    }

    @Override
    public AstNode visitConstructorName(ConstructorName constructorName) {
        if (this.oldNode == constructorName.getType()) {
            return this.parser.parseTypeName();
        }
        if (this.oldNode == constructorName.getName()) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(constructorName);
    }

    @Override
    public AstNode visitContinueStatement(ContinueStatement continueStatement) {
        if (this.oldNode == continueStatement.getLabel()) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(continueStatement);
    }

    @Override
    public AstNode visitDeclaredIdentifier(DeclaredIdentifier declaredIdentifier) {
        if (this.oldNode == declaredIdentifier.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (declaredIdentifier.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == declaredIdentifier.getType()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == declaredIdentifier.getIdentifier()) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(declaredIdentifier);
    }

    @Override
    public AstNode visitDefaultFormalParameter(DefaultFormalParameter defaultFormalParameter) {
        if (this.oldNode == defaultFormalParameter.getParameter()) {
            return this.parser.parseNormalFormalParameter();
        }
        if (this.oldNode == defaultFormalParameter.getDefaultValue()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(defaultFormalParameter);
    }

    @Override
    public AstNode visitDoStatement(DoStatement doStatement) {
        if (this.oldNode == doStatement.getBody()) {
            return this.parser.parseStatement();
        }
        if (this.oldNode == doStatement.getCondition()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(doStatement);
    }

    @Override
    public AstNode visitDoubleLiteral(DoubleLiteral doubleLiteral) {
        return this.notAChild(doubleLiteral);
    }

    @Override
    public AstNode visitEmptyFunctionBody(EmptyFunctionBody emptyFunctionBody) {
        return this.notAChild(emptyFunctionBody);
    }

    @Override
    public AstNode visitEmptyStatement(EmptyStatement emptyStatement) {
        return this.notAChild(emptyStatement);
    }

    @Override
    public AstNode visitExportDirective(ExportDirective exportDirective) {
        if (this.oldNode == exportDirective.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (exportDirective.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == exportDirective.getUri()) {
            return this.parser.parseStringLiteral();
        }
        if (exportDirective.getCombinators().contains(this.oldNode)) {
            throw new IncrementalParseException();
        }
        return this.notAChild(exportDirective);
    }

    @Override
    public AstNode visitExpressionFunctionBody(ExpressionFunctionBody expressionFunctionBody) {
        if (this.oldNode == expressionFunctionBody.getExpression()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(expressionFunctionBody);
    }

    @Override
    public AstNode visitExpressionStatement(ExpressionStatement expressionStatement) {
        if (this.oldNode == expressionStatement.getExpression()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(expressionStatement);
    }

    @Override
    public AstNode visitExtendsClause(ExtendsClause extendsClause) {
        if (this.oldNode == extendsClause.getSuperclass()) {
            return this.parser.parseTypeName();
        }
        return this.notAChild(extendsClause);
    }

    @Override
    public AstNode visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
        if (this.oldNode == fieldDeclaration.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (fieldDeclaration.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == fieldDeclaration.getFields()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(fieldDeclaration);
    }

    @Override
    public AstNode visitFieldFormalParameter(FieldFormalParameter fieldFormalParameter) {
        if (this.oldNode == fieldFormalParameter.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (fieldFormalParameter.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == fieldFormalParameter.getType()) {
            return this.parser.parseTypeName();
        }
        if (this.oldNode == fieldFormalParameter.getIdentifier()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == fieldFormalParameter.getParameters()) {
            return this.parser.parseFormalParameterList();
        }
        return this.notAChild(fieldFormalParameter);
    }

    @Override
    public AstNode visitForEachStatement(ForEachStatement forEachStatement) {
        if (this.oldNode == forEachStatement.getLoopVariable()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == forEachStatement.getIdentifier()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == forEachStatement.getBody()) {
            return this.parser.parseStatement();
        }
        return this.notAChild(forEachStatement);
    }

    @Override
    public AstNode visitFormalParameterList(FormalParameterList formalParameterList) {
        throw new InsufficientContextException();
    }

    @Override
    public AstNode visitForStatement(ForStatement forStatement) {
        if (this.oldNode == forStatement.getVariables()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == forStatement.getInitialization()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == forStatement.getCondition()) {
            return this.parser.parseExpression();
        }
        if (forStatement.getUpdaters().contains(this.oldNode)) {
            return this.parser.parseExpression();
        }
        if (this.oldNode == forStatement.getBody()) {
            return this.parser.parseStatement();
        }
        return this.notAChild(forStatement);
    }

    @Override
    public AstNode visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        if (this.oldNode == functionDeclaration.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (functionDeclaration.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == functionDeclaration.getReturnType()) {
            return this.parser.parseReturnType();
        }
        if (this.oldNode == functionDeclaration.getName()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == functionDeclaration.getFunctionExpression()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(functionDeclaration);
    }

    @Override
    public AstNode visitFunctionDeclarationStatement(FunctionDeclarationStatement functionDeclarationStatement) {
        if (this.oldNode == functionDeclarationStatement.getFunctionDeclaration()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(functionDeclarationStatement);
    }

    @Override
    public AstNode visitFunctionExpression(FunctionExpression functionExpression) {
        if (this.oldNode == functionExpression.getParameters()) {
            return this.parser.parseFormalParameterList();
        }
        if (this.oldNode == functionExpression.getBody()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(functionExpression);
    }

    @Override
    public AstNode visitFunctionExpressionInvocation(FunctionExpressionInvocation functionExpressionInvocation) {
        if (this.oldNode == functionExpressionInvocation.getFunction()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == functionExpressionInvocation.getArgumentList()) {
            return this.parser.parseArgumentList();
        }
        return this.notAChild(functionExpressionInvocation);
    }

    @Override
    public AstNode visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        if (this.oldNode == functionTypeAlias.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (functionTypeAlias.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == functionTypeAlias.getReturnType()) {
            return this.parser.parseReturnType();
        }
        if (this.oldNode == functionTypeAlias.getName()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == functionTypeAlias.getTypeParameters()) {
            return this.parser.parseTypeParameterList();
        }
        if (this.oldNode == functionTypeAlias.getParameters()) {
            return this.parser.parseFormalParameterList();
        }
        return this.notAChild(functionTypeAlias);
    }

    @Override
    public AstNode visitFunctionTypedFormalParameter(FunctionTypedFormalParameter functionTypedFormalParameter) {
        if (this.oldNode == functionTypedFormalParameter.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (functionTypedFormalParameter.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == functionTypedFormalParameter.getReturnType()) {
            return this.parser.parseReturnType();
        }
        if (this.oldNode == functionTypedFormalParameter.getIdentifier()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == functionTypedFormalParameter.getParameters()) {
            return this.parser.parseFormalParameterList();
        }
        return this.notAChild(functionTypedFormalParameter);
    }

    @Override
    public AstNode visitHideCombinator(HideCombinator hideCombinator) {
        if (hideCombinator.getHiddenNames().contains(this.oldNode)) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(hideCombinator);
    }

    @Override
    public AstNode visitIfStatement(IfStatement ifStatement) {
        if (this.oldNode == ifStatement.getCondition()) {
            return this.parser.parseExpression();
        }
        if (this.oldNode == ifStatement.getThenStatement()) {
            return this.parser.parseStatement();
        }
        if (this.oldNode == ifStatement.getElseStatement()) {
            return this.parser.parseStatement();
        }
        return this.notAChild(ifStatement);
    }

    @Override
    public AstNode visitImplementsClause(ImplementsClause implementsClause) {
        if (implementsClause.getInterfaces().contains(implementsClause)) {
            return this.parser.parseTypeName();
        }
        return this.notAChild(implementsClause);
    }

    @Override
    public AstNode visitImportDirective(ImportDirective importDirective) {
        if (this.oldNode == importDirective.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (importDirective.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == importDirective.getUri()) {
            return this.parser.parseStringLiteral();
        }
        if (this.oldNode == importDirective.getPrefix()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (importDirective.getCombinators().contains(this.oldNode)) {
            throw new IncrementalParseException();
        }
        return this.notAChild(importDirective);
    }

    @Override
    public AstNode visitIndexExpression(IndexExpression indexExpression) {
        if (this.oldNode == indexExpression.getTarget()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == indexExpression.getIndex()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(indexExpression);
    }

    @Override
    public AstNode visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        if (this.oldNode == instanceCreationExpression.getConstructorName()) {
            return this.parser.parseConstructorName();
        }
        if (this.oldNode == instanceCreationExpression.getArgumentList()) {
            return this.parser.parseArgumentList();
        }
        return this.notAChild(instanceCreationExpression);
    }

    @Override
    public AstNode visitIntegerLiteral(IntegerLiteral integerLiteral) {
        return this.notAChild(integerLiteral);
    }

    @Override
    public AstNode visitInterpolationExpression(InterpolationExpression interpolationExpression) {
        if (this.oldNode == interpolationExpression.getExpression()) {
            if (interpolationExpression.getLeftBracket() == null) {
                throw new InsufficientContextException();
            }
            return this.parser.parseExpression();
        }
        return this.notAChild(interpolationExpression);
    }

    @Override
    public AstNode visitInterpolationString(InterpolationString interpolationString) {
        throw new InsufficientContextException();
    }

    @Override
    public AstNode visitIsExpression(IsExpression isExpression) {
        if (this.oldNode == isExpression.getExpression()) {
            return this.parser.parseBitwiseOrExpression();
        }
        if (this.oldNode == isExpression.getType()) {
            return this.parser.parseTypeName();
        }
        return this.notAChild(isExpression);
    }

    @Override
    public AstNode visitLabel(Label label) {
        if (this.oldNode == label.getLabel()) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(label);
    }

    @Override
    public AstNode visitLabeledStatement(LabeledStatement labeledStatement) {
        if (labeledStatement.getLabels().contains(this.oldNode)) {
            return this.parser.parseLabel();
        }
        if (this.oldNode == labeledStatement.getStatement()) {
            return this.parser.parseStatement();
        }
        return this.notAChild(labeledStatement);
    }

    @Override
    public AstNode visitLibraryDirective(LibraryDirective libraryDirective) {
        if (this.oldNode == libraryDirective.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (libraryDirective.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == libraryDirective.getName()) {
            return this.parser.parseLibraryIdentifier();
        }
        return this.notAChild(libraryDirective);
    }

    @Override
    public AstNode visitLibraryIdentifier(LibraryIdentifier libraryIdentifier) {
        if (libraryIdentifier.getComponents().contains(this.oldNode)) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(libraryIdentifier);
    }

    @Override
    public AstNode visitListLiteral(ListLiteral listLiteral) {
        if (this.oldNode == listLiteral.getTypeArguments()) {
            return this.parser.parseTypeArgumentList();
        }
        if (listLiteral.getElements().contains(this.oldNode)) {
            return this.parser.parseExpression();
        }
        return this.notAChild(listLiteral);
    }

    @Override
    public AstNode visitMapLiteral(MapLiteral mapLiteral) {
        if (this.oldNode == mapLiteral.getTypeArguments()) {
            return this.parser.parseTypeArgumentList();
        }
        if (mapLiteral.getEntries().contains(this.oldNode)) {
            return this.parser.parseMapLiteralEntry();
        }
        return this.notAChild(mapLiteral);
    }

    @Override
    public AstNode visitMapLiteralEntry(MapLiteralEntry mapLiteralEntry) {
        if (this.oldNode == mapLiteralEntry.getKey()) {
            return this.parser.parseExpression();
        }
        if (this.oldNode == mapLiteralEntry.getValue()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(mapLiteralEntry);
    }

    @Override
    public AstNode visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        if (this.oldNode == methodDeclaration.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (methodDeclaration.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == methodDeclaration.getReturnType()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == methodDeclaration.getName()) {
            if (methodDeclaration.getOperatorKeyword() != null) {
                throw new InsufficientContextException();
            }
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == methodDeclaration.getBody()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(methodDeclaration);
    }

    @Override
    public AstNode visitMethodInvocation(MethodInvocation methodInvocation) {
        if (this.oldNode == methodInvocation.getTarget()) {
            throw new IncrementalParseException();
        }
        if (this.oldNode == methodInvocation.getMethodName()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == methodInvocation.getArgumentList()) {
            return this.parser.parseArgumentList();
        }
        return this.notAChild(methodInvocation);
    }

    @Override
    public AstNode visitNamedExpression(NamedExpression namedExpression) {
        if (this.oldNode == namedExpression.getName()) {
            return this.parser.parseLabel();
        }
        if (this.oldNode == namedExpression.getExpression()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(namedExpression);
    }

    @Override
    public AstNode visitNativeClause(NativeClause nativeClause) {
        if (this.oldNode == nativeClause.getName()) {
            return this.parser.parseStringLiteral();
        }
        return this.notAChild(nativeClause);
    }

    @Override
    public AstNode visitNativeFunctionBody(NativeFunctionBody nativeFunctionBody) {
        if (this.oldNode == nativeFunctionBody.getStringLiteral()) {
            return this.parser.parseStringLiteral();
        }
        return this.notAChild(nativeFunctionBody);
    }

    @Override
    public AstNode visitNullLiteral(NullLiteral nullLiteral) {
        return this.notAChild(nullLiteral);
    }

    @Override
    public AstNode visitParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
        if (this.oldNode == parenthesizedExpression.getExpression()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(parenthesizedExpression);
    }

    @Override
    public AstNode visitPartDirective(PartDirective partDirective) {
        if (this.oldNode == partDirective.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (partDirective.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == partDirective.getUri()) {
            return this.parser.parseStringLiteral();
        }
        return this.notAChild(partDirective);
    }

    @Override
    public AstNode visitPartOfDirective(PartOfDirective partOfDirective) {
        if (this.oldNode == partOfDirective.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (partOfDirective.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == partOfDirective.getLibraryName()) {
            return this.parser.parseLibraryIdentifier();
        }
        return this.notAChild(partOfDirective);
    }

    @Override
    public AstNode visitPostfixExpression(PostfixExpression postfixExpression) {
        if (this.oldNode == postfixExpression.getOperand()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(postfixExpression);
    }

    @Override
    public AstNode visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        if (this.oldNode == prefixedIdentifier.getPrefix()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == prefixedIdentifier.getIdentifier()) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(prefixedIdentifier);
    }

    @Override
    public AstNode visitPrefixExpression(PrefixExpression prefixExpression) {
        if (this.oldNode == prefixExpression.getOperand()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(prefixExpression);
    }

    @Override
    public AstNode visitPropertyAccess(PropertyAccess propertyAccess) {
        if (this.oldNode == propertyAccess.getTarget()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == propertyAccess.getPropertyName()) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(propertyAccess);
    }

    @Override
    public AstNode visitRedirectingConstructorInvocation(RedirectingConstructorInvocation redirectingConstructorInvocation) {
        if (this.oldNode == redirectingConstructorInvocation.getConstructorName()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == redirectingConstructorInvocation.getArgumentList()) {
            return this.parser.parseArgumentList();
        }
        return this.notAChild(redirectingConstructorInvocation);
    }

    @Override
    public AstNode visitRethrowExpression(RethrowExpression rethrowExpression) {
        return this.notAChild(rethrowExpression);
    }

    @Override
    public AstNode visitReturnStatement(ReturnStatement returnStatement) {
        if (this.oldNode == returnStatement.getExpression()) {
            return this.parser.parseExpression();
        }
        return this.notAChild(returnStatement);
    }

    @Override
    public AstNode visitScriptTag(ScriptTag scriptTag) {
        return this.notAChild(scriptTag);
    }

    @Override
    public AstNode visitShowCombinator(ShowCombinator showCombinator) {
        if (showCombinator.getShownNames().contains(this.oldNode)) {
            return this.parser.parseSimpleIdentifier();
        }
        return this.notAChild(showCombinator);
    }

    @Override
    public AstNode visitSimpleFormalParameter(SimpleFormalParameter simpleFormalParameter) {
        if (this.oldNode == simpleFormalParameter.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (simpleFormalParameter.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == simpleFormalParameter.getType()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == simpleFormalParameter.getIdentifier()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(simpleFormalParameter);
    }

    @Override
    public AstNode visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        return this.notAChild(simpleIdentifier);
    }

    @Override
    public AstNode visitSimpleStringLiteral(SimpleStringLiteral simpleStringLiteral) {
        return this.notAChild(simpleStringLiteral);
    }

    @Override
    public AstNode visitStringInterpolation(StringInterpolation stringInterpolation) {
        if (stringInterpolation.getElements().contains(this.oldNode)) {
            throw new InsufficientContextException();
        }
        return this.notAChild(stringInterpolation);
    }

    @Override
    public AstNode visitSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
        if (this.oldNode == superConstructorInvocation.getConstructorName()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == superConstructorInvocation.getArgumentList()) {
            return this.parser.parseArgumentList();
        }
        return this.notAChild(superConstructorInvocation);
    }

    @Override
    public AstNode visitSuperExpression(SuperExpression superExpression) {
        return this.notAChild(superExpression);
    }

    @Override
    public AstNode visitSwitchCase(SwitchCase switchCase) {
        if (switchCase.getLabels().contains(this.oldNode)) {
            return this.parser.parseLabel();
        }
        if (this.oldNode == switchCase.getExpression()) {
            return this.parser.parseExpression();
        }
        if (switchCase.getStatements().contains(this.oldNode)) {
            return this.parser.parseStatement();
        }
        return this.notAChild(switchCase);
    }

    @Override
    public AstNode visitSwitchDefault(SwitchDefault switchDefault) {
        if (switchDefault.getLabels().contains(this.oldNode)) {
            return this.parser.parseLabel();
        }
        if (switchDefault.getStatements().contains(this.oldNode)) {
            return this.parser.parseStatement();
        }
        return this.notAChild(switchDefault);
    }

    @Override
    public AstNode visitSwitchStatement(SwitchStatement switchStatement) {
        if (this.oldNode == switchStatement.getExpression()) {
            return this.parser.parseExpression();
        }
        if (switchStatement.getMembers().contains(this.oldNode)) {
            throw new InsufficientContextException();
        }
        return this.notAChild(switchStatement);
    }

    @Override
    public AstNode visitSymbolLiteral(SymbolLiteral symbolLiteral) {
        return this.notAChild(symbolLiteral);
    }

    @Override
    public AstNode visitThisExpression(ThisExpression thisExpression) {
        return this.notAChild(thisExpression);
    }

    @Override
    public AstNode visitThrowExpression(ThrowExpression throwExpression) {
        if (this.oldNode == throwExpression.getExpression()) {
            if (this.isCascadeAllowedInThrow(throwExpression)) {
                return this.parser.parseExpression();
            }
            return this.parser.parseExpressionWithoutCascade();
        }
        return this.notAChild(throwExpression);
    }

    @Override
    public AstNode visitTopLevelVariableDeclaration(TopLevelVariableDeclaration topLevelVariableDeclaration) {
        if (this.oldNode == topLevelVariableDeclaration.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (topLevelVariableDeclaration.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == topLevelVariableDeclaration.getVariables()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(topLevelVariableDeclaration);
    }

    @Override
    public AstNode visitTryStatement(TryStatement tryStatement) {
        if (this.oldNode == tryStatement.getBody()) {
            return this.parser.parseBlock();
        }
        if (tryStatement.getCatchClauses().contains(this.oldNode)) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == tryStatement.getFinallyBlock()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(tryStatement);
    }

    @Override
    public AstNode visitTypeArgumentList(TypeArgumentList typeArgumentList) {
        if (typeArgumentList.getArguments().contains(this.oldNode)) {
            return this.parser.parseTypeName();
        }
        return this.notAChild(typeArgumentList);
    }

    @Override
    public AstNode visitTypeName(TypeName typeName) {
        if (this.oldNode == typeName.getName()) {
            return this.parser.parsePrefixedIdentifier();
        }
        if (this.oldNode == typeName.getTypeArguments()) {
            return this.parser.parseTypeArgumentList();
        }
        return this.notAChild(typeName);
    }

    @Override
    public AstNode visitTypeParameter(TypeParameter typeParameter) {
        if (this.oldNode == typeParameter.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (typeParameter.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == typeParameter.getName()) {
            return this.parser.parseSimpleIdentifier();
        }
        if (this.oldNode == typeParameter.getBound()) {
            return this.parser.parseTypeName();
        }
        return this.notAChild(typeParameter);
    }

    @Override
    public AstNode visitTypeParameterList(TypeParameterList typeParameterList) {
        if (typeParameterList.getTypeParameters().contains(typeParameterList)) {
            return this.parser.parseTypeParameter();
        }
        return this.notAChild(typeParameterList);
    }

    @Override
    public AstNode visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        if (this.oldNode == variableDeclaration.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (variableDeclaration.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (this.oldNode == variableDeclaration.getName()) {
            throw new InsufficientContextException();
        }
        if (this.oldNode == variableDeclaration.getInitializer()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(variableDeclaration);
    }

    @Override
    public AstNode visitVariableDeclarationList(VariableDeclarationList variableDeclarationList) {
        if (this.oldNode == variableDeclarationList.getDocumentationComment()) {
            throw new InsufficientContextException();
        }
        if (variableDeclarationList.getMetadata().contains(this.oldNode)) {
            return this.parser.parseAnnotation();
        }
        if (variableDeclarationList.getVariables().contains(this.oldNode)) {
            throw new InsufficientContextException();
        }
        return this.notAChild(variableDeclarationList);
    }

    @Override
    public AstNode visitVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement) {
        if (this.oldNode == variableDeclarationStatement.getVariables()) {
            throw new InsufficientContextException();
        }
        return this.notAChild(variableDeclarationStatement);
    }

    @Override
    public AstNode visitWhileStatement(WhileStatement whileStatement) {
        if (this.oldNode == whileStatement.getCondition()) {
            return this.parser.parseExpression();
        }
        if (this.oldNode == whileStatement.getBody()) {
            return this.parser.parseStatement();
        }
        return this.notAChild(whileStatement);
    }

    @Override
    public AstNode visitWithClause(WithClause withClause) {
        if (withClause.getMixinTypes().contains(withClause)) {
            return this.parser.parseTypeName();
        }
        return this.notAChild(withClause);
    }

    private boolean isCascadeAllowedInAssignment(AssignmentExpression assignmentExpression) {
        throw new InsufficientContextException();
    }

    private boolean isCascadeAllowedInThrow(ThrowExpression throwExpression) {
        throw new InsufficientContextException();
    }

    private AstNode notAChild(AstNode astNode) {
        throw new IncrementalParseException("Internal error: the visited node (a " + astNode.getClass().getSimpleName() + ") was not the parent of the node to be replaced (a " + this.oldNode.getClass().getSimpleName() + ")");
    }
}

