/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.verifier;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AssertStatement;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.BlockFunctionBody;
import com.google.dart.engine.ast.BreakStatement;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.CommentReference;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorFieldInitializer;
import com.google.dart.engine.ast.ConstructorInitializer;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.ContinueStatement;
import com.google.dart.engine.ast.Declaration;
import com.google.dart.engine.ast.DefaultFormalParameter;
import com.google.dart.engine.ast.DoStatement;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.ExpressionFunctionBody;
import com.google.dart.engine.ast.ExpressionStatement;
import com.google.dart.engine.ast.ExtendsClause;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.FieldFormalParameter;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionExpressionInvocation;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.IfStatement;
import com.google.dart.engine.ast.ImplementsClause;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NativeClause;
import com.google.dart.engine.ast.NativeFunctionBody;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.NormalFormalParameter;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.RedirectingConstructorInvocation;
import com.google.dart.engine.ast.RethrowExpression;
import com.google.dart.engine.ast.ReturnStatement;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchMember;
import com.google.dart.engine.ast.SwitchStatement;
import com.google.dart.engine.ast.ThisExpression;
import com.google.dart.engine.ast.ThrowExpression;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.VariableDeclarationStatement;
import com.google.dart.engine.ast.WhileStatement;
import com.google.dart.engine.ast.WithClause;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ClassMemberElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.FieldFormalParameterElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.MultiplyInheritedExecutableElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.element.visitor.GeneralizingElementVisitor;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorWithProperties;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.ErrorProperty;
import com.google.dart.engine.error.StaticTypeWarningCode;
import com.google.dart.engine.error.StaticWarningCode;
import com.google.dart.engine.internal.constant.EvaluationResultImpl;
import com.google.dart.engine.internal.constant.ValidResult;
import com.google.dart.engine.internal.element.ClassElementImpl;
import com.google.dart.engine.internal.element.FieldFormalParameterElementImpl;
import com.google.dart.engine.internal.element.LabelElementImpl;
import com.google.dart.engine.internal.element.ParameterElementImpl;
import com.google.dart.engine.internal.element.member.ConstructorMember;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.internal.resolver.ElementResolver;
import com.google.dart.engine.internal.resolver.InheritanceManager;
import com.google.dart.engine.internal.resolver.MemberMap;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.NamespaceBuilder;
import com.google.dart.engine.internal.type.DynamicTypeImpl;
import com.google.dart.engine.internal.type.VoidTypeImpl;
import com.google.dart.engine.parser.ParserErrorCode;
import com.google.dart.engine.resolver.ResolverErrorCode;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.sdk.DartSdk;
import com.google.dart.engine.sdk.SdkLibrary;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.type.TypeParameterType;
import com.google.dart.engine.utilities.dart.ParameterKind;
import com.google.dart.engine.utilities.general.ObjectUtilities;
import com.google.dart.engine.utilities.general.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ErrorVerifier
extends RecursiveAstVisitor<Void> {
    private ErrorReporter errorReporter;
    private LibraryElement currentLibrary;
    private Type dynamicType;
    private InterfaceType boolType;
    private InterfaceType intType;
    private TypeProvider typeProvider;
    private InheritanceManager inheritanceManager;
    private boolean isEnclosingConstructorConst;
    private boolean isInCatchClause;
    private boolean isInComment;
    private boolean isInConstInstanceCreation;
    private boolean isInNativeClass;
    private boolean isInStaticVariableDeclaration;
    private boolean isInInstanceVariableDeclaration;
    private boolean isInInstanceVariableInitializer;
    private boolean isInConstructorInitializer;
    private boolean isInFunctionTypedFormalParameter;
    private boolean isInStaticMethod;
    private boolean isInSystemLibrary;
    private boolean hasExtUri;
    private ClassElement enclosingClass;
    private ExecutableElement enclosingFunction;
    private ArrayList<ReturnStatement> returnsWith = new ArrayList();
    private ArrayList<ReturnStatement> returnsWithout = new ArrayList();
    private HashMap<FieldElement, INIT_STATE> initialFieldElementsMap;
    private HashMap<String, LibraryElement> nameToExportElement = new HashMap();
    private HashMap<String, LibraryElement> nameToImportElement = new HashMap();
    private HashMap<String, Element> exportedElements = new HashMap();
    private HashSet<String> namesForReferenceToDeclaredVariableInInitializer = new HashSet();
    private final InterfaceType[] DISALLOWED_TYPES_TO_EXTEND_OR_IMPLEMENT;

    public ErrorVerifier(ErrorReporter errorReporter, LibraryElement libraryElement, TypeProvider typeProvider, InheritanceManager inheritanceManager) {
        this.errorReporter = errorReporter;
        this.currentLibrary = libraryElement;
        this.isInSystemLibrary = libraryElement.getSource().isInSystemLibrary();
        this.hasExtUri = libraryElement.hasExtUri();
        this.typeProvider = typeProvider;
        this.inheritanceManager = inheritanceManager;
        this.isEnclosingConstructorConst = false;
        this.isInCatchClause = false;
        this.isInStaticVariableDeclaration = false;
        this.isInInstanceVariableDeclaration = false;
        this.isInInstanceVariableInitializer = false;
        this.isInConstructorInitializer = false;
        this.isInStaticMethod = false;
        this.boolType = typeProvider.getBoolType();
        this.intType = typeProvider.getIntType();
        this.dynamicType = typeProvider.getDynamicType();
        this.DISALLOWED_TYPES_TO_EXTEND_OR_IMPLEMENT = new InterfaceType[]{typeProvider.getNullType(), typeProvider.getNumType(), this.intType, typeProvider.getDoubleType(), this.boolType, typeProvider.getStringType()};
    }

    @Override
    public Void visitArgumentList(ArgumentList argumentList) {
        this.checkForArgumentTypesNotAssignableInList(argumentList);
        return (Void)super.visitArgumentList(argumentList);
    }

    @Override
    public Void visitAssertStatement(AssertStatement assertStatement) {
        this.checkForNonBoolExpression(assertStatement);
        return (Void)super.visitAssertStatement(assertStatement);
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        Token token = assignmentExpression.getOperator();
        TokenType tokenType = token.getType();
        if (tokenType == TokenType.EQ) {
            this.checkForInvalidAssignment(assignmentExpression.getLeftHandSide(), assignmentExpression.getRightHandSide());
        } else {
            this.checkForInvalidCompoundAssignment(assignmentExpression);
        }
        this.checkForAssignmentToFinal(assignmentExpression.getLeftHandSide());
        this.checkForArgumentTypeNotAssignableForArgument(assignmentExpression.getRightHandSide());
        return (Void)super.visitAssignmentExpression(assignmentExpression);
    }

    @Override
    public Void visitBinaryExpression(BinaryExpression binaryExpression) {
        this.checkForArgumentTypeNotAssignableForArgument(binaryExpression.getRightOperand());
        return (Void)super.visitBinaryExpression(binaryExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitBlockFunctionBody(BlockFunctionBody blockFunctionBody) {
        ArrayList<ReturnStatement> arrayList = this.returnsWith;
        ArrayList<ReturnStatement> arrayList2 = this.returnsWithout;
        try {
            this.returnsWith = new ArrayList();
            this.returnsWithout = new ArrayList();
            super.visitBlockFunctionBody(blockFunctionBody);
            this.checkForMixedReturns(blockFunctionBody);
        }
        finally {
            this.returnsWith = arrayList;
            this.returnsWithout = arrayList2;
        }
        return null;
    }

    @Override
    public Void visitBreakStatement(BreakStatement breakStatement) {
        Element element;
        SimpleIdentifier simpleIdentifier = breakStatement.getLabel();
        if (simpleIdentifier != null && (element = simpleIdentifier.getStaticElement()) instanceof LabelElementImpl && ((LabelElementImpl)element).isOnSwitchMember()) {
            this.errorReporter.reportErrorForNode(ResolverErrorCode.BREAK_LABEL_ON_SWITCH_MEMBER, simpleIdentifier, new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitCatchClause(CatchClause catchClause) {
        boolean bl = this.isInCatchClause;
        try {
            this.isInCatchClause = true;
            Void void_ = (Void)super.visitCatchClause(catchClause);
            return void_;
        }
        finally {
            this.isInCatchClause = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        ClassElement classElement = this.enclosingClass;
        try {
            Object object;
            ClassElement classElement2;
            this.isInNativeClass = classDeclaration.getNativeClause() != null;
            this.enclosingClass = classDeclaration.getElement();
            WithClause withClause = classDeclaration.getWithClause();
            ImplementsClause implementsClause = classDeclaration.getImplementsClause();
            ExtendsClause extendsClause = classDeclaration.getExtendsClause();
            this.checkForBuiltInIdentifierAsName(classDeclaration.getName(), CompileTimeErrorCode.BUILT_IN_IDENTIFIER_AS_TYPE_NAME);
            this.checkForMemberWithClassName();
            this.checkForNoDefaultSuperConstructorImplicit(classDeclaration);
            this.checkForConflictingTypeVariableErrorCodes(classDeclaration);
            if (!(implementsClause == null && extendsClause == null && withClause == null || this.checkForImplementsDisallowedClass(implementsClause) || this.checkForExtendsDisallowedClass(extendsClause) || this.checkForAllMixinErrorCodes(withClause))) {
                this.checkForNonAbstractClassInheritsAbstractMember(classDeclaration);
                this.checkForInconsistentMethodInheritance();
                this.checkForRecursiveInterfaceInheritance(this.enclosingClass);
                this.checkForConflictingGetterAndMethod();
                this.checkForConflictingInstanceGetterAndSuperclassMember();
                this.checkImplementsSuperClass(classDeclaration);
                this.checkImplementsFunctionWithoutCall(classDeclaration);
            }
            if ((classElement2 = classDeclaration.getElement()) != null) {
                object = classElement2.getFields();
                this.initialFieldElementsMap = new HashMap(((FieldElement[])object).length);
                for (FieldElement fieldElement : object) {
                    if (fieldElement.isSynthetic()) continue;
                    this.initialFieldElementsMap.put(fieldElement, fieldElement.getInitializer() == null ? INIT_STATE.NOT_INIT : INIT_STATE.INIT_IN_DECLARATION);
                }
            }
            this.checkForFinalNotInitializedInClass(classDeclaration);
            this.checkForDuplicateDefinitionInheritance();
            this.checkForConflictingInstanceMethodSetter(classDeclaration);
            object = (Void)super.visitClassDeclaration(classDeclaration);
            return object;
        }
        finally {
            this.isInNativeClass = false;
            this.initialFieldElementsMap = null;
            this.enclosingClass = classElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        this.checkForBuiltInIdentifierAsName(classTypeAlias.getName(), CompileTimeErrorCode.BUILT_IN_IDENTIFIER_AS_TYPEDEF_NAME);
        this.checkForExtendsDisallowedClassInTypeAlias(classTypeAlias);
        this.checkForImplementsDisallowedClass(classTypeAlias.getImplementsClause());
        this.checkForAllMixinErrorCodes(classTypeAlias.getWithClause());
        ClassElement classElement = this.enclosingClass;
        try {
            this.enclosingClass = classTypeAlias.getElement();
            this.checkForRecursiveInterfaceInheritance(classTypeAlias.getElement());
            this.checkForTypeAliasCannotReferenceItself_mixin(classTypeAlias);
        }
        finally {
            this.enclosingClass = classElement;
        }
        return (Void)super.visitClassTypeAlias(classTypeAlias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitComment(Comment comment) {
        this.isInComment = true;
        try {
            Void void_ = (Void)super.visitComment(comment);
            return void_;
        }
        finally {
            this.isInComment = false;
        }
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpression conditionalExpression) {
        this.checkForNonBoolCondition(conditionalExpression.getCondition());
        return (Void)super.visitConditionalExpression(conditionalExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        ExecutableElement executableElement = this.enclosingFunction;
        try {
            this.enclosingFunction = constructorDeclaration.getElement();
            this.isEnclosingConstructorConst = constructorDeclaration.getConstKeyword() != null;
            this.checkForConstConstructorWithNonFinalField(constructorDeclaration);
            this.checkForConstConstructorWithNonConstSuper(constructorDeclaration);
            this.checkForConflictingConstructorNameAndMember(constructorDeclaration);
            this.checkForAllFinalInitializedErrorCodes(constructorDeclaration);
            this.checkForRedirectingConstructorErrorCodes(constructorDeclaration);
            this.checkForMultipleSuperInitializers(constructorDeclaration);
            this.checkForRecursiveConstructorRedirect(constructorDeclaration);
            if (!this.checkForRecursiveFactoryRedirect(constructorDeclaration)) {
                this.checkForAllRedirectConstructorErrorCodes(constructorDeclaration);
            }
            this.checkForUndefinedConstructorInInitializerImplicit(constructorDeclaration);
            this.checkForRedirectToNonConstConstructor(constructorDeclaration);
            this.checkForReturnInGenerativeConstructor(constructorDeclaration);
            Void void_ = (Void)super.visitConstructorDeclaration(constructorDeclaration);
            return void_;
        }
        finally {
            this.isEnclosingConstructorConst = false;
            this.enclosingFunction = executableElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConstructorFieldInitializer(ConstructorFieldInitializer constructorFieldInitializer) {
        this.isInConstructorInitializer = true;
        try {
            this.checkForInvalidField(constructorFieldInitializer);
            this.checkForFieldInitializerNotAssignable(constructorFieldInitializer);
            Void void_ = (Void)super.visitConstructorFieldInitializer(constructorFieldInitializer);
            return void_;
        }
        finally {
            this.isInConstructorInitializer = false;
        }
    }

    @Override
    public Void visitContinueStatement(ContinueStatement continueStatement) {
        Element element;
        SimpleIdentifier simpleIdentifier = continueStatement.getLabel();
        if (simpleIdentifier != null && (element = simpleIdentifier.getStaticElement()) instanceof LabelElementImpl && ((LabelElementImpl)element).isOnSwitchStatement()) {
            this.errorReporter.reportErrorForNode(ResolverErrorCode.CONTINUE_LABEL_ON_SWITCH, simpleIdentifier, new Object[0]);
        }
        return null;
    }

    @Override
    public Void visitDefaultFormalParameter(DefaultFormalParameter defaultFormalParameter) {
        this.checkForInvalidAssignment(defaultFormalParameter.getIdentifier(), defaultFormalParameter.getDefaultValue());
        this.checkForDefaultValueInFunctionTypedParameter(defaultFormalParameter);
        return (Void)super.visitDefaultFormalParameter(defaultFormalParameter);
    }

    @Override
    public Void visitDoStatement(DoStatement doStatement) {
        this.checkForNonBoolCondition(doStatement.getCondition());
        return (Void)super.visitDoStatement(doStatement);
    }

    @Override
    public Void visitExportDirective(ExportDirective exportDirective) {
        ExportElement exportElement = exportDirective.getElement();
        if (exportElement != null) {
            this.checkForAmbiguousExport(exportDirective, exportElement);
            this.checkForExportDuplicateLibraryName(exportDirective, exportElement);
            this.checkForExportInternalLibrary(exportDirective, exportElement);
        }
        return (Void)super.visitExportDirective(exportDirective);
    }

    @Override
    public Void visitExpressionFunctionBody(ExpressionFunctionBody expressionFunctionBody) {
        FunctionType functionType = this.enclosingFunction == null ? null : this.enclosingFunction.getType();
        Type type = functionType == null ? DynamicTypeImpl.getInstance() : functionType.getReturnType();
        this.checkForReturnOfInvalidType(expressionFunctionBody.getExpression(), type);
        return (Void)super.visitExpressionFunctionBody(expressionFunctionBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
        Object object;
        this.isInStaticVariableDeclaration = fieldDeclaration.isStatic();
        boolean bl = this.isInInstanceVariableDeclaration = !this.isInStaticVariableDeclaration;
        if (this.isInInstanceVariableDeclaration && ((VariableDeclarationList)(object = fieldDeclaration.getFields())).isConst()) {
            this.errorReporter.reportErrorForToken(CompileTimeErrorCode.CONST_INSTANCE_FIELD, ((VariableDeclarationList)object).getKeyword(), new Object[0]);
        }
        try {
            this.checkForAllInvalidOverrideErrorCodesForField(fieldDeclaration);
            object = (Void)super.visitFieldDeclaration(fieldDeclaration);
            return object;
        }
        finally {
            this.isInStaticVariableDeclaration = false;
            this.isInInstanceVariableDeclaration = false;
        }
    }

    @Override
    public Void visitFieldFormalParameter(FieldFormalParameter fieldFormalParameter) {
        this.checkForValidField(fieldFormalParameter);
        this.checkForConstFormalParameter(fieldFormalParameter);
        this.checkForPrivateOptionalParameter(fieldFormalParameter);
        this.checkForFieldInitializingFormalRedirectingConstructor(fieldFormalParameter);
        return (Void)super.visitFieldFormalParameter(fieldFormalParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        ExecutableElement executableElement = this.enclosingFunction;
        try {
            Object object;
            SimpleIdentifier simpleIdentifier = functionDeclaration.getName();
            String string = "";
            if (simpleIdentifier != null) {
                string = simpleIdentifier.getName();
            }
            this.enclosingFunction = functionDeclaration.getElement();
            if (functionDeclaration.isSetter() || functionDeclaration.isGetter()) {
                this.checkForMismatchedAccessorTypes(functionDeclaration, string);
                if (functionDeclaration.isSetter()) {
                    object = functionDeclaration.getFunctionExpression();
                    if (object != null) {
                        this.checkForWrongNumberOfParametersForSetter(functionDeclaration.getName(), ((FunctionExpression)object).getParameters());
                    }
                    TypeName typeName = functionDeclaration.getReturnType();
                    this.checkForNonVoidReturnTypeForSetter(typeName);
                }
            }
            object = (Void)super.visitFunctionDeclaration(functionDeclaration);
            return object;
        }
        finally {
            this.enclosingFunction = executableElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        if (!(functionExpression.getParent() instanceof FunctionDeclaration)) {
            ExecutableElement executableElement = this.enclosingFunction;
            try {
                this.enclosingFunction = functionExpression.getElement();
                Void void_ = (Void)super.visitFunctionExpression(functionExpression);
                return void_;
            }
            finally {
                this.enclosingFunction = executableElement;
            }
        }
        return (Void)super.visitFunctionExpression(functionExpression);
    }

    @Override
    public Void visitFunctionExpressionInvocation(FunctionExpressionInvocation functionExpressionInvocation) {
        Expression expression = functionExpressionInvocation.getFunction();
        Type type = expression.getStaticType();
        if (!this.isFunctionType(type)) {
            this.errorReporter.reportErrorForNode(StaticTypeWarningCode.INVOCATION_OF_NON_FUNCTION_EXPRESSION, expression, new Object[0]);
        }
        return (Void)super.visitFunctionExpressionInvocation(functionExpressionInvocation);
    }

    @Override
    public Void visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        this.checkForBuiltInIdentifierAsName(functionTypeAlias.getName(), CompileTimeErrorCode.BUILT_IN_IDENTIFIER_AS_TYPEDEF_NAME);
        this.checkForDefaultValueInFunctionTypeAlias(functionTypeAlias);
        this.checkForTypeAliasCannotReferenceItself_function(functionTypeAlias);
        return (Void)super.visitFunctionTypeAlias(functionTypeAlias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionTypedFormalParameter(FunctionTypedFormalParameter functionTypedFormalParameter) {
        boolean bl = this.isInFunctionTypedFormalParameter;
        this.isInFunctionTypedFormalParameter = true;
        try {
            Void void_ = (Void)super.visitFunctionTypedFormalParameter(functionTypedFormalParameter);
            return void_;
        }
        finally {
            this.isInFunctionTypedFormalParameter = bl;
        }
    }

    @Override
    public Void visitIfStatement(IfStatement ifStatement) {
        this.checkForNonBoolCondition(ifStatement.getCondition());
        return (Void)super.visitIfStatement(ifStatement);
    }

    @Override
    public Void visitImportDirective(ImportDirective importDirective) {
        ImportElement importElement = importDirective.getElement();
        if (importElement != null) {
            this.checkForImportDuplicateLibraryName(importDirective, importElement);
            this.checkForImportInternalLibrary(importDirective, importElement);
        }
        return (Void)super.visitImportDirective(importDirective);
    }

    @Override
    public Void visitIndexExpression(IndexExpression indexExpression) {
        this.checkForArgumentTypeNotAssignableForArgument(indexExpression.getIndex());
        return (Void)super.visitIndexExpression(indexExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        this.isInConstInstanceCreation = instanceCreationExpression.isConst();
        try {
            Object object;
            ConstructorName constructorName = instanceCreationExpression.getConstructorName();
            TypeName typeName = constructorName.getType();
            Type type = typeName.getType();
            if (type instanceof InterfaceType) {
                object = (InterfaceType)type;
                this.checkForConstOrNewWithAbstractClass(instanceCreationExpression, typeName, (InterfaceType)object);
                if (this.isInConstInstanceCreation) {
                    this.checkForConstWithNonConst(instanceCreationExpression);
                    this.checkForConstWithUndefinedConstructor(instanceCreationExpression);
                    this.checkForConstWithTypeParametersInCreation(instanceCreationExpression);
                } else {
                    this.checkForNewWithUndefinedConstructor(instanceCreationExpression);
                }
            }
            object = (Void)super.visitInstanceCreationExpression(instanceCreationExpression);
            return object;
        }
        finally {
            this.isInConstInstanceCreation = false;
        }
    }

    @Override
    public Void visitListLiteral(ListLiteral listLiteral) {
        NodeList<TypeName> nodeList;
        TypeArgumentList typeArgumentList;
        if (listLiteral.getConstKeyword() != null && (typeArgumentList = listLiteral.getTypeArguments()) != null && (nodeList = typeArgumentList.getArguments()).size() != 0) {
            this.checkForInvalidTypeArgumentInConstTypedLiteral(nodeList, CompileTimeErrorCode.INVALID_TYPE_ARGUMENT_IN_CONST_LIST);
        }
        this.checkForExpectedOneListTypeArgument(listLiteral);
        this.checkForListElementTypeNotAssignable(listLiteral);
        return (Void)super.visitListLiteral(listLiteral);
    }

    @Override
    public Void visitMapLiteral(MapLiteral mapLiteral) {
        NodeList<TypeName> nodeList;
        TypeArgumentList typeArgumentList = mapLiteral.getTypeArguments();
        if (typeArgumentList != null && (nodeList = typeArgumentList.getArguments()).size() != 0 && mapLiteral.getConstKeyword() != null) {
            this.checkForInvalidTypeArgumentInConstTypedLiteral(nodeList, CompileTimeErrorCode.INVALID_TYPE_ARGUMENT_IN_CONST_MAP);
        }
        this.checkExpectedTwoMapTypeArguments(typeArgumentList);
        this.checkForNonConstMapAsExpressionStatement(mapLiteral);
        this.checkForMapTypeNotAssignable(mapLiteral);
        this.checkForConstMapKeyExpressionTypeImplementsEquals(mapLiteral);
        return (Void)super.visitMapLiteral(mapLiteral);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        ExecutableElement executableElement = this.enclosingFunction;
        try {
            this.isInStaticMethod = methodDeclaration.isStatic();
            this.enclosingFunction = methodDeclaration.getElement();
            SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
            String string = "";
            if (simpleIdentifier != null) {
                string = simpleIdentifier.getName();
            }
            if (methodDeclaration.isSetter() || methodDeclaration.isGetter()) {
                this.checkForMismatchedAccessorTypes(methodDeclaration, string);
            }
            if (methodDeclaration.isGetter()) {
                this.checkForVoidReturnType(methodDeclaration);
                this.checkForConflictingStaticGetterAndInstanceSetter(methodDeclaration);
            } else if (methodDeclaration.isSetter()) {
                this.checkForWrongNumberOfParametersForSetter(methodDeclaration.getName(), methodDeclaration.getParameters());
                this.checkForNonVoidReturnTypeForSetter(methodDeclaration.getReturnType());
                this.checkForConflictingStaticSetterAndInstanceMember(methodDeclaration);
            } else if (methodDeclaration.isOperator()) {
                this.checkForOptionalParameterInOperator(methodDeclaration);
                this.checkForWrongNumberOfParametersForOperator(methodDeclaration);
                this.checkForNonVoidReturnTypeForOperator(methodDeclaration);
            }
            this.checkForConcreteClassWithAbstractMember(methodDeclaration);
            this.checkForAllInvalidOverrideErrorCodesForMethod(methodDeclaration);
            Void void_ = (Void)super.visitMethodDeclaration(methodDeclaration);
            return void_;
        }
        finally {
            this.enclosingFunction = executableElement;
            this.isInStaticMethod = false;
        }
    }

    @Override
    public Void visitMethodInvocation(MethodInvocation methodInvocation) {
        Expression expression = methodInvocation.getRealTarget();
        SimpleIdentifier simpleIdentifier = methodInvocation.getMethodName();
        if (expression != null) {
            ClassElementImpl classElementImpl = ElementResolver.getTypeReference(expression);
            this.checkForStaticAccessToInstanceMember(classElementImpl, simpleIdentifier);
            this.checkForInstanceAccessToStaticMember(classElementImpl, simpleIdentifier);
        } else {
            this.checkForUnqualifiedReferenceToNonLocalStaticMember(simpleIdentifier);
        }
        return (Void)super.visitMethodInvocation(methodInvocation);
    }

    @Override
    public Void visitNativeClause(NativeClause nativeClause) {
        if (!this.isInSystemLibrary) {
            this.errorReporter.reportErrorForNode(ParserErrorCode.NATIVE_CLAUSE_IN_NON_SDK_CODE, nativeClause, new Object[0]);
        }
        return (Void)super.visitNativeClause(nativeClause);
    }

    @Override
    public Void visitNativeFunctionBody(NativeFunctionBody nativeFunctionBody) {
        this.checkForNativeFunctionBodyInNonSDKCode(nativeFunctionBody);
        return (Void)super.visitNativeFunctionBody(nativeFunctionBody);
    }

    @Override
    public Void visitPostfixExpression(PostfixExpression postfixExpression) {
        this.checkForAssignmentToFinal(postfixExpression.getOperand());
        this.checkForIntNotAssignable(postfixExpression.getOperand());
        return (Void)super.visitPostfixExpression(postfixExpression);
    }

    @Override
    public Void visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        if (!(prefixedIdentifier.getParent() instanceof Annotation)) {
            ClassElementImpl classElementImpl = ElementResolver.getTypeReference(prefixedIdentifier.getPrefix());
            SimpleIdentifier simpleIdentifier = prefixedIdentifier.getIdentifier();
            this.checkForStaticAccessToInstanceMember(classElementImpl, simpleIdentifier);
            this.checkForInstanceAccessToStaticMember(classElementImpl, simpleIdentifier);
        }
        return (Void)super.visitPrefixedIdentifier(prefixedIdentifier);
    }

    @Override
    public Void visitPrefixExpression(PrefixExpression prefixExpression) {
        TokenType tokenType = prefixExpression.getOperator().getType();
        Expression expression = prefixExpression.getOperand();
        if (tokenType == TokenType.BANG) {
            this.checkForNonBoolNegationExpression(expression);
        } else if (tokenType.isIncrementOperator()) {
            this.checkForAssignmentToFinal(expression);
        }
        this.checkForIntNotAssignable(expression);
        return (Void)super.visitPrefixExpression(prefixExpression);
    }

    @Override
    public Void visitPropertyAccess(PropertyAccess propertyAccess) {
        ClassElementImpl classElementImpl = ElementResolver.getTypeReference(propertyAccess.getRealTarget());
        SimpleIdentifier simpleIdentifier = propertyAccess.getPropertyName();
        this.checkForStaticAccessToInstanceMember(classElementImpl, simpleIdentifier);
        this.checkForInstanceAccessToStaticMember(classElementImpl, simpleIdentifier);
        return (Void)super.visitPropertyAccess(propertyAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitRedirectingConstructorInvocation(RedirectingConstructorInvocation redirectingConstructorInvocation) {
        this.isInConstructorInitializer = true;
        try {
            Void void_ = (Void)super.visitRedirectingConstructorInvocation(redirectingConstructorInvocation);
            return void_;
        }
        finally {
            this.isInConstructorInitializer = false;
        }
    }

    @Override
    public Void visitRethrowExpression(RethrowExpression rethrowExpression) {
        this.checkForRethrowOutsideCatch(rethrowExpression);
        return (Void)super.visitRethrowExpression(rethrowExpression);
    }

    @Override
    public Void visitReturnStatement(ReturnStatement returnStatement) {
        if (returnStatement.getExpression() == null) {
            this.returnsWithout.add(returnStatement);
        } else {
            this.returnsWith.add(returnStatement);
        }
        this.checkForAllReturnStatementErrorCodes(returnStatement);
        return (Void)super.visitReturnStatement(returnStatement);
    }

    @Override
    public Void visitSimpleFormalParameter(SimpleFormalParameter simpleFormalParameter) {
        this.checkForConstFormalParameter(simpleFormalParameter);
        this.checkForPrivateOptionalParameter(simpleFormalParameter);
        return (Void)super.visitSimpleFormalParameter(simpleFormalParameter);
    }

    @Override
    public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        this.checkForImplicitThisReferenceInInitializer(simpleIdentifier);
        if (!this.isUnqualifiedReferenceToNonLocalStaticMemberAllowed(simpleIdentifier)) {
            this.checkForUnqualifiedReferenceToNonLocalStaticMember(simpleIdentifier);
        }
        return (Void)super.visitSimpleIdentifier(simpleIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
        this.isInConstructorInitializer = true;
        try {
            Void void_ = (Void)super.visitSuperConstructorInvocation(superConstructorInvocation);
            return void_;
        }
        finally {
            this.isInConstructorInitializer = false;
        }
    }

    @Override
    public Void visitSwitchStatement(SwitchStatement switchStatement) {
        this.checkForInconsistentCaseExpressionTypes(switchStatement);
        this.checkForSwitchExpressionNotAssignable(switchStatement);
        this.checkForCaseBlocksNotTerminated(switchStatement);
        return (Void)super.visitSwitchStatement(switchStatement);
    }

    @Override
    public Void visitThisExpression(ThisExpression thisExpression) {
        this.checkForInvalidReferenceToThis(thisExpression);
        return (Void)super.visitThisExpression(thisExpression);
    }

    @Override
    public Void visitThrowExpression(ThrowExpression throwExpression) {
        this.checkForConstEvalThrowsException(throwExpression);
        return (Void)super.visitThrowExpression(throwExpression);
    }

    @Override
    public Void visitTopLevelVariableDeclaration(TopLevelVariableDeclaration topLevelVariableDeclaration) {
        this.checkForFinalNotInitialized(topLevelVariableDeclaration.getVariables());
        return (Void)super.visitTopLevelVariableDeclaration(topLevelVariableDeclaration);
    }

    @Override
    public Void visitTypeName(TypeName typeName) {
        this.checkForTypeArgumentNotMatchingBounds(typeName);
        this.checkForTypeParameterReferencedByStatic(typeName);
        return (Void)super.visitTypeName(typeName);
    }

    @Override
    public Void visitTypeParameter(TypeParameter typeParameter) {
        this.checkForBuiltInIdentifierAsName(typeParameter.getName(), CompileTimeErrorCode.BUILT_IN_IDENTIFIER_AS_TYPE_PARAMETER_NAME);
        this.checkForTypeParameterSupertypeOfItsBound(typeParameter);
        return (Void)super.visitTypeParameter(typeParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        SimpleIdentifier simpleIdentifier = variableDeclaration.getName();
        Expression expression = variableDeclaration.getInitializer();
        this.checkForInvalidAssignment(simpleIdentifier, expression);
        simpleIdentifier.accept(this);
        String string = simpleIdentifier.getName();
        this.namesForReferenceToDeclaredVariableInInitializer.add(string);
        this.isInInstanceVariableInitializer = this.isInInstanceVariableDeclaration;
        try {
            if (expression != null) {
                expression.accept(this);
            }
        }
        finally {
            this.isInInstanceVariableInitializer = false;
            this.namesForReferenceToDeclaredVariableInInitializer.remove(string);
        }
        return null;
    }

    @Override
    public Void visitVariableDeclarationList(VariableDeclarationList variableDeclarationList) {
        return (Void)super.visitVariableDeclarationList(variableDeclarationList);
    }

    @Override
    public Void visitVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement) {
        this.checkForFinalNotInitialized(variableDeclarationStatement.getVariables());
        return (Void)super.visitVariableDeclarationStatement(variableDeclarationStatement);
    }

    @Override
    public Void visitWhileStatement(WhileStatement whileStatement) {
        this.checkForNonBoolCondition(whileStatement.getCondition());
        return (Void)super.visitWhileStatement(whileStatement);
    }

    private boolean checkExpectedTwoMapTypeArguments(TypeArgumentList typeArgumentList) {
        if (typeArgumentList == null) {
            return false;
        }
        int n = typeArgumentList.getArguments().size();
        if (n == 2) {
            return false;
        }
        this.errorReporter.reportErrorForNode(StaticTypeWarningCode.EXPECTED_TWO_MAP_TYPE_ARGUMENTS, typeArgumentList, n);
        return true;
    }

    private boolean checkForAllFinalInitializedErrorCodes(ConstructorDeclaration constructorDeclaration) {
        Object object;
        Object object2;
        Map.Entry<FieldElement, INIT_STATE> entry2;
        if (constructorDeclaration.getFactoryKeyword() != null || constructorDeclaration.getRedirectedConstructor() != null || constructorDeclaration.getExternalKeyword() != null) {
            return false;
        }
        if (this.isInNativeClass) {
            return false;
        }
        boolean bl = false;
        HashMap<FieldElement, INIT_STATE> hashMap = new HashMap<FieldElement, INIT_STATE>(this.initialFieldElementsMap);
        NodeList<FormalParameter> nodeList = constructorDeclaration.getParameters().getParameters();
        for (FormalParameter object32 : nodeList) {
            entry2 = object32;
            if (entry2 instanceof DefaultFormalParameter) {
                entry2 = ((DefaultFormalParameter)((Object)entry2)).getParameter();
            }
            if (!(entry2 instanceof FieldFormalParameter)) continue;
            object2 = ((FieldFormalParameterElementImpl)((FormalParameter)((Object)entry2)).getElement()).getField();
            object = hashMap.get(object2);
            if (object == INIT_STATE.NOT_INIT) {
                hashMap.put((FieldElement)object2, INIT_STATE.INIT_IN_FIELD_FORMAL);
                continue;
            }
            if (object == INIT_STATE.INIT_IN_DECLARATION) {
                if (!object2.isFinal() && !object2.isConst()) continue;
                this.errorReporter.reportErrorForNode(StaticWarningCode.FINAL_INITIALIZED_IN_DECLARATION_AND_CONSTRUCTOR, object32.getIdentifier(), object2.getDisplayName());
                bl = true;
                continue;
            }
            if (object != INIT_STATE.INIT_IN_FIELD_FORMAL || !object2.isFinal() && !object2.isConst()) continue;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.FINAL_INITIALIZED_MULTIPLE_TIMES, object32.getIdentifier(), object2.getDisplayName());
            bl = true;
        }
        NodeList<ConstructorInitializer> nodeList2 = constructorDeclaration.getInitializers();
        Iterator iterator = nodeList2.iterator();
        while (iterator.hasNext()) {
            Element element;
            entry2 = (ConstructorInitializer)iterator.next();
            if (entry2 instanceof RedirectingConstructorInvocation) {
                return false;
            }
            if (!(entry2 instanceof ConstructorFieldInitializer) || !((element = ((SimpleIdentifier)(object = ((ConstructorFieldInitializer)(object2 = (ConstructorFieldInitializer)((Object)entry2))).getFieldName())).getStaticElement()) instanceof FieldElement)) continue;
            FieldElement fieldElement = (FieldElement)element;
            INIT_STATE iNIT_STATE = hashMap.get(fieldElement);
            if (iNIT_STATE == INIT_STATE.NOT_INIT) {
                hashMap.put(fieldElement, INIT_STATE.INIT_IN_INITIALIZERS);
                continue;
            }
            if (iNIT_STATE == INIT_STATE.INIT_IN_DECLARATION) {
                if (!fieldElement.isFinal() && !fieldElement.isConst()) continue;
                this.errorReporter.reportErrorForNode(StaticWarningCode.FIELD_INITIALIZED_IN_INITIALIZER_AND_DECLARATION, (AstNode)object, new Object[0]);
                bl = true;
                continue;
            }
            if (iNIT_STATE == INIT_STATE.INIT_IN_FIELD_FORMAL) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.FIELD_INITIALIZED_IN_PARAMETER_AND_INITIALIZER, (AstNode)object, new Object[0]);
                bl = true;
                continue;
            }
            if (iNIT_STATE != INIT_STATE.INIT_IN_INITIALIZERS) continue;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.FIELD_INITIALIZED_BY_MULTIPLE_INITIALIZERS, (AstNode)object, fieldElement.getDisplayName());
            bl = true;
        }
        for (Map.Entry<FieldElement, INIT_STATE> entry2 : hashMap.entrySet()) {
            if (entry2.getValue() != INIT_STATE.NOT_INIT) continue;
            object2 = (FieldElement)entry2.getKey();
            if (object2.isConst()) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_NOT_INITIALIZED, constructorDeclaration.getReturnType(), object2.getName());
                bl = true;
                continue;
            }
            if (!object2.isFinal()) continue;
            this.errorReporter.reportErrorForNode(StaticWarningCode.FINAL_NOT_INITIALIZED, constructorDeclaration.getReturnType(), object2.getName());
            bl = true;
        }
        return bl;
    }

    private boolean checkForAllInvalidOverrideErrorCodes(ExecutableElement executableElement, ExecutableElement executableElement2, ParameterElement[] parameterElementArray, AstNode[] astNodeArray, SimpleIdentifier simpleIdentifier) {
        boolean bl;
        block25: {
            Object object2;
            Object object3;
            Object object4;
            int n;
            Object object5;
            boolean bl2 = false;
            boolean bl3 = false;
            if (executableElement instanceof PropertyAccessorElement) {
                object5 = (PropertyAccessorElement)executableElement;
                bl2 = object5.isGetter();
                bl3 = object5.isSetter();
            }
            object5 = executableElement.getName();
            if (executableElement2 == null) {
                if (!(bl2 || bl3 || executableElement.isOperator())) {
                    HashSet<ClassElement> hashSet = new HashSet<ClassElement>();
                    InterfaceType interfaceType = this.enclosingClass.getSupertype();
                    ClassElement classElement = interfaceType == null ? null : interfaceType.getElement();
                    boolean bl4 = Identifier.isPrivateName((String)object5);
                    while (classElement != null && !hashSet.contains(classElement)) {
                        int n2;
                        hashSet.add(classElement);
                        LibraryElement libraryElement = classElement.getLibrary();
                        FieldElement[] fieldElementArray = classElement.getFields();
                        ClassMemberElement[] classMemberElementArray = fieldElementArray;
                        int n3 = classMemberElementArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            FieldElement fieldElement = classMemberElementArray[n2];
                            if (!fieldElement.getName().equals(object5) || bl4 && !this.currentLibrary.equals(libraryElement) || !fieldElement.isStatic()) continue;
                            this.errorReporter.reportErrorForNode(StaticWarningCode.INSTANCE_METHOD_NAME_COLLIDES_WITH_SUPERCLASS_STATIC, simpleIdentifier, object5, fieldElement.getEnclosingElement().getDisplayName());
                            return true;
                        }
                        ClassMemberElement[] classMemberElementArray2 = classMemberElementArray = classElement.getMethods();
                        n2 = classMemberElementArray2.length;
                        for (int i = 0; i < n2; ++i) {
                            ClassMemberElement classMemberElement = classMemberElementArray2[i];
                            if (!classMemberElement.getName().equals(object5) || bl4 && !this.currentLibrary.equals(libraryElement) || !classMemberElement.isStatic()) continue;
                            this.errorReporter.reportErrorForNode(StaticWarningCode.INSTANCE_METHOD_NAME_COLLIDES_WITH_SUPERCLASS_STATIC, simpleIdentifier, object5, classMemberElement.getEnclosingElement().getDisplayName());
                            return true;
                        }
                        interfaceType = classElement.getSupertype();
                        classElement = interfaceType == null ? null : interfaceType.getElement();
                    }
                }
                return false;
            }
            FunctionType functionType = executableElement.getType();
            FunctionType functionType2 = executableElement2.getType();
            InterfaceType interfaceType = this.enclosingClass.getType();
            functionType2 = this.inheritanceManager.substituteTypeArgumentsInMemberFromInheritance(functionType2, (String)object5, interfaceType);
            if (functionType == null || functionType2 == null) {
                return false;
            }
            Type type = functionType.getReturnType();
            Type type2 = functionType2.getReturnType();
            Type[] typeArray = functionType.getNormalParameterTypes();
            Type[] typeArray2 = functionType2.getNormalParameterTypes();
            Type[] typeArray3 = functionType.getOptionalParameterTypes();
            Type[] typeArray4 = functionType2.getOptionalParameterTypes();
            Map<String, Type> map = functionType.getNamedParameterTypes();
            Map<String, Type> map2 = functionType2.getNamedParameterTypes();
            if (typeArray.length > typeArray2.length) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.INVALID_OVERRIDE_REQUIRED, simpleIdentifier, typeArray2.length, executableElement2.getEnclosingElement().getDisplayName());
                return true;
            }
            if (typeArray.length + typeArray3.length < typeArray4.length + typeArray2.length) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.INVALID_OVERRIDE_POSITIONAL, simpleIdentifier, typeArray4.length + typeArray2.length, executableElement2.getEnclosingElement().getDisplayName());
                return true;
            }
            Set<String> set = map.keySet();
            for (String string : map2.keySet()) {
                if (set.contains(string)) continue;
                this.errorReporter.reportErrorForNode(StaticWarningCode.INVALID_OVERRIDE_NAMED, simpleIdentifier, string, executableElement2.getEnclosingElement().getDisplayName());
                return true;
            }
            if (!type2.equals(VoidTypeImpl.getInstance()) && !type.isAssignableTo(type2)) {
                this.errorReporter.reportErrorForNode(!bl2 ? StaticWarningCode.INVALID_METHOD_OVERRIDE_RETURN_TYPE : StaticWarningCode.INVALID_GETTER_OVERRIDE_RETURN_TYPE, simpleIdentifier, type.getDisplayName(), type2.getDisplayName(), executableElement2.getEnclosingElement().getDisplayName());
                return true;
            }
            if (astNodeArray == null) {
                return false;
            }
            int n4 = 0;
            for (n = 0; n < typeArray.length; ++n) {
                if (!typeArray[n].isAssignableTo(typeArray2[n])) {
                    this.errorReporter.reportErrorForNode(!bl3 ? StaticWarningCode.INVALID_METHOD_OVERRIDE_NORMAL_PARAM_TYPE : StaticWarningCode.INVALID_SETTER_OVERRIDE_NORMAL_PARAM_TYPE, astNodeArray[n4], typeArray[n].getDisplayName(), typeArray2[n].getDisplayName(), executableElement2.getEnclosingElement().getDisplayName());
                    return true;
                }
                ++n4;
            }
            for (n = 0; n < typeArray4.length; ++n) {
                if (!typeArray3[n].isAssignableTo(typeArray4[n])) {
                    this.errorReporter.reportErrorForNode(StaticWarningCode.INVALID_METHOD_OVERRIDE_OPTIONAL_PARAM_TYPE, astNodeArray[n4], typeArray3[n].getDisplayName(), typeArray4[n].getDisplayName(), executableElement2.getEnclosingElement().getDisplayName());
                    return true;
                }
                ++n4;
            }
            for (Map.Entry<String, Type> entry : map2.entrySet()) {
                object4 = map.get(entry.getKey());
                if (object4 == null || entry.getValue().isAssignableTo((Type)object4)) continue;
                object3 = null;
                object2 = null;
                for (int i = 0; i < parameterElementArray.length; ++i) {
                    ParameterElement parameterElement = parameterElementArray[i];
                    if (parameterElement.getParameterKind() != ParameterKind.NAMED || !entry.getKey().equals(parameterElement.getName())) continue;
                    object3 = parameterElement;
                    object2 = astNodeArray[i];
                    break;
                }
                if (object3 == null) continue;
                this.errorReporter.reportErrorForNode(StaticWarningCode.INVALID_METHOD_OVERRIDE_NAMED_PARAM_TYPE, (AstNode)object2, object4.getDisplayName(), entry.getValue().getDisplayName(), executableElement2.getEnclosingElement().getDisplayName());
                return true;
            }
            bl = false;
            object4 = new ArrayList();
            object3 = new ArrayList<ParameterElementImpl>();
            object2 = new ArrayList<ParameterElementImpl>();
            ParameterElement[] parameterElementArray2 = executableElement2.getParameters();
            for (int i = 0; i < parameterElementArray.length; ++i) {
                ParameterElement parameterElement = parameterElementArray[i];
                if (!parameterElement.getParameterKind().isOptional()) continue;
                ((ArrayList)object4).add(astNodeArray[i]);
                ((ArrayList)object3).add((ParameterElementImpl)parameterElement);
            }
            for (ParameterElement object6 : parameterElementArray2) {
                if (!object6.getParameterKind().isOptional() || !(object6 instanceof ParameterElementImpl)) continue;
                ((ArrayList)object2).add((ParameterElementImpl)object6);
            }
            if (((ArrayList)object3).size() <= 0) break block25;
            if (((ParameterElementImpl)((ArrayList)object3).get(0)).getParameterKind() == ParameterKind.NAMED) {
                block10: for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                    ParameterElementImpl parameterElementImpl = (ParameterElementImpl)((ArrayList)object3).get(i);
                    EvaluationResultImpl evaluationResultImpl = parameterElementImpl.getEvaluationResult();
                    if (this.isUserDefinedObject(evaluationResultImpl)) continue;
                    String string = parameterElementImpl.getName();
                    for (int j = 0; j < ((ArrayList)object2).size(); ++j) {
                        ParameterElementImpl parameterElementImpl2 = (ParameterElementImpl)((ArrayList)object2).get(j);
                        String string2 = parameterElementImpl2.getName();
                        if (string == null || !string.equals(string2)) continue;
                        EvaluationResultImpl evaluationResultImpl2 = parameterElementImpl2.getEvaluationResult();
                        if (this.isUserDefinedObject(evaluationResultImpl2)) continue block10;
                        if (evaluationResultImpl.equalValues(this.typeProvider, evaluationResultImpl2)) continue;
                        this.errorReporter.reportErrorForNode(StaticWarningCode.INVALID_OVERRIDE_DIFFERENT_DEFAULT_VALUES_NAMED, (AstNode)((ArrayList)object4).get(i), executableElement2.getEnclosingElement().getDisplayName(), executableElement2.getDisplayName(), string);
                        bl = true;
                    }
                }
            } else {
                for (int i = 0; i < ((ArrayList)object3).size() && i < ((ArrayList)object2).size(); ++i) {
                    ParameterElementImpl parameterElementImpl;
                    EvaluationResultImpl evaluationResultImpl;
                    ParameterElementImpl parameterElementImpl3 = (ParameterElementImpl)((ArrayList)object3).get(i);
                    EvaluationResultImpl evaluationResultImpl3 = parameterElementImpl3.getEvaluationResult();
                    if (this.isUserDefinedObject(evaluationResultImpl3) || this.isUserDefinedObject(evaluationResultImpl = (parameterElementImpl = (ParameterElementImpl)((ArrayList)object2).get(i)).getEvaluationResult()) || evaluationResultImpl3.equalValues(this.typeProvider, evaluationResultImpl)) continue;
                    this.errorReporter.reportErrorForNode(StaticWarningCode.INVALID_OVERRIDE_DIFFERENT_DEFAULT_VALUES_POSITIONAL, (AstNode)((ArrayList)object4).get(i), executableElement2.getEnclosingElement().getDisplayName(), executableElement2.getDisplayName());
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean checkForAllInvalidOverrideErrorCodesForExecutable(ExecutableElement executableElement, ParameterElement[] parameterElementArray, AstNode[] astNodeArray, SimpleIdentifier simpleIdentifier) {
        ExecutableElement executableElement2 = this.inheritanceManager.lookupInheritance(this.enclosingClass, executableElement.getName());
        if (executableElement2 instanceof MultiplyInheritedExecutableElement) {
            MultiplyInheritedExecutableElement multiplyInheritedExecutableElement = (MultiplyInheritedExecutableElement)executableElement2;
            ExecutableElement[] executableElementArray = multiplyInheritedExecutableElement.getInheritedElements();
            for (int i = 0; i < executableElementArray.length; ++i) {
                if (!this.checkForAllInvalidOverrideErrorCodes(executableElement, executableElementArray[i], parameterElementArray, astNodeArray, simpleIdentifier)) continue;
                return true;
            }
            return false;
        }
        return this.checkForAllInvalidOverrideErrorCodes(executableElement, executableElement2, parameterElementArray, astNodeArray, simpleIdentifier);
    }

    private boolean checkForAllInvalidOverrideErrorCodesForField(FieldDeclaration fieldDeclaration) {
        if (this.enclosingClass == null || fieldDeclaration.isStatic()) {
            return false;
        }
        boolean bl = false;
        VariableDeclarationList variableDeclarationList = fieldDeclaration.getFields();
        for (VariableDeclaration variableDeclaration : variableDeclarationList.getVariables()) {
            FieldElement fieldElement = (FieldElement)variableDeclaration.getElement();
            if (fieldElement == null) continue;
            PropertyAccessorElement propertyAccessorElement = fieldElement.getGetter();
            PropertyAccessorElement propertyAccessorElement2 = fieldElement.getSetter();
            SimpleIdentifier simpleIdentifier = variableDeclaration.getName();
            if (propertyAccessorElement != null) {
                bl |= this.checkForAllInvalidOverrideErrorCodesForExecutable(propertyAccessorElement, ParameterElementImpl.EMPTY_ARRAY, AstNode.EMPTY_ARRAY, simpleIdentifier);
            }
            if (propertyAccessorElement2 == null) continue;
            bl |= this.checkForAllInvalidOverrideErrorCodesForExecutable(propertyAccessorElement2, propertyAccessorElement2.getParameters(), new AstNode[]{simpleIdentifier}, simpleIdentifier);
        }
        return bl;
    }

    private boolean checkForAllInvalidOverrideErrorCodesForMethod(MethodDeclaration methodDeclaration) {
        if (this.enclosingClass == null || methodDeclaration.isStatic() || methodDeclaration.getBody() instanceof NativeFunctionBody) {
            return false;
        }
        ExecutableElement executableElement = methodDeclaration.getElement();
        if (executableElement == null) {
            return false;
        }
        SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
        if (simpleIdentifier.isSynthetic()) {
            return false;
        }
        FormalParameterList formalParameterList = methodDeclaration.getParameters();
        NodeList<FormalParameter> nodeList = formalParameterList != null ? formalParameterList.getParameters() : null;
        AstNode[] astNodeArray = nodeList != null ? nodeList.toArray(new AstNode[nodeList.size()]) : null;
        return this.checkForAllInvalidOverrideErrorCodesForExecutable(executableElement, executableElement.getParameters(), astNodeArray, simpleIdentifier);
    }

    private boolean checkForAllMixinErrorCodes(WithClause withClause) {
        if (withClause == null) {
            return false;
        }
        boolean bl = false;
        for (TypeName typeName : withClause.getMixinTypes()) {
            Type type = typeName.getType();
            if (!(type instanceof InterfaceType)) continue;
            if (this.checkForExtendsOrImplementsDisallowedClass(typeName, CompileTimeErrorCode.MIXIN_OF_DISALLOWED_CLASS)) {
                bl = true;
                continue;
            }
            ClassElement classElement = ((InterfaceType)type).getElement();
            bl |= this.checkForMixinDeclaresConstructor(typeName, classElement);
            bl |= this.checkForMixinInheritsNotFromObject(typeName, classElement);
            bl |= this.checkForMixinReferencesSuper(typeName, classElement);
        }
        return bl;
    }

    private boolean checkForAllRedirectConstructorErrorCodes(ConstructorDeclaration constructorDeclaration) {
        FunctionType functionType;
        Type type;
        ConstructorName constructorName = constructorDeclaration.getRedirectedConstructor();
        if (constructorName == null) {
            return false;
        }
        ConstructorElement constructorElement = constructorName.getStaticElement();
        if (constructorElement == null) {
            TypeName typeName = constructorName.getType();
            Type type2 = typeName.getType();
            if (type2 != null && type2.getElement() != null && !type2.isDynamic()) {
                String string = typeName.getName().getName();
                if (constructorName.getName() != null) {
                    string = string + '.' + constructorName.getName().getName();
                }
                Enum enum_ = constructorDeclaration.getConstKeyword() != null ? CompileTimeErrorCode.REDIRECT_TO_MISSING_CONSTRUCTOR : StaticWarningCode.REDIRECT_TO_MISSING_CONSTRUCTOR;
                this.errorReporter.reportErrorForNode((ErrorCode)((Object)enum_), constructorName, new Object[]{string, type2.getDisplayName()});
                return true;
            }
            return false;
        }
        FunctionType functionType2 = constructorElement.getType();
        Type type3 = functionType2.getReturnType();
        if (!type3.isAssignableTo(type = (functionType = constructorDeclaration.getElement().getType()).getReturnType())) {
            this.errorReporter.reportErrorForNode(StaticWarningCode.REDIRECT_TO_INVALID_RETURN_TYPE, constructorName, type3, type);
            return true;
        }
        if (!functionType2.isSubtypeOf(functionType)) {
            this.errorReporter.reportErrorForNode(StaticWarningCode.REDIRECT_TO_INVALID_FUNCTION_TYPE, constructorName, functionType2, functionType);
            return true;
        }
        return false;
    }

    private boolean checkForAllReturnStatementErrorCodes(ReturnStatement returnStatement) {
        boolean bl;
        FunctionType functionType = this.enclosingFunction == null ? null : this.enclosingFunction.getType();
        Type type = functionType == null ? DynamicTypeImpl.getInstance() : functionType.getReturnType();
        Expression expression = returnStatement.getExpression();
        boolean bl2 = bl = this.enclosingFunction instanceof ConstructorElement && !((ConstructorElement)this.enclosingFunction).isFactory();
        if (bl) {
            if (expression == null) {
                return false;
            }
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.RETURN_IN_GENERATIVE_CONSTRUCTOR, expression, new Object[0]);
            return true;
        }
        if (expression == null) {
            if (VoidTypeImpl.getInstance().isAssignableTo(type)) {
                return false;
            }
            this.errorReporter.reportErrorForNode(StaticWarningCode.RETURN_WITHOUT_VALUE, returnStatement, new Object[0]);
            return true;
        }
        return this.checkForReturnOfInvalidType(expression, type);
    }

    private boolean checkForAmbiguousExport(ExportDirective exportDirective, ExportElement exportElement) {
        LibraryElement libraryElement = exportElement.getExportedLibrary();
        if (libraryElement == null) {
            return false;
        }
        Namespace namespace = new NamespaceBuilder().createExportNamespaceForDirective(exportElement);
        Map<String, Element> map = namespace.getDefinedNames();
        for (Map.Entry<String, Element> entry : map.entrySet()) {
            String string = entry.getKey();
            Element element = entry.getValue();
            Element element2 = this.exportedElements.get(string);
            if (element != null && element2 != null && !element2.equals(element)) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.AMBIGUOUS_EXPORT, exportDirective, string, element2.getLibrary().getDefiningCompilationUnit().getDisplayName(), element.getLibrary().getDefiningCompilationUnit().getDisplayName());
                return true;
            }
            this.exportedElements.put(string, element);
        }
        return false;
    }

    private boolean checkForArgumentTypeNotAssignable(Expression expression, Type type, Type type2, ErrorCode errorCode) {
        if (type2 != null && type != null && !type2.isAssignableTo(type)) {
            this.errorReporter.reportErrorForNode(errorCode, expression, type2.getDisplayName(), type.getDisplayName());
            return true;
        }
        return false;
    }

    private boolean checkForArgumentTypeNotAssignableForArgument(Expression expression) {
        if (expression == null) {
            return false;
        }
        ParameterElement parameterElement = expression.getStaticParameterElement();
        Type type = parameterElement == null ? null : parameterElement.getType();
        return this.checkForArgumentTypeNotAssignableWithExpectedTypes(expression, type, StaticWarningCode.ARGUMENT_TYPE_NOT_ASSIGNABLE);
    }

    private boolean checkForArgumentTypeNotAssignableWithExpectedTypes(Expression expression, Type type, ErrorCode errorCode) {
        return this.checkForArgumentTypeNotAssignable(expression, type, this.getStaticType(expression), errorCode);
    }

    private boolean checkForArgumentTypesNotAssignableInList(ArgumentList argumentList) {
        if (argumentList == null) {
            return false;
        }
        boolean bl = false;
        for (Expression expression : argumentList.getArguments()) {
            bl |= this.checkForArgumentTypeNotAssignableForArgument(expression);
        }
        return bl;
    }

    private boolean checkForAssignmentToFinal(Expression expression) {
        Element element;
        Element element2 = null;
        if (expression instanceof Identifier) {
            element2 = ((Identifier)expression).getStaticElement();
        }
        if (expression instanceof PropertyAccess) {
            element2 = ((PropertyAccess)expression).getPropertyName().getStaticElement();
        }
        if (element2 instanceof PropertyAccessorElement) {
            element = (PropertyAccessorElement)element2;
            element2 = element.getVariable();
        }
        if (element2 instanceof VariableElement) {
            element = (VariableElement)element2;
            if (element.isConst()) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.ASSIGNMENT_TO_CONST, expression, new Object[0]);
                return true;
            }
            if (element.isFinal()) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.ASSIGNMENT_TO_FINAL, expression, element.getName());
                return true;
            }
            return false;
        }
        if (element2 instanceof MethodElement) {
            this.errorReporter.reportErrorForNode(StaticWarningCode.ASSIGNMENT_TO_METHOD, expression, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForBuiltInIdentifierAsName(SimpleIdentifier simpleIdentifier, ErrorCode errorCode) {
        Token token = simpleIdentifier.getToken();
        if (token.getType() == TokenType.KEYWORD) {
            this.errorReporter.reportErrorForNode(errorCode, simpleIdentifier, simpleIdentifier.getName());
            return true;
        }
        return false;
    }

    private boolean checkForCaseBlockNotTerminated(SwitchCase switchCase) {
        NodeList<Statement> nodeList = switchCase.getStatements();
        if (nodeList.isEmpty()) {
            SwitchStatement switchStatement;
            NodeList<SwitchMember> nodeList2;
            int n;
            AstNode astNode = switchCase.getParent();
            if (astNode instanceof SwitchStatement && (n = (nodeList2 = (switchStatement = (SwitchStatement)astNode).getMembers()).indexOf(switchCase)) != -1 && n < nodeList2.size() - 1) {
                return false;
            }
        } else {
            Expression expression;
            Statement statement = (Statement)nodeList.get(nodeList.size() - 1);
            if (statement instanceof BreakStatement || statement instanceof ContinueStatement || statement instanceof ReturnStatement) {
                return false;
            }
            if (statement instanceof ExpressionStatement && (expression = ((ExpressionStatement)statement).getExpression()) instanceof ThrowExpression) {
                return false;
            }
        }
        this.errorReporter.reportErrorForToken(StaticWarningCode.CASE_BLOCK_NOT_TERMINATED, switchCase.getKeyword(), new Object[0]);
        return true;
    }

    private boolean checkForCaseBlocksNotTerminated(SwitchStatement switchStatement) {
        boolean bl = false;
        NodeList<SwitchMember> nodeList = switchStatement.getMembers();
        int n = nodeList.size() - 1;
        for (int i = 0; i < n; ++i) {
            SwitchMember switchMember = (SwitchMember)nodeList.get(i);
            if (!(switchMember instanceof SwitchCase)) continue;
            bl |= this.checkForCaseBlockNotTerminated((SwitchCase)switchMember);
        }
        return bl;
    }

    private boolean checkForCaseExpressionTypeImplementsEquals(SwitchStatement switchStatement, Type type) {
        if (!this.implementsEqualsWhenNotAllowed(type)) {
            return false;
        }
        this.errorReporter.reportErrorForToken(CompileTimeErrorCode.CASE_EXPRESSION_TYPE_IMPLEMENTS_EQUALS, switchStatement.getKeyword(), type.getDisplayName());
        return true;
    }

    private boolean checkForConcreteClassWithAbstractMember(MethodDeclaration methodDeclaration) {
        if (methodDeclaration.isAbstract() && this.enclosingClass != null && !this.enclosingClass.isAbstract()) {
            SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
            this.errorReporter.reportErrorForNode(StaticWarningCode.CONCRETE_CLASS_WITH_ABSTRACT_MEMBER, simpleIdentifier, simpleIdentifier.getName(), this.enclosingClass.getDisplayName());
            return true;
        }
        return false;
    }

    private boolean checkForConflictingConstructorNameAndMember(ConstructorDeclaration constructorDeclaration) {
        ConstructorElement[] constructorElementArray;
        ConstructorElement constructorElement = constructorDeclaration.getElement();
        SimpleIdentifier simpleIdentifier = constructorDeclaration.getName();
        String string = constructorElement.getName();
        ClassElement classElement = constructorElement.getEnclosingElement();
        for (ConstructorElement constructorElement2 : constructorElementArray = classElement.getConstructors()) {
            if (constructorElement2 == constructorElement || !ObjectUtilities.equals(string, constructorElement2.getName())) continue;
            if (string == null || string.length() == 0) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.DUPLICATE_CONSTRUCTOR_DEFAULT, constructorDeclaration, new Object[0]);
            } else {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.DUPLICATE_CONSTRUCTOR_NAME, constructorDeclaration, string);
            }
            return true;
        }
        if (simpleIdentifier != null && constructorElement != null && !simpleIdentifier.isSynthetic()) {
            FieldElement fieldElement = classElement.getField(string);
            if (fieldElement != null) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONFLICTING_CONSTRUCTOR_NAME_AND_FIELD, constructorDeclaration, string);
                return true;
            }
            MethodElement methodElement = classElement.getMethod(string);
            if (methodElement != null) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONFLICTING_CONSTRUCTOR_NAME_AND_METHOD, constructorDeclaration, string);
                return true;
            }
        }
        return false;
    }

    private boolean checkForConflictingGetterAndMethod() {
        ExecutableElement executableElement;
        String string;
        if (this.enclosingClass == null) {
            return false;
        }
        boolean bl = false;
        for (MethodElement executableElement2 : this.enclosingClass.getMethods()) {
            string = executableElement2.getName();
            executableElement = this.inheritanceManager.lookupInheritance(this.enclosingClass, string);
            if (!(executableElement instanceof PropertyAccessorElement)) continue;
            bl = true;
            this.errorReporter.reportErrorForOffset(CompileTimeErrorCode.CONFLICTING_GETTER_AND_METHOD, executableElement2.getNameOffset(), string.length(), this.enclosingClass.getDisplayName(), executableElement.getEnclosingElement().getDisplayName(), string);
        }
        for (ExecutableElement executableElement2 : this.enclosingClass.getAccessors()) {
            if (!executableElement2.isGetter() || !((executableElement = this.inheritanceManager.lookupInheritance(this.enclosingClass, string = executableElement2.getName())) instanceof MethodElement)) continue;
            bl = true;
            this.errorReporter.reportErrorForOffset(CompileTimeErrorCode.CONFLICTING_METHOD_AND_GETTER, executableElement2.getNameOffset(), string.length(), this.enclosingClass.getDisplayName(), executableElement.getEnclosingElement().getDisplayName(), string);
        }
        return bl;
    }

    private boolean checkForConflictingInstanceGetterAndSuperclassMember() {
        if (this.enclosingClass == null) {
            return false;
        }
        InterfaceType interfaceType = this.enclosingClass.getType();
        boolean bl = false;
        for (PropertyAccessorElement propertyAccessorElement : this.enclosingClass.getAccessors()) {
            if (propertyAccessorElement.isStatic()) continue;
            String string = propertyAccessorElement.getDisplayName();
            boolean bl2 = propertyAccessorElement.isGetter();
            if (propertyAccessorElement.isSetter() && propertyAccessorElement.isSynthetic()) continue;
            ExecutableElement executableElement = interfaceType.lookUpGetterInSuperclass(string, this.currentLibrary);
            if (executableElement == null) {
                executableElement = interfaceType.lookUpSetterInSuperclass(string, this.currentLibrary);
            }
            if (executableElement == null) {
                executableElement = interfaceType.lookUpMethodInSuperclass(string, this.currentLibrary);
            }
            if (executableElement == null || !executableElement.isStatic()) continue;
            ClassElement classElement = (ClassElement)executableElement.getEnclosingElement();
            InterfaceType interfaceType2 = classElement.getType();
            bl = true;
            if (bl2) {
                this.errorReporter.reportErrorForElement(StaticWarningCode.CONFLICTING_INSTANCE_GETTER_AND_SUPERCLASS_MEMBER, propertyAccessorElement, interfaceType2.getDisplayName());
                continue;
            }
            this.errorReporter.reportErrorForElement(StaticWarningCode.CONFLICTING_INSTANCE_SETTER_AND_SUPERCLASS_MEMBER, propertyAccessorElement, interfaceType2.getDisplayName());
        }
        return bl;
    }

    private boolean checkForConflictingInstanceMethodSetter(ClassDeclaration classDeclaration) {
        NodeList<ClassMember> nodeList = classDeclaration.getMembers();
        if (nodeList.isEmpty()) {
            return false;
        }
        boolean bl = false;
        HashMap<String, MethodDeclaration> hashMap = new HashMap<String, MethodDeclaration>(nodeList.size());
        for (ClassMember classMember : nodeList) {
            Object object;
            String string;
            boolean bl2;
            SimpleIdentifier simpleIdentifier;
            MethodDeclaration methodDeclaration;
            if (!(classMember instanceof MethodDeclaration) || (methodDeclaration = (MethodDeclaration)classMember).isStatic() || (simpleIdentifier = methodDeclaration.getName()) == null) continue;
            boolean bl3 = true;
            boolean bl4 = methodDeclaration.isGetter();
            boolean bl5 = methodDeclaration.isSetter();
            boolean bl6 = methodDeclaration.isOperator();
            boolean bl7 = bl2 = !bl4 && !bl5 && !bl6;
            if (bl2) {
                string = simpleIdentifier.getName() + "=";
                object = null;
                ClassMember classMember2 = (ClassMember)hashMap.get(string);
                if (classMember2 != null) {
                    object = classMember2.getElement().getEnclosingElement();
                } else {
                    ExecutableElement executableElement = this.inheritanceManager.lookupInheritance(this.enclosingClass, string);
                    if (executableElement != null) {
                        object = executableElement.getEnclosingElement();
                    }
                }
                if (object != null) {
                    this.errorReporter.reportErrorForNode(StaticWarningCode.CONFLICTING_INSTANCE_METHOD_SETTER, simpleIdentifier, this.enclosingClass.getDisplayName(), simpleIdentifier.getName(), object.getDisplayName());
                    bl |= true;
                    bl3 = false;
                }
            } else if (bl5 && (object = (ClassMember)hashMap.get(string = simpleIdentifier.getName())) != null && object instanceof MethodDeclaration && !((MethodDeclaration)object).isGetter()) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.CONFLICTING_INSTANCE_METHOD_SETTER2, simpleIdentifier, this.enclosingClass.getDisplayName(), simpleIdentifier.getName());
                bl |= true;
                bl3 = false;
            }
            if (!bl3) continue;
            if (methodDeclaration.isSetter()) {
                hashMap.put(simpleIdentifier.getName() + "=", methodDeclaration);
                continue;
            }
            hashMap.put(simpleIdentifier.getName(), methodDeclaration);
        }
        return bl;
    }

    private boolean checkForConflictingStaticGetterAndInstanceSetter(MethodDeclaration methodDeclaration) {
        if (!methodDeclaration.isStatic()) {
            return false;
        }
        SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
        if (simpleIdentifier == null) {
            return false;
        }
        String string = simpleIdentifier.getName();
        if (this.enclosingClass == null) {
            return false;
        }
        InterfaceType interfaceType = this.enclosingClass.getType();
        PropertyAccessorElement propertyAccessorElement = interfaceType.lookUpSetter(string, this.currentLibrary);
        if (propertyAccessorElement == null) {
            return false;
        }
        if (propertyAccessorElement.isStatic()) {
            return false;
        }
        ClassElement classElement = (ClassElement)propertyAccessorElement.getEnclosingElement();
        InterfaceType interfaceType2 = classElement.getType();
        this.errorReporter.reportErrorForNode(StaticWarningCode.CONFLICTING_STATIC_GETTER_AND_INSTANCE_SETTER, simpleIdentifier, interfaceType2.getDisplayName());
        return true;
    }

    private boolean checkForConflictingStaticSetterAndInstanceMember(MethodDeclaration methodDeclaration) {
        if (!methodDeclaration.isStatic()) {
            return false;
        }
        SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
        if (simpleIdentifier == null) {
            return false;
        }
        String string = simpleIdentifier.getName();
        if (this.enclosingClass == null) {
            return false;
        }
        InterfaceType interfaceType = this.enclosingClass.getType();
        ExecutableElement executableElement = interfaceType.lookUpMethod(string, this.currentLibrary);
        if (executableElement == null) {
            executableElement = interfaceType.lookUpGetter(string, this.currentLibrary);
        }
        if (executableElement == null) {
            executableElement = interfaceType.lookUpSetter(string, this.currentLibrary);
        }
        if (executableElement == null) {
            return false;
        }
        if (executableElement.isStatic()) {
            return false;
        }
        ClassElement classElement = (ClassElement)executableElement.getEnclosingElement();
        InterfaceType interfaceType2 = classElement.getType();
        this.errorReporter.reportErrorForNode(StaticWarningCode.CONFLICTING_STATIC_SETTER_AND_INSTANCE_MEMBER, simpleIdentifier, interfaceType2.getDisplayName());
        return true;
    }

    private boolean checkForConflictingTypeVariableErrorCodes(ClassDeclaration classDeclaration) {
        boolean bl = false;
        for (TypeParameterElement typeParameterElement : this.enclosingClass.getTypeParameters()) {
            String string = typeParameterElement.getName();
            if (this.enclosingClass.getName().equals(string)) {
                this.errorReporter.reportErrorForOffset(CompileTimeErrorCode.CONFLICTING_TYPE_VARIABLE_AND_CLASS, typeParameterElement.getNameOffset(), string.length(), string);
                bl = true;
            }
            if (this.enclosingClass.getMethod(string) == null && this.enclosingClass.getGetter(string) == null && this.enclosingClass.getSetter(string) == null) continue;
            this.errorReporter.reportErrorForOffset(CompileTimeErrorCode.CONFLICTING_TYPE_VARIABLE_AND_MEMBER, typeParameterElement.getNameOffset(), string.length(), string);
            bl = true;
        }
        return bl;
    }

    private boolean checkForConstConstructorWithNonConstSuper(ConstructorDeclaration constructorDeclaration) {
        if (!this.isEnclosingConstructorConst) {
            return false;
        }
        if (constructorDeclaration.getFactoryKeyword() != null) {
            return false;
        }
        for (ConstructorInitializer object2 : constructorDeclaration.getInitializers()) {
            if (!(object2 instanceof SuperConstructorInvocation)) continue;
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)object2;
            ConstructorElement constructorElement = superConstructorInvocation.getStaticElement();
            if (constructorElement == null || constructorElement.isConst()) {
                return false;
            }
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_CONSTRUCTOR_WITH_NON_CONST_SUPER, superConstructorInvocation, new Object[0]);
            return true;
        }
        InterfaceType interfaceType = this.enclosingClass.getSupertype();
        if (interfaceType == null) {
            return false;
        }
        if (interfaceType.isObject()) {
            return false;
        }
        ConstructorElement constructorElement = interfaceType.getElement().getUnnamedConstructor();
        if (constructorElement == null) {
            return false;
        }
        if (constructorElement.isConst()) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_CONSTRUCTOR_WITH_NON_CONST_SUPER, constructorDeclaration.getReturnType(), new Object[0]);
        return true;
    }

    private boolean checkForConstConstructorWithNonFinalField(ConstructorDeclaration constructorDeclaration) {
        if (!this.isEnclosingConstructorConst) {
            return false;
        }
        ConstructorElement constructorElement = constructorDeclaration.getElement();
        ClassElement classElement = constructorElement.getEnclosingElement();
        if (!classElement.hasNonFinalField()) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_CONSTRUCTOR_WITH_NON_FINAL_FIELD, constructorDeclaration, new Object[0]);
        return true;
    }

    private boolean checkForConstEvalThrowsException(ThrowExpression throwExpression) {
        if (this.isEnclosingConstructorConst) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_CONSTRUCTOR_THROWS_EXCEPTION, throwExpression, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForConstFormalParameter(NormalFormalParameter normalFormalParameter) {
        if (normalFormalParameter.isConst()) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_FORMAL_PARAMETER, normalFormalParameter, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForConstMapKeyExpressionTypeImplementsEquals(MapLiteral mapLiteral) {
        if (mapLiteral.getConstKeyword() == null) {
            return false;
        }
        boolean bl = false;
        for (MapLiteralEntry mapLiteralEntry : mapLiteral.getEntries()) {
            Expression expression = mapLiteralEntry.getKey();
            Type type = expression.getStaticType();
            if (!this.implementsEqualsWhenNotAllowed(type)) continue;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_MAP_KEY_EXPRESSION_TYPE_IMPLEMENTS_EQUALS, expression, type.getDisplayName());
            bl = true;
        }
        return bl;
    }

    private boolean checkForConstOrNewWithAbstractClass(InstanceCreationExpression instanceCreationExpression, TypeName typeName, InterfaceType interfaceType) {
        ConstructorElement constructorElement;
        if (interfaceType.getElement().isAbstract() && (constructorElement = instanceCreationExpression.getStaticElement()) != null && !constructorElement.isFactory()) {
            if (((KeywordToken)instanceCreationExpression.getKeyword()).getKeyword() == Keyword.CONST) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.CONST_WITH_ABSTRACT_CLASS, typeName, new Object[0]);
            } else {
                this.errorReporter.reportErrorForNode(StaticWarningCode.NEW_WITH_ABSTRACT_CLASS, typeName, new Object[0]);
            }
            return true;
        }
        return false;
    }

    private boolean checkForConstWithNonConst(InstanceCreationExpression instanceCreationExpression) {
        ConstructorElement constructorElement = instanceCreationExpression.getStaticElement();
        if (constructorElement != null && !constructorElement.isConst()) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_WITH_NON_CONST, instanceCreationExpression, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForConstWithTypeParameters(TypeName typeName) {
        TypeArgumentList typeArgumentList;
        if (typeName == null) {
            return false;
        }
        Identifier identifier = typeName.getName();
        if (identifier == null) {
            return false;
        }
        if (identifier.getStaticElement() instanceof TypeParameterElement) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_WITH_TYPE_PARAMETERS, identifier, new Object[0]);
        }
        if ((typeArgumentList = typeName.getTypeArguments()) != null) {
            boolean bl = false;
            for (TypeName typeName2 : typeArgumentList.getArguments()) {
                bl |= this.checkForConstWithTypeParameters(typeName2);
            }
            return bl;
        }
        return false;
    }

    private boolean checkForConstWithTypeParametersInCreation(InstanceCreationExpression instanceCreationExpression) {
        ConstructorName constructorName = instanceCreationExpression.getConstructorName();
        if (constructorName == null) {
            return false;
        }
        TypeName typeName = constructorName.getType();
        return this.checkForConstWithTypeParameters(typeName);
    }

    private boolean checkForConstWithUndefinedConstructor(InstanceCreationExpression instanceCreationExpression) {
        if (instanceCreationExpression.getStaticElement() != null) {
            return false;
        }
        ConstructorName constructorName = instanceCreationExpression.getConstructorName();
        if (constructorName == null) {
            return false;
        }
        TypeName typeName = constructorName.getType();
        if (typeName == null) {
            return false;
        }
        Identifier identifier = typeName.getName();
        SimpleIdentifier simpleIdentifier = constructorName.getName();
        if (simpleIdentifier != null) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_WITH_UNDEFINED_CONSTRUCTOR, simpleIdentifier, identifier, simpleIdentifier);
        } else {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_WITH_UNDEFINED_CONSTRUCTOR_DEFAULT, constructorName, identifier);
        }
        return true;
    }

    private boolean checkForDefaultValueInFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        boolean bl = false;
        FormalParameterList formalParameterList = functionTypeAlias.getParameters();
        NodeList<FormalParameter> nodeList = formalParameterList.getParameters();
        for (FormalParameter formalParameter : nodeList) {
            DefaultFormalParameter defaultFormalParameter;
            if (!(formalParameter instanceof DefaultFormalParameter) || (defaultFormalParameter = (DefaultFormalParameter)formalParameter).getDefaultValue() == null) continue;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.DEFAULT_VALUE_IN_FUNCTION_TYPE_ALIAS, functionTypeAlias, new Object[0]);
            bl = true;
        }
        return bl;
    }

    private boolean checkForDefaultValueInFunctionTypedParameter(DefaultFormalParameter defaultFormalParameter) {
        if (!this.isInFunctionTypedFormalParameter) {
            return false;
        }
        if (defaultFormalParameter.getDefaultValue() == null) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.DEFAULT_VALUE_IN_FUNCTION_TYPED_PARAMETER, defaultFormalParameter, new Object[0]);
        return true;
    }

    private boolean checkForDuplicateDefinitionInheritance() {
        if (this.enclosingClass == null) {
            return false;
        }
        boolean bl = false;
        for (MethodElement executableElement : this.enclosingClass.getMethods()) {
            if (!executableElement.isStatic()) continue;
            bl |= this.checkForDuplicateDefinitionOfMember(executableElement);
        }
        for (ExecutableElement executableElement : this.enclosingClass.getAccessors()) {
            if (!executableElement.isStatic()) continue;
            bl |= this.checkForDuplicateDefinitionOfMember(executableElement);
        }
        return bl;
    }

    private boolean checkForDuplicateDefinitionOfMember(ExecutableElement executableElement) {
        String string = executableElement.getName();
        if (string == null) {
            return false;
        }
        ExecutableElement executableElement2 = this.inheritanceManager.lookupInheritance(this.enclosingClass, string);
        if (executableElement2 == null) {
            return false;
        }
        if (executableElement2.isStatic()) {
            return false;
        }
        this.errorReporter.reportErrorForOffset(CompileTimeErrorCode.DUPLICATE_DEFINITION_INHERITANCE, executableElement.getNameOffset(), string.length(), string, executableElement2.getEnclosingElement().getDisplayName());
        return true;
    }

    private boolean checkForExpectedOneListTypeArgument(ListLiteral listLiteral) {
        TypeArgumentList typeArgumentList = listLiteral.getTypeArguments();
        if (typeArgumentList == null) {
            return false;
        }
        int n = typeArgumentList.getArguments().size();
        if (n == 1) {
            return false;
        }
        this.errorReporter.reportErrorForNode(StaticTypeWarningCode.EXPECTED_ONE_LIST_TYPE_ARGUMENTS, typeArgumentList, n);
        return true;
    }

    private boolean checkForExportDuplicateLibraryName(ExportDirective exportDirective, ExportElement exportElement) {
        LibraryElement libraryElement = exportElement.getExportedLibrary();
        if (libraryElement == null) {
            return false;
        }
        String string = libraryElement.getName();
        LibraryElement libraryElement2 = this.nameToExportElement.get(string);
        if (libraryElement2 != null) {
            if (!libraryElement2.equals(libraryElement)) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.EXPORT_DUPLICATED_LIBRARY_NAME, exportDirective, libraryElement2.getDefiningCompilationUnit().getDisplayName(), libraryElement.getDefiningCompilationUnit().getDisplayName(), string);
                return true;
            }
        } else {
            this.nameToExportElement.put(string, libraryElement);
        }
        return false;
    }

    private boolean checkForExportInternalLibrary(ExportDirective exportDirective, ExportElement exportElement) {
        String string;
        if (this.isInSystemLibrary) {
            return false;
        }
        DartSdk dartSdk = this.currentLibrary.getContext().getSourceFactory().getDartSdk();
        SdkLibrary sdkLibrary = dartSdk.getSdkLibrary(string = exportElement.getUri());
        if (sdkLibrary == null) {
            return false;
        }
        if (!sdkLibrary.isInternal()) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.EXPORT_INTERNAL_LIBRARY, exportDirective, exportDirective.getUri());
        return true;
    }

    private boolean checkForExtendsDisallowedClass(ExtendsClause extendsClause) {
        if (extendsClause == null) {
            return false;
        }
        return this.checkForExtendsOrImplementsDisallowedClass(extendsClause.getSuperclass(), CompileTimeErrorCode.EXTENDS_DISALLOWED_CLASS);
    }

    private boolean checkForExtendsDisallowedClassInTypeAlias(ClassTypeAlias classTypeAlias) {
        if (classTypeAlias == null) {
            return false;
        }
        return this.checkForExtendsOrImplementsDisallowedClass(classTypeAlias.getSuperclass(), CompileTimeErrorCode.EXTENDS_DISALLOWED_CLASS);
    }

    private boolean checkForExtendsOrImplementsDisallowedClass(TypeName typeName, ErrorCode errorCode) {
        if (typeName.isSynthetic()) {
            return false;
        }
        Type type = typeName.getType();
        for (InterfaceType interfaceType : this.DISALLOWED_TYPES_TO_EXTEND_OR_IMPLEMENT) {
            ClassElement classElement;
            InterfaceType interfaceType2;
            AstNode astNode;
            if (type == null || !type.equals(interfaceType)) continue;
            if (type.equals(this.typeProvider.getNumType()) && (astNode = typeName.getParent().getParent()) instanceof ClassDeclaration && (interfaceType2 = (classElement = ((ClassDeclaration)astNode).getElement()).getType()) != null && (interfaceType2.equals(this.intType) || interfaceType2.equals(this.typeProvider.getDoubleType()))) {
                return false;
            }
            this.errorReporter.reportErrorForNode(errorCode, typeName, interfaceType.getDisplayName());
            return true;
        }
        return false;
    }

    private boolean checkForFieldInitializerNotAssignable(ConstructorFieldInitializer constructorFieldInitializer) {
        Element element = constructorFieldInitializer.getFieldName().getStaticElement();
        if (!(element instanceof FieldElement)) {
            return false;
        }
        FieldElement fieldElement = (FieldElement)element;
        Type type = fieldElement.getType();
        Expression expression = constructorFieldInitializer.getExpression();
        if (expression == null) {
            return false;
        }
        Type type2 = this.getStaticType(expression);
        if (type2 == null) {
            return false;
        }
        if (type2.isAssignableTo(type)) {
            return false;
        }
        if (this.isEnclosingConstructorConst) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_FIELD_INITIALIZER_NOT_ASSIGNABLE, expression, type2.getDisplayName(), type.getDisplayName());
        } else {
            this.errorReporter.reportErrorForNode(StaticWarningCode.FIELD_INITIALIZER_NOT_ASSIGNABLE, expression, type2.getDisplayName(), type.getDisplayName());
        }
        return true;
    }

    private boolean checkForFieldInitializingFormalRedirectingConstructor(FieldFormalParameter fieldFormalParameter) {
        ConstructorDeclaration constructorDeclaration = fieldFormalParameter.getAncestor(ConstructorDeclaration.class);
        if (constructorDeclaration == null) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.FIELD_INITIALIZER_OUTSIDE_CONSTRUCTOR, fieldFormalParameter, new Object[0]);
            return true;
        }
        if (constructorDeclaration.getFactoryKeyword() != null) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.FIELD_INITIALIZER_FACTORY_CONSTRUCTOR, fieldFormalParameter, new Object[0]);
            return true;
        }
        for (ConstructorInitializer constructorInitializer : constructorDeclaration.getInitializers()) {
            if (!(constructorInitializer instanceof RedirectingConstructorInvocation)) continue;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.FIELD_INITIALIZER_REDIRECTING_CONSTRUCTOR, fieldFormalParameter, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForFinalNotInitialized(VariableDeclarationList variableDeclarationList) {
        if (this.isInNativeClass) {
            return false;
        }
        boolean bl = false;
        if (!variableDeclarationList.isSynthetic()) {
            NodeList<VariableDeclaration> nodeList = variableDeclarationList.getVariables();
            for (VariableDeclaration variableDeclaration : nodeList) {
                if (variableDeclaration.getInitializer() != null) continue;
                if (variableDeclarationList.isConst()) {
                    this.errorReporter.reportErrorForNode(CompileTimeErrorCode.CONST_NOT_INITIALIZED, variableDeclaration.getName(), variableDeclaration.getName().getName());
                } else if (variableDeclarationList.isFinal()) {
                    this.errorReporter.reportErrorForNode(StaticWarningCode.FINAL_NOT_INITIALIZED, variableDeclaration.getName(), variableDeclaration.getName().getName());
                }
                bl = true;
            }
        }
        return bl;
    }

    private boolean checkForFinalNotInitializedInClass(ClassDeclaration classDeclaration) {
        NodeList<ClassMember> nodeList = classDeclaration.getMembers();
        for (ClassMember object : nodeList) {
            if (!(object instanceof ConstructorDeclaration)) continue;
            return false;
        }
        boolean bl = false;
        for (ClassMember classMember : nodeList) {
            if (!(classMember instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)classMember;
            bl |= this.checkForFinalNotInitialized(fieldDeclaration.getFields());
        }
        return bl;
    }

    private boolean checkForImplementsDisallowedClass(ImplementsClause implementsClause) {
        if (implementsClause == null) {
            return false;
        }
        boolean bl = false;
        for (TypeName typeName : implementsClause.getInterfaces()) {
            bl |= this.checkForExtendsOrImplementsDisallowedClass(typeName, CompileTimeErrorCode.IMPLEMENTS_DISALLOWED_CLASS);
        }
        return bl;
    }

    private boolean checkForImplicitThisReferenceInInitializer(SimpleIdentifier simpleIdentifier) {
        Expression expression;
        if (!(this.isInConstructorInitializer || this.isInStaticMethod || this.isInInstanceVariableInitializer || this.isInStaticVariableDeclaration)) {
            return false;
        }
        Element element = simpleIdentifier.getStaticElement();
        if (!(element instanceof MethodElement) && !(element instanceof PropertyAccessorElement)) {
            return false;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.isStatic()) {
            return false;
        }
        Element element2 = element.getEnclosingElement();
        if (!(element2 instanceof ClassElement)) {
            return false;
        }
        AstNode astNode = simpleIdentifier.getParent();
        if (astNode instanceof CommentReference) {
            return false;
        }
        if (astNode instanceof MethodInvocation && ((MethodInvocation)(expression = (MethodInvocation)astNode)).getMethodName() == simpleIdentifier && ((MethodInvocation)expression).getRealTarget() != null) {
            return false;
        }
        if (astNode instanceof PropertyAccess && ((PropertyAccess)(expression = (PropertyAccess)astNode)).getPropertyName() == simpleIdentifier && ((PropertyAccess)expression).getRealTarget() != null) {
            return false;
        }
        if (astNode instanceof PrefixedIdentifier && ((PrefixedIdentifier)(expression = (PrefixedIdentifier)astNode)).getIdentifier() == simpleIdentifier) {
            return false;
        }
        if (this.isInStaticMethod) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INSTANCE_MEMBER_ACCESS_FROM_STATIC, simpleIdentifier, new Object[0]);
        } else {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.IMPLICIT_THIS_REFERENCE_IN_INITIALIZER, simpleIdentifier, new Object[0]);
        }
        return true;
    }

    private boolean checkForImportDuplicateLibraryName(ImportDirective importDirective, ImportElement importElement) {
        LibraryElement libraryElement = importElement.getImportedLibrary();
        if (libraryElement == null) {
            return false;
        }
        String string = libraryElement.getName();
        LibraryElement libraryElement2 = this.nameToImportElement.get(string);
        if (libraryElement2 != null) {
            if (!libraryElement2.equals(libraryElement)) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.IMPORT_DUPLICATED_LIBRARY_NAME, importDirective, libraryElement2.getDefiningCompilationUnit().getDisplayName(), libraryElement.getDefiningCompilationUnit().getDisplayName(), string);
                return true;
            }
        } else {
            this.nameToImportElement.put(string, libraryElement);
        }
        return false;
    }

    private boolean checkForImportInternalLibrary(ImportDirective importDirective, ImportElement importElement) {
        String string;
        if (this.isInSystemLibrary) {
            return false;
        }
        DartSdk dartSdk = this.currentLibrary.getContext().getSourceFactory().getDartSdk();
        SdkLibrary sdkLibrary = dartSdk.getSdkLibrary(string = importElement.getUri());
        if (sdkLibrary == null) {
            return false;
        }
        if (!sdkLibrary.isInternal()) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.IMPORT_INTERNAL_LIBRARY, importDirective, importDirective.getUri());
        return true;
    }

    private boolean checkForInconsistentCaseExpressionTypes(SwitchStatement switchStatement) {
        NodeList<SwitchMember> nodeList = switchStatement.getMembers();
        boolean bl = false;
        Type type = null;
        for (SwitchMember switchMember : nodeList) {
            if (!(switchMember instanceof SwitchCase)) continue;
            SwitchCase switchCase = (SwitchCase)switchMember;
            Expression expression = switchCase.getExpression();
            if (type == null) {
                type = expression.getBestType();
                continue;
            }
            Type type2 = expression.getBestType();
            if (type.equals(type2)) continue;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INCONSISTENT_CASE_EXPRESSION_TYPES, expression, expression.toSource(), type.getDisplayName());
            bl = true;
        }
        if (!bl) {
            this.checkForCaseExpressionTypeImplementsEquals(switchStatement, type);
        }
        return bl;
    }

    private boolean checkForInconsistentMethodInheritance() {
        this.inheritanceManager.getMapOfMembersInheritedFromInterfaces(this.enclosingClass);
        HashSet<AnalysisError> hashSet = this.inheritanceManager.getErrors(this.enclosingClass);
        if (hashSet == null || hashSet.isEmpty()) {
            return false;
        }
        for (AnalysisError analysisError : hashSet) {
            this.errorReporter.reportError(analysisError);
        }
        return true;
    }

    private boolean checkForInstanceAccessToStaticMember(ClassElement classElement, SimpleIdentifier simpleIdentifier) {
        if (this.isInComment) {
            return false;
        }
        if (classElement != null) {
            return false;
        }
        Element element = simpleIdentifier.getStaticElement();
        if (!(element instanceof ExecutableElement)) {
            return false;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (!(executableElement.getEnclosingElement() instanceof ClassElement)) {
            return false;
        }
        if (!executableElement.isStatic()) {
            return false;
        }
        this.errorReporter.reportErrorForNode(StaticTypeWarningCode.INSTANCE_ACCESS_TO_STATIC_MEMBER, simpleIdentifier, simpleIdentifier.getName());
        return true;
    }

    private boolean checkForIntNotAssignable(Expression expression) {
        if (expression == null) {
            return false;
        }
        ParameterElement parameterElement = expression.getStaticParameterElement();
        Type type = parameterElement == null ? null : parameterElement.getType();
        return this.checkForArgumentTypeNotAssignable(expression, type, this.intType, StaticWarningCode.ARGUMENT_TYPE_NOT_ASSIGNABLE);
    }

    private boolean checkForInvalidAssignment(Expression expression, Expression expression2) {
        if (expression == null || expression2 == null) {
            return false;
        }
        VariableElement variableElement = this.getVariableElement(expression);
        Type type = variableElement == null ? this.getStaticType(expression) : variableElement.getType();
        Type type2 = this.getStaticType(expression2);
        boolean bl = type2.isAssignableTo(type);
        if (!bl) {
            String string;
            String string2 = type.getDisplayName();
            if (string2.equals(string = type2.getDisplayName())) {
                string2 = this.getExtendedDisplayName(type);
                string = this.getExtendedDisplayName(type2);
            }
            this.errorReporter.reportErrorForNode(StaticTypeWarningCode.INVALID_ASSIGNMENT, expression2, string, string2);
            return true;
        }
        return false;
    }

    private boolean checkForInvalidCompoundAssignment(AssignmentExpression assignmentExpression) {
        Expression expression = assignmentExpression.getLeftHandSide();
        if (expression == null) {
            return false;
        }
        VariableElement variableElement = this.getVariableElement(expression);
        Type type = variableElement == null ? this.getStaticType(expression) : variableElement.getType();
        MethodElement methodElement = assignmentExpression.getStaticElement();
        if (methodElement == null) {
            return false;
        }
        Type type2 = methodElement.getType().getReturnType();
        if (type == null || type2 == null) {
            return false;
        }
        if (!type2.isAssignableTo(type)) {
            String string;
            String string2 = type.getDisplayName();
            if (string2.equals(string = type2.getDisplayName())) {
                string2 = this.getExtendedDisplayName(type);
                string = this.getExtendedDisplayName(type2);
            }
            this.errorReporter.reportErrorForNode(StaticTypeWarningCode.INVALID_ASSIGNMENT, assignmentExpression.getRightHandSide(), string, string2);
            return true;
        }
        return false;
    }

    private void checkForInvalidField(ConstructorFieldInitializer constructorFieldInitializer) {
        SimpleIdentifier simpleIdentifier = constructorFieldInitializer.getFieldName();
        Element element = simpleIdentifier.getStaticElement();
        if (element instanceof FieldElement) {
            FieldElement fieldElement = (FieldElement)element;
            if (fieldElement.isSynthetic()) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INITIALIZER_FOR_NON_EXISTANT_FIELD, constructorFieldInitializer, simpleIdentifier);
            } else if (fieldElement.isStatic()) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INITIALIZER_FOR_STATIC_FIELD, constructorFieldInitializer, simpleIdentifier);
            }
        } else {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INITIALIZER_FOR_NON_EXISTANT_FIELD, constructorFieldInitializer, simpleIdentifier);
            return;
        }
    }

    private boolean checkForInvalidReferenceToThis(ThisExpression thisExpression) {
        if (!this.isThisInValidContext(thisExpression)) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INVALID_REFERENCE_TO_THIS, thisExpression, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForInvalidTypeArgumentInConstTypedLiteral(NodeList<TypeName> nodeList, ErrorCode errorCode) {
        boolean bl = false;
        for (TypeName typeName : nodeList) {
            if (!(typeName.getType() instanceof TypeParameterType)) continue;
            this.errorReporter.reportErrorForNode(errorCode, typeName, typeName.getName());
            bl = true;
        }
        return bl;
    }

    private boolean checkForListElementTypeNotAssignable(ListLiteral listLiteral) {
        TypeArgumentList typeArgumentList = listLiteral.getTypeArguments();
        if (typeArgumentList == null) {
            return false;
        }
        NodeList<TypeName> nodeList = typeArgumentList.getArguments();
        if (nodeList.size() < 1) {
            return false;
        }
        Type type = ((TypeName)nodeList.get(0)).getType();
        Enum enum_ = listLiteral.getConstKeyword() != null ? CompileTimeErrorCode.LIST_ELEMENT_TYPE_NOT_ASSIGNABLE : StaticWarningCode.LIST_ELEMENT_TYPE_NOT_ASSIGNABLE;
        boolean bl = false;
        for (Expression expression : listLiteral.getElements()) {
            bl |= this.checkForArgumentTypeNotAssignableWithExpectedTypes(expression, type, (ErrorCode)((Object)enum_));
        }
        return bl;
    }

    private boolean checkForMapTypeNotAssignable(MapLiteral mapLiteral) {
        Enum enum_;
        Enum enum_2;
        TypeArgumentList typeArgumentList = mapLiteral.getTypeArguments();
        if (typeArgumentList == null) {
            return false;
        }
        NodeList<TypeName> nodeList = typeArgumentList.getArguments();
        if (nodeList.size() < 2) {
            return false;
        }
        Type type = ((TypeName)nodeList.get(0)).getType();
        Type type2 = ((TypeName)nodeList.get(1)).getType();
        if (mapLiteral.getConstKeyword() != null) {
            enum_2 = CompileTimeErrorCode.MAP_KEY_TYPE_NOT_ASSIGNABLE;
            enum_ = CompileTimeErrorCode.MAP_VALUE_TYPE_NOT_ASSIGNABLE;
        } else {
            enum_2 = StaticWarningCode.MAP_KEY_TYPE_NOT_ASSIGNABLE;
            enum_ = StaticWarningCode.MAP_VALUE_TYPE_NOT_ASSIGNABLE;
        }
        boolean bl = false;
        NodeList<MapLiteralEntry> nodeList2 = mapLiteral.getEntries();
        for (MapLiteralEntry mapLiteralEntry : nodeList2) {
            Expression expression = mapLiteralEntry.getKey();
            Expression expression2 = mapLiteralEntry.getValue();
            bl |= this.checkForArgumentTypeNotAssignableWithExpectedTypes(expression, type, (ErrorCode)((Object)enum_2));
            bl |= this.checkForArgumentTypeNotAssignableWithExpectedTypes(expression2, type2, (ErrorCode)((Object)enum_));
        }
        return bl;
    }

    private boolean checkForMemberWithClassName() {
        if (this.enclosingClass == null) {
            return false;
        }
        String string = this.enclosingClass.getName();
        if (string == null) {
            return false;
        }
        boolean bl = false;
        for (PropertyAccessorElement propertyAccessorElement : this.enclosingClass.getAccessors()) {
            if (!string.equals(propertyAccessorElement.getName())) continue;
            this.errorReporter.reportErrorForOffset(CompileTimeErrorCode.MEMBER_WITH_CLASS_NAME, propertyAccessorElement.getNameOffset(), string.length(), new Object[0]);
            bl = true;
        }
        return bl;
    }

    private boolean checkForMismatchedAccessorTypes(Declaration declaration, String string) {
        Object object;
        Object object2;
        ExecutableElement executableElement = (ExecutableElement)declaration.getElement();
        if (!(executableElement instanceof PropertyAccessorElement)) {
            return false;
        }
        PropertyAccessorElement propertyAccessorElement = (PropertyAccessorElement)executableElement;
        PropertyAccessorElement propertyAccessorElement2 = null;
        ClassElement classElement = null;
        if (propertyAccessorElement.isGetter()) {
            propertyAccessorElement2 = propertyAccessorElement.getCorrespondingSetter();
        } else {
            propertyAccessorElement2 = propertyAccessorElement.getCorrespondingGetter();
            if (propertyAccessorElement2 != null && propertyAccessorElement2.getEnclosingElement() == propertyAccessorElement.getEnclosingElement()) {
                return false;
            }
        }
        if (propertyAccessorElement2 == null) {
            if (this.enclosingClass != null && (object2 = this.inheritanceManager.lookupInheritance(this.enclosingClass, (String)(object = StringUtilities.endsWithChar((String)(object = propertyAccessorElement.getName()), 61) ? ((String)object).substring(0, ((String)object).length() - 1) : (String)object + "="))) != null && object2 instanceof PropertyAccessorElement) {
                classElement = (ClassElement)object2.getEnclosingElement();
                propertyAccessorElement2 = (PropertyAccessorElement)object2;
            }
            if (propertyAccessorElement2 == null) {
                return false;
            }
        }
        object = null;
        object2 = null;
        if (propertyAccessorElement.isGetter()) {
            object = this.getGetterType(propertyAccessorElement);
            object2 = this.getSetterType(propertyAccessorElement2);
        } else if (propertyAccessorElement.isSetter()) {
            object2 = this.getSetterType(propertyAccessorElement);
            object = this.getGetterType(propertyAccessorElement2);
        }
        if (object2 != null && object != null && !object.isAssignableTo((Type)object2)) {
            if (classElement == null) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.MISMATCHED_GETTER_AND_SETTER_TYPES, declaration, string, object2.getDisplayName(), object.getDisplayName());
                return true;
            }
            this.errorReporter.reportErrorForNode(StaticWarningCode.MISMATCHED_GETTER_AND_SETTER_TYPES_FROM_SUPERTYPE, declaration, string, object2.getDisplayName(), object.getDisplayName(), classElement.getDisplayName());
        }
        return false;
    }

    private boolean checkForMixedReturns(BlockFunctionBody blockFunctionBody) {
        int n = this.returnsWith.size();
        int n2 = this.returnsWithout.size();
        if (n > 0 && n2 > 0) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                this.errorReporter.reportErrorForToken(StaticWarningCode.MIXED_RETURN_TYPES, this.returnsWith.get(n3).getKeyword(), new Object[0]);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.errorReporter.reportErrorForToken(StaticWarningCode.MIXED_RETURN_TYPES, this.returnsWithout.get(n3).getKeyword(), new Object[0]);
            }
            return true;
        }
        return false;
    }

    private boolean checkForMixinDeclaresConstructor(TypeName typeName, ClassElement classElement) {
        for (ConstructorElement constructorElement : classElement.getConstructors()) {
            if (constructorElement.isSynthetic() || constructorElement.isFactory()) continue;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.MIXIN_DECLARES_CONSTRUCTOR, typeName, classElement.getName());
            return true;
        }
        return false;
    }

    private boolean checkForMixinInheritsNotFromObject(TypeName typeName, ClassElement classElement) {
        InterfaceType interfaceType = classElement.getSupertype();
        if (interfaceType != null && (!interfaceType.isObject() || !classElement.isTypedef() && classElement.getMixins().length != 0)) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.MIXIN_INHERITS_FROM_NOT_OBJECT, typeName, classElement.getName());
            return true;
        }
        return false;
    }

    private boolean checkForMixinReferencesSuper(TypeName typeName, ClassElement classElement) {
        if (classElement.hasReferenceToSuper()) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.MIXIN_REFERENCES_SUPER, typeName, classElement.getName());
        }
        return false;
    }

    private boolean checkForMultipleSuperInitializers(ConstructorDeclaration constructorDeclaration) {
        int n = 0;
        for (ConstructorInitializer constructorInitializer : constructorDeclaration.getInitializers()) {
            if (!(constructorInitializer instanceof SuperConstructorInvocation) || ++n <= 1) continue;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.MULTIPLE_SUPER_INITIALIZERS, constructorInitializer, new Object[0]);
        }
        return n > 0;
    }

    private boolean checkForNativeFunctionBodyInNonSDKCode(NativeFunctionBody nativeFunctionBody) {
        if (!this.isInSystemLibrary && !this.hasExtUri) {
            this.errorReporter.reportErrorForNode(ParserErrorCode.NATIVE_FUNCTION_BODY_IN_NON_SDK_CODE, nativeFunctionBody, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForNewWithUndefinedConstructor(InstanceCreationExpression instanceCreationExpression) {
        if (instanceCreationExpression.getStaticElement() != null) {
            return false;
        }
        ConstructorName constructorName = instanceCreationExpression.getConstructorName();
        if (constructorName == null) {
            return false;
        }
        TypeName typeName = constructorName.getType();
        if (typeName == null) {
            return false;
        }
        Identifier identifier = typeName.getName();
        SimpleIdentifier simpleIdentifier = constructorName.getName();
        if (simpleIdentifier != null) {
            this.errorReporter.reportErrorForNode(StaticWarningCode.NEW_WITH_UNDEFINED_CONSTRUCTOR, simpleIdentifier, identifier, simpleIdentifier);
        } else {
            this.errorReporter.reportErrorForNode(StaticWarningCode.NEW_WITH_UNDEFINED_CONSTRUCTOR_DEFAULT, constructorName, identifier);
        }
        return true;
    }

    private boolean checkForNoDefaultSuperConstructorImplicit(ClassDeclaration classDeclaration) {
        ConstructorElement[] constructorElementArray = this.enclosingClass.getConstructors();
        if (!constructorElementArray[0].isSynthetic()) {
            return false;
        }
        InterfaceType interfaceType = this.enclosingClass.getSupertype();
        if (interfaceType == null) {
            return false;
        }
        ClassElement classElement = interfaceType.getElement();
        ConstructorElement constructorElement = classElement.getUnnamedConstructor();
        if (constructorElement != null) {
            if (constructorElement.isFactory()) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.NON_GENERATIVE_CONSTRUCTOR, classDeclaration.getName(), constructorElement);
                return true;
            }
            if (constructorElement.isDefaultConstructor()) {
                return true;
            }
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.NO_DEFAULT_SUPER_CONSTRUCTOR_IMPLICIT, classDeclaration.getName(), interfaceType.getDisplayName());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkForNonAbstractClassInheritsAbstractMember(ClassDeclaration classDeclaration) {
        int n;
        Object object;
        Object object2;
        ExecutableElement[] executableElementArray;
        void var9_17;
        if (this.enclosingClass.isAbstract()) {
            return false;
        }
        MethodElement[] methodElementArray = this.enclosingClass.getMethods();
        PropertyAccessorElement[] propertyAccessorElementArray = this.enclosingClass.getAccessors();
        HashSet<String> hashSet = new HashSet<String>();
        for (MethodElement methodElement : methodElementArray) {
            String object3 = methodElement.getName();
            if (object3.equals("noSuchMethod")) {
                return false;
            }
            hashSet.add(object3);
        }
        HashSet hashSet2 = new HashSet();
        for (PropertyAccessorElement propertyAccessorElement : propertyAccessorElementArray) {
            hashSet2.add(propertyAccessorElement.getName());
        }
        HashSet hashSet3 = new HashSet();
        MemberMap memberMap = this.inheritanceManager.getMapOfMembersInheritedFromInterfaces(this.enclosingClass);
        MemberMap memberMap2 = this.inheritanceManager.getMapOfMembersInheritedFromClasses(this.enclosingClass);
        boolean bl = false;
        while (var9_17 < memberMap.getSize()) {
            block10: {
                block11: {
                    FunctionType functionType;
                    FunctionType functionType2;
                    executableElementArray = memberMap.getKey((int)var9_17);
                    object2 = memberMap.getValue((int)var9_17);
                    if (executableElementArray == null) break;
                    if (object2.getEnclosingElement() != null && ((ClassElement)object2.getEnclosingElement()).getType().isObject() || this.isMemberInClassOrMixin((ExecutableElement)object2, this.enclosingClass)) break block10;
                    ExecutableElement executableElement = memberMap2.get((String)executableElementArray);
                    if (executableElement == null) break block11;
                    object = this.enclosingClass.getType();
                    FunctionType functionType3 = executableElement.getType();
                    FunctionType functionType4 = object2.getType();
                    if (object == null || functionType3 == null || functionType4 == null || (executableElement instanceof MethodElement && !((MethodElement)executableElement).isAbstract() || executableElement instanceof PropertyAccessorElement && !((PropertyAccessorElement)executableElement).isAbstract()) && (functionType2 = this.inheritanceManager.substituteTypeArgumentsInMemberFromInheritance(functionType3, (String)executableElementArray, (InterfaceType)object)).isSubtypeOf(functionType = this.inheritanceManager.substituteTypeArgumentsInMemberFromInheritance(functionType4, (String)executableElementArray, (InterfaceType)object))) break block10;
                }
                hashSet3.add(object2);
            }
            ++var9_17;
        }
        if ((n = hashSet3.size()) == 0) {
            return false;
        }
        executableElementArray = hashSet3.toArray(new ExecutableElement[n]);
        object2 = new ArrayList(executableElementArray.length);
        for (int i = 0; i < executableElementArray.length; ++i) {
            object = executableElementArray[i].getEnclosingElement() != null ? executableElementArray[i].getEnclosingElement().getDisplayName() + '.' + executableElementArray[i].getDisplayName() : executableElementArray[i].getDisplayName();
            if (((ArrayList)object2).contains(object)) continue;
            ((ArrayList)object2).add(object);
        }
        String[] stringArray = ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]);
        object = stringArray.length == 1 ? this.errorReporter.newErrorWithProperties(StaticWarningCode.NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_ONE, classDeclaration.getName(), stringArray[0]) : (stringArray.length == 2 ? this.errorReporter.newErrorWithProperties(StaticWarningCode.NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_TWO, classDeclaration.getName(), stringArray[0], stringArray[1]) : (stringArray.length == 3 ? this.errorReporter.newErrorWithProperties(StaticWarningCode.NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_THREE, classDeclaration.getName(), stringArray[0], stringArray[1], stringArray[2]) : (stringArray.length == 4 ? this.errorReporter.newErrorWithProperties(StaticWarningCode.NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_FOUR, classDeclaration.getName(), stringArray[0], stringArray[1], stringArray[2], stringArray[3]) : this.errorReporter.newErrorWithProperties(StaticWarningCode.NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_FIVE_PLUS, classDeclaration.getName(), stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray.length - 4))));
        ((AnalysisErrorWithProperties)object).setProperty(ErrorProperty.UNIMPLEMENTED_METHODS, executableElementArray);
        this.errorReporter.reportError((AnalysisError)object);
        return true;
    }

    private boolean checkForNonBoolCondition(Expression expression) {
        Type type = this.getStaticType(expression);
        if (type != null && !type.isAssignableTo(this.boolType)) {
            this.errorReporter.reportErrorForNode(StaticTypeWarningCode.NON_BOOL_CONDITION, expression, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForNonBoolExpression(AssertStatement assertStatement) {
        FunctionType functionType;
        Expression expression = assertStatement.getCondition();
        Type type = this.getStaticType(expression);
        if (type instanceof InterfaceType) {
            if (!type.isAssignableTo(this.boolType)) {
                this.errorReporter.reportErrorForNode(StaticTypeWarningCode.NON_BOOL_EXPRESSION, expression, new Object[0]);
                return true;
            }
        } else if (type instanceof FunctionType && (functionType = (FunctionType)type).getTypeArguments().length == 0 && !functionType.getReturnType().isAssignableTo(this.boolType)) {
            this.errorReporter.reportErrorForNode(StaticTypeWarningCode.NON_BOOL_EXPRESSION, expression, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForNonBoolNegationExpression(Expression expression) {
        Type type = this.getStaticType(expression);
        if (type != null && !type.isAssignableTo(this.boolType)) {
            this.errorReporter.reportErrorForNode(StaticTypeWarningCode.NON_BOOL_NEGATION_EXPRESSION, expression, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForNonConstMapAsExpressionStatement(MapLiteral mapLiteral) {
        if (mapLiteral.getConstKeyword() != null) {
            return false;
        }
        if (mapLiteral.getTypeArguments() != null) {
            return false;
        }
        Statement statement = mapLiteral.getAncestor(ExpressionStatement.class);
        if (statement == null) {
            return false;
        }
        if (statement.getBeginToken() != mapLiteral.getBeginToken()) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.NON_CONST_MAP_AS_EXPRESSION_STATEMENT, mapLiteral, new Object[0]);
        return true;
    }

    private boolean checkForNonVoidReturnTypeForOperator(MethodDeclaration methodDeclaration) {
        Type type;
        SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
        if (!simpleIdentifier.getName().equals("[]=")) {
            return false;
        }
        TypeName typeName = methodDeclaration.getReturnType();
        if (typeName != null && (type = typeName.getType()) != null && !type.isVoid()) {
            this.errorReporter.reportErrorForNode(StaticWarningCode.NON_VOID_RETURN_FOR_OPERATOR, typeName, new Object[0]);
        }
        return false;
    }

    private boolean checkForNonVoidReturnTypeForSetter(TypeName typeName) {
        Type type;
        if (typeName != null && (type = typeName.getType()) != null && !type.isVoid()) {
            this.errorReporter.reportErrorForNode(StaticWarningCode.NON_VOID_RETURN_FOR_SETTER, typeName, new Object[0]);
        }
        return false;
    }

    private boolean checkForOptionalParameterInOperator(MethodDeclaration methodDeclaration) {
        FormalParameterList formalParameterList = methodDeclaration.getParameters();
        if (formalParameterList == null) {
            return false;
        }
        boolean bl = false;
        NodeList<FormalParameter> nodeList = formalParameterList.getParameters();
        for (FormalParameter formalParameter : nodeList) {
            if (!formalParameter.getKind().isOptional()) continue;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.OPTIONAL_PARAMETER_IN_OPERATOR, formalParameter, new Object[0]);
            bl = true;
        }
        return bl;
    }

    private boolean checkForPrivateOptionalParameter(FormalParameter formalParameter) {
        if (formalParameter.getKind() != ParameterKind.NAMED) {
            return false;
        }
        SimpleIdentifier simpleIdentifier = formalParameter.getIdentifier();
        if (simpleIdentifier.isSynthetic() || !StringUtilities.startsWithChar(simpleIdentifier.getName(), 95)) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.PRIVATE_OPTIONAL_PARAMETER, formalParameter, new Object[0]);
        return true;
    }

    private boolean checkForRecursiveConstructorRedirect(ConstructorDeclaration constructorDeclaration) {
        if (constructorDeclaration.getFactoryKeyword() != null) {
            return false;
        }
        for (ConstructorInitializer constructorInitializer : constructorDeclaration.getInitializers()) {
            if (!(constructorInitializer instanceof RedirectingConstructorInvocation)) continue;
            ConstructorElement constructorElement = constructorDeclaration.getElement();
            if (!this.hasRedirectingFactoryConstructorCycle(constructorElement)) {
                return false;
            }
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.RECURSIVE_CONSTRUCTOR_REDIRECT, constructorInitializer, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForRecursiveFactoryRedirect(ConstructorDeclaration constructorDeclaration) {
        ConstructorName constructorName = constructorDeclaration.getRedirectedConstructor();
        if (constructorName == null) {
            return false;
        }
        ConstructorElement constructorElement = constructorDeclaration.getElement();
        if (!this.hasRedirectingFactoryConstructorCycle(constructorElement)) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.RECURSIVE_FACTORY_REDIRECT, constructorName, new Object[0]);
        return true;
    }

    private boolean checkForRecursiveInterfaceInheritance(ClassElement classElement) {
        if (classElement == null) {
            return false;
        }
        return this.safeCheckForRecursiveInterfaceInheritance(classElement, new ArrayList<ClassElement>());
    }

    private boolean checkForRedirectingConstructorErrorCodes(ConstructorDeclaration constructorDeclaration) {
        boolean bl = false;
        ConstructorName constructorName = constructorDeclaration.getRedirectedConstructor();
        if (constructorName != null) {
            for (FormalParameter object : constructorDeclaration.getParameters().getParameters()) {
                if (!(object instanceof DefaultFormalParameter) || ((DefaultFormalParameter)object).getDefaultValue() == null) continue;
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.DEFAULT_VALUE_IN_REDIRECTING_FACTORY_CONSTRUCTOR, object.getIdentifier(), new Object[0]);
                bl = true;
            }
        }
        int n = 0;
        for (ConstructorInitializer constructorInitializer : constructorDeclaration.getInitializers()) {
            if (!(constructorInitializer instanceof RedirectingConstructorInvocation)) continue;
            if (n > 0) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.MULTIPLE_REDIRECTING_CONSTRUCTOR_INVOCATIONS, constructorInitializer, new Object[0]);
                bl = true;
            }
            ++n;
        }
        if (n > 0) {
            for (ConstructorInitializer constructorInitializer : constructorDeclaration.getInitializers()) {
                if (constructorInitializer instanceof SuperConstructorInvocation) {
                    this.errorReporter.reportErrorForNode(CompileTimeErrorCode.SUPER_IN_REDIRECTING_CONSTRUCTOR, constructorInitializer, new Object[0]);
                    bl = true;
                }
                if (!(constructorInitializer instanceof ConstructorFieldInitializer)) continue;
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.FIELD_INITIALIZER_REDIRECTING_CONSTRUCTOR, constructorInitializer, new Object[0]);
                bl = true;
            }
        }
        return bl;
    }

    private boolean checkForRedirectToNonConstConstructor(ConstructorDeclaration constructorDeclaration) {
        ConstructorName constructorName = constructorDeclaration.getRedirectedConstructor();
        if (constructorName == null) {
            return false;
        }
        ConstructorElement constructorElement = constructorDeclaration.getElement();
        if (constructorElement == null) {
            return false;
        }
        if (!constructorElement.isConst()) {
            return false;
        }
        ConstructorElement constructorElement2 = constructorElement.getRedirectedConstructor();
        if (constructorElement2 == null) {
            return false;
        }
        if (constructorElement2.isConst()) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.REDIRECT_TO_NON_CONST_CONSTRUCTOR, constructorName, new Object[0]);
        return true;
    }

    private boolean checkForRethrowOutsideCatch(RethrowExpression rethrowExpression) {
        if (!this.isInCatchClause) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.RETHROW_OUTSIDE_CATCH, rethrowExpression, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForReturnInGenerativeConstructor(ConstructorDeclaration constructorDeclaration) {
        if (constructorDeclaration.getFactoryKeyword() != null) {
            return false;
        }
        FunctionBody functionBody = constructorDeclaration.getBody();
        if (!(functionBody instanceof ExpressionFunctionBody)) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.RETURN_IN_GENERATIVE_CONSTRUCTOR, functionBody, new Object[0]);
        return true;
    }

    private boolean checkForReturnOfInvalidType(Expression expression, Type type) {
        Type type2 = this.getStaticType(expression);
        if (type.isVoid()) {
            if (type2.isVoid() || type2.isDynamic() || type2.isBottom()) {
                return false;
            }
            this.errorReporter.reportErrorForNode(StaticTypeWarningCode.RETURN_OF_INVALID_TYPE, expression, type2.getDisplayName(), type.getDisplayName(), this.enclosingFunction.getDisplayName());
            return true;
        }
        boolean bl = type2.isAssignableTo(type);
        if (bl) {
            return false;
        }
        this.errorReporter.reportErrorForNode(StaticTypeWarningCode.RETURN_OF_INVALID_TYPE, expression, type2.getDisplayName(), type.getDisplayName(), this.enclosingFunction.getDisplayName());
        return true;
    }

    private boolean checkForStaticAccessToInstanceMember(ClassElement classElement, SimpleIdentifier simpleIdentifier) {
        if (classElement == null) {
            return false;
        }
        Element element = simpleIdentifier.getStaticElement();
        if (!(element instanceof ExecutableElement)) {
            return false;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.isStatic()) {
            return false;
        }
        this.errorReporter.reportErrorForNode(StaticWarningCode.STATIC_ACCESS_TO_INSTANCE_MEMBER, simpleIdentifier, simpleIdentifier.getName());
        return true;
    }

    private boolean checkForSwitchExpressionNotAssignable(SwitchStatement switchStatement) {
        Expression expression = switchStatement.getExpression();
        Type type = this.getStaticType(expression);
        if (type == null) {
            return false;
        }
        NodeList<SwitchMember> nodeList = switchStatement.getMembers();
        for (SwitchMember switchMember : nodeList) {
            if (!(switchMember instanceof SwitchCase)) continue;
            SwitchCase switchCase = (SwitchCase)switchMember;
            Expression expression2 = switchCase.getExpression();
            Type type2 = this.getStaticType(expression2);
            if (type.isAssignableTo(type2)) {
                return false;
            }
            this.errorReporter.reportErrorForNode(StaticWarningCode.SWITCH_EXPRESSION_NOT_ASSIGNABLE, expression, type, type2);
            return true;
        }
        return false;
    }

    private boolean checkForTypeAliasCannotReferenceItself_function(FunctionTypeAlias functionTypeAlias) {
        FunctionTypeAliasElement functionTypeAliasElement = functionTypeAlias.getElement();
        if (!this.hasTypedefSelfReference(functionTypeAliasElement)) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.TYPE_ALIAS_CANNOT_REFERENCE_ITSELF, functionTypeAlias, new Object[0]);
        return true;
    }

    private boolean checkForTypeAliasCannotReferenceItself_mixin(ClassTypeAlias classTypeAlias) {
        ClassElement classElement = classTypeAlias.getElement();
        if (!this.hasTypedefSelfReference(classElement)) {
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.TYPE_ALIAS_CANNOT_REFERENCE_ITSELF, classTypeAlias, new Object[0]);
        return true;
    }

    private boolean checkForTypeArgumentNotMatchingBounds(TypeName typeName) {
        if (typeName.getTypeArguments() == null) {
            return false;
        }
        Type type = typeName.getType();
        if (type == null) {
            return false;
        }
        Element element = type.getElement();
        if (!(element instanceof ClassElement)) {
            return false;
        }
        ClassElement classElement = (ClassElement)element;
        Type[] typeArray = classElement.getType().getTypeArguments();
        TypeParameterElement[] typeParameterElementArray = classElement.getTypeParameters();
        NodeList<TypeName> nodeList = typeName.getTypeArguments().getArguments();
        Type[] typeArray2 = ((InterfaceType)type).getTypeArguments();
        int n = Math.min(nodeList.size(), typeParameterElementArray.length);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            TypeName typeName2 = (TypeName)nodeList.get(i);
            Type type2 = typeName2.getType();
            Type type3 = typeParameterElementArray[i].getBound();
            if (type2 == null || type3 == null || type2.isSubtypeOf(type3 = type3.substitute(typeArray2, typeArray))) continue;
            Enum enum_ = this.isInConstInstanceCreation ? CompileTimeErrorCode.TYPE_ARGUMENT_NOT_MATCHING_BOUNDS : StaticTypeWarningCode.TYPE_ARGUMENT_NOT_MATCHING_BOUNDS;
            this.errorReporter.reportErrorForNode((ErrorCode)((Object)enum_), typeName2, new Object[]{type2.getDisplayName(), type3.getDisplayName()});
            bl = true;
        }
        return bl;
    }

    private boolean checkForTypeParameterReferencedByStatic(TypeName typeName) {
        Type type;
        if ((this.isInStaticMethod || this.isInStaticVariableDeclaration) && (type = typeName.getType()) instanceof TypeParameterType) {
            this.errorReporter.reportErrorForNode(StaticWarningCode.TYPE_PARAMETER_REFERENCED_BY_STATIC, typeName, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForTypeParameterSupertypeOfItsBound(TypeParameter typeParameter) {
        TypeParameterElement typeParameterElement = typeParameter.getElement();
        Type type = typeParameterElement.getBound();
        if (type == null) {
            return false;
        }
        if (!type.isMoreSpecificThan(typeParameterElement.getType())) {
            return false;
        }
        this.errorReporter.reportErrorForNode(StaticTypeWarningCode.TYPE_PARAMETER_SUPERTYPE_OF_ITS_BOUND, typeParameter, typeParameterElement.getDisplayName());
        return true;
    }

    private boolean checkForUndefinedConstructorInInitializerImplicit(ConstructorDeclaration constructorDeclaration) {
        if (constructorDeclaration.getFactoryKeyword() != null) {
            return false;
        }
        for (ConstructorInitializer object2 : constructorDeclaration.getInitializers()) {
            if (!(object2 instanceof SuperConstructorInvocation) && !(object2 instanceof RedirectingConstructorInvocation)) continue;
            return false;
        }
        if (this.enclosingClass == null) {
            return false;
        }
        InterfaceType interfaceType = this.enclosingClass.getSupertype();
        if (interfaceType == null) {
            return false;
        }
        ClassElement classElement = interfaceType.getElement();
        ConstructorElement constructorElement = classElement.getUnnamedConstructor();
        if (constructorElement != null) {
            if (constructorElement.isFactory()) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.NON_GENERATIVE_CONSTRUCTOR, constructorDeclaration.getReturnType(), constructorElement);
                return true;
            }
            if (!constructorElement.isDefaultConstructor()) {
                Identifier identifier = constructorDeclaration.getReturnType();
                SimpleIdentifier simpleIdentifier = constructorDeclaration.getName();
                int n = identifier.getOffset();
                int n2 = (simpleIdentifier != null ? simpleIdentifier.getEnd() : identifier.getEnd()) - n;
                this.errorReporter.reportErrorForOffset(CompileTimeErrorCode.NO_DEFAULT_SUPER_CONSTRUCTOR_EXPLICIT, n, n2, interfaceType.getDisplayName());
            }
            return false;
        }
        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.UNDEFINED_CONSTRUCTOR_IN_INITIALIZER_DEFAULT, constructorDeclaration.getReturnType(), classElement.getName());
        return true;
    }

    private boolean checkForUnqualifiedReferenceToNonLocalStaticMember(SimpleIdentifier simpleIdentifier) {
        Element element = simpleIdentifier.getStaticElement();
        if (element == null || element instanceof TypeParameterElement) {
            return false;
        }
        Element element2 = element.getEnclosingElement();
        if (!(element2 instanceof ClassElement)) {
            return false;
        }
        if (element instanceof MethodElement && !((MethodElement)element).isStatic() || element instanceof PropertyAccessorElement && !((PropertyAccessorElement)element).isStatic()) {
            return false;
        }
        if (element2 == this.enclosingClass) {
            return false;
        }
        this.errorReporter.reportErrorForNode(StaticTypeWarningCode.UNQUALIFIED_REFERENCE_TO_NON_LOCAL_STATIC_MEMBER, simpleIdentifier, simpleIdentifier.getName());
        return true;
    }

    private void checkForValidField(FieldFormalParameter fieldFormalParameter) {
        ParameterElement parameterElement = fieldFormalParameter.getElement();
        if (parameterElement instanceof FieldFormalParameterElement) {
            FieldElement fieldElement = ((FieldFormalParameterElement)parameterElement).getField();
            if (fieldElement == null || fieldElement.isSynthetic()) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INITIALIZING_FORMAL_FOR_NON_EXISTANT_FIELD, fieldFormalParameter, fieldFormalParameter.getIdentifier().getName());
            } else {
                ParameterElement parameterElement2 = fieldFormalParameter.getElement();
                if (parameterElement2 instanceof FieldFormalParameterElementImpl) {
                    FieldFormalParameterElementImpl fieldFormalParameterElementImpl = (FieldFormalParameterElementImpl)parameterElement2;
                    Type type = fieldFormalParameterElementImpl.getType();
                    Type type2 = fieldElement.getType();
                    if (fieldElement.isSynthetic()) {
                        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INITIALIZING_FORMAL_FOR_NON_EXISTANT_FIELD, fieldFormalParameter, fieldFormalParameter.getIdentifier().getName());
                    } else if (fieldElement.isStatic()) {
                        this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INITIALIZING_FORMAL_FOR_STATIC_FIELD, fieldFormalParameter, fieldFormalParameter.getIdentifier().getName());
                    } else if (type != null && type2 != null && !type.isAssignableTo(type2)) {
                        this.errorReporter.reportErrorForNode(StaticWarningCode.FIELD_INITIALIZING_FORMAL_NOT_ASSIGNABLE, fieldFormalParameter, type.getDisplayName(), type2.getDisplayName());
                    }
                } else if (fieldElement.isSynthetic()) {
                    this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INITIALIZING_FORMAL_FOR_NON_EXISTANT_FIELD, fieldFormalParameter, fieldFormalParameter.getIdentifier().getName());
                } else if (fieldElement.isStatic()) {
                    this.errorReporter.reportErrorForNode(CompileTimeErrorCode.INITIALIZING_FORMAL_FOR_STATIC_FIELD, fieldFormalParameter, fieldFormalParameter.getIdentifier().getName());
                }
            }
        }
    }

    private boolean checkForVoidReturnType(MethodDeclaration methodDeclaration) {
        TypeName typeName = methodDeclaration.getReturnType();
        if (typeName == null || !typeName.getName().getName().equals("void")) {
            return false;
        }
        this.errorReporter.reportErrorForNode(StaticWarningCode.VOID_RETURN_FOR_GETTER, typeName, new Object[0]);
        return true;
    }

    private boolean checkForWrongNumberOfParametersForOperator(MethodDeclaration methodDeclaration) {
        FormalParameterList formalParameterList = methodDeclaration.getParameters();
        if (formalParameterList == null) {
            return false;
        }
        int n = formalParameterList.getParameters().size();
        SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
        if (simpleIdentifier == null) {
            return false;
        }
        String string = simpleIdentifier.getName();
        int n2 = -1;
        if ("[]=".equals(string)) {
            n2 = 2;
        } else if ("<".equals(string) || ">".equals(string) || "<=".equals(string) || ">=".equals(string) || "==".equals(string) || "+".equals(string) || "/".equals(string) || "~/".equals(string) || "*".equals(string) || "%".equals(string) || "|".equals(string) || "^".equals(string) || "&".equals(string) || "<<".equals(string) || ">>".equals(string) || "[]".equals(string)) {
            n2 = 1;
        } else if ("~".equals(string)) {
            n2 = 0;
        }
        if (n2 != -1 && n != n2) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.WRONG_NUMBER_OF_PARAMETERS_FOR_OPERATOR, simpleIdentifier, string, n2, n);
            return true;
        }
        if ("-".equals(string) && n > 1) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.WRONG_NUMBER_OF_PARAMETERS_FOR_OPERATOR_MINUS, simpleIdentifier, n);
            return true;
        }
        return false;
    }

    private boolean checkForWrongNumberOfParametersForSetter(SimpleIdentifier simpleIdentifier, FormalParameterList formalParameterList) {
        if (simpleIdentifier == null) {
            return false;
        }
        if (formalParameterList == null) {
            return false;
        }
        NodeList<FormalParameter> nodeList = formalParameterList.getParameters();
        if (nodeList.size() != 1 || ((FormalParameter)nodeList.get(0)).getKind() != ParameterKind.REQUIRED) {
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.WRONG_NUMBER_OF_PARAMETERS_FOR_SETTER, simpleIdentifier, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkImplementsFunctionWithoutCall(ClassDeclaration classDeclaration) {
        if (classDeclaration.getAbstractKeyword() != null) {
            return false;
        }
        ClassElement classElement = classDeclaration.getElement();
        if (classElement == null) {
            return false;
        }
        if (!classElement.getType().isSubtypeOf(this.typeProvider.getFunctionType())) {
            return false;
        }
        ExecutableElement executableElement = this.inheritanceManager.lookupMember(classElement, "call");
        if (executableElement == null || !(executableElement instanceof MethodElement) || ((MethodElement)executableElement).isAbstract()) {
            this.errorReporter.reportErrorForNode(StaticWarningCode.FUNCTION_WITHOUT_CALL, classDeclaration.getName(), new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkImplementsSuperClass(ClassDeclaration classDeclaration) {
        InterfaceType interfaceType = this.enclosingClass.getSupertype();
        if (interfaceType == null) {
            return false;
        }
        ImplementsClause implementsClause = classDeclaration.getImplementsClause();
        if (implementsClause == null) {
            return false;
        }
        boolean bl = false;
        for (TypeName typeName : implementsClause.getInterfaces()) {
            if (!typeName.getType().equals(interfaceType)) continue;
            bl = true;
            this.errorReporter.reportErrorForNode(CompileTimeErrorCode.IMPLEMENTS_SUPER_CLASS, typeName, interfaceType.getDisplayName());
        }
        return bl;
    }

    private String getExtendedDisplayName(Type type) {
        Source source;
        Element element = type.getElement();
        if (element != null && (source = element.getSource()) != null) {
            return type.getDisplayName() + " (" + source.getFullName() + ")";
        }
        return type.getDisplayName();
    }

    private Type getGetterType(PropertyAccessorElement propertyAccessorElement) {
        FunctionType functionType = propertyAccessorElement.getType();
        if (functionType != null) {
            return functionType.getReturnType();
        }
        return null;
    }

    private Type getSetterType(PropertyAccessorElement propertyAccessorElement) {
        ParameterElement[] parameterElementArray = propertyAccessorElement.getParameters();
        if (parameterElementArray.length == 0) {
            return null;
        }
        return parameterElementArray[0].getType();
    }

    private Type getStaticType(Expression expression) {
        Type type = expression.getStaticType();
        if (type == null) {
            return this.dynamicType;
        }
        return type;
    }

    private VariableElement getVariableElement(Expression expression) {
        Element element;
        if (expression instanceof Identifier && (element = ((Identifier)expression).getStaticElement()) instanceof VariableElement) {
            return (VariableElement)element;
        }
        return null;
    }

    private boolean hasRedirectingFactoryConstructorCycle(ConstructorElement constructorElement) {
        HashSet<ConstructorElement> hashSet = new HashSet<ConstructorElement>();
        ConstructorElement constructorElement2 = constructorElement;
        while (constructorElement2 != null) {
            if (hashSet.contains(constructorElement2)) {
                return constructorElement2 == constructorElement;
            }
            hashSet.add(constructorElement2);
            if (!((constructorElement2 = constructorElement2.getRedirectedConstructor()) instanceof ConstructorMember)) continue;
            constructorElement2 = ((ConstructorMember)constructorElement2).getBaseElement();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasTypedefSelfReference(final Element element) {
        HashSet<Element> hashSet = new HashSet<Element>();
        final ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(element);
        boolean bl = true;
        while (!arrayList.isEmpty()) {
            Element element2 = (Element)arrayList.remove(arrayList.size() - 1);
            if (element.equals(element2)) {
                if (!bl) return true;
                bl = false;
            } else if (element2 == null || hashSet.contains(element2)) continue;
            element2.accept(new GeneralizingElementVisitor<Void>(){
                private boolean inClass;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitClassElement(ClassElement classElement) {
                    this.addTypeToCheck(classElement.getSupertype());
                    for (InterfaceType interfaceType : classElement.getMixins()) {
                        this.addTypeToCheck(interfaceType);
                    }
                    this.inClass = !classElement.isTypedef();
                    try {
                        Void void_ = (Void)super.visitClassElement(classElement);
                        return void_;
                    }
                    finally {
                        this.inClass = false;
                    }
                }

                @Override
                public Void visitExecutableElement(ExecutableElement executableElement) {
                    if (executableElement.isSynthetic()) {
                        return null;
                    }
                    this.addTypeToCheck(executableElement.getReturnType());
                    return (Void)super.visitExecutableElement(executableElement);
                }

                @Override
                public Void visitFunctionTypeAliasElement(FunctionTypeAliasElement functionTypeAliasElement) {
                    this.addTypeToCheck(functionTypeAliasElement.getReturnType());
                    return (Void)super.visitFunctionTypeAliasElement(functionTypeAliasElement);
                }

                @Override
                public Void visitParameterElement(ParameterElement parameterElement) {
                    this.addTypeToCheck(parameterElement.getType());
                    return (Void)super.visitParameterElement(parameterElement);
                }

                @Override
                public Void visitTypeParameterElement(TypeParameterElement typeParameterElement) {
                    this.addTypeToCheck(typeParameterElement.getBound());
                    return (Void)super.visitTypeParameterElement(typeParameterElement);
                }

                @Override
                public Void visitVariableElement(VariableElement variableElement) {
                    this.addTypeToCheck(variableElement.getType());
                    return (Void)super.visitVariableElement(variableElement);
                }

                private void addTypeToCheck(Type type) {
                    if (type == null) {
                        return;
                    }
                    Element element2 = type.getElement();
                    if (this.inClass && element.equals(element2)) {
                        return;
                    }
                    arrayList.add(element2);
                    if (type instanceof InterfaceType) {
                        InterfaceType interfaceType = (InterfaceType)type;
                        for (Type type2 : interfaceType.getTypeArguments()) {
                            this.addTypeToCheck(type2);
                        }
                    }
                }
            });
            hashSet.add(element2);
        }
        return false;
    }

    private boolean implementsEqualsWhenNotAllowed(Type type) {
        if (type == null || type.equals(this.intType) || type.equals(this.typeProvider.getStringType())) {
            return false;
        }
        Element element = type.getElement();
        if (!(element instanceof ClassElement)) {
            return false;
        }
        ClassElement classElement = (ClassElement)element;
        MethodElement methodElement = classElement.lookUpMethod("==", this.currentLibrary);
        return methodElement != null && !methodElement.getEnclosingElement().getType().isObject();
    }

    private boolean isFunctionType(Type type) {
        if (type.isDynamic() || type.isBottom()) {
            return true;
        }
        if (type instanceof FunctionType || type.isDartCoreFunction()) {
            return true;
        }
        if (type instanceof InterfaceType) {
            MethodElement methodElement = ((InterfaceType)type).lookUpMethod("call", this.currentLibrary);
            return methodElement != null;
        }
        return false;
    }

    private boolean isMemberInClassOrMixin(ExecutableElement executableElement, ClassElement classElement) {
        String string = executableElement.getName();
        if (executableElement instanceof MethodElement) {
            MethodElement methodElement = classElement.getMethod(string);
            if (methodElement != null) {
                return true;
            }
            InterfaceType[] interfaceTypeArray = classElement.getMixins();
            for (int i = 0; i < interfaceTypeArray.length && methodElement == null; ++i) {
                methodElement = interfaceTypeArray[i].getMethod(string);
            }
            if (methodElement != null) {
                return true;
            }
        } else if (executableElement instanceof PropertyAccessorElement) {
            PropertyAccessorElement propertyAccessorElement = classElement.getGetter(executableElement.getName());
            if (propertyAccessorElement == null) {
                propertyAccessorElement = classElement.getSetter(string);
            }
            if (propertyAccessorElement != null) {
                return true;
            }
            InterfaceType[] interfaceTypeArray = classElement.getMixins();
            for (int i = 0; i < interfaceTypeArray.length && propertyAccessorElement == null; ++i) {
                propertyAccessorElement = interfaceTypeArray[i].getGetter(string);
                if (propertyAccessorElement != null) continue;
                propertyAccessorElement = interfaceTypeArray[i].getSetter(string);
            }
            if (propertyAccessorElement != null) {
                return true;
            }
        }
        return false;
    }

    private boolean isThisInValidContext(ThisExpression thisExpression) {
        for (AstNode astNode = thisExpression; astNode != null; astNode = astNode.getParent()) {
            if (astNode instanceof CompilationUnit) {
                return false;
            }
            if (astNode instanceof ConstructorDeclaration) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)astNode;
                return constructorDeclaration.getFactoryKeyword() == null;
            }
            if (astNode instanceof ConstructorInitializer) {
                return false;
            }
            if (!(astNode instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDeclaration = (MethodDeclaration)astNode;
            return !methodDeclaration.isStatic();
        }
        return false;
    }

    private boolean isUnqualifiedReferenceToNonLocalStaticMemberAllowed(SimpleIdentifier simpleIdentifier) {
        CommentReference commentReference;
        if (simpleIdentifier.inDeclarationContext()) {
            return true;
        }
        AstNode astNode = simpleIdentifier.getParent();
        if (astNode instanceof ConstructorName || astNode instanceof MethodInvocation || astNode instanceof PropertyAccess || astNode instanceof SuperConstructorInvocation) {
            return true;
        }
        if (astNode instanceof PrefixedIdentifier && ((PrefixedIdentifier)astNode).getIdentifier() == simpleIdentifier) {
            return true;
        }
        if (astNode instanceof Annotation && ((Annotation)astNode).getConstructorName() == simpleIdentifier) {
            return true;
        }
        return astNode instanceof CommentReference && (commentReference = (CommentReference)astNode).getNewKeyword() != null;
    }

    private boolean isUserDefinedObject(EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl == null || evaluationResultImpl instanceof ValidResult && ((ValidResult)evaluationResultImpl).isUserDefinedObject();
    }

    private boolean safeCheckForRecursiveInterfaceInheritance(ClassElement classElement, ArrayList<ClassElement> arrayList) {
        InterfaceType[] interfaceTypeArray;
        int n = arrayList.size();
        if (n > 0 && this.enclosingClass.equals(classElement)) {
            String string = this.enclosingClass.getDisplayName();
            if (n > 1) {
                String string2 = ", ";
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(arrayList.get(i).getDisplayName());
                    stringBuilder.append(string2);
                }
                stringBuilder.append(classElement.getDisplayName());
                this.errorReporter.reportErrorForOffset(CompileTimeErrorCode.RECURSIVE_INTERFACE_INHERITANCE, this.enclosingClass.getNameOffset(), string.length(), string, stringBuilder.toString());
                return true;
            }
            InterfaceType interfaceType = classElement.getSupertype();
            CompileTimeErrorCode compileTimeErrorCode = interfaceType != null && this.enclosingClass.equals(interfaceType.getElement()) ? CompileTimeErrorCode.RECURSIVE_INTERFACE_INHERITANCE_BASE_CASE_EXTENDS : CompileTimeErrorCode.RECURSIVE_INTERFACE_INHERITANCE_BASE_CASE_IMPLEMENTS;
            this.errorReporter.reportErrorForOffset(compileTimeErrorCode, this.enclosingClass.getNameOffset(), string.length(), string);
            return true;
        }
        if (arrayList.indexOf(classElement) > 0) {
            return false;
        }
        arrayList.add(classElement);
        InterfaceType interfaceType = classElement.getSupertype();
        if (interfaceType != null && this.safeCheckForRecursiveInterfaceInheritance(interfaceType.getElement(), arrayList)) {
            return true;
        }
        for (InterfaceType interfaceType2 : interfaceTypeArray = classElement.getInterfaces()) {
            if (!this.safeCheckForRecursiveInterfaceInheritance(interfaceType2.getElement(), arrayList)) continue;
            return true;
        }
        arrayList.remove(arrayList.size() - 1);
        return false;
    }

    private static enum INIT_STATE {
        NOT_INIT,
        INIT_IN_DECLARATION,
        INIT_IN_FIELD_FORMAL,
        INIT_IN_INITIALIZERS;

    }
}

