/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.verifier;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorFieldInitializer;
import com.google.dart.engine.ast.ConstructorInitializer;
import com.google.dart.engine.ast.DefaultFormalParameter;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.RedirectingConstructorInvocation;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.StaticWarningCode;
import com.google.dart.engine.internal.constant.ConstantVisitor;
import com.google.dart.engine.internal.constant.ErrorResult;
import com.google.dart.engine.internal.constant.EvaluationResultImpl;
import com.google.dart.engine.internal.constant.ValidResult;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DartObjectImpl;
import com.google.dart.engine.internal.object.DoubleState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.GenericState;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.IntState;
import com.google.dart.engine.internal.object.NumState;
import com.google.dart.engine.internal.object.StringState;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import java.util.ArrayList;
import java.util.HashSet;

public class ConstantVerifier
extends RecursiveAstVisitor<Void> {
    private ErrorReporter errorReporter;
    private TypeProvider typeProvider;
    private InterfaceType boolType;
    private InterfaceType intType;
    private InterfaceType numType;
    private InterfaceType stringType;

    public ConstantVerifier(ErrorReporter errorReporter, TypeProvider typeProvider) {
        this.errorReporter = errorReporter;
        this.typeProvider = typeProvider;
        this.boolType = typeProvider.getBoolType();
        this.intType = typeProvider.getIntType();
        this.numType = typeProvider.getNumType();
        this.stringType = typeProvider.getStringType();
    }

    @Override
    public Void visitAnnotation(Annotation annotation) {
        super.visitAnnotation(annotation);
        Element element = annotation.getElement();
        if (element instanceof ConstructorElement) {
            ConstructorElement constructorElement = (ConstructorElement)element;
            if (!constructorElement.isConst()) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.NON_CONSTANT_ANNOTATION_CONSTRUCTOR, annotation, new Object[0]);
                return null;
            }
            ArgumentList argumentList = annotation.getArguments();
            if (argumentList == null) {
                this.errorReporter.reportErrorForNode(CompileTimeErrorCode.NO_ANNOTATION_CONSTRUCTOR_ARGUMENTS, annotation, new Object[0]);
                return null;
            }
            this.validateConstantArguments(argumentList);
        }
        return null;
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        if (constructorDeclaration.getConstKeyword() != null) {
            this.validateInitializers(constructorDeclaration);
        }
        this.validateDefaultValues(constructorDeclaration.getParameters());
        return (Void)super.visitConstructorDeclaration(constructorDeclaration);
    }

    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        super.visitFunctionExpression(functionExpression);
        this.validateDefaultValues(functionExpression.getParameters());
        return null;
    }

    @Override
    public Void visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        this.validateInstanceCreationArguments(instanceCreationExpression);
        return (Void)super.visitInstanceCreationExpression(instanceCreationExpression);
    }

    @Override
    public Void visitListLiteral(ListLiteral listLiteral) {
        super.visitListLiteral(listLiteral);
        if (listLiteral.getConstKeyword() != null) {
            for (Expression expression : listLiteral.getElements()) {
                this.validate(expression, CompileTimeErrorCode.NON_CONSTANT_LIST_ELEMENT);
            }
        }
        return null;
    }

    @Override
    public Void visitMapLiteral(MapLiteral mapLiteral) {
        super.visitMapLiteral(mapLiteral);
        boolean bl = mapLiteral.getConstKeyword() != null;
        boolean bl2 = true;
        HashSet<DartObjectImpl> hashSet = new HashSet<DartObjectImpl>();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (MapLiteralEntry astNode : mapLiteral.getEntries()) {
            DartObjectImpl dartObjectImpl;
            EvaluationResultImpl evaluationResultImpl;
            Expression expression = astNode.getKey();
            if (bl) {
                evaluationResultImpl = this.validate(expression, CompileTimeErrorCode.NON_CONSTANT_MAP_KEY);
                this.validate(astNode.getValue(), CompileTimeErrorCode.NON_CONSTANT_MAP_VALUE);
                if (!(evaluationResultImpl instanceof ValidResult)) continue;
                dartObjectImpl = ((ValidResult)evaluationResultImpl).getValue();
                if (hashSet.contains(dartObjectImpl)) {
                    arrayList.add(expression);
                    continue;
                }
                hashSet.add(dartObjectImpl);
                continue;
            }
            evaluationResultImpl = expression.accept(new ConstantVisitor(this.typeProvider));
            if (evaluationResultImpl instanceof ValidResult) {
                dartObjectImpl = ((ValidResult)evaluationResultImpl).getValue();
                if (hashSet.contains(dartObjectImpl)) {
                    arrayList.add(expression);
                    continue;
                }
                hashSet.add(dartObjectImpl);
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            for (Expression expression : arrayList) {
                this.errorReporter.reportErrorForNode(StaticWarningCode.EQUAL_KEYS_IN_MAP, expression, new Object[0]);
            }
        }
        return null;
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        super.visitMethodDeclaration(methodDeclaration);
        this.validateDefaultValues(methodDeclaration.getParameters());
        return null;
    }

    @Override
    public Void visitSwitchCase(SwitchCase switchCase) {
        super.visitSwitchCase(switchCase);
        this.validate(switchCase.getExpression(), CompileTimeErrorCode.NON_CONSTANT_CASE_EXPRESSION);
        return null;
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        super.visitVariableDeclaration(variableDeclaration);
        Expression expression = variableDeclaration.getInitializer();
        if (expression != null && variableDeclaration.isConst()) {
            VariableElementImpl variableElementImpl = (VariableElementImpl)variableDeclaration.getElement();
            EvaluationResultImpl evaluationResultImpl = variableElementImpl.getEvaluationResult();
            if (evaluationResultImpl == null) {
                evaluationResultImpl = this.validate(expression, CompileTimeErrorCode.CONST_INITIALIZED_WITH_NON_CONSTANT_VALUE);
                variableElementImpl.setEvaluationResult(evaluationResultImpl);
            } else if (evaluationResultImpl instanceof ErrorResult) {
                this.reportErrors(evaluationResultImpl, CompileTimeErrorCode.CONST_INITIALIZED_WITH_NON_CONSTANT_VALUE);
            }
        }
        return null;
    }

    private void reportErrors(EvaluationResultImpl evaluationResultImpl, ErrorCode errorCode) {
        if (evaluationResultImpl instanceof ErrorResult) {
            for (ErrorResult.ErrorData errorData : ((ErrorResult)evaluationResultImpl).getErrorData()) {
                ErrorCode errorCode2 = errorData.getErrorCode();
                if (errorCode2 == CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION || errorCode2 == CompileTimeErrorCode.CONST_EVAL_THROWS_IDBZE || errorCode2 == CompileTimeErrorCode.CONST_EVAL_TYPE_BOOL_NUM_STRING || errorCode2 == CompileTimeErrorCode.CONST_EVAL_TYPE_BOOL || errorCode2 == CompileTimeErrorCode.CONST_EVAL_TYPE_INT || errorCode2 == CompileTimeErrorCode.CONST_EVAL_TYPE_NUM) {
                    this.errorReporter.reportErrorForNode(errorCode2, errorData.getNode(), new Object[0]);
                    continue;
                }
                this.errorReporter.reportErrorForNode(errorCode, errorData.getNode(), new Object[0]);
            }
        }
    }

    private ValidResult valid(InterfaceType interfaceType, InstanceState instanceState) {
        return new ValidResult(new DartObjectImpl(interfaceType, instanceState));
    }

    private EvaluationResultImpl validate(Expression expression, ErrorCode errorCode) {
        EvaluationResultImpl evaluationResultImpl = expression.accept(new ConstantVisitor(this.typeProvider));
        this.reportErrors(evaluationResultImpl, errorCode);
        return evaluationResultImpl;
    }

    private void validateConstantArguments(ArgumentList argumentList) {
        for (Expression expression : argumentList.getArguments()) {
            if (expression instanceof NamedExpression) {
                expression = ((NamedExpression)expression).getExpression();
            }
            this.validate(expression, CompileTimeErrorCode.CONST_WITH_NON_CONSTANT_ARGUMENT);
        }
    }

    private void validateDefaultValues(FormalParameterList formalParameterList) {
        if (formalParameterList == null) {
            return;
        }
        for (FormalParameter formalParameter : formalParameterList.getParameters()) {
            DefaultFormalParameter defaultFormalParameter;
            Expression expression;
            if (!(formalParameter instanceof DefaultFormalParameter) || (expression = (defaultFormalParameter = (DefaultFormalParameter)formalParameter).getDefaultValue()) == null) continue;
            EvaluationResultImpl evaluationResultImpl = this.validate(expression, CompileTimeErrorCode.NON_CONSTANT_DEFAULT_VALUE);
            VariableElementImpl variableElementImpl = (VariableElementImpl)((Object)formalParameter.getElement());
            variableElementImpl.setEvaluationResult(evaluationResultImpl);
        }
    }

    private void validateInitializerExpression(final ParameterElement[] parameterElementArray, Expression expression) {
        EvaluationResultImpl evaluationResultImpl = expression.accept(new ConstantVisitor(this.typeProvider){

            @Override
            public EvaluationResultImpl visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
                Element element = simpleIdentifier.getStaticElement();
                for (ParameterElement parameterElement : parameterElementArray) {
                    if (parameterElement != element || parameterElement == null) continue;
                    Type type = parameterElement.getType();
                    if (type != null) {
                        if (type.isDynamic()) {
                            return ConstantVerifier.this.valid(ConstantVerifier.this.typeProvider.getObjectType(), DynamicState.DYNAMIC_STATE);
                        }
                        if (type.isSubtypeOf(ConstantVerifier.this.boolType)) {
                            return ConstantVerifier.this.valid(ConstantVerifier.this.typeProvider.getBoolType(), BoolState.UNKNOWN_VALUE);
                        }
                        if (type.isSubtypeOf(ConstantVerifier.this.typeProvider.getDoubleType())) {
                            return ConstantVerifier.this.valid(ConstantVerifier.this.typeProvider.getDoubleType(), DoubleState.UNKNOWN_VALUE);
                        }
                        if (type.isSubtypeOf(ConstantVerifier.this.intType)) {
                            return ConstantVerifier.this.valid(ConstantVerifier.this.typeProvider.getIntType(), IntState.UNKNOWN_VALUE);
                        }
                        if (type.isSubtypeOf(ConstantVerifier.this.numType)) {
                            return ConstantVerifier.this.valid(ConstantVerifier.this.typeProvider.getNumType(), NumState.UNKNOWN_VALUE);
                        }
                        if (type.isSubtypeOf(ConstantVerifier.this.stringType)) {
                            return ConstantVerifier.this.valid(ConstantVerifier.this.typeProvider.getStringType(), StringState.UNKNOWN_VALUE);
                        }
                    }
                    return ConstantVerifier.this.valid(type instanceof InterfaceType ? (InterfaceType)type : ConstantVerifier.this.typeProvider.getObjectType(), GenericState.UNKNOWN_VALUE);
                }
                return super.visitSimpleIdentifier(simpleIdentifier);
            }
        });
        this.reportErrors(evaluationResultImpl, CompileTimeErrorCode.NON_CONSTANT_VALUE_IN_INITIALIZER);
    }

    private void validateInitializerInvocationArguments(ParameterElement[] parameterElementArray, ArgumentList argumentList) {
        if (argumentList == null) {
            return;
        }
        for (Expression expression : argumentList.getArguments()) {
            this.validateInitializerExpression(parameterElementArray, expression);
        }
    }

    private void validateInitializers(ConstructorDeclaration constructorDeclaration) {
        ParameterElement[] parameterElementArray = constructorDeclaration.getParameters().getParameterElements();
        NodeList<ConstructorInitializer> nodeList = constructorDeclaration.getInitializers();
        for (ConstructorInitializer constructorInitializer : nodeList) {
            ConstructorInitializer constructorInitializer2;
            if (constructorInitializer instanceof ConstructorFieldInitializer) {
                constructorInitializer2 = (ConstructorFieldInitializer)constructorInitializer;
                this.validateInitializerExpression(parameterElementArray, ((ConstructorFieldInitializer)constructorInitializer2).getExpression());
            }
            if (constructorInitializer instanceof RedirectingConstructorInvocation) {
                constructorInitializer2 = (RedirectingConstructorInvocation)constructorInitializer;
                this.validateInitializerInvocationArguments(parameterElementArray, ((RedirectingConstructorInvocation)constructorInitializer2).getArgumentList());
            }
            if (!(constructorInitializer instanceof SuperConstructorInvocation)) continue;
            constructorInitializer2 = (SuperConstructorInvocation)constructorInitializer;
            this.validateInitializerInvocationArguments(parameterElementArray, ((SuperConstructorInvocation)constructorInitializer2).getArgumentList());
        }
    }

    private void validateInstanceCreationArguments(InstanceCreationExpression instanceCreationExpression) {
        if (!instanceCreationExpression.isConst()) {
            return;
        }
        ArgumentList argumentList = instanceCreationExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        this.validateConstantArguments(argumentList);
    }
}

