/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.type;

import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.internal.element.ElementPair;
import com.google.dart.engine.internal.type.TypeImpl;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.type.TypeParameterType;
import com.google.dart.engine.utilities.general.ObjectUtilities;
import java.util.HashSet;
import java.util.Set;

public class TypeParameterTypeImpl
extends TypeImpl
implements TypeParameterType {
    public static final TypeParameterType[] EMPTY_ARRAY = new TypeParameterType[0];

    public static TypeParameterType[] getTypes(TypeParameterElement[] typeParameterElementArray) {
        int n = typeParameterElementArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        TypeParameterType[] typeParameterTypeArray = new TypeParameterType[n];
        for (int i = 0; i < n; ++i) {
            typeParameterTypeArray[i] = typeParameterElementArray[i].getType();
        }
        return typeParameterTypeArray;
    }

    public TypeParameterTypeImpl(TypeParameterElement typeParameterElement) {
        super(typeParameterElement, typeParameterElement.getName());
    }

    public boolean equals(Object object) {
        return object instanceof TypeParameterTypeImpl && ObjectUtilities.equals(this.getElement(), ((TypeParameterTypeImpl)object).getElement());
    }

    @Override
    public TypeParameterElement getElement() {
        return (TypeParameterElement)super.getElement();
    }

    public int hashCode() {
        return this.getElement().hashCode();
    }

    @Override
    public Type substitute(Type[] typeArray, Type[] typeArray2) {
        int n = typeArray2.length;
        for (int i = 0; i < n; ++i) {
            if (!typeArray2[i].equals(this)) continue;
            return typeArray[i];
        }
        return this;
    }

    @Override
    protected boolean internalEquals(Object object, Set<ElementPair> set) {
        return this.equals(object);
    }

    @Override
    protected boolean internalIsMoreSpecificThan(Type type, boolean bl, Set<TypeImpl.TypePair> set) {
        if (this.equals(type)) {
            return true;
        }
        if (type.isBottom()) {
            return true;
        }
        if (type.isDynamic()) {
            return true;
        }
        return this.isMoreSpecificThan(type, new HashSet<Type>(), bl, set);
    }

    @Override
    protected boolean internalIsSubtypeOf(Type type, Set<TypeImpl.TypePair> set) {
        return this.isMoreSpecificThan(type, true, new HashSet<TypeImpl.TypePair>());
    }

    private boolean isMoreSpecificThan(Type type, Set<Type> set, boolean bl, Set<TypeImpl.TypePair> set2) {
        Type type2 = this.getElement().getBound();
        if (type.equals(type2)) {
            return true;
        }
        if (type.isObject()) {
            return true;
        }
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof TypeParameterTypeImpl) {
            TypeParameterTypeImpl typeParameterTypeImpl = (TypeParameterTypeImpl)type2;
            if (set.contains(type2)) {
                return false;
            }
            set.add(type2);
            return typeParameterTypeImpl.isMoreSpecificThan(type, set, bl, set2);
        }
        return ((TypeImpl)type2).isMoreSpecificThan(type, bl, set2);
    }
}

