/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.type;

import com.google.dart.engine.element.Element;
import com.google.dart.engine.internal.element.ElementPair;
import com.google.dart.engine.type.Type;
import java.util.HashSet;
import java.util.Set;

public abstract class TypeImpl
implements Type {
    private Element element;
    private String name;
    public static final Type[] EMPTY_ARRAY = new Type[0];

    protected static boolean equalArrays(Type[] typeArray, Type[] typeArray2, Set<ElementPair> set) {
        if (typeArray.length != typeArray2.length) {
            return false;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            if (((TypeImpl)typeArray[i]).internalEquals(typeArray2[i], set)) continue;
            return false;
        }
        return true;
    }

    protected static Type[] substitute(Type[] typeArray, Type[] typeArray2, Type[] typeArray3) {
        int n = typeArray.length;
        if (n == 0) {
            return typeArray;
        }
        Type[] typeArray4 = new Type[n];
        for (int i = 0; i < n; ++i) {
            typeArray4[i] = typeArray[i].substitute(typeArray2, typeArray3);
        }
        return typeArray4;
    }

    public TypeImpl(Element element, String string) {
        this.element = element;
        this.name = string;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public Type getLeastUpperBound(Type type) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAssignableTo(Type type) {
        return this.isAssignableTo(type, new HashSet<TypePair>());
    }

    public final boolean isAssignableTo(Type type, Set<TypePair> set) {
        return this.isSubtypeOf(type, set) || ((TypeImpl)type).isSubtypeOf(this, set);
    }

    @Override
    public boolean isBottom() {
        return false;
    }

    @Override
    public boolean isDartCoreFunction() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public final boolean isMoreSpecificThan(Type type) {
        return this.isMoreSpecificThan(type, false, new HashSet<TypePair>());
    }

    public final boolean isMoreSpecificThan(Type type, boolean bl, Set<TypePair> set) {
        TypePair typePair = new TypePair(this, type);
        if (!set.add(typePair)) {
            return false;
        }
        boolean bl2 = this.internalIsMoreSpecificThan(type, bl, set);
        set.remove(typePair);
        return bl2;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public final boolean isSubtypeOf(Type type) {
        return this.isSubtypeOf(type, new HashSet<TypePair>());
    }

    public final boolean isSubtypeOf(Type type, Set<TypePair> set) {
        TypePair typePair = new TypePair(this, type);
        if (!set.add(typePair)) {
            return false;
        }
        boolean bl = this.internalIsSubtypeOf(type, set);
        set.remove(typePair);
        return bl;
    }

    @Override
    public boolean isSupertypeOf(Type type) {
        return type.isSubtypeOf(this);
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendTo(stringBuilder);
        return stringBuilder.toString();
    }

    protected void appendTo(StringBuilder stringBuilder) {
        if (this.name == null) {
            stringBuilder.append("<unnamed type>");
        } else {
            stringBuilder.append(this.name);
        }
    }

    protected abstract boolean internalEquals(Object var1, Set<ElementPair> var2);

    protected abstract boolean internalIsMoreSpecificThan(Type var1, boolean var2, Set<TypePair> var3);

    protected abstract boolean internalIsSubtypeOf(Type var1, Set<TypePair> var2);

    public class TypePair {
        private Type firstType;
        private Type secondType;
        private int cachedHashCode;

        TypePair(Type type, Type type2) {
            this.firstType = type;
            this.secondType = type2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof TypePair) {
                TypePair typePair = (TypePair)object;
                return this.firstType.equals(typePair.firstType) && this.secondType != null && this.secondType.equals(typePair.secondType);
            }
            return false;
        }

        public int hashCode() {
            if (this.cachedHashCode == 0) {
                int n = 0;
                if (this.firstType != null) {
                    Element element = this.firstType.getElement();
                    n = element == null ? 0 : element.hashCode();
                }
                int n2 = 0;
                if (this.secondType != null) {
                    Element element = this.secondType.getElement();
                    n2 = element == null ? 0 : element.hashCode();
                }
                this.cachedHashCode = n + n2;
            }
            return this.cachedHashCode;
        }
    }
}

