/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.type;

import com.google.common.annotations.VisibleForTesting;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.internal.element.ClassElementImpl;
import com.google.dart.engine.internal.element.ElementPair;
import com.google.dart.engine.internal.element.member.ConstructorMember;
import com.google.dart.engine.internal.element.member.MethodMember;
import com.google.dart.engine.internal.element.member.PropertyAccessorMember;
import com.google.dart.engine.internal.type.DynamicTypeImpl;
import com.google.dart.engine.internal.type.TypeImpl;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.type.TypeParameterType;
import com.google.dart.engine.utilities.general.ObjectUtilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class InterfaceTypeImpl
extends TypeImpl
implements InterfaceType {
    public static final InterfaceType[] EMPTY_ARRAY = new InterfaceType[0];
    private Type[] typeArguments = TypeImpl.EMPTY_ARRAY;

    @VisibleForTesting
    public static int computeLongestInheritancePathToObject(InterfaceType interfaceType) {
        return InterfaceTypeImpl.computeLongestInheritancePathToObject(interfaceType, 0, new HashSet<ClassElement>());
    }

    @VisibleForTesting
    public static Set<InterfaceType> computeSuperinterfaceSet(InterfaceType interfaceType) {
        return InterfaceTypeImpl.computeSuperinterfaceSet(interfaceType, new HashSet<InterfaceType>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int computeLongestInheritancePathToObject(InterfaceType interfaceType, int n, HashSet<ClassElement> hashSet) {
        ClassElement classElement = interfaceType.getElement();
        if (classElement.getSupertype() == null || hashSet.contains(classElement)) {
            return n;
        }
        int n2 = 1;
        try {
            int n3;
            Object object;
            hashSet.add(classElement);
            InterfaceType[] interfaceTypeArray = classElement.getInterfaces();
            if (interfaceTypeArray.length > 0) {
                object = interfaceTypeArray;
                int n4 = ((InterfaceType[])object).length;
                for (int i = 0; i < n4; ++i) {
                    InterfaceType interfaceType2 = object[i];
                    n3 = InterfaceTypeImpl.computeLongestInheritancePathToObject(interfaceType2, n + 1, hashSet);
                    if (n3 <= n2) continue;
                    n2 = n3;
                }
            }
            if ((n3 = InterfaceTypeImpl.computeLongestInheritancePathToObject((InterfaceType)(object = classElement.getSupertype()), n + 1, hashSet)) > n2) {
                n2 = n3;
            }
        }
        finally {
            hashSet.remove(classElement);
        }
        return n2;
    }

    private static Set<InterfaceType> computeSuperinterfaceSet(InterfaceType interfaceType, HashSet<InterfaceType> hashSet) {
        ClassElement classElement = interfaceType.getElement();
        if (classElement != null && classElement instanceof ClassElement) {
            InterfaceType[] interfaceTypeArray;
            ClassElement classElement2 = classElement;
            for (InterfaceType interfaceType2 : interfaceTypeArray = classElement2.getInterfaces()) {
                if (!hashSet.add(interfaceType2)) continue;
                InterfaceTypeImpl.computeSuperinterfaceSet(interfaceType2, hashSet);
            }
            InterfaceType interfaceType3 = classElement2.getSupertype();
            if (interfaceType3 != null && hashSet.add(interfaceType3)) {
                InterfaceTypeImpl.computeSuperinterfaceSet(interfaceType3, hashSet);
            }
        }
        return hashSet;
    }

    private static InterfaceType[] intersection(Set<InterfaceType> set, Set<InterfaceType> set2) {
        HashMap<ClassElement, InterfaceType> hashMap = new HashMap<ClassElement, InterfaceType>();
        for (InterfaceType object : set) {
            hashMap.put(object.getElement(), object);
        }
        HashSet hashSet = new HashSet();
        for (InterfaceType interfaceType : set2) {
            InterfaceType interfaceType2 = (InterfaceType)hashMap.get(interfaceType.getElement());
            if (interfaceType2 == null) continue;
            hashSet.add(InterfaceTypeImpl.leastUpperBound(interfaceType2, interfaceType));
        }
        return hashSet.toArray(new InterfaceType[hashSet.size()]);
    }

    private static InterfaceType leastUpperBound(InterfaceType interfaceType, InterfaceType interfaceType2) {
        if (interfaceType.equals(interfaceType2)) {
            return interfaceType;
        }
        Type[] typeArray = interfaceType.getTypeArguments();
        Type[] typeArray2 = interfaceType2.getTypeArguments();
        int n = typeArray.length;
        if (n == 0) {
            return interfaceType;
        }
        Type[] typeArray3 = new Type[n];
        for (int i = 0; i < n; ++i) {
            if (typeArray[i].equals(typeArray2[i])) {
                typeArray3[i] = typeArray[i];
            }
            if (typeArray3[i] != null) continue;
            typeArray3[i] = DynamicTypeImpl.getInstance();
        }
        InterfaceTypeImpl interfaceTypeImpl = new InterfaceTypeImpl(interfaceType.getElement());
        interfaceTypeImpl.setTypeArguments(typeArray3);
        return interfaceTypeImpl;
    }

    public InterfaceTypeImpl(ClassElement classElement) {
        super(classElement, classElement.getDisplayName());
    }

    private InterfaceTypeImpl(String string) {
        super(null, string);
    }

    public boolean equals(Object object) {
        return this.internalEquals(object, new HashSet<ElementPair>());
    }

    @Override
    public PropertyAccessorElement[] getAccessors() {
        PropertyAccessorElement[] propertyAccessorElementArray = this.getElement().getAccessors();
        PropertyAccessorElement[] propertyAccessorElementArray2 = new PropertyAccessorElement[propertyAccessorElementArray.length];
        for (int i = 0; i < propertyAccessorElementArray.length; ++i) {
            propertyAccessorElementArray2[i] = PropertyAccessorMember.from(propertyAccessorElementArray[i], this);
        }
        return propertyAccessorElementArray2;
    }

    @Override
    public String getDisplayName() {
        String string = this.getName();
        Type[] typeArray = this.getTypeArguments();
        boolean bl = true;
        for (Type type : typeArray) {
            if (type == null || type.isDynamic()) continue;
            bl = false;
            break;
        }
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append("<");
            for (int i = 0; i < typeArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                Type type = typeArray[i];
                stringBuilder.append(type.getDisplayName());
            }
            stringBuilder.append(">");
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public ClassElement getElement() {
        return (ClassElement)super.getElement();
    }

    @Override
    public PropertyAccessorElement getGetter(String string) {
        return PropertyAccessorMember.from(((ClassElementImpl)this.getElement()).getGetter(string), this);
    }

    @Override
    public InterfaceType[] getInterfaces() {
        ClassElement classElement = this.getElement();
        InterfaceType[] interfaceTypeArray = classElement.getInterfaces();
        TypeParameterElement[] typeParameterElementArray = classElement.getTypeParameters();
        Type[] typeArray = classElement.getType().getTypeArguments();
        if (typeParameterElementArray.length == 0) {
            return interfaceTypeArray;
        }
        int n = interfaceTypeArray.length;
        InterfaceType[] interfaceTypeArray2 = new InterfaceType[n];
        for (int i = 0; i < n; ++i) {
            interfaceTypeArray2[i] = interfaceTypeArray[i].substitute(this.typeArguments, typeArray);
        }
        return interfaceTypeArray2;
    }

    @Override
    public Type getLeastUpperBound(Type type) {
        int n;
        if (type == this) {
            return this;
        }
        DynamicTypeImpl dynamicTypeImpl = DynamicTypeImpl.getInstance();
        if (this == dynamicTypeImpl || type == dynamicTypeImpl) {
            return dynamicTypeImpl;
        }
        if (!(type instanceof InterfaceType)) {
            return null;
        }
        InterfaceTypeImpl interfaceTypeImpl = this;
        InterfaceType interfaceType = (InterfaceType)type;
        Set<InterfaceType> set = InterfaceTypeImpl.computeSuperinterfaceSet(interfaceTypeImpl);
        Set<InterfaceType> set2 = InterfaceTypeImpl.computeSuperinterfaceSet(interfaceType);
        set.add(interfaceTypeImpl);
        set2.add(interfaceType);
        InterfaceType[] interfaceTypeArray = InterfaceTypeImpl.intersection(set, set2);
        int[] nArray = new int[interfaceTypeArray.length];
        int n2 = 0;
        for (n = 0; n < interfaceTypeArray.length; ++n) {
            nArray[n] = InterfaceTypeImpl.computeLongestInheritancePathToObject(interfaceTypeArray[n]);
            if (nArray[n] <= n2) continue;
            n2 = nArray[n];
        }
        while (n2 >= 0) {
            n = -1;
            int n3 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n2) continue;
                ++n3;
                n = i;
            }
            if (n3 == 1) {
                return interfaceTypeArray[n];
            }
            --n2;
        }
        return null;
    }

    @Override
    public MethodElement getMethod(String string) {
        return MethodMember.from(((ClassElementImpl)this.getElement()).getMethod(string), this);
    }

    @Override
    public MethodElement[] getMethods() {
        MethodElement[] methodElementArray = this.getElement().getMethods();
        MethodElement[] methodElementArray2 = new MethodElement[methodElementArray.length];
        for (int i = 0; i < methodElementArray.length; ++i) {
            methodElementArray2[i] = MethodMember.from(methodElementArray[i], this);
        }
        return methodElementArray2;
    }

    @Override
    public InterfaceType[] getMixins() {
        ClassElement classElement = this.getElement();
        InterfaceType[] interfaceTypeArray = classElement.getMixins();
        TypeParameterElement[] typeParameterElementArray = classElement.getTypeParameters();
        Type[] typeArray = classElement.getType().getTypeArguments();
        if (typeParameterElementArray.length == 0) {
            return interfaceTypeArray;
        }
        int n = interfaceTypeArray.length;
        InterfaceType[] interfaceTypeArray2 = new InterfaceType[n];
        for (int i = 0; i < n; ++i) {
            interfaceTypeArray2[i] = interfaceTypeArray[i].substitute(this.typeArguments, typeArray);
        }
        return interfaceTypeArray2;
    }

    @Override
    public PropertyAccessorElement getSetter(String string) {
        return PropertyAccessorMember.from(((ClassElementImpl)this.getElement()).getSetter(string), this);
    }

    @Override
    public InterfaceType getSuperclass() {
        ClassElement classElement = this.getElement();
        InterfaceType interfaceType = classElement.getSupertype();
        if (interfaceType == null) {
            return null;
        }
        return interfaceType.substitute(this.typeArguments, classElement.getType().getTypeArguments());
    }

    @Override
    public Type[] getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public TypeParameterElement[] getTypeParameters() {
        return this.getElement().getTypeParameters();
    }

    public int hashCode() {
        ClassElement classElement = this.getElement();
        if (classElement == null) {
            return 0;
        }
        return classElement.hashCode();
    }

    @Override
    public boolean isDartCoreFunction() {
        ClassElement classElement = this.getElement();
        if (classElement == null) {
            return false;
        }
        return classElement.getName().equals("Function") && classElement.getLibrary().isDartCore();
    }

    @Override
    public boolean isDirectSupertypeOf(InterfaceType interfaceType) {
        Type[] typeArray;
        InterfaceTypeImpl interfaceTypeImpl = this;
        InterfaceType interfaceType2 = interfaceType;
        ClassElement classElement = interfaceType2.getElement();
        InterfaceType interfaceType3 = classElement.getSupertype();
        if (interfaceType3 == null) {
            return false;
        }
        Type[] typeArray2 = interfaceType2.getTypeArguments();
        if ((interfaceType3 = interfaceType3.substitute(typeArray2, typeArray = classElement.getType().getTypeArguments())).equals(interfaceTypeImpl)) {
            return true;
        }
        for (InterfaceType interfaceType4 : classElement.getInterfaces()) {
            if (!(interfaceType4 = interfaceType4.substitute(typeArray2, typeArray)).equals(interfaceTypeImpl)) continue;
            return true;
        }
        for (InterfaceType interfaceType4 : classElement.getMixins()) {
            if (!(interfaceType4 = interfaceType4.substitute(typeArray2, typeArray)).equals(interfaceTypeImpl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isObject() {
        return this.getElement().getSupertype() == null;
    }

    @Override
    public ConstructorElement lookUpConstructor(String string, LibraryElement libraryElement) {
        ConstructorElement constructorElement = string == null ? this.getElement().getUnnamedConstructor() : this.getElement().getNamedConstructor(string);
        if (constructorElement == null || !constructorElement.isAccessibleIn(libraryElement)) {
            return null;
        }
        return ConstructorMember.from(constructorElement, this);
    }

    @Override
    public PropertyAccessorElement lookUpGetter(String string, LibraryElement libraryElement) {
        PropertyAccessorElement propertyAccessorElement = this.getGetter(string);
        if (propertyAccessorElement != null && propertyAccessorElement.isAccessibleIn(libraryElement)) {
            return propertyAccessorElement;
        }
        return this.lookUpGetterInSuperclass(string, libraryElement);
    }

    @Override
    public PropertyAccessorElement lookUpGetterInSuperclass(String string, LibraryElement libraryElement) {
        ClassElement classElement;
        for (InterfaceType object : this.getMixins()) {
            InterfaceType[] interfaceTypeArray = object.getGetter(string);
            if (interfaceTypeArray == null || !interfaceTypeArray.isAccessibleIn(libraryElement)) continue;
            return interfaceTypeArray;
        }
        HashSet hashSet = new HashSet();
        InterfaceType interfaceType = this.getSuperclass();
        ClassElement classElement2 = classElement = interfaceType == null ? null : interfaceType.getElement();
        while (interfaceType != null && !hashSet.contains(classElement)) {
            hashSet.add(classElement);
            PropertyAccessorElement propertyAccessorElement = interfaceType.getGetter(string);
            if (propertyAccessorElement != null && propertyAccessorElement.isAccessibleIn(libraryElement)) {
                return propertyAccessorElement;
            }
            for (InterfaceType interfaceType2 : interfaceType.getMixins()) {
                PropertyAccessorElement propertyAccessorElement2 = interfaceType2.getGetter(string);
                if (propertyAccessorElement2 == null || !propertyAccessorElement2.isAccessibleIn(libraryElement)) continue;
                return propertyAccessorElement2;
            }
            classElement = (interfaceType = interfaceType.getSuperclass()) == null ? null : interfaceType.getElement();
        }
        return null;
    }

    @Override
    public MethodElement lookUpMethod(String string, LibraryElement libraryElement) {
        MethodElement methodElement = this.getMethod(string);
        if (methodElement != null && methodElement.isAccessibleIn(libraryElement)) {
            return methodElement;
        }
        return this.lookUpMethodInSuperclass(string, libraryElement);
    }

    @Override
    public MethodElement lookUpMethodInSuperclass(String string, LibraryElement libraryElement) {
        ClassElement classElement;
        for (InterfaceType object : this.getMixins()) {
            InterfaceType[] interfaceTypeArray = object.getMethod(string);
            if (interfaceTypeArray == null || !interfaceTypeArray.isAccessibleIn(libraryElement)) continue;
            return interfaceTypeArray;
        }
        HashSet hashSet = new HashSet();
        InterfaceType interfaceType = this.getSuperclass();
        ClassElement classElement2 = classElement = interfaceType == null ? null : interfaceType.getElement();
        while (interfaceType != null && !hashSet.contains(classElement)) {
            hashSet.add(classElement);
            MethodElement methodElement = interfaceType.getMethod(string);
            if (methodElement != null && methodElement.isAccessibleIn(libraryElement)) {
                return methodElement;
            }
            for (InterfaceType interfaceType2 : interfaceType.getMixins()) {
                MethodElement methodElement2 = interfaceType2.getMethod(string);
                if (methodElement2 == null || !methodElement2.isAccessibleIn(libraryElement)) continue;
                return methodElement2;
            }
            classElement = (interfaceType = interfaceType.getSuperclass()) == null ? null : interfaceType.getElement();
        }
        return null;
    }

    @Override
    public PropertyAccessorElement lookUpSetter(String string, LibraryElement libraryElement) {
        PropertyAccessorElement propertyAccessorElement = this.getSetter(string);
        if (propertyAccessorElement != null && propertyAccessorElement.isAccessibleIn(libraryElement)) {
            return propertyAccessorElement;
        }
        return this.lookUpSetterInSuperclass(string, libraryElement);
    }

    @Override
    public PropertyAccessorElement lookUpSetterInSuperclass(String string, LibraryElement libraryElement) {
        ClassElement classElement;
        for (InterfaceType object : this.getMixins()) {
            InterfaceType[] interfaceTypeArray = object.getSetter(string);
            if (interfaceTypeArray == null || !interfaceTypeArray.isAccessibleIn(libraryElement)) continue;
            return interfaceTypeArray;
        }
        HashSet hashSet = new HashSet();
        InterfaceType interfaceType = this.getSuperclass();
        ClassElement classElement2 = classElement = interfaceType == null ? null : interfaceType.getElement();
        while (interfaceType != null && !hashSet.contains(classElement)) {
            hashSet.add(classElement);
            PropertyAccessorElement propertyAccessorElement = interfaceType.getSetter(string);
            if (propertyAccessorElement != null && propertyAccessorElement.isAccessibleIn(libraryElement)) {
                return propertyAccessorElement;
            }
            for (InterfaceType interfaceType2 : interfaceType.getMixins()) {
                PropertyAccessorElement propertyAccessorElement2 = interfaceType2.getSetter(string);
                if (propertyAccessorElement2 == null || !propertyAccessorElement2.isAccessibleIn(libraryElement)) continue;
                return propertyAccessorElement2;
            }
            classElement = (interfaceType = interfaceType.getSuperclass()) == null ? null : interfaceType.getElement();
        }
        return null;
    }

    public void setTypeArguments(Type[] typeArray) {
        this.typeArguments = typeArray;
    }

    @Override
    public InterfaceTypeImpl substitute(Type[] typeArray) {
        return this.substitute(typeArray, this.getTypeArguments());
    }

    @Override
    public InterfaceTypeImpl substitute(Type[] typeArray, Type[] typeArray2) {
        if (typeArray.length != typeArray2.length) {
            throw new IllegalArgumentException("argumentTypes.length (" + typeArray.length + ") != parameterTypes.length (" + typeArray2.length + ")");
        }
        if (typeArray.length == 0 || this.typeArguments.length == 0) {
            return this;
        }
        Object[] objectArray = InterfaceTypeImpl.substitute(this.typeArguments, typeArray, typeArray2);
        if (Arrays.equals(objectArray, this.typeArguments)) {
            return this;
        }
        InterfaceTypeImpl interfaceTypeImpl = new InterfaceTypeImpl(this.getElement());
        interfaceTypeImpl.setTypeArguments((Type[])objectArray);
        return interfaceTypeImpl;
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.getName());
        int n = this.typeArguments.length;
        if (n > 0) {
            stringBuilder.append("<");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                ((TypeImpl)this.typeArguments[i]).appendTo(stringBuilder);
            }
            stringBuilder.append(">");
        }
    }

    @Override
    protected boolean internalEquals(Object object, Set<ElementPair> set) {
        if (!(object instanceof InterfaceTypeImpl)) {
            return false;
        }
        InterfaceTypeImpl interfaceTypeImpl = (InterfaceTypeImpl)object;
        return ObjectUtilities.equals(this.getElement(), interfaceTypeImpl.getElement()) && TypeImpl.equalArrays(this.typeArguments, interfaceTypeImpl.typeArguments, set);
    }

    @Override
    protected boolean internalIsMoreSpecificThan(Type type, boolean bl, Set<TypeImpl.TypePair> set) {
        if (type == DynamicTypeImpl.getInstance()) {
            return true;
        }
        if (!(type instanceof InterfaceType)) {
            return false;
        }
        return this.isMoreSpecificThan((InterfaceType)type, new HashSet<ClassElement>(), bl, set);
    }

    @Override
    protected boolean internalIsSubtypeOf(Type type, Set<TypeImpl.TypePair> set) {
        if (type == DynamicTypeImpl.getInstance()) {
            return true;
        }
        if (type instanceof TypeParameterType) {
            return true;
        }
        if (type instanceof FunctionType) {
            ClassElement classElement = this.getElement();
            MethodElement methodElement = classElement.lookUpMethod("call", classElement.getLibrary());
            if (methodElement != null) {
                return methodElement.getType().isSubtypeOf(type);
            }
            return false;
        }
        if (!(type instanceof InterfaceType)) {
            return false;
        }
        if (this.equals(type)) {
            return true;
        }
        return this.isSubtypeOf((InterfaceType)type, new HashSet<ClassElement>(), set);
    }

    private boolean isMoreSpecificThan(InterfaceType interfaceType, HashSet<ClassElement> hashSet, boolean bl, Set<TypeImpl.TypePair> set) {
        ClassElement classElement;
        if (this.equals(interfaceType)) {
            return true;
        }
        if (interfaceType.isDirectSupertypeOf(this)) {
            return true;
        }
        ClassElement classElement2 = this.getElement();
        if (classElement2.equals(classElement = interfaceType.getElement())) {
            Type[] typeArray;
            Type[] typeArray2 = this.getTypeArguments();
            if (typeArray2.length != (typeArray = interfaceType.getTypeArguments()).length) {
                return false;
            }
            for (int i = 0; i < typeArray2.length; ++i) {
                if (((TypeImpl)typeArray2[i]).isMoreSpecificThan(typeArray[i], bl, set)) continue;
                return false;
            }
            return true;
        }
        ClassElement classElement3 = this.getElement();
        if (classElement3 == null || hashSet.contains(classElement3)) {
            return false;
        }
        hashSet.add(classElement3);
        InterfaceType interfaceType2 = this.getSuperclass();
        if (interfaceType2 != null && ((InterfaceTypeImpl)interfaceType2).isMoreSpecificThan(interfaceType, hashSet, bl, set)) {
            return true;
        }
        for (InterfaceType interfaceType3 : this.getInterfaces()) {
            if (!((InterfaceTypeImpl)interfaceType3).isMoreSpecificThan(interfaceType, hashSet, bl, set)) continue;
            return true;
        }
        for (InterfaceType interfaceType3 : this.getMixins()) {
            if (!((InterfaceTypeImpl)interfaceType3).isMoreSpecificThan(interfaceType, hashSet, bl, set)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOf(InterfaceType interfaceType, HashSet<ClassElement> hashSet, Set<TypeImpl.TypePair> set) {
        InterfaceType[] interfaceTypeArray;
        InterfaceTypeImpl interfaceTypeImpl = this;
        InterfaceType interfaceType2 = interfaceType;
        ClassElement classElement = this.getElement();
        if (classElement == null || hashSet.contains(classElement)) {
            return false;
        }
        hashSet.add(classElement);
        if (((Object)interfaceTypeImpl).equals(interfaceType2)) {
            return true;
        }
        if (ObjectUtilities.equals(classElement, interfaceType2.getElement())) {
            Type[] typeArray;
            Type[] typeArray2 = interfaceTypeImpl.getTypeArguments();
            if (typeArray2.length != (typeArray = interfaceType2.getTypeArguments()).length) {
                return false;
            }
            for (int i = 0; i < typeArray2.length; ++i) {
                if (((TypeImpl)typeArray2[i]).isSubtypeOf(typeArray[i], set)) continue;
                return false;
            }
            return true;
        }
        if (interfaceType2.isDartCoreFunction() && classElement.getMethod("call") != null) {
            return true;
        }
        InterfaceType interfaceType3 = this.getSuperclass();
        if (interfaceType3 != null && ((InterfaceTypeImpl)interfaceType3).isSubtypeOf(interfaceType2, hashSet, set)) {
            return true;
        }
        InterfaceType[] interfaceTypeArray2 = interfaceTypeArray = this.getInterfaces();
        int n = interfaceTypeArray2.length;
        for (int i = 0; i < n; ++i) {
            InterfaceType interfaceType4 = interfaceTypeArray2[i];
            if (!((InterfaceTypeImpl)interfaceType4).isSubtypeOf(interfaceType2, hashSet, set)) continue;
            return true;
        }
        for (InterfaceType interfaceType5 : interfaceTypeArray2 = this.getMixins()) {
            if (!((InterfaceTypeImpl)interfaceType5).isSubtypeOf(interfaceType2, hashSet, set)) continue;
            return true;
        }
        return false;
    }
}

