/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.type;

import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.internal.element.ElementPair;
import com.google.dart.engine.internal.element.TypeParameterElementImpl;
import com.google.dart.engine.internal.element.member.ParameterMember;
import com.google.dart.engine.internal.type.DynamicTypeImpl;
import com.google.dart.engine.internal.type.TypeImpl;
import com.google.dart.engine.internal.type.TypeParameterTypeImpl;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.dart.ParameterKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class FunctionTypeImpl
extends TypeImpl
implements FunctionType {
    private Type[] typeArguments = TypeImpl.EMPTY_ARRAY;

    private static boolean equals(Map<String, Type> map, Map<String, Type> map2, Set<ElementPair> set) {
        if (map2.size() != map.size()) {
            return false;
        }
        Iterator<Map.Entry<String, Type>> iterator = map.entrySet().iterator();
        Iterator<Map.Entry<String, Type>> iterator2 = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Type> entry = iterator.next();
            Map.Entry<String, Type> entry2 = iterator2.next();
            if (entry.getKey().equals(entry2.getKey()) && ((TypeImpl)entry.getValue()).internalEquals(entry2.getValue(), set)) continue;
            return false;
        }
        return true;
    }

    public FunctionTypeImpl(ExecutableElement executableElement) {
        super(executableElement, executableElement == null ? null : executableElement.getName());
    }

    public FunctionTypeImpl(FunctionTypeAliasElement functionTypeAliasElement) {
        super(functionTypeAliasElement, functionTypeAliasElement == null ? null : functionTypeAliasElement.getName());
    }

    public boolean equals(Object object) {
        return this.internalEquals(object, new HashSet<ElementPair>());
    }

    @Override
    public String getDisplayName() {
        String string = this.getName();
        if (string == null || string.length() == 0) {
            Type[] typeArray = this.getNormalParameterTypes();
            Type[] typeArray2 = this.getOptionalParameterTypes();
            Map<String, Type> map = this.getNamedParameterTypes();
            Type type = this.getReturnType();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            boolean bl = false;
            if (typeArray.length > 0) {
                for (Type type2 : typeArray) {
                    if (bl) {
                        stringBuilder.append(", ");
                    } else {
                        bl = true;
                    }
                    stringBuilder.append(type2.getDisplayName());
                }
            }
            if (typeArray2.length > 0) {
                if (bl) {
                    stringBuilder.append(", ");
                    bl = false;
                }
                stringBuilder.append("[");
                for (Type type3 : typeArray2) {
                    if (bl) {
                        stringBuilder.append(", ");
                    } else {
                        bl = true;
                    }
                    stringBuilder.append(type3.getDisplayName());
                }
                stringBuilder.append("]");
                bl = true;
            }
            if (map.size() > 0) {
                if (bl) {
                    stringBuilder.append(", ");
                    bl = false;
                }
                stringBuilder.append("{");
                for (Map.Entry entry : map.entrySet()) {
                    if (bl) {
                        stringBuilder.append(", ");
                    } else {
                        bl = true;
                    }
                    stringBuilder.append((String)entry.getKey());
                    stringBuilder.append(": ");
                    stringBuilder.append(((Type)entry.getValue()).getDisplayName());
                }
                stringBuilder.append("}");
                bl = true;
            }
            stringBuilder.append(")");
            stringBuilder.append(" \u2192 ");
            if (type == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(type.getDisplayName());
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public Map<String, Type> getNamedParameterTypes() {
        LinkedHashMap<String, Type> linkedHashMap = new LinkedHashMap<String, Type>();
        ParameterElement[] parameterElementArray = this.getBaseParameters();
        if (parameterElementArray.length == 0) {
            return linkedHashMap;
        }
        Type[] typeArray = TypeParameterTypeImpl.getTypes(this.getTypeParameters());
        for (ParameterElement parameterElement : parameterElementArray) {
            if (parameterElement.getParameterKind() != ParameterKind.NAMED) continue;
            linkedHashMap.put(parameterElement.getName(), parameterElement.getType().substitute(this.typeArguments, typeArray));
        }
        return linkedHashMap;
    }

    @Override
    public Type[] getNormalParameterTypes() {
        ParameterElement[] parameterElementArray = this.getBaseParameters();
        if (parameterElementArray.length == 0) {
            return TypeImpl.EMPTY_ARRAY;
        }
        Type[] typeArray = TypeParameterTypeImpl.getTypes(this.getTypeParameters());
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (ParameterElement parameterElement : parameterElementArray) {
            if (parameterElement.getParameterKind() != ParameterKind.REQUIRED) continue;
            arrayList.add(parameterElement.getType().substitute(this.typeArguments, typeArray));
        }
        return arrayList.toArray(new Type[arrayList.size()]);
    }

    @Override
    public Type[] getOptionalParameterTypes() {
        ParameterElement[] parameterElementArray = this.getBaseParameters();
        if (parameterElementArray.length == 0) {
            return TypeImpl.EMPTY_ARRAY;
        }
        Type[] typeArray = TypeParameterTypeImpl.getTypes(this.getTypeParameters());
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (ParameterElement parameterElement : parameterElementArray) {
            if (parameterElement.getParameterKind() != ParameterKind.POSITIONAL) continue;
            arrayList.add(parameterElement.getType().substitute(this.typeArguments, typeArray));
        }
        return arrayList.toArray(new Type[arrayList.size()]);
    }

    @Override
    public ParameterElement[] getParameters() {
        ParameterElement[] parameterElementArray = this.getBaseParameters();
        int n = parameterElementArray.length;
        if (n == 0) {
            return parameterElementArray;
        }
        ParameterElement[] parameterElementArray2 = new ParameterElement[n];
        for (int i = 0; i < n; ++i) {
            parameterElementArray2[i] = ParameterMember.from(parameterElementArray[i], this);
        }
        return parameterElementArray2;
    }

    @Override
    public Type getReturnType() {
        Type type = this.getBaseReturnType();
        if (type == null) {
            return DynamicTypeImpl.getInstance();
        }
        return type.substitute(this.typeArguments, TypeParameterTypeImpl.getTypes(this.getTypeParameters()));
    }

    @Override
    public Type[] getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public TypeParameterElement[] getTypeParameters() {
        Element element = this.getElement();
        if (element instanceof FunctionTypeAliasElement) {
            return ((FunctionTypeAliasElement)element).getTypeParameters();
        }
        ClassElement classElement = element.getAncestor(ClassElement.class);
        if (classElement != null) {
            return classElement.getTypeParameters();
        }
        return TypeParameterElementImpl.EMPTY_ARRAY;
    }

    public int hashCode() {
        int n;
        if (this.getElement() == null) {
            return 0;
        }
        Type[] typeArray = this.getNormalParameterTypes();
        Type[] typeArray2 = this.getOptionalParameterTypes();
        Collection<Type> collection = this.getNamedParameterTypes().values();
        int n2 = this.getReturnType().hashCode();
        for (n = 0; n < typeArray.length; ++n) {
            n2 = (n2 << 1) + typeArray[n].hashCode();
        }
        for (n = 0; n < typeArray2.length; ++n) {
            n2 = (n2 << 1) + typeArray2[n].hashCode();
        }
        for (Type type : collection) {
            n2 = (n2 << 1) + type.hashCode();
        }
        return n2;
    }

    @Override
    public boolean internalIsMoreSpecificThan(Type type, boolean bl, Set<TypeImpl.TypePair> set) {
        Object object;
        if (type == null) {
            return false;
        }
        if (this == type || type.isDynamic() || type.isDartCoreFunction() || type.isObject()) {
            return true;
        }
        if (!(type instanceof FunctionType)) {
            return false;
        }
        if (this.equals(type)) {
            return true;
        }
        FunctionTypeImpl functionTypeImpl = this;
        FunctionType functionType = (FunctionType)type;
        Type[] typeArray = functionTypeImpl.getNormalParameterTypes();
        Type[] typeArray2 = functionTypeImpl.getOptionalParameterTypes();
        Type[] typeArray3 = functionType.getNormalParameterTypes();
        Type[] typeArray4 = functionType.getOptionalParameterTypes();
        if (typeArray4.length > 0 && functionTypeImpl.getNamedParameterTypes().size() > 0 || typeArray2.length > 0 && functionType.getNamedParameterTypes().size() > 0) {
            return false;
        }
        if (functionTypeImpl.getNamedParameterTypes().size() > 0) {
            if (functionTypeImpl.getNormalParameterTypes().length != functionType.getNormalParameterTypes().length) {
                return false;
            }
            if (functionTypeImpl.getNormalParameterTypes().length > 0) {
                for (int i = 0; i < typeArray.length; ++i) {
                    if (((TypeImpl)typeArray[i]).isMoreSpecificThan(typeArray3[i], bl, set)) continue;
                    return false;
                }
            }
            Map<String, Type> map = functionTypeImpl.getNamedParameterTypes();
            object = functionType.getNamedParameterTypes();
            if (map.size() < object.size()) {
                return false;
            }
            for (Map.Entry<String, Type> entry : object.entrySet()) {
                Type type2 = map.get(entry.getKey());
                if (type2 == null) {
                    return false;
                }
                if (((TypeImpl)type2).isMoreSpecificThan(entry.getValue(), bl, set)) continue;
                return false;
            }
        } else {
            if (functionType.getNamedParameterTypes().size() > 0) {
                return false;
            }
            int n = typeArray.length + typeArray2.length;
            int n2 = typeArray3.length + typeArray4.length;
            if (n < n2 || typeArray3.length < typeArray.length) {
                return false;
            }
            if (typeArray2.length == 0 && typeArray4.length == 0) {
                for (int i = 0; i < typeArray3.length; ++i) {
                    if (((TypeImpl)typeArray[i]).isMoreSpecificThan(typeArray3[i], bl, set)) continue;
                    return false;
                }
            } else {
                int n3;
                Type[] typeArray5 = new Type[n2];
                for (n3 = 0; n3 < typeArray.length; ++n3) {
                    typeArray5[n3] = typeArray[n3];
                }
                n3 = typeArray.length;
                int n4 = 0;
                while (n3 < n2) {
                    typeArray5[n3] = typeArray2[n4];
                    ++n3;
                    ++n4;
                }
                Type[] typeArray6 = new Type[n2];
                for (n4 = 0; n4 < typeArray3.length; ++n4) {
                    typeArray6[n4] = typeArray3[n4];
                }
                n4 = typeArray3.length;
                int n5 = 0;
                while (n4 < n2) {
                    typeArray6[n4] = typeArray4[n5];
                    ++n4;
                    ++n5;
                }
                for (n4 = 0; n4 < typeArray6.length; ++n4) {
                    if (((TypeImpl)typeArray5[n4]).isMoreSpecificThan(typeArray6[n4], bl, set)) continue;
                    return false;
                }
            }
        }
        Type type3 = functionTypeImpl.getReturnType();
        object = functionType.getReturnType();
        return object.isVoid() || ((TypeImpl)type3).isMoreSpecificThan((Type)object, bl, set);
    }

    @Override
    public boolean isAssignableTo(Type type) {
        return this.isSubtypeOf(type, new HashSet<TypeImpl.TypePair>());
    }

    public void setTypeArguments(Type[] typeArray) {
        this.typeArguments = typeArray;
    }

    @Override
    public FunctionTypeImpl substitute(Type[] typeArray) {
        return this.substitute(typeArray, this.getTypeArguments());
    }

    @Override
    public FunctionTypeImpl substitute(Type[] typeArray, Type[] typeArray2) {
        if (typeArray.length != typeArray2.length) {
            throw new IllegalArgumentException("argumentTypes.length (" + typeArray.length + ") != parameterTypes.length (" + typeArray2.length + ")");
        }
        if (typeArray.length == 0) {
            return this;
        }
        Element element = this.getElement();
        FunctionTypeImpl functionTypeImpl = element instanceof ExecutableElement ? new FunctionTypeImpl((ExecutableElement)element) : new FunctionTypeImpl((FunctionTypeAliasElement)element);
        functionTypeImpl.setTypeArguments(FunctionTypeImpl.substitute(this.typeArguments, typeArray, typeArray2));
        return functionTypeImpl;
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        Type[] typeArray = this.getNormalParameterTypes();
        Type[] typeArray2 = this.getOptionalParameterTypes();
        Map<String, Type> map = this.getNamedParameterTypes();
        Type type = this.getReturnType();
        stringBuilder.append("(");
        boolean bl = false;
        if (typeArray.length > 0) {
            for (Type type2 : typeArray) {
                if (bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = true;
                }
                ((TypeImpl)type2).appendTo(stringBuilder);
            }
        }
        if (typeArray2.length > 0) {
            if (bl) {
                stringBuilder.append(", ");
                bl = false;
            }
            stringBuilder.append("[");
            for (Type type3 : typeArray2) {
                if (bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = true;
                }
                ((TypeImpl)type3).appendTo(stringBuilder);
            }
            stringBuilder.append("]");
            bl = true;
        }
        if (map.size() > 0) {
            if (bl) {
                stringBuilder.append(", ");
                bl = false;
            }
            stringBuilder.append("{");
            for (Map.Entry entry : map.entrySet()) {
                if (bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = true;
                }
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append(": ");
                ((TypeImpl)entry.getValue()).appendTo(stringBuilder);
            }
            stringBuilder.append("}");
            bl = true;
        }
        stringBuilder.append(")");
        stringBuilder.append(" \u2192 ");
        if (type == null) {
            stringBuilder.append("null");
        } else {
            ((TypeImpl)type).appendTo(stringBuilder);
        }
    }

    protected ParameterElement[] getBaseParameters() {
        Element element = this.getElement();
        if (element instanceof ExecutableElement) {
            return ((ExecutableElement)element).getParameters();
        }
        return ((FunctionTypeAliasElement)element).getParameters();
    }

    @Override
    protected boolean internalEquals(Object object, Set<ElementPair> set) {
        if (!(object instanceof FunctionTypeImpl)) {
            return false;
        }
        FunctionTypeImpl functionTypeImpl = (FunctionTypeImpl)object;
        ElementPair elementPair = new ElementPair(this.getElement(), functionTypeImpl.getElement());
        if (!set.add(elementPair)) {
            return elementPair.getFirstElt().equals(elementPair.getSecondElt());
        }
        boolean bl = TypeImpl.equalArrays(this.getNormalParameterTypes(), functionTypeImpl.getNormalParameterTypes(), set) && TypeImpl.equalArrays(this.getOptionalParameterTypes(), functionTypeImpl.getOptionalParameterTypes(), set) && FunctionTypeImpl.equals(this.getNamedParameterTypes(), functionTypeImpl.getNamedParameterTypes(), set) && ((TypeImpl)this.getReturnType()).internalEquals(functionTypeImpl.getReturnType(), set);
        set.remove(elementPair);
        return bl;
    }

    @Override
    protected boolean internalIsSubtypeOf(Type type, Set<TypeImpl.TypePair> set) {
        Object object;
        if (type == null) {
            return false;
        }
        if (this == type || type.isDynamic() || type.isDartCoreFunction() || type.isObject()) {
            return true;
        }
        if (!(type instanceof FunctionType)) {
            return false;
        }
        if (this.equals(type)) {
            return true;
        }
        FunctionTypeImpl functionTypeImpl = this;
        FunctionType functionType = (FunctionType)type;
        Type[] typeArray = functionTypeImpl.getNormalParameterTypes();
        Type[] typeArray2 = functionTypeImpl.getOptionalParameterTypes();
        Type[] typeArray3 = functionType.getNormalParameterTypes();
        Type[] typeArray4 = functionType.getOptionalParameterTypes();
        if (typeArray4.length > 0 && functionTypeImpl.getNamedParameterTypes().size() > 0 || typeArray2.length > 0 && functionType.getNamedParameterTypes().size() > 0) {
            return false;
        }
        if (functionTypeImpl.getNamedParameterTypes().size() > 0) {
            if (functionTypeImpl.getNormalParameterTypes().length != functionType.getNormalParameterTypes().length) {
                return false;
            }
            if (functionTypeImpl.getNormalParameterTypes().length > 0) {
                for (int i = 0; i < typeArray.length; ++i) {
                    if (((TypeImpl)typeArray[i]).isAssignableTo(typeArray3[i], set)) continue;
                    return false;
                }
            }
            Map<String, Type> map = functionTypeImpl.getNamedParameterTypes();
            object = functionType.getNamedParameterTypes();
            if (map.size() < object.size()) {
                return false;
            }
            for (Map.Entry<String, Type> entry : object.entrySet()) {
                Type type2 = map.get(entry.getKey());
                if (type2 == null) {
                    return false;
                }
                if (((TypeImpl)type2).isAssignableTo(entry.getValue(), set)) continue;
                return false;
            }
        } else {
            if (functionType.getNamedParameterTypes().size() > 0) {
                return false;
            }
            int n = typeArray.length + typeArray2.length;
            int n2 = typeArray3.length + typeArray4.length;
            if (n < n2 || typeArray3.length < typeArray.length) {
                return false;
            }
            if (typeArray2.length == 0 && typeArray4.length == 0) {
                for (int i = 0; i < typeArray3.length; ++i) {
                    if (((TypeImpl)typeArray[i]).isAssignableTo(typeArray3[i], set)) continue;
                    return false;
                }
            } else {
                int n3;
                Type[] typeArray5 = new Type[n2];
                for (n3 = 0; n3 < typeArray.length; ++n3) {
                    typeArray5[n3] = typeArray[n3];
                }
                n3 = typeArray.length;
                int n4 = 0;
                while (n3 < n2) {
                    typeArray5[n3] = typeArray2[n4];
                    ++n3;
                    ++n4;
                }
                Type[] typeArray6 = new Type[n2];
                for (n4 = 0; n4 < typeArray3.length; ++n4) {
                    typeArray6[n4] = typeArray3[n4];
                }
                n4 = typeArray3.length;
                int n5 = 0;
                while (n4 < n2) {
                    typeArray6[n4] = typeArray4[n5];
                    ++n4;
                    ++n5;
                }
                for (n4 = 0; n4 < typeArray6.length; ++n4) {
                    if (((TypeImpl)typeArray5[n4]).isAssignableTo(typeArray6[n4], set)) continue;
                    return false;
                }
            }
        }
        Type type3 = functionTypeImpl.getReturnType();
        object = functionType.getReturnType();
        return object.isVoid() || ((TypeImpl)type3).isAssignableTo((Type)object, set);
    }

    private Type getBaseReturnType() {
        Element element = this.getElement();
        if (element instanceof ExecutableElement) {
            return ((ExecutableElement)element).getReturnType();
        }
        return ((FunctionTypeAliasElement)element).getReturnType();
    }
}

