/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.PerformanceStatistics;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.scanner.CharSequenceReader;
import com.google.dart.engine.scanner.Scanner;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.TimeCounter;
import com.google.dart.engine.utilities.source.LineInfo;

public class ScanDartTask
extends AnalysisTask {
    private Source source;
    private long modificationTime;
    private CharSequence content;
    private Token tokenStream;
    private LineInfo lineInfo;
    private AnalysisError[] errors = AnalysisError.NO_ERRORS;

    public ScanDartTask(InternalAnalysisContext internalAnalysisContext, Source source, long l, CharSequence charSequence) {
        super(internalAnalysisContext);
        this.source = source;
        this.modificationTime = l;
        this.content = charSequence;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitScanDartTask(this);
    }

    public AnalysisError[] getErrors() {
        return this.errors;
    }

    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public Source getSource() {
        return this.source;
    }

    public Token getTokenStream() {
        return this.tokenStream;
    }

    @Override
    protected String getTaskDescription() {
        if (this.source == null) {
            return "scan as dart null source";
        }
        return "scan as dart " + this.source.getFullName();
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        RecordingErrorListener recordingErrorListener = new RecordingErrorListener();
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.scan.start();
        try {
            Scanner scanner = new Scanner(this.source, new CharSequenceReader(this.content), recordingErrorListener);
            scanner.setPreserveComments(this.getContext().getAnalysisOptions().getPreserveComments());
            this.tokenStream = scanner.tokenize();
            this.lineInfo = new LineInfo(scanner.getLineStarts());
            this.errors = recordingErrorListener.getErrorsForSource(this.source);
        }
        catch (Exception exception) {
            throw new AnalysisException(exception);
        }
        finally {
            timeCounterHandle.stop();
        }
    }
}

