/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.internal.builder.HtmlUnitBuilder;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.source.Source;

public class ResolveHtmlTask
extends AnalysisTask {
    private Source source;
    private long modificationTime;
    private HtmlUnit unit;
    private HtmlUnit resolvedUnit;
    private HtmlElement element = null;
    private AnalysisError[] resolutionErrors = AnalysisError.NO_ERRORS;

    public ResolveHtmlTask(InternalAnalysisContext internalAnalysisContext, Source source, long l, HtmlUnit htmlUnit) {
        super(internalAnalysisContext);
        this.source = source;
        this.modificationTime = l;
        this.unit = htmlUnit;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitResolveHtmlTask(this);
    }

    public HtmlElement getElement() {
        return this.element;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public AnalysisError[] getResolutionErrors() {
        return this.resolutionErrors;
    }

    public HtmlUnit getResolvedUnit() {
        return this.resolvedUnit;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    protected String getTaskDescription() {
        if (this.source == null) {
            return "resolve as html null source";
        }
        return "resolve as html " + this.source.getFullName();
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        HtmlUnitBuilder htmlUnitBuilder = new HtmlUnitBuilder(this.getContext());
        this.element = htmlUnitBuilder.buildHtmlElement(this.source, this.modificationTime, this.unit);
        RecordingErrorListener recordingErrorListener = htmlUnitBuilder.getErrorListener();
        this.resolutionErrors = recordingErrorListener.getErrorsForSource(this.source);
        this.resolvedUnit = this.unit;
    }
}

