/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.PerformanceStatistics;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.context.ResolvableCompilationUnit;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.internal.resolver.DeclarationResolver;
import com.google.dart.engine.internal.resolver.InheritanceManager;
import com.google.dart.engine.internal.resolver.ProxyConditionalAnalysisError;
import com.google.dart.engine.internal.resolver.ResolverVisitor;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.resolver.TypeResolverVisitor;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.internal.verifier.ConstantVerifier;
import com.google.dart.engine.internal.verifier.ErrorVerifier;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.TimeCounter;

public class ResolveDartUnitTask
extends AnalysisTask {
    private Source source;
    private LibraryElement libraryElement;
    private long modificationTime = -1L;
    private CompilationUnit resolvedUnit;

    public ResolveDartUnitTask(InternalAnalysisContext internalAnalysisContext, Source source, LibraryElement libraryElement) {
        super(internalAnalysisContext);
        this.source = source;
        this.libraryElement = libraryElement;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitResolveDartUnitTask(this);
    }

    public Source getLibrarySource() {
        return this.libraryElement.getSource();
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public CompilationUnit getResolvedUnit() {
        return this.resolvedUnit;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    protected String getTaskDescription() {
        Source source = this.libraryElement.getSource();
        if (source == null) {
            return "resolve unit null source";
        }
        return "resolve unit " + source.getFullName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalPerform() throws AnalysisException {
        TypeProvider typeProvider = ((InternalAnalysisContext)this.libraryElement.getContext()).getTypeProvider();
        ResolvableCompilationUnit resolvableCompilationUnit = this.getContext().computeResolvableCompilationUnit(this.source);
        this.modificationTime = resolvableCompilationUnit.getModificationTime();
        CompilationUnit compilationUnit = resolvableCompilationUnit.getCompilationUnit();
        if (compilationUnit == null) {
            throw new AnalysisException("Internal error: computeResolvableCompilationUnit returned a value without a parsed Dart unit");
        }
        new DeclarationResolver().resolve(compilationUnit, this.find(this.libraryElement, this.source));
        RecordingErrorListener recordingErrorListener = new RecordingErrorListener();
        TypeResolverVisitor typeResolverVisitor = new TypeResolverVisitor(this.libraryElement, this.source, typeProvider, recordingErrorListener);
        compilationUnit.accept(typeResolverVisitor);
        InheritanceManager inheritanceManager = new InheritanceManager(this.libraryElement);
        ResolverVisitor resolverVisitor = new ResolverVisitor(this.libraryElement, this.source, typeProvider, inheritanceManager, (AnalysisErrorListener)recordingErrorListener);
        compilationUnit.accept(resolverVisitor);
        for (ProxyConditionalAnalysisError object : resolverVisitor.getProxyConditionalAnalysisErrors()) {
            if (!object.shouldIncludeErrorCode()) continue;
            resolverVisitor.reportError(object.getAnalysisError());
        }
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.errors.start();
        try {
            ErrorReporter errorReporter = new ErrorReporter(recordingErrorListener, this.source);
            ErrorVerifier errorVerifier = new ErrorVerifier(errorReporter, this.libraryElement, typeProvider, inheritanceManager);
            compilationUnit.accept(errorVerifier);
            ConstantVerifier constantVerifier = new ConstantVerifier(errorReporter, typeProvider);
            compilationUnit.accept(constantVerifier);
        }
        finally {
            timeCounterHandle.stop();
        }
        this.resolvedUnit = compilationUnit;
    }

    private CompilationUnitElement find(LibraryElement libraryElement, Source source) {
        CompilationUnitElement compilationUnitElement = libraryElement.getDefiningCompilationUnit();
        if (((Object)compilationUnitElement.getSource()).equals(source)) {
            return compilationUnitElement;
        }
        for (CompilationUnitElement compilationUnitElement2 : libraryElement.getParts()) {
            if (!((Object)compilationUnitElement2.getSource()).equals(source)) continue;
            return compilationUnitElement2;
        }
        return null;
    }
}

