/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.resolver.LibraryResolver;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.source.Source;

public class ResolveDartLibraryTask
extends AnalysisTask {
    private Source unitSource;
    private Source librarySource;
    private LibraryResolver resolver;

    public ResolveDartLibraryTask(InternalAnalysisContext internalAnalysisContext, Source source, Source source2) {
        super(internalAnalysisContext);
        this.unitSource = source;
        this.librarySource = source2;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitResolveDartLibraryTask(this);
    }

    public LibraryResolver getLibraryResolver() {
        return this.resolver;
    }

    public Source getLibrarySource() {
        return this.librarySource;
    }

    public Source getUnitSource() {
        return this.unitSource;
    }

    @Override
    protected String getTaskDescription() {
        if (this.librarySource == null) {
            return "resolve library null source";
        }
        return "resolve library " + this.librarySource.getFullName();
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        this.resolver = new LibraryResolver(this.getContext());
        this.resolver.resolveLibrary(this.librarySource, true);
    }
}

