/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.resolver.LibraryResolver2;
import com.google.dart.engine.internal.resolver.ResolvableLibrary;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.source.Source;
import java.util.List;

public class ResolveDartLibraryCycleTask
extends AnalysisTask {
    private Source unitSource;
    private Source librarySource;
    private List<ResolvableLibrary> librariesInCycle;
    private LibraryResolver2 resolver;

    public ResolveDartLibraryCycleTask(InternalAnalysisContext internalAnalysisContext, Source source, Source source2, List<ResolvableLibrary> list) {
        super(internalAnalysisContext);
        this.unitSource = source;
        this.librarySource = source2;
        this.librariesInCycle = list;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitResolveDartLibraryCycleTask(this);
    }

    public LibraryResolver2 getLibraryResolver() {
        return this.resolver;
    }

    public Source getLibrarySource() {
        return this.librarySource;
    }

    public Source getUnitSource() {
        return this.unitSource;
    }

    @Override
    protected String getTaskDescription() {
        if (this.librarySource == null) {
            return "resolve library null source";
        }
        return "resolve library " + this.librarySource.getFullName();
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        this.resolver = new LibraryResolver2(this.getContext());
        this.resolver.resolveLibrary(this.librarySource, this.librariesInCycle);
    }
}

