/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.element.angular.AngularApplication;
import com.google.dart.engine.internal.html.angular.AngularHtmlUnitResolver;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.source.LineInfo;

public class ResolveAngularEntryHtmlTask
extends AnalysisTask {
    private final Source source;
    private long modificationTime;
    private HtmlUnit unit;
    private final RecordingErrorListener errorListener = new RecordingErrorListener();
    private HtmlUnit resolvedUnit;
    private HtmlElement element = null;
    private AngularApplication application;

    public ResolveAngularEntryHtmlTask(InternalAnalysisContext internalAnalysisContext, Source source, long l, HtmlUnit htmlUnit) {
        super(internalAnalysisContext);
        this.source = source;
        this.modificationTime = l;
        this.unit = htmlUnit;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitResolveAngularEntryHtmlTask(this);
    }

    public AngularApplication getApplication() {
        return this.application;
    }

    public HtmlElement getElement() {
        return this.element;
    }

    public AnalysisError[] getEntryErrors() {
        return this.errorListener.getErrorsForSource(this.source);
    }

    public AnalysisError[] getErrors(Source source) {
        return this.errorListener.getErrorsForSource(source);
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public HtmlUnit getResolvedUnit() {
        return this.resolvedUnit;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    protected String getTaskDescription() {
        if (this.source == null) {
            return "resolve as Angular entry point null source";
        }
        return "resolve as Angular entry point " + this.source.getFullName();
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        LineInfo lineInfo = this.getContext().getLineInfo(this.source);
        this.application = new AngularHtmlUnitResolver(this.getContext(), this.errorListener, this.source, lineInfo, this.unit).calculateAngularApplication();
        if (this.application != null) {
            new AngularHtmlUnitResolver(this.getContext(), this.errorListener, this.source, lineInfo, this.unit).resolveEntryPoint(this.application);
        }
        this.resolvedUnit = this.unit;
    }
}

