/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.angular.AngularComponentElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.element.angular.AngularApplication;
import com.google.dart.engine.internal.html.angular.AngularHtmlUnitResolver;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.source.LineInfo;

public class ResolveAngularComponentTemplateTask
extends AnalysisTask {
    private final Source source;
    private long modificationTime;
    private HtmlUnit unit;
    private final AngularComponentElement component;
    private final AngularApplication application;
    private HtmlUnit resolvedUnit;
    private AnalysisError[] resolutionErrors = AnalysisError.NO_ERRORS;

    public ResolveAngularComponentTemplateTask(InternalAnalysisContext internalAnalysisContext, Source source, long l, HtmlUnit htmlUnit, AngularComponentElement angularComponentElement, AngularApplication angularApplication) {
        super(internalAnalysisContext);
        this.source = source;
        this.modificationTime = l;
        this.unit = htmlUnit;
        this.component = angularComponentElement;
        this.application = angularApplication;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitResolveAngularComponentTemplateTask(this);
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public AnalysisError[] getResolutionErrors() {
        return this.resolutionErrors;
    }

    public HtmlUnit getResolvedUnit() {
        return this.resolvedUnit;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    protected String getTaskDescription() {
        return "resolving Angular template " + this.source;
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        RecordingErrorListener recordingErrorListener = new RecordingErrorListener();
        LineInfo lineInfo = this.getContext().getLineInfo(this.source);
        if (this.application != null) {
            AngularHtmlUnitResolver angularHtmlUnitResolver = new AngularHtmlUnitResolver(this.getContext(), recordingErrorListener, this.source, lineInfo, this.unit);
            angularHtmlUnitResolver.resolveComponentTemplate(this.application, this.component);
            this.resolvedUnit = this.unit;
        }
        this.resolutionErrors = recordingErrorListener.getErrorsForSource(this.source);
    }
}

