/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.html.ast.HtmlScriptTagNode;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.visitor.RecursiveXmlVisitor;
import com.google.dart.engine.html.parser.HtmlParser;
import com.google.dart.engine.html.scanner.StringScanner;
import com.google.dart.engine.html.scanner.Token;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.internal.task.ParseDartTask;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.source.LineInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class ParseHtmlTask
extends AnalysisTask {
    private Source source;
    private long modificationTime;
    private CharSequence content;
    private LineInfo lineInfo;
    private HtmlUnit unit;
    private AnalysisError[] errors = AnalysisError.NO_ERRORS;
    private Source[] referencedLibraries = Source.EMPTY_ARRAY;
    private static final String ATTRIBUTE_SRC = "src";
    private static final String TAG_SCRIPT = "script";

    public ParseHtmlTask(InternalAnalysisContext internalAnalysisContext, Source source, long l, CharSequence charSequence) {
        super(internalAnalysisContext);
        this.source = source;
        this.modificationTime = l;
        this.content = charSequence;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitParseHtmlTask(this);
    }

    public AnalysisError[] getErrors() {
        return this.errors;
    }

    public HtmlUnit getHtmlUnit() {
        return this.unit;
    }

    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public Source[] getReferencedLibraries() {
        return this.referencedLibraries;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    protected String getTaskDescription() {
        if (this.source == null) {
            return "parse as html null source";
        }
        return "parse as html " + this.source.getFullName();
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        try {
            StringScanner stringScanner = new StringScanner(this.source, this.content);
            stringScanner.setPassThroughElements(new String[]{TAG_SCRIPT});
            Token token = stringScanner.tokenize();
            this.lineInfo = new LineInfo(stringScanner.getLineStarts());
            final RecordingErrorListener recordingErrorListener = new RecordingErrorListener();
            this.unit = new HtmlParser(this.source, recordingErrorListener).parse(token, this.lineInfo);
            this.unit.accept(new RecursiveXmlVisitor<Void>(){

                @Override
                public Void visitHtmlScriptTagNode(HtmlScriptTagNode htmlScriptTagNode) {
                    ParseHtmlTask.this.resolveScriptDirectives(htmlScriptTagNode.getScript(), recordingErrorListener);
                    return null;
                }
            });
            this.errors = recordingErrorListener.getErrorsForSource(this.source);
            this.referencedLibraries = this.getLibrarySources();
        }
        catch (Exception exception) {
            throw new AnalysisException(exception);
        }
    }

    private Source[] getLibrarySources() {
        final ArrayList arrayList = new ArrayList();
        this.unit.accept(new RecursiveXmlVisitor<Void>(){

            @Override
            public Void visitHtmlScriptTagNode(HtmlScriptTagNode htmlScriptTagNode) {
                XmlAttributeNode xmlAttributeNode = null;
                for (XmlAttributeNode object : htmlScriptTagNode.getAttributes()) {
                    if (!object.getName().equalsIgnoreCase(ParseHtmlTask.ATTRIBUTE_SRC)) continue;
                    xmlAttributeNode = object;
                }
                if (xmlAttributeNode != null) {
                    try {
                        URI uRI = new URI(null, null, xmlAttributeNode.getText(), null);
                        String string = uRI.getPath();
                        Source source = ParseHtmlTask.this.getContext().getSourceFactory().resolveUri(ParseHtmlTask.this.source, string);
                        if (ParseHtmlTask.this.getContext().exists(source)) {
                            arrayList.add(source);
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                return (Void)super.visitHtmlScriptTagNode(htmlScriptTagNode);
            }
        });
        if (arrayList.isEmpty()) {
            return Source.EMPTY_ARRAY;
        }
        return arrayList.toArray(new Source[arrayList.size()]);
    }

    private void resolveScriptDirectives(CompilationUnit compilationUnit, AnalysisErrorListener analysisErrorListener) {
        if (compilationUnit == null) {
            return;
        }
        InternalAnalysisContext internalAnalysisContext = this.getContext();
        for (Directive directive : compilationUnit.getDirectives()) {
            if (directive instanceof ExportDirective) {
                ParseDartTask.resolveSource(internalAnalysisContext, this.source, (ExportDirective)directive, analysisErrorListener);
                continue;
            }
            if (directive instanceof ImportDirective) {
                ParseDartTask.resolveSource(internalAnalysisContext, this.source, (ImportDirective)directive, analysisErrorListener);
                continue;
            }
            if (!(directive instanceof PartDirective)) continue;
            ParseDartTask.resolveSource(internalAnalysisContext, this.source, (PartDirective)directive, analysisErrorListener);
        }
    }
}

