/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.ast.PartOfDirective;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.ast.UriBasedDirective;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.PerformanceStatistics;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.parser.Parser;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.TimeCounter;
import com.google.dart.engine.utilities.io.UriUtilities;
import com.google.dart.engine.utilities.source.LineInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;

public class ParseDartTask
extends AnalysisTask {
    private Source source;
    private long modificationTime;
    private Token tokenStream;
    private LineInfo lineInfo;
    private CompilationUnit unit;
    private boolean containsPartOfDirective = false;
    private boolean containsNonPartOfDirective = false;
    private HashSet<Source> exportedSources = new HashSet();
    private HashSet<Source> importedSources = new HashSet();
    private HashSet<Source> includedSources = new HashSet();
    private AnalysisError[] errors = AnalysisError.NO_ERRORS;
    private static final String DART_EXT_SCHEME = "dart-ext:";

    public static Source resolveSource(AnalysisContext analysisContext, Source source, UriBasedDirective uriBasedDirective, AnalysisErrorListener analysisErrorListener) {
        StringLiteral stringLiteral = uriBasedDirective.getUri();
        if (stringLiteral instanceof StringInterpolation) {
            analysisErrorListener.onError(new AnalysisError(source, stringLiteral.getOffset(), stringLiteral.getLength(), CompileTimeErrorCode.URI_WITH_INTERPOLATION, new Object[0]));
            return null;
        }
        String string = stringLiteral.getStringValue().trim();
        uriBasedDirective.setUriContent(string);
        if (uriBasedDirective instanceof ImportDirective && string.startsWith(DART_EXT_SCHEME)) {
            return null;
        }
        try {
            String string2 = UriUtilities.encode(string);
            new URI(string2);
            Source source2 = analysisContext.getSourceFactory().resolveUri(source, string2);
            if (!analysisContext.exists(source2)) {
                analysisErrorListener.onError(new AnalysisError(source, stringLiteral.getOffset(), stringLiteral.getLength(), CompileTimeErrorCode.URI_DOES_NOT_EXIST, string));
            }
            uriBasedDirective.setSource(source2);
            return source2;
        }
        catch (URISyntaxException uRISyntaxException) {
            analysisErrorListener.onError(new AnalysisError(source, stringLiteral.getOffset(), stringLiteral.getLength(), CompileTimeErrorCode.INVALID_URI, string));
            return null;
        }
    }

    public ParseDartTask(InternalAnalysisContext internalAnalysisContext, Source source, long l, Token token, LineInfo lineInfo) {
        super(internalAnalysisContext);
        this.source = source;
        this.modificationTime = l;
        this.tokenStream = token;
        this.lineInfo = lineInfo;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitParseDartTask(this);
    }

    public CompilationUnit getCompilationUnit() {
        return this.unit;
    }

    public AnalysisError[] getErrors() {
        return this.errors;
    }

    public Source[] getExportedSources() {
        return this.toArray(this.exportedSources);
    }

    public Source[] getImportedSources() {
        return this.toArray(this.importedSources);
    }

    public Source[] getIncludedSources() {
        return this.toArray(this.includedSources);
    }

    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public Source getSource() {
        return this.source;
    }

    public boolean hasNonPartOfDirective() {
        return this.containsNonPartOfDirective;
    }

    public boolean hasPartOfDirective() {
        return this.containsPartOfDirective;
    }

    @Override
    protected String getTaskDescription() {
        if (this.source == null) {
            return "parse as dart null source";
        }
        return "parse as dart " + this.source.getFullName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalPerform() throws AnalysisException {
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.parse.start();
        try {
            RecordingErrorListener recordingErrorListener = new RecordingErrorListener();
            Parser parser = new Parser(this.source, recordingErrorListener);
            parser.setParseFunctionBodies(this.getContext().getAnalysisOptions().getAnalyzeFunctionBodies());
            this.unit = parser.parseCompilationUnit(this.tokenStream);
            this.unit.setLineInfo(this.lineInfo);
            InternalAnalysisContext internalAnalysisContext = this.getContext();
            for (Directive directive : this.unit.getDirectives()) {
                Source source;
                if (directive instanceof PartOfDirective) {
                    this.containsPartOfDirective = true;
                    continue;
                }
                this.containsNonPartOfDirective = true;
                if (directive instanceof ExportDirective) {
                    source = ParseDartTask.resolveSource(internalAnalysisContext, this.source, (ExportDirective)directive, recordingErrorListener);
                    if (source == null) continue;
                    this.exportedSources.add(source);
                    continue;
                }
                if (directive instanceof ImportDirective) {
                    source = ParseDartTask.resolveSource(internalAnalysisContext, this.source, (ImportDirective)directive, recordingErrorListener);
                    if (source == null) continue;
                    this.importedSources.add(source);
                    continue;
                }
                if (!(directive instanceof PartDirective) || (source = ParseDartTask.resolveSource(internalAnalysisContext, this.source, (PartDirective)directive, recordingErrorListener)) == null || ((Object)source).equals(this.source)) continue;
                this.includedSources.add(source);
            }
            this.errors = recordingErrorListener.getErrorsForSource(this.source);
        }
        finally {
            timeCounterHandle.stop();
        }
    }

    private Source[] toArray(HashSet<Source> hashSet) {
        int n = hashSet.size();
        if (n == 0) {
            return Source.EMPTY_ARRAY;
        }
        return hashSet.toArray(new Source[n]);
    }
}

