/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.BooleanErrorListener;
import com.google.dart.engine.internal.context.IncrementalAnalysisCache;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.resolver.IncrementalResolver;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.parser.IncrementalParser;
import com.google.dart.engine.scanner.CharSequenceReader;
import com.google.dart.engine.scanner.IncrementalScanner;
import com.google.dart.engine.source.Source;

public class IncrementalAnalysisTask
extends AnalysisTask {
    private final IncrementalAnalysisCache cache;
    private CompilationUnit updatedUnit;

    public IncrementalAnalysisTask(InternalAnalysisContext internalAnalysisContext, IncrementalAnalysisCache incrementalAnalysisCache) {
        super(internalAnalysisContext);
        this.cache = incrementalAnalysisCache;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitIncrementalAnalysisTask(this);
    }

    public IncrementalAnalysisCache getCache() {
        return this.cache;
    }

    public CompilationUnit getCompilationUnit() {
        return this.updatedUnit;
    }

    public Source getSource() {
        return this.cache != null ? this.cache.getSource() : null;
    }

    @Override
    protected String getTaskDescription() {
        return "incremental analysis " + (this.cache != null ? this.cache.getSource() : "null");
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        LibraryElement libraryElement;
        CompilationUnitElement compilationUnitElement;
        if (this.cache == null) {
            return;
        }
        if (this.cache.getOldLength() > 0 || this.cache.getNewLength() > 30) {
            return;
        }
        CharSequenceReader charSequenceReader = new CharSequenceReader(this.cache.getNewContents());
        BooleanErrorListener booleanErrorListener = new BooleanErrorListener();
        IncrementalScanner incrementalScanner = new IncrementalScanner(this.cache.getSource(), charSequenceReader, booleanErrorListener);
        incrementalScanner.rescan(this.cache.getResolvedUnit().getBeginToken(), this.cache.getOffset(), this.cache.getOldLength(), this.cache.getNewLength());
        if (booleanErrorListener.getErrorReported()) {
            return;
        }
        IncrementalParser incrementalParser = new IncrementalParser(this.cache.getSource(), incrementalScanner.getTokenMap(), AnalysisErrorListener.NULL_LISTENER);
        this.updatedUnit = incrementalParser.reparse(this.cache.getResolvedUnit(), incrementalScanner.getLeftToken(), incrementalScanner.getRightToken(), this.cache.getOffset(), this.cache.getOffset() + this.cache.getOldLength());
        TypeProvider typeProvider = this.getTypeProvider();
        if (this.updatedUnit != null && typeProvider != null && (compilationUnitElement = this.updatedUnit.getElement()) != null && (libraryElement = compilationUnitElement.getLibrary()) != null) {
            IncrementalResolver incrementalResolver = new IncrementalResolver(libraryElement, this.cache.getSource(), typeProvider, booleanErrorListener);
            incrementalResolver.resolve(incrementalParser.getUpdatedNode());
        }
    }

    private TypeProvider getTypeProvider() {
        try {
            return this.getContext().getTypeProvider();
        }
        catch (AnalysisException analysisException) {
            return null;
        }
    }
}

