/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.TimestampedData;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.source.Source;

public class GetContentTask
extends AnalysisTask {
    private Source source;
    private boolean complete = false;
    private CharSequence content;
    private long modificationTime = -1L;

    public GetContentTask(InternalAnalysisContext internalAnalysisContext, Source source) {
        super(internalAnalysisContext);
        if (source == null) {
            throw new IllegalArgumentException("Cannot get contents of null source");
        }
        this.source = source;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitGetContentTask(this);
    }

    public CharSequence getContent() {
        return this.content;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public Source getSource() {
        return this.source;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    protected String getTaskDescription() {
        return "get contents of " + this.source.getFullName();
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        this.complete = true;
        try {
            TimestampedData<CharSequence> timestampedData = this.getContext().getContents(this.source);
            this.content = timestampedData.getData();
            this.modificationTime = timestampedData.getModificationTime();
        }
        catch (Exception exception) {
            throw new AnalysisException("Could not get contents of " + this.source, exception);
        }
    }
}

