/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.context.TimestampedData;
import com.google.dart.engine.internal.hint.HintGenerator;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.source.Source;
import java.util.HashMap;

public class GenerateDartHintsTask
extends AnalysisTask {
    private TimestampedData<CompilationUnit>[] units;
    private LibraryElement libraryElement;
    private HashMap<Source, TimestampedData<AnalysisError[]>> hintMap;

    public GenerateDartHintsTask(InternalAnalysisContext internalAnalysisContext, TimestampedData<CompilationUnit>[] timestampedDataArray, LibraryElement libraryElement) {
        super(internalAnalysisContext);
        this.units = timestampedDataArray;
        this.libraryElement = libraryElement;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitGenerateDartHintsTask(this);
    }

    public HashMap<Source, TimestampedData<AnalysisError[]>> getHintMap() {
        return this.hintMap;
    }

    public LibraryElement getLibraryElement() {
        return this.libraryElement;
    }

    @Override
    protected String getTaskDescription() {
        Source source = this.libraryElement.getSource();
        if (source == null) {
            return "generate Dart hints for library without source";
        }
        return "generate Dart hints for " + source.getFullName();
    }

    @Override
    protected void internalPerform() throws AnalysisException {
        int n = this.units.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n];
        for (int i = 0; i < n; ++i) {
            compilationUnitArray[i] = this.units[i].getData();
        }
        RecordingErrorListener recordingErrorListener = new RecordingErrorListener();
        HintGenerator hintGenerator = new HintGenerator(compilationUnitArray, this.getContext(), recordingErrorListener);
        hintGenerator.generateForLibrary();
        this.hintMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            long l = this.units[i].getModificationTime();
            Source source = this.units[i].getData().getElement().getSource();
            AnalysisError[] analysisErrorArray = recordingErrorListener.getErrorsForSource(source);
            this.hintMap.put(source, new TimestampedData<AnalysisError[]>(l, analysisErrorArray));
        }
    }
}

