/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.PerformanceStatistics;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.internal.resolver.InheritanceManager;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.internal.verifier.ConstantVerifier;
import com.google.dart.engine.internal.verifier.ErrorVerifier;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.TimeCounter;

public class GenerateDartErrorsTask
extends AnalysisTask {
    private Source source;
    private long modificationTime;
    private CompilationUnit unit;
    private LibraryElement libraryElement;
    private AnalysisError[] errors;

    public GenerateDartErrorsTask(InternalAnalysisContext internalAnalysisContext, Source source, long l, CompilationUnit compilationUnit, LibraryElement libraryElement) {
        super(internalAnalysisContext);
        this.source = source;
        this.modificationTime = l;
        this.unit = compilationUnit;
        this.libraryElement = libraryElement;
    }

    @Override
    public <E> E accept(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        return analysisTaskVisitor.visitGenerateDartErrorsTask(this);
    }

    public AnalysisError[] getErrors() {
        return this.errors;
    }

    public LibraryElement getLibraryElement() {
        return this.libraryElement;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    protected String getTaskDescription() {
        return "generate errors and warnings for " + this.source.getFullName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalPerform() throws AnalysisException {
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.errors.start();
        try {
            RecordingErrorListener recordingErrorListener = new RecordingErrorListener();
            ErrorReporter errorReporter = new ErrorReporter(recordingErrorListener, this.source);
            TypeProvider typeProvider = this.getContext().getTypeProvider();
            ConstantVerifier constantVerifier = new ConstantVerifier(errorReporter, typeProvider);
            this.unit.accept(constantVerifier);
            ErrorVerifier errorVerifier = new ErrorVerifier(errorReporter, this.libraryElement, typeProvider, new InheritanceManager(this.libraryElement));
            this.unit.accept(errorVerifier);
            this.errors = recordingErrorListener.getErrorsForSource(this.source);
        }
        finally {
            timeCounterHandle.stop();
        }
    }
}

