/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.task;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;

public abstract class AnalysisTask {
    private InternalAnalysisContext context;
    private AnalysisException thrownException;

    public AnalysisTask(InternalAnalysisContext internalAnalysisContext) {
        this.context = internalAnalysisContext;
    }

    public abstract <E> E accept(AnalysisTaskVisitor<E> var1) throws AnalysisException;

    public AnalysisException getException() {
        return this.thrownException;
    }

    public <E> E perform(AnalysisTaskVisitor<E> analysisTaskVisitor) throws AnalysisException {
        try {
            this.safelyPerform();
        }
        catch (AnalysisException analysisException) {
            this.thrownException = analysisException;
            AnalysisEngine.getInstance().getLogger().logInformation("Task failed: " + this.getTaskDescription(), analysisException);
        }
        return this.accept(analysisTaskVisitor);
    }

    public String toString() {
        return this.getTaskDescription();
    }

    protected InternalAnalysisContext getContext() {
        return this.context;
    }

    protected abstract String getTaskDescription();

    protected abstract void internalPerform() throws AnalysisException;

    private void safelyPerform() throws AnalysisException {
        try {
            this.internalPerform();
        }
        catch (AnalysisException analysisException) {
            throw analysisException;
        }
        catch (Exception exception) {
            throw new AnalysisException(exception);
        }
    }
}

