/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.search.pattern;

import com.google.dart.engine.element.Element;
import com.google.dart.engine.search.MatchQuality;
import com.google.dart.engine.search.SearchPattern;
import org.apache.commons.lang3.StringUtils;

public class PrefixSearchPattern
implements SearchPattern {
    private final String prefix;
    private final boolean caseSensitive;

    public PrefixSearchPattern(String string, boolean bl) {
        this.prefix = string;
        this.caseSensitive = bl;
    }

    @Override
    public MatchQuality matches(Element element) {
        if (element == null) {
            return null;
        }
        String string = element.getDisplayName();
        if (string == null) {
            return null;
        }
        if (this.caseSensitive && StringUtils.startsWith(string, this.prefix)) {
            return MatchQuality.EXACT;
        }
        if (!this.caseSensitive && StringUtils.startsWithIgnoreCase(string, this.prefix)) {
            return MatchQuality.EXACT;
        }
        return null;
    }
}

