/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.search;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.PropertyInducingElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.element.angular.AngularElement;
import com.google.dart.engine.index.Index;
import com.google.dart.engine.index.Location;
import com.google.dart.engine.index.LocationWithData;
import com.google.dart.engine.index.Relationship;
import com.google.dart.engine.index.RelationshipCallback;
import com.google.dart.engine.internal.element.member.Member;
import com.google.dart.engine.internal.index.IndexConstants;
import com.google.dart.engine.internal.index.NameElementImpl;
import com.google.dart.engine.internal.search.listener.CountingSearchListener;
import com.google.dart.engine.internal.search.listener.FilteredSearchListener;
import com.google.dart.engine.internal.search.listener.GatheringSearchListener;
import com.google.dart.engine.internal.search.listener.NameMatchingSearchListener;
import com.google.dart.engine.internal.search.scope.LibrarySearchScope;
import com.google.dart.engine.search.MatchKind;
import com.google.dart.engine.search.MatchQuality;
import com.google.dart.engine.search.SearchEngine;
import com.google.dart.engine.search.SearchFilter;
import com.google.dart.engine.search.SearchListener;
import com.google.dart.engine.search.SearchMatch;
import com.google.dart.engine.search.SearchPattern;
import com.google.dart.engine.search.SearchScope;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.source.SourceRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class SearchEngineImpl
implements SearchEngine {
    private Index index;

    private static SearchListener applyFilter(SearchFilter searchFilter, SearchListener searchListener) {
        if (searchFilter == null) {
            return searchListener;
        }
        return new FilteredSearchListener(searchFilter, searchListener);
    }

    private static SearchListener applyPattern(SearchPattern searchPattern, SearchListener searchListener) {
        if (searchPattern == null) {
            return searchListener;
        }
        return new NameMatchingSearchListener(searchPattern, searchListener);
    }

    private static Element[] createElements(SearchScope searchScope) {
        if (searchScope instanceof LibrarySearchScope) {
            return ((LibrarySearchScope)searchScope).getLibraries();
        }
        return new Element[]{IndexConstants.UNIVERSE};
    }

    private static RelationshipCallback newCallback(MatchKind matchKind, SearchScope searchScope, SearchListener searchListener) {
        return new RelationshipCallbackImpl(searchScope, matchKind, searchListener);
    }

    public SearchEngineImpl(Index index) {
        this.index = index;
    }

    @Override
    public Set<Type> searchAssignedTypes(PropertyInducingElement propertyInducingElement, SearchScope searchScope) {
        class Callback
        implements RelationshipCallback {
            Callback() {
            }

            @Override
            public void hasRelationships(Element element, Relationship relationship, Location[] locationArray) {
                Collections.addAll(arrayList, locationArray);
                countDownLatch.countDown();
            }
        }
        PropertyAccessorElement propertyAccessorElement = propertyInducingElement.getSetter();
        int n = (propertyAccessorElement != null ? 2 : 0) + 2;
        final ArrayList<Location> arrayList = Lists.newArrayList();
        final CountDownLatch countDownLatch = new CountDownLatch(n);
        if (propertyAccessorElement != null) {
            this.index.getRelationships(propertyAccessorElement, IndexConstants.IS_REFERENCED_BY_QUALIFIED, new Callback());
            this.index.getRelationships(propertyAccessorElement, IndexConstants.IS_REFERENCED_BY_UNQUALIFIED, new Callback());
        }
        this.index.getRelationships(propertyInducingElement, IndexConstants.IS_REFERENCED_BY, new Callback());
        this.index.getRelationships(propertyInducingElement, IndexConstants.IS_DEFINED_BY, new Callback());
        Uninterruptibles.awaitUninterruptibly(countDownLatch);
        HashSet<Type> hashSet = Sets.newHashSet();
        for (Location location : arrayList) {
            Object d;
            Object object;
            if (searchScope != null && !searchScope.encloses((Element)(object = location.getElement())) || !(location instanceof LocationWithData) || !((d = ((LocationWithData)(object = (LocationWithData)location)).getData()) instanceof Type)) continue;
            Type type = (Type)d;
            hashSet.add(type);
        }
        return hashSet;
    }

    @Override
    public List<SearchMatch> searchDeclarations(final String string, final SearchScope searchScope, final SearchFilter searchFilter) {
        return this.gatherResults(new SearchRunner(){

            @Override
            public void performSearch(SearchListener searchListener) {
                SearchEngineImpl.this.searchDeclarations(string, searchScope, searchFilter, searchListener);
            }
        });
    }

    @Override
    public void searchDeclarations(String string, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        this.index.getRelationships(new NameElementImpl(string), IndexConstants.IS_DEFINED_BY, SearchEngineImpl.newCallback(MatchKind.NAME_DECLARATION, searchScope, searchListener));
    }

    @Override
    public List<SearchMatch> searchFunctionDeclarations(final SearchScope searchScope, final SearchPattern searchPattern, final SearchFilter searchFilter) {
        return this.gatherResults(new SearchRunner(){

            @Override
            public void performSearch(SearchListener searchListener) {
                SearchEngineImpl.this.searchFunctionDeclarations(searchScope, searchPattern, searchFilter, searchListener);
            }
        });
    }

    @Override
    public void searchFunctionDeclarations(SearchScope searchScope, SearchPattern searchPattern, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        Element[] elementArray = SearchEngineImpl.createElements(searchScope);
        searchListener = SearchEngineImpl.applyPattern(searchPattern, searchListener);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(elementArray.length, searchListener);
        for (Element element : elementArray) {
            this.index.getRelationships(element, IndexConstants.DEFINES_FUNCTION, SearchEngineImpl.newCallback(MatchKind.FUNCTION_DECLARATION, searchScope, searchListener));
        }
    }

    @Override
    public List<SearchMatch> searchQualifiedMemberReferences(final String string, final SearchScope searchScope, final SearchFilter searchFilter) {
        return this.gatherResults(new SearchRunner(){

            @Override
            public void performSearch(SearchListener searchListener) {
                SearchEngineImpl.this.searchQualifiedMemberReferences(string, searchScope, searchFilter, searchListener);
            }
        });
    }

    @Override
    public void searchQualifiedMemberReferences(String string, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(2, searchListener);
        this.index.getRelationships(new NameElementImpl(string), IndexConstants.IS_REFERENCED_BY_QUALIFIED_RESOLVED, SearchEngineImpl.newCallback(MatchKind.NAME_REFERENCE_RESOLVED, searchScope, searchListener));
        this.index.getRelationships(new NameElementImpl(string), IndexConstants.IS_REFERENCED_BY_QUALIFIED_UNRESOLVED, SearchEngineImpl.newCallback(MatchKind.NAME_REFERENCE_UNRESOLVED, searchScope, searchListener));
    }

    @Override
    public List<SearchMatch> searchReferences(final Element element, final SearchScope searchScope, final SearchFilter searchFilter) {
        return this.gatherResults(new SearchRunner(){

            @Override
            public void performSearch(SearchListener searchListener) {
                SearchEngineImpl.this.searchReferences(element, searchScope, searchFilter, searchListener);
            }
        });
    }

    @Override
    public void searchReferences(Element element, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        if (element == null) {
            searchListener.searchComplete();
            return;
        }
        if (element instanceof Member) {
            element = ((Member)element).getBaseElement();
        }
        switch (element.getKind()) {
            case ANGULAR_COMPONENT: 
            case ANGULAR_CONTROLLER: 
            case ANGULAR_FILTER: 
            case ANGULAR_PROPERTY: 
            case ANGULAR_SCOPE_PROPERTY: 
            case ANGULAR_SELECTOR: {
                this.searchReferences((AngularElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case CLASS: {
                this.searchReferences((ClassElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case COMPILATION_UNIT: {
                this.searchReferences((CompilationUnitElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case CONSTRUCTOR: {
                this.searchReferences((ConstructorElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case FIELD: 
            case TOP_LEVEL_VARIABLE: {
                this.searchReferences((PropertyInducingElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case FUNCTION: {
                this.searchReferences((FunctionElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case GETTER: 
            case SETTER: {
                this.searchReferences((PropertyAccessorElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case IMPORT: {
                this.searchReferences((ImportElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case LIBRARY: {
                this.searchReferences((LibraryElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case LOCAL_VARIABLE: {
                this.searchReferences((LocalVariableElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case METHOD: {
                this.searchReferences((MethodElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case PARAMETER: {
                this.searchReferences((ParameterElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case FUNCTION_TYPE_ALIAS: {
                this.searchReferences((FunctionTypeAliasElement)element, searchScope, searchFilter, searchListener);
                return;
            }
            case TYPE_PARAMETER: {
                this.searchReferences((TypeParameterElement)element, searchScope, searchFilter, searchListener);
                return;
            }
        }
        searchListener.searchComplete();
    }

    @Override
    public List<SearchMatch> searchSubtypes(final ClassElement classElement, final SearchScope searchScope, final SearchFilter searchFilter) {
        return this.gatherResults(new SearchRunner(){

            @Override
            public void performSearch(SearchListener searchListener) {
                SearchEngineImpl.this.searchSubtypes(classElement, searchScope, searchFilter, searchListener);
            }
        });
    }

    @Override
    public void searchSubtypes(ClassElement classElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(3, searchListener);
        this.index.getRelationships(classElement, IndexConstants.IS_EXTENDED_BY, SearchEngineImpl.newCallback(MatchKind.EXTENDS_REFERENCE, searchScope, searchListener));
        this.index.getRelationships(classElement, IndexConstants.IS_MIXED_IN_BY, SearchEngineImpl.newCallback(MatchKind.WITH_REFERENCE, searchScope, searchListener));
        this.index.getRelationships(classElement, IndexConstants.IS_IMPLEMENTED_BY, SearchEngineImpl.newCallback(MatchKind.IMPLEMENTS_REFERENCE, searchScope, searchListener));
    }

    @Override
    public List<SearchMatch> searchTypeDeclarations(final SearchScope searchScope, final SearchPattern searchPattern, final SearchFilter searchFilter) {
        return this.gatherResults(new SearchRunner(){

            @Override
            public void performSearch(SearchListener searchListener) {
                SearchEngineImpl.this.searchTypeDeclarations(searchScope, searchPattern, searchFilter, searchListener);
            }
        });
    }

    @Override
    public void searchTypeDeclarations(SearchScope searchScope, SearchPattern searchPattern, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        Element[] elementArray = SearchEngineImpl.createElements(searchScope);
        searchListener = SearchEngineImpl.applyPattern(searchPattern, searchListener);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(elementArray.length * 3, searchListener);
        for (Element element : elementArray) {
            this.index.getRelationships(element, IndexConstants.DEFINES_CLASS, SearchEngineImpl.newCallback(MatchKind.CLASS_DECLARATION, searchScope, searchListener));
            this.index.getRelationships(element, IndexConstants.DEFINES_CLASS_ALIAS, SearchEngineImpl.newCallback(MatchKind.CLASS_ALIAS_DECLARATION, searchScope, searchListener));
            this.index.getRelationships(element, IndexConstants.DEFINES_FUNCTION_TYPE, SearchEngineImpl.newCallback(MatchKind.FUNCTION_TYPE_DECLARATION, searchScope, searchListener));
        }
    }

    @Override
    public List<SearchMatch> searchVariableDeclarations(final SearchScope searchScope, final SearchPattern searchPattern, final SearchFilter searchFilter) {
        return this.gatherResults(new SearchRunner(){

            @Override
            public void performSearch(SearchListener searchListener) {
                SearchEngineImpl.this.searchVariableDeclarations(searchScope, searchPattern, searchFilter, searchListener);
            }
        });
    }

    @Override
    public void searchVariableDeclarations(SearchScope searchScope, SearchPattern searchPattern, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        Element[] elementArray = SearchEngineImpl.createElements(searchScope);
        searchListener = SearchEngineImpl.applyPattern(searchPattern, searchListener);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(elementArray.length, searchListener);
        for (Element element : elementArray) {
            this.index.getRelationships(element, IndexConstants.DEFINES_VARIABLE, SearchEngineImpl.newCallback(MatchKind.VARIABLE_DECLARATION, searchScope, searchListener));
        }
    }

    private List<SearchMatch> gatherResults(SearchRunner searchRunner) {
        GatheringSearchListener gatheringSearchListener = new GatheringSearchListener();
        searchRunner.performSearch(gatheringSearchListener);
        while (!gatheringSearchListener.isComplete()) {
            Thread.yield();
        }
        return gatheringSearchListener.getMatches();
    }

    private void searchReferences(AngularElement angularElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(2, searchListener);
        this.index.getRelationships(angularElement, IndexConstants.ANGULAR_REFERENCE, SearchEngineImpl.newCallback(MatchKind.ANGULAR_REFERENCE, searchScope, searchListener));
        this.index.getRelationships(angularElement, IndexConstants.ANGULAR_CLOSING_TAG_REFERENCE, SearchEngineImpl.newCallback(MatchKind.ANGULAR_CLOSING_TAG_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(ClassElement classElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        this.index.getRelationships(classElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.TYPE_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(CompilationUnitElement compilationUnitElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        this.index.getRelationships(compilationUnitElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.UNIT_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(ConstructorElement constructorElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(2, searchListener);
        this.index.getRelationships(constructorElement, IndexConstants.IS_DEFINED_BY, SearchEngineImpl.newCallback(MatchKind.CONSTRUCTOR_DECLARATION, searchScope, searchListener));
        this.index.getRelationships(constructorElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.CONSTRUCTOR_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(FunctionElement functionElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(2, searchListener);
        this.index.getRelationships(functionElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.FUNCTION_REFERENCE, searchScope, searchListener));
        this.index.getRelationships(functionElement, IndexConstants.IS_INVOKED_BY, SearchEngineImpl.newCallback(MatchKind.FUNCTION_EXECUTION, searchScope, searchListener));
    }

    private void searchReferences(FunctionTypeAliasElement functionTypeAliasElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        this.index.getRelationships(functionTypeAliasElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.FUNCTION_TYPE_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(ImportElement importElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        this.index.getRelationships(importElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.IMPORT_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(LibraryElement libraryElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        this.index.getRelationships(libraryElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.LIBRARY_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(MethodElement methodElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(4, searchListener);
        this.index.getRelationships(methodElement, IndexConstants.IS_INVOKED_BY_UNQUALIFIED, SearchEngineImpl.newCallback(MatchKind.METHOD_INVOCATION, searchScope, searchListener));
        this.index.getRelationships(methodElement, IndexConstants.IS_INVOKED_BY_QUALIFIED, SearchEngineImpl.newCallback(MatchKind.METHOD_INVOCATION, searchScope, searchListener));
        this.index.getRelationships(methodElement, IndexConstants.IS_REFERENCED_BY_UNQUALIFIED, SearchEngineImpl.newCallback(MatchKind.METHOD_REFERENCE, searchScope, searchListener));
        this.index.getRelationships(methodElement, IndexConstants.IS_REFERENCED_BY_QUALIFIED, SearchEngineImpl.newCallback(MatchKind.METHOD_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(ParameterElement parameterElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(4, searchListener);
        this.index.getRelationships(parameterElement, IndexConstants.IS_READ_BY, SearchEngineImpl.newCallback(MatchKind.VARIABLE_READ, searchScope, searchListener));
        this.index.getRelationships(parameterElement, IndexConstants.IS_READ_WRITTEN_BY, SearchEngineImpl.newCallback(MatchKind.VARIABLE_READ_WRITE, searchScope, searchListener));
        this.index.getRelationships(parameterElement, IndexConstants.IS_WRITTEN_BY, SearchEngineImpl.newCallback(MatchKind.VARIABLE_WRITE, searchScope, searchListener));
        this.index.getRelationships(parameterElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.NAMED_PARAMETER_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(PropertyAccessorElement propertyAccessorElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(2, searchListener);
        this.index.getRelationships(propertyAccessorElement, IndexConstants.IS_REFERENCED_BY_QUALIFIED, SearchEngineImpl.newCallback(MatchKind.PROPERTY_ACCESSOR_REFERENCE, searchScope, searchListener));
        this.index.getRelationships(propertyAccessorElement, IndexConstants.IS_REFERENCED_BY_UNQUALIFIED, SearchEngineImpl.newCallback(MatchKind.PROPERTY_ACCESSOR_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(PropertyInducingElement propertyInducingElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        PropertyAccessorElement propertyAccessorElement = propertyInducingElement.getGetter();
        PropertyAccessorElement propertyAccessorElement2 = propertyInducingElement.getSetter();
        int n = (propertyAccessorElement != null ? 2 : 0) + (propertyAccessorElement2 != null ? 2 : 0) + 2;
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(n, searchListener);
        if (propertyAccessorElement != null) {
            this.index.getRelationships(propertyAccessorElement, IndexConstants.IS_REFERENCED_BY_QUALIFIED, SearchEngineImpl.newCallback(MatchKind.FIELD_READ, searchScope, searchListener));
            this.index.getRelationships(propertyAccessorElement, IndexConstants.IS_REFERENCED_BY_UNQUALIFIED, SearchEngineImpl.newCallback(MatchKind.FIELD_READ, searchScope, searchListener));
        }
        if (propertyAccessorElement2 != null) {
            this.index.getRelationships(propertyAccessorElement2, IndexConstants.IS_REFERENCED_BY_QUALIFIED, SearchEngineImpl.newCallback(MatchKind.FIELD_WRITE, searchScope, searchListener));
            this.index.getRelationships(propertyAccessorElement2, IndexConstants.IS_REFERENCED_BY_UNQUALIFIED, SearchEngineImpl.newCallback(MatchKind.FIELD_WRITE, searchScope, searchListener));
        }
        this.index.getRelationships(propertyInducingElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.FIELD_REFERENCE, searchScope, searchListener));
        this.index.getRelationships(propertyInducingElement, IndexConstants.IS_REFERENCED_BY_QUALIFIED, SearchEngineImpl.newCallback(MatchKind.FIELD_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(TypeParameterElement typeParameterElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        this.index.getRelationships(typeParameterElement, IndexConstants.IS_REFERENCED_BY, SearchEngineImpl.newCallback(MatchKind.TYPE_PARAMETER_REFERENCE, searchScope, searchListener));
    }

    private void searchReferences(VariableElement variableElement, SearchScope searchScope, SearchFilter searchFilter, SearchListener searchListener) {
        assert (searchListener != null);
        searchListener = SearchEngineImpl.applyFilter(searchFilter, searchListener);
        searchListener = new CountingSearchListener(3, searchListener);
        this.index.getRelationships(variableElement, IndexConstants.IS_READ_BY, SearchEngineImpl.newCallback(MatchKind.VARIABLE_READ, searchScope, searchListener));
        this.index.getRelationships(variableElement, IndexConstants.IS_READ_WRITTEN_BY, SearchEngineImpl.newCallback(MatchKind.VARIABLE_READ_WRITE, searchScope, searchListener));
        this.index.getRelationships(variableElement, IndexConstants.IS_WRITTEN_BY, SearchEngineImpl.newCallback(MatchKind.VARIABLE_WRITE, searchScope, searchListener));
    }

    private static interface SearchRunner {
        public void performSearch(SearchListener var1);
    }

    private static class RelationshipCallbackImpl
    implements RelationshipCallback {
        private final SearchScope scope;
        private MatchKind matchKind;
        private SearchListener listener;

        public RelationshipCallbackImpl(SearchScope searchScope, MatchKind matchKind, SearchListener searchListener) {
            this.scope = searchScope;
            this.matchKind = matchKind;
            this.listener = searchListener;
        }

        @Override
        public void hasRelationships(Element element, Relationship relationship, Location[] locationArray) {
            for (Location location : locationArray) {
                Element element2 = location.getElement();
                if (this.scope != null && !this.scope.encloses(element2)) continue;
                SourceRange sourceRange = new SourceRange(location.getOffset(), location.getLength());
                MatchQuality matchQuality = MatchQuality.EXACT;
                SearchMatch searchMatch = new SearchMatch(matchQuality, this.matchKind, element2, sourceRange);
                searchMatch.setQualified(relationship == IndexConstants.IS_REFERENCED_BY_QUALIFIED || relationship == IndexConstants.IS_INVOKED_BY_QUALIFIED);
                this.listener.matchFound(searchMatch);
            }
            this.listener.searchComplete();
        }
    }
}

