/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.sdk;

import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.error.BooleanErrorListener;
import com.google.dart.engine.internal.sdk.LibraryMap;
import com.google.dart.engine.internal.sdk.SdkLibraryImpl;
import com.google.dart.engine.parser.Parser;
import com.google.dart.engine.scanner.CharSequenceReader;
import com.google.dart.engine.scanner.Scanner;
import com.google.dart.engine.source.FileBasedSource;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.UriKind;
import java.io.File;

public class SdkLibrariesReader {
    private boolean useDart2jsPaths;

    public SdkLibrariesReader(boolean bl) {
        this.useDart2jsPaths = bl;
    }

    public LibraryMap readFromFile(File file, String string) {
        return this.readFromSource(new FileBasedSource(file, UriKind.FILE_URI), string);
    }

    public LibraryMap readFromSource(Source source, String string) {
        BooleanErrorListener booleanErrorListener = new BooleanErrorListener();
        Scanner scanner = new Scanner(source, new CharSequenceReader(string), booleanErrorListener);
        Parser parser = new Parser(source, booleanErrorListener);
        CompilationUnit compilationUnit = parser.parseCompilationUnit(scanner.tokenize());
        LibraryBuilder libraryBuilder = new LibraryBuilder(this.useDart2jsPaths);
        if (!booleanErrorListener.getErrorReported()) {
            compilationUnit.accept(libraryBuilder);
        }
        return libraryBuilder.getLibrariesMap();
    }

    public static class LibraryBuilder
    extends RecursiveAstVisitor<Void> {
        private static final String LIBRARY_PREFIX = "dart:";
        private static final String IMPLEMENTATION = "implementation";
        private static final String DART2JS_PATH = "dart2jsPath";
        private static final String DOCUMENTED = "documented";
        private static final String CATEGORY = "category";
        private static final String PLATFORMS = "platforms";
        private static final String VM_PLATFORM = "VM_PLATFORM";
        private boolean useDart2jsPaths;
        private LibraryMap librariesMap = new LibraryMap();

        public LibraryBuilder(boolean bl) {
            this.useDart2jsPaths = bl;
        }

        public LibraryMap getLibrariesMap() {
            return this.librariesMap;
        }

        @Override
        public Void visitMapLiteralEntry(MapLiteralEntry mapLiteralEntry) {
            Expression expression;
            String string = null;
            Expression expression2 = mapLiteralEntry.getKey();
            if (expression2 instanceof SimpleStringLiteral) {
                string = LIBRARY_PREFIX + ((SimpleStringLiteral)expression2).getValue();
            }
            if ((expression = mapLiteralEntry.getValue()) instanceof InstanceCreationExpression) {
                SdkLibraryImpl sdkLibraryImpl = new SdkLibraryImpl(string);
                NodeList<Expression> nodeList = ((InstanceCreationExpression)expression).getArgumentList().getArguments();
                for (Expression expression3 : nodeList) {
                    if (expression3 instanceof SimpleStringLiteral) {
                        sdkLibraryImpl.setPath(((SimpleStringLiteral)expression3).getValue());
                        continue;
                    }
                    if (!(expression3 instanceof NamedExpression)) continue;
                    String string2 = ((NamedExpression)expression3).getName().getLabel().getName();
                    Expression expression4 = ((NamedExpression)expression3).getExpression();
                    if (string2.equals(CATEGORY)) {
                        sdkLibraryImpl.setCategory(((SimpleStringLiteral)expression4).getValue());
                        continue;
                    }
                    if (string2.equals(IMPLEMENTATION)) {
                        sdkLibraryImpl.setImplementation(((BooleanLiteral)expression4).getValue());
                        continue;
                    }
                    if (string2.equals(DOCUMENTED)) {
                        sdkLibraryImpl.setDocumented(((BooleanLiteral)expression4).getValue());
                        continue;
                    }
                    if (string2.equals(PLATFORMS)) {
                        if (!(expression4 instanceof SimpleIdentifier)) continue;
                        String string3 = ((SimpleIdentifier)expression4).getName();
                        if (string3.equals(VM_PLATFORM)) {
                            sdkLibraryImpl.setVmLibrary();
                            continue;
                        }
                        sdkLibraryImpl.setDart2JsLibrary();
                        continue;
                    }
                    if (!this.useDart2jsPaths || !string2.equals(DART2JS_PATH) || !(expression4 instanceof SimpleStringLiteral)) continue;
                    sdkLibraryImpl.setPath(((SimpleStringLiteral)expression4).getValue());
                }
                this.librariesMap.setLibrary(string, sdkLibraryImpl);
            }
            return null;
        }
    }
}

