/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.scope;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.internal.scope.ClassScope;
import com.google.dart.engine.internal.scope.FunctionScope;
import com.google.dart.engine.internal.scope.FunctionTypeScope;
import com.google.dart.engine.internal.scope.LibraryScope;
import com.google.dart.engine.internal.scope.Scope;

public final class ScopeBuilder {
    private AnalysisErrorListener errorListener;

    public static Scope scopeFor(AstNode astNode, AnalysisErrorListener analysisErrorListener) throws AnalysisException {
        if (astNode == null) {
            throw new AnalysisException("Cannot create scope: node is null");
        }
        if (astNode instanceof CompilationUnit) {
            ScopeBuilder scopeBuilder = new ScopeBuilder(analysisErrorListener);
            return scopeBuilder.scopeForAstNode(astNode);
        }
        AstNode astNode2 = astNode.getParent();
        if (astNode2 == null) {
            throw new AnalysisException("Cannot create scope: node is not part of a CompilationUnit");
        }
        ScopeBuilder scopeBuilder = new ScopeBuilder(analysisErrorListener);
        return scopeBuilder.scopeForAstNode(astNode2);
    }

    private ScopeBuilder(AnalysisErrorListener analysisErrorListener) {
        this.errorListener = analysisErrorListener;
    }

    private Scope scopeForAstNode(AstNode astNode) throws AnalysisException {
        if (astNode instanceof CompilationUnit) {
            return this.scopeForCompilationUnit((CompilationUnit)astNode);
        }
        AstNode astNode2 = astNode.getParent();
        if (astNode2 == null) {
            throw new AnalysisException("Cannot create scope: node is not part of a CompilationUnit");
        }
        Scope scope = this.scopeForAstNode(astNode2);
        if (astNode instanceof ClassDeclaration) {
            ClassElement classElement = ((ClassDeclaration)astNode).getElement();
            if (classElement == null) {
                throw new AnalysisException("Cannot build a scope for an unresolved class");
            }
            scope = new ClassScope(scope, classElement);
        } else if (astNode instanceof ClassTypeAlias) {
            ClassElement classElement = ((ClassTypeAlias)astNode).getElement();
            if (classElement == null) {
                throw new AnalysisException("Cannot build a scope for an unresolved class type alias");
            }
            scope = new ClassScope(scope, classElement);
        } else if (astNode instanceof ConstructorDeclaration) {
            ConstructorElement constructorElement = ((ConstructorDeclaration)astNode).getElement();
            if (constructorElement == null) {
                throw new AnalysisException("Cannot build a scope for an unresolved constructor");
            }
            FunctionScope functionScope = new FunctionScope(scope, constructorElement);
            functionScope.defineParameters();
            scope = functionScope;
        } else if (astNode instanceof FunctionDeclaration) {
            ExecutableElement executableElement = ((FunctionDeclaration)astNode).getElement();
            if (executableElement == null) {
                throw new AnalysisException("Cannot build a scope for an unresolved function");
            }
            FunctionScope functionScope = new FunctionScope(scope, executableElement);
            functionScope.defineParameters();
            scope = functionScope;
        } else if (astNode instanceof FunctionTypeAlias) {
            scope = new FunctionTypeScope(scope, ((FunctionTypeAlias)astNode).getElement());
        } else if (astNode instanceof MethodDeclaration) {
            ExecutableElement executableElement = ((MethodDeclaration)astNode).getElement();
            if (executableElement == null) {
                throw new AnalysisException("Cannot build a scope for an unresolved method");
            }
            FunctionScope functionScope = new FunctionScope(scope, executableElement);
            functionScope.defineParameters();
            scope = functionScope;
        }
        return scope;
    }

    private Scope scopeForCompilationUnit(CompilationUnit compilationUnit) throws AnalysisException {
        CompilationUnitElement compilationUnitElement = compilationUnit.getElement();
        if (compilationUnitElement == null) {
            throw new AnalysisException("Cannot create scope: compilation unit is not resolved");
        }
        LibraryElement libraryElement = compilationUnitElement.getLibrary();
        if (libraryElement == null) {
            throw new AnalysisException("Cannot create scope: compilation unit is not part of a library");
        }
        return new LibraryScope(libraryElement, this.errorListener);
    }
}

