/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.scope;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.StringUtilities;
import java.util.HashMap;

public abstract class Scope {
    public static final int PRIVATE_NAME_PREFIX = 95;
    public static final String SETTER_SUFFIX = "=";
    public static final String UNARY_MINUS = "unary-";
    private HashMap<String, Element> definedNames = new HashMap();
    private boolean hasName = false;

    public static boolean isPrivateName(String string) {
        return string != null && StringUtilities.startsWithChar(string, 95);
    }

    public void define(Element element) {
        String string = this.getName(element);
        if (string != null && !string.isEmpty()) {
            if (this.definedNames.containsKey(string)) {
                this.getErrorListener().onError(this.getErrorForDuplicate(this.definedNames.get(string), element));
            } else {
                this.definedNames.put(string, element);
                this.hasName = true;
            }
        }
    }

    public Scope getEnclosingScope() {
        return null;
    }

    public Element lookup(Identifier identifier, LibraryElement libraryElement) {
        return this.internalLookup(identifier, identifier.getName(), libraryElement);
    }

    protected void defineNameWithoutChecking(String string, Element element) {
        this.definedNames.put(string, element);
        this.hasName = true;
    }

    protected void defineWithoutChecking(Element element) {
        this.definedNames.put(this.getName(element), element);
        this.hasName = true;
    }

    protected AnalysisError getErrorForDuplicate(Element element, Element element2) {
        Source source = element2.getSource();
        return new AnalysisError(source, element2.getNameOffset(), element2.getDisplayName().length(), CompileTimeErrorCode.DUPLICATE_DEFINITION, element.getDisplayName());
    }

    protected abstract AnalysisErrorListener getErrorListener();

    protected final Source getSource(AstNode astNode) {
        CompilationUnitElement compilationUnitElement;
        CompilationUnit compilationUnit = astNode.getAncestor(CompilationUnit.class);
        if (compilationUnit != null && (compilationUnitElement = compilationUnit.getElement()) != null) {
            return compilationUnitElement.getSource();
        }
        return null;
    }

    protected abstract Element internalLookup(Identifier var1, String var2, LibraryElement var3);

    protected Element localLookup(String string, LibraryElement libraryElement) {
        if (this.hasName) {
            return this.definedNames.get(string);
        }
        return null;
    }

    private String getName(Element element) {
        MethodElement methodElement;
        if (element instanceof MethodElement && (methodElement = (MethodElement)element).getName().equals("-") && methodElement.getParameters().length == 0) {
            return UNARY_MINUS;
        }
        return element.getName();
    }
}

