/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.scope;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.HideElementCombinator;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.NamespaceCombinator;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.ShowElementCombinator;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.Scope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class NamespaceBuilder {
    public Namespace createExportNamespaceForDirective(ExportElement exportElement) {
        LibraryElement libraryElement = exportElement.getExportedLibrary();
        if (libraryElement == null) {
            return Namespace.EMPTY;
        }
        HashMap<String, Element> hashMap = this.createExportMapping(libraryElement, new HashSet<LibraryElement>());
        hashMap = this.applyCombinators(hashMap, exportElement.getCombinators());
        return new Namespace(hashMap);
    }

    public Namespace createExportNamespaceForLibrary(LibraryElement libraryElement) {
        return new Namespace(this.createExportMapping(libraryElement, new HashSet<LibraryElement>()));
    }

    public Namespace createImportNamespaceForDirective(ImportElement importElement) {
        LibraryElement libraryElement = importElement.getImportedLibrary();
        if (libraryElement == null) {
            return Namespace.EMPTY;
        }
        HashMap<String, Element> hashMap = this.createExportMapping(libraryElement, new HashSet<LibraryElement>());
        hashMap = this.applyCombinators(hashMap, importElement.getCombinators());
        hashMap = this.applyPrefix(hashMap, importElement.getPrefix());
        return new Namespace(hashMap);
    }

    public Namespace createPublicNamespaceForLibrary(LibraryElement libraryElement) {
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        this.addPublicNames(hashMap, libraryElement.getDefiningCompilationUnit());
        for (CompilationUnitElement compilationUnitElement : libraryElement.getParts()) {
            this.addPublicNames(hashMap, compilationUnitElement);
        }
        return new Namespace(hashMap);
    }

    private void addAllFromMap(Map<String, Element> map, Map<String, Element> map2) {
        for (Map.Entry<String, Element> entry : map2.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    private void addAllFromNamespace(Map<String, Element> map, Namespace namespace) {
        if (namespace != null) {
            this.addAllFromMap(map, namespace.getDefinedNames());
        }
    }

    private void addIfPublic(Map<String, Element> map, Element element) {
        String string = element.getName();
        if (string != null && !Scope.isPrivateName(string)) {
            map.put(string, element);
        }
    }

    private void addPublicNames(Map<String, Element> map, CompilationUnitElement compilationUnitElement) {
        for (PropertyAccessorElement element : compilationUnitElement.getAccessors()) {
            this.addIfPublic(map, element);
        }
        for (ExecutableElement executableElement : compilationUnitElement.getFunctions()) {
            this.addIfPublic(map, executableElement);
        }
        for (Element element : compilationUnitElement.getFunctionTypeAliases()) {
            this.addIfPublic(map, element);
        }
        for (Element element : compilationUnitElement.getTypes()) {
            this.addIfPublic(map, element);
        }
    }

    private HashMap<String, Element> applyCombinators(HashMap<String, Element> hashMap, NamespaceCombinator[] namespaceCombinatorArray) {
        for (NamespaceCombinator namespaceCombinator : namespaceCombinatorArray) {
            if (namespaceCombinator instanceof HideElementCombinator) {
                this.hide(hashMap, ((HideElementCombinator)namespaceCombinator).getHiddenNames());
                continue;
            }
            if (namespaceCombinator instanceof ShowElementCombinator) {
                hashMap = this.show(hashMap, ((ShowElementCombinator)namespaceCombinator).getShownNames());
                continue;
            }
            AnalysisEngine.getInstance().getLogger().logError("Unknown type of combinator: " + namespaceCombinator.getClass().getName());
        }
        return hashMap;
    }

    private HashMap<String, Element> applyPrefix(HashMap<String, Element> hashMap, PrefixElement prefixElement) {
        if (prefixElement != null) {
            String string = prefixElement.getName();
            HashMap<String, Element> hashMap2 = new HashMap<String, Element>(hashMap.size());
            for (Map.Entry<String, Element> entry : hashMap.entrySet()) {
                hashMap2.put(string + "." + entry.getKey(), entry.getValue());
            }
            return hashMap2;
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Element> createExportMapping(LibraryElement libraryElement, HashSet<LibraryElement> hashSet) {
        hashSet.add(libraryElement);
        try {
            HashMap<String, Element> hashMap = new HashMap<String, Element>();
            for (ExportElement exportElement : libraryElement.getExports()) {
                LibraryElement libraryElement2 = exportElement.getExportedLibrary();
                if (libraryElement2 == null || hashSet.contains(libraryElement2)) continue;
                HashMap<String, Element> hashMap2 = this.createExportMapping(libraryElement2, hashSet);
                hashMap2 = this.applyCombinators(hashMap2, exportElement.getCombinators());
                this.addAllFromMap(hashMap, hashMap2);
            }
            this.addAllFromNamespace(hashMap, ((InternalAnalysisContext)libraryElement.getContext()).getPublicNamespace(libraryElement));
            HashMap<String, Element> hashMap3 = hashMap;
            return hashMap3;
        }
        finally {
            hashSet.remove(libraryElement);
        }
    }

    private void hide(HashMap<String, Element> hashMap, String[] stringArray) {
        for (String string : stringArray) {
            hashMap.remove(string);
            hashMap.remove(string + "=");
        }
    }

    private HashMap<String, Element> show(HashMap<String, Element> hashMap, String[] stringArray) {
        HashMap<String, Element> hashMap2 = new HashMap<String, Element>(hashMap.size());
        for (String string : stringArray) {
            String string2;
            Element element = hashMap.get(string);
            if (element != null) {
                hashMap2.put(string, element);
            }
            if ((element = hashMap.get(string2 = string + "=")) == null) continue;
            hashMap2.put(string2, element);
        }
        return hashMap2;
    }
}

