/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.scope;

import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.scope.EnclosedScope;
import com.google.dart.engine.internal.scope.LibraryImportScope;

public class LibraryScope
extends EnclosedScope {
    public LibraryScope(LibraryElement libraryElement, AnalysisErrorListener analysisErrorListener) {
        super(new LibraryImportScope(libraryElement, analysisErrorListener));
        this.defineTopLevelNames(libraryElement);
    }

    @Override
    protected AnalysisError getErrorForDuplicate(Element element, Element element2) {
        if (element instanceof PrefixElement) {
            PropertyAccessorElement propertyAccessorElement;
            int n = element2.getNameOffset();
            if (element2 instanceof PropertyAccessorElement && (propertyAccessorElement = (PropertyAccessorElement)element2).isSynthetic()) {
                n = propertyAccessorElement.getVariable().getNameOffset();
            }
            return new AnalysisError(element2.getSource(), n, element2.getDisplayName().length(), CompileTimeErrorCode.PREFIX_COLLIDES_WITH_TOP_LEVEL_MEMBER, element.getDisplayName());
        }
        return super.getErrorForDuplicate(element, element2);
    }

    private void defineLocalNames(CompilationUnitElement compilationUnitElement) {
        for (PropertyAccessorElement element : compilationUnitElement.getAccessors()) {
            this.define(element);
        }
        for (ExecutableElement executableElement : compilationUnitElement.getFunctions()) {
            this.define(executableElement);
        }
        for (Element element : compilationUnitElement.getFunctionTypeAliases()) {
            this.define(element);
        }
        for (Element element : compilationUnitElement.getTypes()) {
            this.define(element);
        }
    }

    private final void defineTopLevelNames(LibraryElement libraryElement) {
        for (PrefixElement element : libraryElement.getPrefixes()) {
            this.define(element);
        }
        this.defineLocalNames(libraryElement.getDefiningCompilationUnit());
        for (Element element : libraryElement.getParts()) {
            this.defineLocalNames((CompilationUnitElement)element);
        }
    }
}

