/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.scope;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.StaticWarningCode;
import com.google.dart.engine.internal.element.MultiplyDefinedElementImpl;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.NamespaceBuilder;
import com.google.dart.engine.internal.scope.Scope;

public class LibraryImportScope
extends Scope {
    private LibraryElement definingLibrary;
    private AnalysisErrorListener errorListener;
    private Namespace[] importedNamespaces;

    public LibraryImportScope(LibraryElement libraryElement, AnalysisErrorListener analysisErrorListener) {
        this.definingLibrary = libraryElement;
        this.errorListener = analysisErrorListener;
        this.createImportedNamespaces(libraryElement);
    }

    @Override
    public void define(Element element) {
        if (!LibraryImportScope.isPrivateName(element.getDisplayName())) {
            super.define(element);
        }
    }

    @Override
    public AnalysisErrorListener getErrorListener() {
        return this.errorListener;
    }

    @Override
    protected Element internalLookup(Identifier identifier, String string, LibraryElement libraryElement) {
        Element element = this.localLookup(string, libraryElement);
        if (element != null) {
            return element;
        }
        for (Namespace namespace : this.importedNamespaces) {
            Element element2 = namespace.get(string);
            if (element2 == null) continue;
            if (element == null) {
                element = element2;
                continue;
            }
            if (element == element2) continue;
            element = MultiplyDefinedElementImpl.fromElements(this.definingLibrary.getContext(), element, element2);
        }
        if (element instanceof MultiplyDefinedElementImpl) {
            element = this.removeSdkElements(identifier, string, (MultiplyDefinedElementImpl)element);
        }
        if (element instanceof MultiplyDefinedElementImpl) {
            String string2 = element.getDisplayName();
            Element[] elementArray = ((MultiplyDefinedElementImpl)element).getConflictingElements();
            String string3 = this.getLibraryName(elementArray[0], "");
            String string4 = this.getLibraryName(elementArray[1], "");
            this.errorListener.onError(new AnalysisError(this.getSource(identifier), identifier.getOffset(), identifier.getLength(), StaticWarningCode.AMBIGUOUS_IMPORT, string2, string3, string4));
            return element;
        }
        if (element != null) {
            this.defineNameWithoutChecking(string, element);
        }
        return element;
    }

    private final void createImportedNamespaces(LibraryElement libraryElement) {
        NamespaceBuilder namespaceBuilder = new NamespaceBuilder();
        ImportElement[] importElementArray = libraryElement.getImports();
        int n = importElementArray.length;
        this.importedNamespaces = new Namespace[n];
        for (int i = 0; i < n; ++i) {
            this.importedNamespaces[i] = namespaceBuilder.createImportNamespaceForDirective(importElementArray[i]);
        }
    }

    private String getLibraryName(Element element, String string) {
        if (element == null) {
            return string;
        }
        LibraryElement libraryElement = element.getLibrary();
        if (libraryElement == null) {
            return string;
        }
        return libraryElement.getDefiningCompilationUnit().getDisplayName();
    }

    private Element removeSdkElements(Identifier identifier, String string, MultiplyDefinedElementImpl multiplyDefinedElementImpl) {
        Element[] elementArray;
        Element[] elementArray2 = multiplyDefinedElementImpl.getConflictingElements();
        int n = elementArray2.length;
        int n2 = 0;
        Element element = null;
        for (Element element2 : elementArray2) {
            if (element2.getLibrary().isInSdk()) {
                element = element2;
                continue;
            }
            elementArray2[n2++] = element2;
        }
        if (element != null && n2 > 0) {
            elementArray = this.getLibraryName(element, "");
            String string2 = this.getLibraryName(elementArray2[0], "");
            this.errorListener.onError(new AnalysisError(this.getSource(identifier), identifier.getOffset(), identifier.getLength(), StaticWarningCode.CONFLICTING_DART_IMPORT, string, elementArray, string2));
        }
        if (n2 == n) {
            return multiplyDefinedElementImpl;
        }
        if (n2 == 1) {
            return elementArray2[0];
        }
        if (n2 == 0) {
            AnalysisEngine.getInstance().getLogger().logInformation("Multiply defined SDK element: " + multiplyDefinedElementImpl);
            return multiplyDefinedElementImpl;
        }
        elementArray = new Element[n2];
        System.arraycopy(elementArray2, 0, elementArray, 0, n2);
        return new MultiplyDefinedElementImpl(this.definingLibrary.getContext(), elementArray);
    }
}

